/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * List of properties of a link provider.
 */
public class VpnLinkProviderProperties {
    /**
     * Name of the link provider.
     */
    @JsonProperty(value = "linkProviderName")
    private String linkProviderName;

    /**
     * Link speed.
     */
    @JsonProperty(value = "linkSpeedInMbps")
    private Integer linkSpeedInMbps;

    /**
     * Get name of the link provider.
     *
     * @return the linkProviderName value
     */
    public String linkProviderName() {
        return this.linkProviderName;
    }

    /**
     * Set name of the link provider.
     *
     * @param linkProviderName the linkProviderName value to set
     * @return the VpnLinkProviderProperties object itself.
     */
    public VpnLinkProviderProperties withLinkProviderName(String linkProviderName) {
        this.linkProviderName = linkProviderName;
        return this;
    }

    /**
     * Get link speed.
     *
     * @return the linkSpeedInMbps value
     */
    public Integer linkSpeedInMbps() {
        return this.linkSpeedInMbps;
    }

    /**
     * Set link speed.
     *
     * @param linkSpeedInMbps the linkSpeedInMbps value to set
     * @return the VpnLinkProviderProperties object itself.
     */
    public VpnLinkProviderProperties withLinkSpeedInMbps(Integer linkSpeedInMbps) {
        this.linkSpeedInMbps = linkSpeedInMbps;
        return this;
    }

}
