/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.network.ErrorException;
import com.microsoft.azure.management.network.TagsObject;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in IpGroups.
 */
public class IpGroupsInner implements InnerSupportsGet<IpGroupInner>, InnerSupportsDelete<Void>, InnerSupportsListing<IpGroupInner> {
    /** The Retrofit service to perform REST calls. */
    private IpGroupsService service;
    /** The service client containing this operation class. */
    private NetworkManagementClientImpl client;

    /**
     * Initializes an instance of IpGroupsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public IpGroupsInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = retrofit.create(IpGroupsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for IpGroups to be
     * used by Retrofit to perform actually REST calls.
     */
    interface IpGroupsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.IpGroups getByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/ipGroups/{ipGroupsName}")
        Observable<Response<ResponseBody>> getByResourceGroup(@Path("resourceGroupName") String resourceGroupName, @Path("ipGroupsName") String ipGroupsName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Query("$expand") String expand, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.IpGroups createOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/ipGroups/{ipGroupsName}")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("ipGroupsName") String ipGroupsName, @Path("subscriptionId") String subscriptionId, @Body IpGroupInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.IpGroups beginCreateOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/ipGroups/{ipGroupsName}")
        Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("ipGroupsName") String ipGroupsName, @Path("subscriptionId") String subscriptionId, @Body IpGroupInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.IpGroups updateGroups" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/ipGroups/{ipGroupsName}")
        Observable<Response<ResponseBody>> updateGroups(@Path("resourceGroupName") String resourceGroupName, @Path("ipGroupsName") String ipGroupsName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body TagsObject parameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.IpGroups delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/ipGroups/{ipGroupsName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("resourceGroupName") String resourceGroupName, @Path("ipGroupsName") String ipGroupsName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.IpGroups beginDelete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/ipGroups/{ipGroupsName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDelete(@Path("resourceGroupName") String resourceGroupName, @Path("ipGroupsName") String ipGroupsName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.IpGroups listByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/ipGroups")
        Observable<Response<ResponseBody>> listByResourceGroup(@Path("resourceGroupName") String resourceGroupName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.IpGroups list" })
        @GET("subscriptions/{subscriptionId}/providers/Microsoft.Network/ipGroups")
        Observable<Response<ResponseBody>> list(@Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.IpGroups listByResourceGroupNext" })
        @GET
        Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.IpGroups listNext" })
        @GET
        Observable<Response<ResponseBody>> listNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Gets the specified ipGroups.
     *
     * @param resourceGroupName The name of the resource group.
     * @param ipGroupsName The name of the ipGroups.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the IpGroupInner object if successful.
     */
    public IpGroupInner getByResourceGroup(String resourceGroupName, String ipGroupsName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, ipGroupsName).toBlocking().single().body();
    }

    /**
     * Gets the specified ipGroups.
     *
     * @param resourceGroupName The name of the resource group.
     * @param ipGroupsName The name of the ipGroups.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<IpGroupInner> getByResourceGroupAsync(String resourceGroupName, String ipGroupsName, final ServiceCallback<IpGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(getByResourceGroupWithServiceResponseAsync(resourceGroupName, ipGroupsName), serviceCallback);
    }

    /**
     * Gets the specified ipGroups.
     *
     * @param resourceGroupName The name of the resource group.
     * @param ipGroupsName The name of the ipGroups.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the IpGroupInner object
     */
    public Observable<IpGroupInner> getByResourceGroupAsync(String resourceGroupName, String ipGroupsName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, ipGroupsName).map(new Func1<ServiceResponse<IpGroupInner>, IpGroupInner>() {
            @Override
            public IpGroupInner call(ServiceResponse<IpGroupInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the specified ipGroups.
     *
     * @param resourceGroupName The name of the resource group.
     * @param ipGroupsName The name of the ipGroups.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the IpGroupInner object
     */
    public Observable<ServiceResponse<IpGroupInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String ipGroupsName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (ipGroupsName == null) {
            throw new IllegalArgumentException("Parameter ipGroupsName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        final String expand = null;
        return service.getByResourceGroup(resourceGroupName, ipGroupsName, this.client.subscriptionId(), apiVersion, expand, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<IpGroupInner>>>() {
                @Override
                public Observable<ServiceResponse<IpGroupInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<IpGroupInner> clientResponse = getByResourceGroupDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Gets the specified ipGroups.
     *
     * @param resourceGroupName The name of the resource group.
     * @param ipGroupsName The name of the ipGroups.
     * @param expand Expands resourceIds (of Firewalls/Network Security Groups etc.) back referenced by the IpGroups resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the IpGroupInner object if successful.
     */
    public IpGroupInner getByResourceGroup(String resourceGroupName, String ipGroupsName, String expand) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, ipGroupsName, expand).toBlocking().single().body();
    }

    /**
     * Gets the specified ipGroups.
     *
     * @param resourceGroupName The name of the resource group.
     * @param ipGroupsName The name of the ipGroups.
     * @param expand Expands resourceIds (of Firewalls/Network Security Groups etc.) back referenced by the IpGroups resource.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<IpGroupInner> getByResourceGroupAsync(String resourceGroupName, String ipGroupsName, String expand, final ServiceCallback<IpGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(getByResourceGroupWithServiceResponseAsync(resourceGroupName, ipGroupsName, expand), serviceCallback);
    }

    /**
     * Gets the specified ipGroups.
     *
     * @param resourceGroupName The name of the resource group.
     * @param ipGroupsName The name of the ipGroups.
     * @param expand Expands resourceIds (of Firewalls/Network Security Groups etc.) back referenced by the IpGroups resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the IpGroupInner object
     */
    public Observable<IpGroupInner> getByResourceGroupAsync(String resourceGroupName, String ipGroupsName, String expand) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, ipGroupsName, expand).map(new Func1<ServiceResponse<IpGroupInner>, IpGroupInner>() {
            @Override
            public IpGroupInner call(ServiceResponse<IpGroupInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the specified ipGroups.
     *
     * @param resourceGroupName The name of the resource group.
     * @param ipGroupsName The name of the ipGroups.
     * @param expand Expands resourceIds (of Firewalls/Network Security Groups etc.) back referenced by the IpGroups resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the IpGroupInner object
     */
    public Observable<ServiceResponse<IpGroupInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String ipGroupsName, String expand) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (ipGroupsName == null) {
            throw new IllegalArgumentException("Parameter ipGroupsName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        return service.getByResourceGroup(resourceGroupName, ipGroupsName, this.client.subscriptionId(), apiVersion, expand, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<IpGroupInner>>>() {
                @Override
                public Observable<ServiceResponse<IpGroupInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<IpGroupInner> clientResponse = getByResourceGroupDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<IpGroupInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<IpGroupInner, ErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<IpGroupInner>() { }.getType())
                .registerError(ErrorException.class)
                .build(response);
    }

    /**
     * Creates or updates an ipGroups in a specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param ipGroupsName The name of the ipGroups.
     * @param parameters Parameters supplied to the create or update IpGroups operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the IpGroupInner object if successful.
     */
    public IpGroupInner createOrUpdate(String resourceGroupName, String ipGroupsName, IpGroupInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, ipGroupsName, parameters).toBlocking().last().body();
    }

    /**
     * Creates or updates an ipGroups in a specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param ipGroupsName The name of the ipGroups.
     * @param parameters Parameters supplied to the create or update IpGroups operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<IpGroupInner> createOrUpdateAsync(String resourceGroupName, String ipGroupsName, IpGroupInner parameters, final ServiceCallback<IpGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, ipGroupsName, parameters), serviceCallback);
    }

    /**
     * Creates or updates an ipGroups in a specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param ipGroupsName The name of the ipGroups.
     * @param parameters Parameters supplied to the create or update IpGroups operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<IpGroupInner> createOrUpdateAsync(String resourceGroupName, String ipGroupsName, IpGroupInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, ipGroupsName, parameters).map(new Func1<ServiceResponse<IpGroupInner>, IpGroupInner>() {
            @Override
            public IpGroupInner call(ServiceResponse<IpGroupInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates an ipGroups in a specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param ipGroupsName The name of the ipGroups.
     * @param parameters Parameters supplied to the create or update IpGroups operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<IpGroupInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String ipGroupsName, IpGroupInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (ipGroupsName == null) {
            throw new IllegalArgumentException("Parameter ipGroupsName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = service.createOrUpdate(resourceGroupName, ipGroupsName, this.client.subscriptionId(), parameters, apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<IpGroupInner>() { }.getType());
    }

    /**
     * Creates or updates an ipGroups in a specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param ipGroupsName The name of the ipGroups.
     * @param parameters Parameters supplied to the create or update IpGroups operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the IpGroupInner object if successful.
     */
    public IpGroupInner beginCreateOrUpdate(String resourceGroupName, String ipGroupsName, IpGroupInner parameters) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, ipGroupsName, parameters).toBlocking().single().body();
    }

    /**
     * Creates or updates an ipGroups in a specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param ipGroupsName The name of the ipGroups.
     * @param parameters Parameters supplied to the create or update IpGroups operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<IpGroupInner> beginCreateOrUpdateAsync(String resourceGroupName, String ipGroupsName, IpGroupInner parameters, final ServiceCallback<IpGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, ipGroupsName, parameters), serviceCallback);
    }

    /**
     * Creates or updates an ipGroups in a specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param ipGroupsName The name of the ipGroups.
     * @param parameters Parameters supplied to the create or update IpGroups operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the IpGroupInner object
     */
    public Observable<IpGroupInner> beginCreateOrUpdateAsync(String resourceGroupName, String ipGroupsName, IpGroupInner parameters) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, ipGroupsName, parameters).map(new Func1<ServiceResponse<IpGroupInner>, IpGroupInner>() {
            @Override
            public IpGroupInner call(ServiceResponse<IpGroupInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates an ipGroups in a specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param ipGroupsName The name of the ipGroups.
     * @param parameters Parameters supplied to the create or update IpGroups operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the IpGroupInner object
     */
    public Observable<ServiceResponse<IpGroupInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String ipGroupsName, IpGroupInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (ipGroupsName == null) {
            throw new IllegalArgumentException("Parameter ipGroupsName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String apiVersion = "2019-11-01";
        return service.beginCreateOrUpdate(resourceGroupName, ipGroupsName, this.client.subscriptionId(), parameters, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<IpGroupInner>>>() {
                @Override
                public Observable<ServiceResponse<IpGroupInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<IpGroupInner> clientResponse = beginCreateOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<IpGroupInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<IpGroupInner, ErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<IpGroupInner>() { }.getType())
                .register(201, new TypeToken<IpGroupInner>() { }.getType())
                .registerError(ErrorException.class)
                .build(response);
    }

    /**
     * Updates tags of an IpGroups resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param ipGroupsName The name of the ipGroups.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the IpGroupInner object if successful.
     */
    public IpGroupInner updateGroups(String resourceGroupName, String ipGroupsName) {
        return updateGroupsWithServiceResponseAsync(resourceGroupName, ipGroupsName).toBlocking().single().body();
    }

    /**
     * Updates tags of an IpGroups resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param ipGroupsName The name of the ipGroups.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<IpGroupInner> updateGroupsAsync(String resourceGroupName, String ipGroupsName, final ServiceCallback<IpGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateGroupsWithServiceResponseAsync(resourceGroupName, ipGroupsName), serviceCallback);
    }

    /**
     * Updates tags of an IpGroups resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param ipGroupsName The name of the ipGroups.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the IpGroupInner object
     */
    public Observable<IpGroupInner> updateGroupsAsync(String resourceGroupName, String ipGroupsName) {
        return updateGroupsWithServiceResponseAsync(resourceGroupName, ipGroupsName).map(new Func1<ServiceResponse<IpGroupInner>, IpGroupInner>() {
            @Override
            public IpGroupInner call(ServiceResponse<IpGroupInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates tags of an IpGroups resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param ipGroupsName The name of the ipGroups.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the IpGroupInner object
     */
    public Observable<ServiceResponse<IpGroupInner>> updateGroupsWithServiceResponseAsync(String resourceGroupName, String ipGroupsName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (ipGroupsName == null) {
            throw new IllegalArgumentException("Parameter ipGroupsName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        final Map<String, String> tags = null;
        TagsObject parameters = new TagsObject();
        parameters.withTags(null);
        return service.updateGroups(resourceGroupName, ipGroupsName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), parameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<IpGroupInner>>>() {
                @Override
                public Observable<ServiceResponse<IpGroupInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<IpGroupInner> clientResponse = updateGroupsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Updates tags of an IpGroups resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param ipGroupsName The name of the ipGroups.
     * @param tags Resource tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the IpGroupInner object if successful.
     */
    public IpGroupInner updateGroups(String resourceGroupName, String ipGroupsName, Map<String, String> tags) {
        return updateGroupsWithServiceResponseAsync(resourceGroupName, ipGroupsName, tags).toBlocking().single().body();
    }

    /**
     * Updates tags of an IpGroups resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param ipGroupsName The name of the ipGroups.
     * @param tags Resource tags.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<IpGroupInner> updateGroupsAsync(String resourceGroupName, String ipGroupsName, Map<String, String> tags, final ServiceCallback<IpGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateGroupsWithServiceResponseAsync(resourceGroupName, ipGroupsName, tags), serviceCallback);
    }

    /**
     * Updates tags of an IpGroups resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param ipGroupsName The name of the ipGroups.
     * @param tags Resource tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the IpGroupInner object
     */
    public Observable<IpGroupInner> updateGroupsAsync(String resourceGroupName, String ipGroupsName, Map<String, String> tags) {
        return updateGroupsWithServiceResponseAsync(resourceGroupName, ipGroupsName, tags).map(new Func1<ServiceResponse<IpGroupInner>, IpGroupInner>() {
            @Override
            public IpGroupInner call(ServiceResponse<IpGroupInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates tags of an IpGroups resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param ipGroupsName The name of the ipGroups.
     * @param tags Resource tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the IpGroupInner object
     */
    public Observable<ServiceResponse<IpGroupInner>> updateGroupsWithServiceResponseAsync(String resourceGroupName, String ipGroupsName, Map<String, String> tags) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (ipGroupsName == null) {
            throw new IllegalArgumentException("Parameter ipGroupsName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        Validator.validate(tags);
        final String apiVersion = "2019-11-01";
        TagsObject parameters = new TagsObject();
        parameters.withTags(tags);
        return service.updateGroups(resourceGroupName, ipGroupsName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), parameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<IpGroupInner>>>() {
                @Override
                public Observable<ServiceResponse<IpGroupInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<IpGroupInner> clientResponse = updateGroupsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<IpGroupInner> updateGroupsDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<IpGroupInner, ErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<IpGroupInner>() { }.getType())
                .registerError(ErrorException.class)
                .build(response);
    }

    /**
     * Deletes the specified ipGroups.
     *
     * @param resourceGroupName The name of the resource group.
     * @param ipGroupsName The name of the ipGroups.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String ipGroupsName) {
        deleteWithServiceResponseAsync(resourceGroupName, ipGroupsName).toBlocking().last().body();
    }

    /**
     * Deletes the specified ipGroups.
     *
     * @param resourceGroupName The name of the resource group.
     * @param ipGroupsName The name of the ipGroups.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String ipGroupsName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, ipGroupsName), serviceCallback);
    }

    /**
     * Deletes the specified ipGroups.
     *
     * @param resourceGroupName The name of the resource group.
     * @param ipGroupsName The name of the ipGroups.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String ipGroupsName) {
        return deleteWithServiceResponseAsync(resourceGroupName, ipGroupsName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes the specified ipGroups.
     *
     * @param resourceGroupName The name of the resource group.
     * @param ipGroupsName The name of the ipGroups.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String ipGroupsName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (ipGroupsName == null) {
            throw new IllegalArgumentException("Parameter ipGroupsName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = service.delete(resourceGroupName, ipGroupsName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes the specified ipGroups.
     *
     * @param resourceGroupName The name of the resource group.
     * @param ipGroupsName The name of the ipGroups.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDelete(String resourceGroupName, String ipGroupsName) {
        beginDeleteWithServiceResponseAsync(resourceGroupName, ipGroupsName).toBlocking().single().body();
    }

    /**
     * Deletes the specified ipGroups.
     *
     * @param resourceGroupName The name of the resource group.
     * @param ipGroupsName The name of the ipGroups.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String ipGroupsName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteWithServiceResponseAsync(resourceGroupName, ipGroupsName), serviceCallback);
    }

    /**
     * Deletes the specified ipGroups.
     *
     * @param resourceGroupName The name of the resource group.
     * @param ipGroupsName The name of the ipGroups.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAsync(String resourceGroupName, String ipGroupsName) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, ipGroupsName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes the specified ipGroups.
     *
     * @param resourceGroupName The name of the resource group.
     * @param ipGroupsName The name of the ipGroups.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String ipGroupsName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (ipGroupsName == null) {
            throw new IllegalArgumentException("Parameter ipGroupsName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        return service.beginDelete(resourceGroupName, ipGroupsName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, ErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(ErrorException.class)
                .build(response);
    }

    /**
     * Gets all IpGroups in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;IpGroupInner&gt; object if successful.
     */
    public PagedList<IpGroupInner> listByResourceGroup(final String resourceGroupName) {
        ServiceResponse<Page<IpGroupInner>> response = listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<IpGroupInner>(response.body()) {
            @Override
            public Page<IpGroupInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets all IpGroups in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<IpGroupInner>> listByResourceGroupAsync(final String resourceGroupName, final ListOperationCallback<IpGroupInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupSinglePageAsync(resourceGroupName),
            new Func1<String, Observable<ServiceResponse<Page<IpGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<IpGroupInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets all IpGroups in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;IpGroupInner&gt; object
     */
    public Observable<Page<IpGroupInner>> listByResourceGroupAsync(final String resourceGroupName) {
        return listByResourceGroupWithServiceResponseAsync(resourceGroupName)
            .map(new Func1<ServiceResponse<Page<IpGroupInner>>, Page<IpGroupInner>>() {
                @Override
                public Page<IpGroupInner> call(ServiceResponse<Page<IpGroupInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets all IpGroups in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;IpGroupInner&gt; object
     */
    public Observable<ServiceResponse<Page<IpGroupInner>>> listByResourceGroupWithServiceResponseAsync(final String resourceGroupName) {
        return listByResourceGroupSinglePageAsync(resourceGroupName)
            .concatMap(new Func1<ServiceResponse<Page<IpGroupInner>>, Observable<ServiceResponse<Page<IpGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<IpGroupInner>>> call(ServiceResponse<Page<IpGroupInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets all IpGroups in a resource group.
     *
    ServiceResponse<PageImpl<IpGroupInner>> * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;IpGroupInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<IpGroupInner>>> listByResourceGroupSinglePageAsync(final String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        return service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<IpGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<IpGroupInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<IpGroupInner>> result = listByResourceGroupDelegate(response);
                        return Observable.just(new ServiceResponse<Page<IpGroupInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<IpGroupInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<IpGroupInner>, ErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<IpGroupInner>>() { }.getType())
                .registerError(ErrorException.class)
                .build(response);
    }

    /**
     * Gets all IpGroups in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;IpGroupInner&gt; object if successful.
     */
    public PagedList<IpGroupInner> list() {
        ServiceResponse<Page<IpGroupInner>> response = listSinglePageAsync().toBlocking().single();
        return new PagedList<IpGroupInner>(response.body()) {
            @Override
            public Page<IpGroupInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets all IpGroups in a subscription.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<IpGroupInner>> listAsync(final ListOperationCallback<IpGroupInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(),
            new Func1<String, Observable<ServiceResponse<Page<IpGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<IpGroupInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets all IpGroups in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;IpGroupInner&gt; object
     */
    public Observable<Page<IpGroupInner>> listAsync() {
        return listWithServiceResponseAsync()
            .map(new Func1<ServiceResponse<Page<IpGroupInner>>, Page<IpGroupInner>>() {
                @Override
                public Page<IpGroupInner> call(ServiceResponse<Page<IpGroupInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets all IpGroups in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;IpGroupInner&gt; object
     */
    public Observable<ServiceResponse<Page<IpGroupInner>>> listWithServiceResponseAsync() {
        return listSinglePageAsync()
            .concatMap(new Func1<ServiceResponse<Page<IpGroupInner>>, Observable<ServiceResponse<Page<IpGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<IpGroupInner>>> call(ServiceResponse<Page<IpGroupInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets all IpGroups in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;IpGroupInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<IpGroupInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        return service.list(this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<IpGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<IpGroupInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<IpGroupInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<IpGroupInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<IpGroupInner>> listDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<IpGroupInner>, ErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<IpGroupInner>>() { }.getType())
                .registerError(ErrorException.class)
                .build(response);
    }

    /**
     * Gets all IpGroups in a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;IpGroupInner&gt; object if successful.
     */
    public PagedList<IpGroupInner> listByResourceGroupNext(final String nextPageLink) {
        ServiceResponse<Page<IpGroupInner>> response = listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<IpGroupInner>(response.body()) {
            @Override
            public Page<IpGroupInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets all IpGroups in a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<IpGroupInner>> listByResourceGroupNextAsync(final String nextPageLink, final ServiceFuture<List<IpGroupInner>> serviceFuture, final ListOperationCallback<IpGroupInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<IpGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<IpGroupInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets all IpGroups in a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;IpGroupInner&gt; object
     */
    public Observable<Page<IpGroupInner>> listByResourceGroupNextAsync(final String nextPageLink) {
        return listByResourceGroupNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<IpGroupInner>>, Page<IpGroupInner>>() {
                @Override
                public Page<IpGroupInner> call(ServiceResponse<Page<IpGroupInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets all IpGroups in a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;IpGroupInner&gt; object
     */
    public Observable<ServiceResponse<Page<IpGroupInner>>> listByResourceGroupNextWithServiceResponseAsync(final String nextPageLink) {
        return listByResourceGroupNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<IpGroupInner>>, Observable<ServiceResponse<Page<IpGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<IpGroupInner>>> call(ServiceResponse<Page<IpGroupInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets all IpGroups in a resource group.
     *
    ServiceResponse<PageImpl<IpGroupInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;IpGroupInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<IpGroupInner>>> listByResourceGroupNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<IpGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<IpGroupInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<IpGroupInner>> result = listByResourceGroupNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<IpGroupInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<IpGroupInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<IpGroupInner>, ErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<IpGroupInner>>() { }.getType())
                .registerError(ErrorException.class)
                .build(response);
    }

    /**
     * Gets all IpGroups in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;IpGroupInner&gt; object if successful.
     */
    public PagedList<IpGroupInner> listNext(final String nextPageLink) {
        ServiceResponse<Page<IpGroupInner>> response = listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<IpGroupInner>(response.body()) {
            @Override
            public Page<IpGroupInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets all IpGroups in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<IpGroupInner>> listNextAsync(final String nextPageLink, final ServiceFuture<List<IpGroupInner>> serviceFuture, final ListOperationCallback<IpGroupInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<IpGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<IpGroupInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets all IpGroups in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;IpGroupInner&gt; object
     */
    public Observable<Page<IpGroupInner>> listNextAsync(final String nextPageLink) {
        return listNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<IpGroupInner>>, Page<IpGroupInner>>() {
                @Override
                public Page<IpGroupInner> call(ServiceResponse<Page<IpGroupInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets all IpGroups in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;IpGroupInner&gt; object
     */
    public Observable<ServiceResponse<Page<IpGroupInner>>> listNextWithServiceResponseAsync(final String nextPageLink) {
        return listNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<IpGroupInner>>, Observable<ServiceResponse<Page<IpGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<IpGroupInner>>> call(ServiceResponse<Page<IpGroupInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets all IpGroups in a subscription.
     *
    ServiceResponse<PageImpl<IpGroupInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;IpGroupInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<IpGroupInner>>> listNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<IpGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<IpGroupInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<IpGroupInner>> result = listNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<IpGroupInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<IpGroupInner>> listNextDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<IpGroupInner>, ErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<IpGroupInner>>() { }.getType())
                .registerError(ErrorException.class)
                .build(response);
    }

}
