/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureClient;
import com.microsoft.azure.AzureServiceClient;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.LongRunningFinalState;
import com.microsoft.azure.LongRunningOperationOptions;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.network.BastionShareableLinkListRequest;
import com.microsoft.azure.management.network.SessionIds;
import com.microsoft.azure.management.network.VirtualWanVpnProfileParameters;
import com.microsoft.azure.management.network.implementation.ApplicationGatewaysInner;
import com.microsoft.azure.management.network.implementation.ApplicationSecurityGroupsInner;
import com.microsoft.azure.management.network.implementation.AvailableDelegationsInner;
import com.microsoft.azure.management.network.implementation.AvailableEndpointServicesInner;
import com.microsoft.azure.management.network.implementation.AvailablePrivateEndpointTypesInner;
import com.microsoft.azure.management.network.implementation.AvailableResourceGroupDelegationsInner;
import com.microsoft.azure.management.network.implementation.AvailableServiceAliasesInner;
import com.microsoft.azure.management.network.implementation.AzureFirewallFqdnTagsInner;
import com.microsoft.azure.management.network.implementation.AzureFirewallsInner;
import com.microsoft.azure.management.network.implementation.BastionActiveSessionInner;
import com.microsoft.azure.management.network.implementation.BastionHostsInner;
import com.microsoft.azure.management.network.implementation.BastionSessionStateInner;
import com.microsoft.azure.management.network.implementation.BastionShareableLinkInner;
import com.microsoft.azure.management.network.implementation.BgpServiceCommunitiesInner;
import com.microsoft.azure.management.network.implementation.ConnectionMonitorsInner;
import com.microsoft.azure.management.network.implementation.DdosCustomPoliciesInner;
import com.microsoft.azure.management.network.implementation.DdosProtectionPlansInner;
import com.microsoft.azure.management.network.implementation.DefaultSecurityRulesInner;
import com.microsoft.azure.management.network.implementation.DnsNameAvailabilityResultInner;
import com.microsoft.azure.management.network.implementation.ExpressRouteCircuitAuthorizationsInner;
import com.microsoft.azure.management.network.implementation.ExpressRouteCircuitConnectionsInner;
import com.microsoft.azure.management.network.implementation.ExpressRouteCircuitPeeringsInner;
import com.microsoft.azure.management.network.implementation.ExpressRouteCircuitsInner;
import com.microsoft.azure.management.network.implementation.ExpressRouteConnectionsInner;
import com.microsoft.azure.management.network.implementation.ExpressRouteCrossConnectionPeeringsInner;
import com.microsoft.azure.management.network.implementation.ExpressRouteCrossConnectionsInner;
import com.microsoft.azure.management.network.implementation.ExpressRouteGatewaysInner;
import com.microsoft.azure.management.network.implementation.ExpressRouteLinksInner;
import com.microsoft.azure.management.network.implementation.ExpressRoutePortsInner;
import com.microsoft.azure.management.network.implementation.ExpressRoutePortsLocationsInner;
import com.microsoft.azure.management.network.implementation.ExpressRouteServiceProvidersInner;
import com.microsoft.azure.management.network.implementation.FirewallPoliciesInner;
import com.microsoft.azure.management.network.implementation.FirewallPolicyRuleGroupsInner;
import com.microsoft.azure.management.network.implementation.FlowLogsInner;
import com.microsoft.azure.management.network.implementation.HubVirtualNetworkConnectionsInner;
import com.microsoft.azure.management.network.implementation.InboundNatRulesInner;
import com.microsoft.azure.management.network.implementation.IpGroupsInner;
import com.microsoft.azure.management.network.implementation.LoadBalancerBackendAddressPoolsInner;
import com.microsoft.azure.management.network.implementation.LoadBalancerFrontendIPConfigurationsInner;
import com.microsoft.azure.management.network.implementation.LoadBalancerLoadBalancingRulesInner;
import com.microsoft.azure.management.network.implementation.LoadBalancerNetworkInterfacesInner;
import com.microsoft.azure.management.network.implementation.LoadBalancerOutboundRulesInner;
import com.microsoft.azure.management.network.implementation.LoadBalancerProbesInner;
import com.microsoft.azure.management.network.implementation.LoadBalancersInner;
import com.microsoft.azure.management.network.implementation.LocalNetworkGatewaysInner;
import com.microsoft.azure.management.network.implementation.NatGatewaysInner;
import com.microsoft.azure.management.network.implementation.NetworkInterfaceIPConfigurationsInner;
import com.microsoft.azure.management.network.implementation.NetworkInterfaceLoadBalancersInner;
import com.microsoft.azure.management.network.implementation.NetworkInterfaceTapConfigurationsInner;
import com.microsoft.azure.management.network.implementation.NetworkInterfacesInner;
import com.microsoft.azure.management.network.implementation.NetworkProfilesInner;
import com.microsoft.azure.management.network.implementation.NetworkSecurityGroupsInner;
import com.microsoft.azure.management.network.implementation.NetworkWatchersInner;
import com.microsoft.azure.management.network.implementation.OperationsInner;
import com.microsoft.azure.management.network.implementation.P2sVpnGatewaysInner;
import com.microsoft.azure.management.network.implementation.PacketCapturesInner;
import com.microsoft.azure.management.network.implementation.PageImpl;
import com.microsoft.azure.management.network.implementation.PeerExpressRouteCircuitConnectionsInner;
import com.microsoft.azure.management.network.implementation.PrivateEndpointsInner;
import com.microsoft.azure.management.network.implementation.PrivateLinkServicesInner;
import com.microsoft.azure.management.network.implementation.PublicIPAddressesInner;
import com.microsoft.azure.management.network.implementation.PublicIPPrefixesInner;
import com.microsoft.azure.management.network.implementation.ResourceNavigationLinksInner;
import com.microsoft.azure.management.network.implementation.RouteFilterRulesInner;
import com.microsoft.azure.management.network.implementation.RouteFiltersInner;
import com.microsoft.azure.management.network.implementation.RouteTablesInner;
import com.microsoft.azure.management.network.implementation.RoutesInner;
import com.microsoft.azure.management.network.implementation.SecurityRulesInner;
import com.microsoft.azure.management.network.implementation.ServiceAssociationLinksInner;
import com.microsoft.azure.management.network.implementation.ServiceEndpointPoliciesInner;
import com.microsoft.azure.management.network.implementation.ServiceEndpointPolicyDefinitionsInner;
import com.microsoft.azure.management.network.implementation.ServiceTagsInner;
import com.microsoft.azure.management.network.implementation.SubnetsInner;
import com.microsoft.azure.management.network.implementation.UsagesInner;
import com.microsoft.azure.management.network.implementation.VirtualHubRouteTableV2sInner;
import com.microsoft.azure.management.network.implementation.VirtualHubsInner;
import com.microsoft.azure.management.network.implementation.VirtualNetworkGatewayConnectionsInner;
import com.microsoft.azure.management.network.implementation.VirtualNetworkGatewaysInner;
import com.microsoft.azure.management.network.implementation.VirtualNetworkPeeringsInner;
import com.microsoft.azure.management.network.implementation.VirtualNetworkTapsInner;
import com.microsoft.azure.management.network.implementation.VirtualNetworksInner;
import com.microsoft.azure.management.network.implementation.VirtualRouterPeeringsInner;
import com.microsoft.azure.management.network.implementation.VirtualRoutersInner;
import com.microsoft.azure.management.network.implementation.VirtualWanSecurityProvidersInner;
import com.microsoft.azure.management.network.implementation.VirtualWansInner;
import com.microsoft.azure.management.network.implementation.VpnConnectionsInner;
import com.microsoft.azure.management.network.implementation.VpnGatewaysInner;
import com.microsoft.azure.management.network.implementation.VpnLinkConnectionsInner;
import com.microsoft.azure.management.network.implementation.VpnProfileResponseInner;
import com.microsoft.azure.management.network.implementation.VpnServerConfigurationsAssociatedWithVirtualWansInner;
import com.microsoft.azure.management.network.implementation.VpnServerConfigurationsInner;
import com.microsoft.azure.management.network.implementation.VpnSiteLinkConnectionsInner;
import com.microsoft.azure.management.network.implementation.VpnSiteLinksInner;
import com.microsoft.azure.management.network.implementation.VpnSitesConfigurationsInner;
import com.microsoft.azure.management.network.implementation.VpnSitesInner;
import com.microsoft.azure.management.network.implementation.WebApplicationFirewallPoliciesInner;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import com.microsoft.rest.credentials.ServiceClientCredentials;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class NetworkManagementClientImpl
extends AzureServiceClient {
    private NetworkManagementClientService service;
    private AzureClient azureClient;
    private String subscriptionId;
    private String apiVersion;
    private String acceptLanguage;
    private int longRunningOperationRetryTimeout;
    private boolean generateClientRequestId;
    private ApplicationGatewaysInner applicationGateways;
    private ApplicationSecurityGroupsInner applicationSecurityGroups;
    private AvailableDelegationsInner availableDelegations;
    private AvailableResourceGroupDelegationsInner availableResourceGroupDelegations;
    private AvailableServiceAliasesInner availableServiceAliases;
    private AzureFirewallsInner azureFirewalls;
    private AzureFirewallFqdnTagsInner azureFirewallFqdnTags;
    private BastionHostsInner bastionHosts;
    private DdosCustomPoliciesInner ddosCustomPolicies;
    private DdosProtectionPlansInner ddosProtectionPlans;
    private AvailableEndpointServicesInner availableEndpointServices;
    private ExpressRouteCircuitAuthorizationsInner expressRouteCircuitAuthorizations;
    private ExpressRouteCircuitPeeringsInner expressRouteCircuitPeerings;
    private ExpressRouteCircuitConnectionsInner expressRouteCircuitConnections;
    private PeerExpressRouteCircuitConnectionsInner peerExpressRouteCircuitConnections;
    private ExpressRouteCircuitsInner expressRouteCircuits;
    private ExpressRouteServiceProvidersInner expressRouteServiceProviders;
    private ExpressRouteCrossConnectionsInner expressRouteCrossConnections;
    private ExpressRouteCrossConnectionPeeringsInner expressRouteCrossConnectionPeerings;
    private ExpressRouteGatewaysInner expressRouteGateways;
    private ExpressRouteConnectionsInner expressRouteConnections;
    private ExpressRoutePortsLocationsInner expressRoutePortsLocations;
    private ExpressRoutePortsInner expressRoutePorts;
    private ExpressRouteLinksInner expressRouteLinks;
    private FirewallPoliciesInner firewallPolicies;
    private FirewallPolicyRuleGroupsInner firewallPolicyRuleGroups;
    private IpGroupsInner ipGroups;
    private LoadBalancersInner loadBalancers;
    private LoadBalancerBackendAddressPoolsInner loadBalancerBackendAddressPools;
    private LoadBalancerFrontendIPConfigurationsInner loadBalancerFrontendIPConfigurations;
    private InboundNatRulesInner inboundNatRules;
    private LoadBalancerLoadBalancingRulesInner loadBalancerLoadBalancingRules;
    private LoadBalancerOutboundRulesInner loadBalancerOutboundRules;
    private LoadBalancerNetworkInterfacesInner loadBalancerNetworkInterfaces;
    private LoadBalancerProbesInner loadBalancerProbes;
    private NatGatewaysInner natGateways;
    private NetworkInterfacesInner networkInterfaces;
    private NetworkInterfaceIPConfigurationsInner networkInterfaceIPConfigurations;
    private NetworkInterfaceLoadBalancersInner networkInterfaceLoadBalancers;
    private NetworkInterfaceTapConfigurationsInner networkInterfaceTapConfigurations;
    private NetworkProfilesInner networkProfiles;
    private NetworkSecurityGroupsInner networkSecurityGroups;
    private SecurityRulesInner securityRules;
    private DefaultSecurityRulesInner defaultSecurityRules;
    private NetworkWatchersInner networkWatchers;
    private PacketCapturesInner packetCaptures;
    private ConnectionMonitorsInner connectionMonitors;
    private FlowLogsInner flowLogs;
    private OperationsInner operations;
    private PrivateEndpointsInner privateEndpoints;
    private AvailablePrivateEndpointTypesInner availablePrivateEndpointTypes;
    private PrivateLinkServicesInner privateLinkServices;
    private PublicIPAddressesInner publicIPAddresses;
    private PublicIPPrefixesInner publicIPPrefixes;
    private RouteFiltersInner routeFilters;
    private RouteFilterRulesInner routeFilterRules;
    private RouteTablesInner routeTables;
    private RoutesInner routes;
    private BgpServiceCommunitiesInner bgpServiceCommunities;
    private ServiceEndpointPoliciesInner serviceEndpointPolicies;
    private ServiceEndpointPolicyDefinitionsInner serviceEndpointPolicyDefinitions;
    private ServiceTagsInner serviceTags;
    private UsagesInner usages;
    private VirtualNetworksInner virtualNetworks;
    private SubnetsInner subnets;
    private ResourceNavigationLinksInner resourceNavigationLinks;
    private ServiceAssociationLinksInner serviceAssociationLinks;
    private VirtualNetworkPeeringsInner virtualNetworkPeerings;
    private VirtualNetworkGatewaysInner virtualNetworkGateways;
    private VirtualNetworkGatewayConnectionsInner virtualNetworkGatewayConnections;
    private LocalNetworkGatewaysInner localNetworkGateways;
    private VirtualNetworkTapsInner virtualNetworkTaps;
    private VirtualRoutersInner virtualRouters;
    private VirtualRouterPeeringsInner virtualRouterPeerings;
    private VirtualWansInner virtualWans;
    private VpnSitesInner vpnSites;
    private VpnSiteLinksInner vpnSiteLinks;
    private VpnSitesConfigurationsInner vpnSitesConfigurations;
    private VpnServerConfigurationsInner vpnServerConfigurations;
    private VirtualHubsInner virtualHubs;
    private HubVirtualNetworkConnectionsInner hubVirtualNetworkConnections;
    private VpnGatewaysInner vpnGateways;
    private VpnConnectionsInner vpnConnections;
    private VpnSiteLinkConnectionsInner vpnSiteLinkConnections;
    private VpnLinkConnectionsInner vpnLinkConnections;
    private P2sVpnGatewaysInner p2sVpnGateways;
    private VpnServerConfigurationsAssociatedWithVirtualWansInner vpnServerConfigurationsAssociatedWithVirtualWans;
    private VirtualHubRouteTableV2sInner virtualHubRouteTableV2s;
    private WebApplicationFirewallPoliciesInner webApplicationFirewallPolicies;

    public AzureClient getAzureClient() {
        return this.azureClient;
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public NetworkManagementClientImpl withSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    public String apiVersion() {
        return this.apiVersion;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public NetworkManagementClientImpl withAcceptLanguage(String acceptLanguage) {
        this.acceptLanguage = acceptLanguage;
        return this;
    }

    public int longRunningOperationRetryTimeout() {
        return this.longRunningOperationRetryTimeout;
    }

    public NetworkManagementClientImpl withLongRunningOperationRetryTimeout(int longRunningOperationRetryTimeout) {
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeout;
        return this;
    }

    public boolean generateClientRequestId() {
        return this.generateClientRequestId;
    }

    public NetworkManagementClientImpl withGenerateClientRequestId(boolean generateClientRequestId) {
        this.generateClientRequestId = generateClientRequestId;
        return this;
    }

    public ApplicationGatewaysInner applicationGateways() {
        return this.applicationGateways;
    }

    public ApplicationSecurityGroupsInner applicationSecurityGroups() {
        return this.applicationSecurityGroups;
    }

    public AvailableDelegationsInner availableDelegations() {
        return this.availableDelegations;
    }

    public AvailableResourceGroupDelegationsInner availableResourceGroupDelegations() {
        return this.availableResourceGroupDelegations;
    }

    public AvailableServiceAliasesInner availableServiceAliases() {
        return this.availableServiceAliases;
    }

    public AzureFirewallsInner azureFirewalls() {
        return this.azureFirewalls;
    }

    public AzureFirewallFqdnTagsInner azureFirewallFqdnTags() {
        return this.azureFirewallFqdnTags;
    }

    public BastionHostsInner bastionHosts() {
        return this.bastionHosts;
    }

    public DdosCustomPoliciesInner ddosCustomPolicies() {
        return this.ddosCustomPolicies;
    }

    public DdosProtectionPlansInner ddosProtectionPlans() {
        return this.ddosProtectionPlans;
    }

    public AvailableEndpointServicesInner availableEndpointServices() {
        return this.availableEndpointServices;
    }

    public ExpressRouteCircuitAuthorizationsInner expressRouteCircuitAuthorizations() {
        return this.expressRouteCircuitAuthorizations;
    }

    public ExpressRouteCircuitPeeringsInner expressRouteCircuitPeerings() {
        return this.expressRouteCircuitPeerings;
    }

    public ExpressRouteCircuitConnectionsInner expressRouteCircuitConnections() {
        return this.expressRouteCircuitConnections;
    }

    public PeerExpressRouteCircuitConnectionsInner peerExpressRouteCircuitConnections() {
        return this.peerExpressRouteCircuitConnections;
    }

    public ExpressRouteCircuitsInner expressRouteCircuits() {
        return this.expressRouteCircuits;
    }

    public ExpressRouteServiceProvidersInner expressRouteServiceProviders() {
        return this.expressRouteServiceProviders;
    }

    public ExpressRouteCrossConnectionsInner expressRouteCrossConnections() {
        return this.expressRouteCrossConnections;
    }

    public ExpressRouteCrossConnectionPeeringsInner expressRouteCrossConnectionPeerings() {
        return this.expressRouteCrossConnectionPeerings;
    }

    public ExpressRouteGatewaysInner expressRouteGateways() {
        return this.expressRouteGateways;
    }

    public ExpressRouteConnectionsInner expressRouteConnections() {
        return this.expressRouteConnections;
    }

    public ExpressRoutePortsLocationsInner expressRoutePortsLocations() {
        return this.expressRoutePortsLocations;
    }

    public ExpressRoutePortsInner expressRoutePorts() {
        return this.expressRoutePorts;
    }

    public ExpressRouteLinksInner expressRouteLinks() {
        return this.expressRouteLinks;
    }

    public FirewallPoliciesInner firewallPolicies() {
        return this.firewallPolicies;
    }

    public FirewallPolicyRuleGroupsInner firewallPolicyRuleGroups() {
        return this.firewallPolicyRuleGroups;
    }

    public IpGroupsInner ipGroups() {
        return this.ipGroups;
    }

    public LoadBalancersInner loadBalancers() {
        return this.loadBalancers;
    }

    public LoadBalancerBackendAddressPoolsInner loadBalancerBackendAddressPools() {
        return this.loadBalancerBackendAddressPools;
    }

    public LoadBalancerFrontendIPConfigurationsInner loadBalancerFrontendIPConfigurations() {
        return this.loadBalancerFrontendIPConfigurations;
    }

    public InboundNatRulesInner inboundNatRules() {
        return this.inboundNatRules;
    }

    public LoadBalancerLoadBalancingRulesInner loadBalancerLoadBalancingRules() {
        return this.loadBalancerLoadBalancingRules;
    }

    public LoadBalancerOutboundRulesInner loadBalancerOutboundRules() {
        return this.loadBalancerOutboundRules;
    }

    public LoadBalancerNetworkInterfacesInner loadBalancerNetworkInterfaces() {
        return this.loadBalancerNetworkInterfaces;
    }

    public LoadBalancerProbesInner loadBalancerProbes() {
        return this.loadBalancerProbes;
    }

    public NatGatewaysInner natGateways() {
        return this.natGateways;
    }

    public NetworkInterfacesInner networkInterfaces() {
        return this.networkInterfaces;
    }

    public NetworkInterfaceIPConfigurationsInner networkInterfaceIPConfigurations() {
        return this.networkInterfaceIPConfigurations;
    }

    public NetworkInterfaceLoadBalancersInner networkInterfaceLoadBalancers() {
        return this.networkInterfaceLoadBalancers;
    }

    public NetworkInterfaceTapConfigurationsInner networkInterfaceTapConfigurations() {
        return this.networkInterfaceTapConfigurations;
    }

    public NetworkProfilesInner networkProfiles() {
        return this.networkProfiles;
    }

    public NetworkSecurityGroupsInner networkSecurityGroups() {
        return this.networkSecurityGroups;
    }

    public SecurityRulesInner securityRules() {
        return this.securityRules;
    }

    public DefaultSecurityRulesInner defaultSecurityRules() {
        return this.defaultSecurityRules;
    }

    public NetworkWatchersInner networkWatchers() {
        return this.networkWatchers;
    }

    public PacketCapturesInner packetCaptures() {
        return this.packetCaptures;
    }

    public ConnectionMonitorsInner connectionMonitors() {
        return this.connectionMonitors;
    }

    public FlowLogsInner flowLogs() {
        return this.flowLogs;
    }

    public OperationsInner operations() {
        return this.operations;
    }

    public PrivateEndpointsInner privateEndpoints() {
        return this.privateEndpoints;
    }

    public AvailablePrivateEndpointTypesInner availablePrivateEndpointTypes() {
        return this.availablePrivateEndpointTypes;
    }

    public PrivateLinkServicesInner privateLinkServices() {
        return this.privateLinkServices;
    }

    public PublicIPAddressesInner publicIPAddresses() {
        return this.publicIPAddresses;
    }

    public PublicIPPrefixesInner publicIPPrefixes() {
        return this.publicIPPrefixes;
    }

    public RouteFiltersInner routeFilters() {
        return this.routeFilters;
    }

    public RouteFilterRulesInner routeFilterRules() {
        return this.routeFilterRules;
    }

    public RouteTablesInner routeTables() {
        return this.routeTables;
    }

    public RoutesInner routes() {
        return this.routes;
    }

    public BgpServiceCommunitiesInner bgpServiceCommunities() {
        return this.bgpServiceCommunities;
    }

    public ServiceEndpointPoliciesInner serviceEndpointPolicies() {
        return this.serviceEndpointPolicies;
    }

    public ServiceEndpointPolicyDefinitionsInner serviceEndpointPolicyDefinitions() {
        return this.serviceEndpointPolicyDefinitions;
    }

    public ServiceTagsInner serviceTags() {
        return this.serviceTags;
    }

    public UsagesInner usages() {
        return this.usages;
    }

    public VirtualNetworksInner virtualNetworks() {
        return this.virtualNetworks;
    }

    public SubnetsInner subnets() {
        return this.subnets;
    }

    public ResourceNavigationLinksInner resourceNavigationLinks() {
        return this.resourceNavigationLinks;
    }

    public ServiceAssociationLinksInner serviceAssociationLinks() {
        return this.serviceAssociationLinks;
    }

    public VirtualNetworkPeeringsInner virtualNetworkPeerings() {
        return this.virtualNetworkPeerings;
    }

    public VirtualNetworkGatewaysInner virtualNetworkGateways() {
        return this.virtualNetworkGateways;
    }

    public VirtualNetworkGatewayConnectionsInner virtualNetworkGatewayConnections() {
        return this.virtualNetworkGatewayConnections;
    }

    public LocalNetworkGatewaysInner localNetworkGateways() {
        return this.localNetworkGateways;
    }

    public VirtualNetworkTapsInner virtualNetworkTaps() {
        return this.virtualNetworkTaps;
    }

    public VirtualRoutersInner virtualRouters() {
        return this.virtualRouters;
    }

    public VirtualRouterPeeringsInner virtualRouterPeerings() {
        return this.virtualRouterPeerings;
    }

    public VirtualWansInner virtualWans() {
        return this.virtualWans;
    }

    public VpnSitesInner vpnSites() {
        return this.vpnSites;
    }

    public VpnSiteLinksInner vpnSiteLinks() {
        return this.vpnSiteLinks;
    }

    public VpnSitesConfigurationsInner vpnSitesConfigurations() {
        return this.vpnSitesConfigurations;
    }

    public VpnServerConfigurationsInner vpnServerConfigurations() {
        return this.vpnServerConfigurations;
    }

    public VirtualHubsInner virtualHubs() {
        return this.virtualHubs;
    }

    public HubVirtualNetworkConnectionsInner hubVirtualNetworkConnections() {
        return this.hubVirtualNetworkConnections;
    }

    public VpnGatewaysInner vpnGateways() {
        return this.vpnGateways;
    }

    public VpnConnectionsInner vpnConnections() {
        return this.vpnConnections;
    }

    public VpnSiteLinkConnectionsInner vpnSiteLinkConnections() {
        return this.vpnSiteLinkConnections;
    }

    public VpnLinkConnectionsInner vpnLinkConnections() {
        return this.vpnLinkConnections;
    }

    public P2sVpnGatewaysInner p2sVpnGateways() {
        return this.p2sVpnGateways;
    }

    public VpnServerConfigurationsAssociatedWithVirtualWansInner vpnServerConfigurationsAssociatedWithVirtualWans() {
        return this.vpnServerConfigurationsAssociatedWithVirtualWans;
    }

    public VirtualHubRouteTableV2sInner virtualHubRouteTableV2s() {
        return this.virtualHubRouteTableV2s;
    }

    public WebApplicationFirewallPoliciesInner webApplicationFirewallPolicies() {
        return this.webApplicationFirewallPolicies;
    }

    public NetworkManagementClientImpl(ServiceClientCredentials credentials) {
        this("https://management.azure.com", credentials);
    }

    public NetworkManagementClientImpl(String baseUrl, ServiceClientCredentials credentials) {
        super(baseUrl, credentials);
        this.initialize();
    }

    public NetworkManagementClientImpl(RestClient restClient) {
        super(restClient);
        this.initialize();
    }

    protected void initialize() {
        this.acceptLanguage = "en-US";
        this.longRunningOperationRetryTimeout = 30;
        this.generateClientRequestId = true;
        this.applicationGateways = new ApplicationGatewaysInner(this.restClient().retrofit(), this);
        this.applicationSecurityGroups = new ApplicationSecurityGroupsInner(this.restClient().retrofit(), this);
        this.availableDelegations = new AvailableDelegationsInner(this.restClient().retrofit(), this);
        this.availableResourceGroupDelegations = new AvailableResourceGroupDelegationsInner(this.restClient().retrofit(), this);
        this.availableServiceAliases = new AvailableServiceAliasesInner(this.restClient().retrofit(), this);
        this.azureFirewalls = new AzureFirewallsInner(this.restClient().retrofit(), this);
        this.azureFirewallFqdnTags = new AzureFirewallFqdnTagsInner(this.restClient().retrofit(), this);
        this.bastionHosts = new BastionHostsInner(this.restClient().retrofit(), this);
        this.ddosCustomPolicies = new DdosCustomPoliciesInner(this.restClient().retrofit(), this);
        this.ddosProtectionPlans = new DdosProtectionPlansInner(this.restClient().retrofit(), this);
        this.availableEndpointServices = new AvailableEndpointServicesInner(this.restClient().retrofit(), this);
        this.expressRouteCircuitAuthorizations = new ExpressRouteCircuitAuthorizationsInner(this.restClient().retrofit(), this);
        this.expressRouteCircuitPeerings = new ExpressRouteCircuitPeeringsInner(this.restClient().retrofit(), this);
        this.expressRouteCircuitConnections = new ExpressRouteCircuitConnectionsInner(this.restClient().retrofit(), this);
        this.peerExpressRouteCircuitConnections = new PeerExpressRouteCircuitConnectionsInner(this.restClient().retrofit(), this);
        this.expressRouteCircuits = new ExpressRouteCircuitsInner(this.restClient().retrofit(), this);
        this.expressRouteServiceProviders = new ExpressRouteServiceProvidersInner(this.restClient().retrofit(), this);
        this.expressRouteCrossConnections = new ExpressRouteCrossConnectionsInner(this.restClient().retrofit(), this);
        this.expressRouteCrossConnectionPeerings = new ExpressRouteCrossConnectionPeeringsInner(this.restClient().retrofit(), this);
        this.expressRouteGateways = new ExpressRouteGatewaysInner(this.restClient().retrofit(), this);
        this.expressRouteConnections = new ExpressRouteConnectionsInner(this.restClient().retrofit(), this);
        this.expressRoutePortsLocations = new ExpressRoutePortsLocationsInner(this.restClient().retrofit(), this);
        this.expressRoutePorts = new ExpressRoutePortsInner(this.restClient().retrofit(), this);
        this.expressRouteLinks = new ExpressRouteLinksInner(this.restClient().retrofit(), this);
        this.firewallPolicies = new FirewallPoliciesInner(this.restClient().retrofit(), this);
        this.firewallPolicyRuleGroups = new FirewallPolicyRuleGroupsInner(this.restClient().retrofit(), this);
        this.ipGroups = new IpGroupsInner(this.restClient().retrofit(), this);
        this.loadBalancers = new LoadBalancersInner(this.restClient().retrofit(), this);
        this.loadBalancerBackendAddressPools = new LoadBalancerBackendAddressPoolsInner(this.restClient().retrofit(), this);
        this.loadBalancerFrontendIPConfigurations = new LoadBalancerFrontendIPConfigurationsInner(this.restClient().retrofit(), this);
        this.inboundNatRules = new InboundNatRulesInner(this.restClient().retrofit(), this);
        this.loadBalancerLoadBalancingRules = new LoadBalancerLoadBalancingRulesInner(this.restClient().retrofit(), this);
        this.loadBalancerOutboundRules = new LoadBalancerOutboundRulesInner(this.restClient().retrofit(), this);
        this.loadBalancerNetworkInterfaces = new LoadBalancerNetworkInterfacesInner(this.restClient().retrofit(), this);
        this.loadBalancerProbes = new LoadBalancerProbesInner(this.restClient().retrofit(), this);
        this.natGateways = new NatGatewaysInner(this.restClient().retrofit(), this);
        this.networkInterfaces = new NetworkInterfacesInner(this.restClient().retrofit(), this);
        this.networkInterfaceIPConfigurations = new NetworkInterfaceIPConfigurationsInner(this.restClient().retrofit(), this);
        this.networkInterfaceLoadBalancers = new NetworkInterfaceLoadBalancersInner(this.restClient().retrofit(), this);
        this.networkInterfaceTapConfigurations = new NetworkInterfaceTapConfigurationsInner(this.restClient().retrofit(), this);
        this.networkProfiles = new NetworkProfilesInner(this.restClient().retrofit(), this);
        this.networkSecurityGroups = new NetworkSecurityGroupsInner(this.restClient().retrofit(), this);
        this.securityRules = new SecurityRulesInner(this.restClient().retrofit(), this);
        this.defaultSecurityRules = new DefaultSecurityRulesInner(this.restClient().retrofit(), this);
        this.networkWatchers = new NetworkWatchersInner(this.restClient().retrofit(), this);
        this.packetCaptures = new PacketCapturesInner(this.restClient().retrofit(), this);
        this.connectionMonitors = new ConnectionMonitorsInner(this.restClient().retrofit(), this);
        this.flowLogs = new FlowLogsInner(this.restClient().retrofit(), this);
        this.operations = new OperationsInner(this.restClient().retrofit(), this);
        this.privateEndpoints = new PrivateEndpointsInner(this.restClient().retrofit(), this);
        this.availablePrivateEndpointTypes = new AvailablePrivateEndpointTypesInner(this.restClient().retrofit(), this);
        this.privateLinkServices = new PrivateLinkServicesInner(this.restClient().retrofit(), this);
        this.publicIPAddresses = new PublicIPAddressesInner(this.restClient().retrofit(), this);
        this.publicIPPrefixes = new PublicIPPrefixesInner(this.restClient().retrofit(), this);
        this.routeFilters = new RouteFiltersInner(this.restClient().retrofit(), this);
        this.routeFilterRules = new RouteFilterRulesInner(this.restClient().retrofit(), this);
        this.routeTables = new RouteTablesInner(this.restClient().retrofit(), this);
        this.routes = new RoutesInner(this.restClient().retrofit(), this);
        this.bgpServiceCommunities = new BgpServiceCommunitiesInner(this.restClient().retrofit(), this);
        this.serviceEndpointPolicies = new ServiceEndpointPoliciesInner(this.restClient().retrofit(), this);
        this.serviceEndpointPolicyDefinitions = new ServiceEndpointPolicyDefinitionsInner(this.restClient().retrofit(), this);
        this.serviceTags = new ServiceTagsInner(this.restClient().retrofit(), this);
        this.usages = new UsagesInner(this.restClient().retrofit(), this);
        this.virtualNetworks = new VirtualNetworksInner(this.restClient().retrofit(), this);
        this.subnets = new SubnetsInner(this.restClient().retrofit(), this);
        this.resourceNavigationLinks = new ResourceNavigationLinksInner(this.restClient().retrofit(), this);
        this.serviceAssociationLinks = new ServiceAssociationLinksInner(this.restClient().retrofit(), this);
        this.virtualNetworkPeerings = new VirtualNetworkPeeringsInner(this.restClient().retrofit(), this);
        this.virtualNetworkGateways = new VirtualNetworkGatewaysInner(this.restClient().retrofit(), this);
        this.virtualNetworkGatewayConnections = new VirtualNetworkGatewayConnectionsInner(this.restClient().retrofit(), this);
        this.localNetworkGateways = new LocalNetworkGatewaysInner(this.restClient().retrofit(), this);
        this.virtualNetworkTaps = new VirtualNetworkTapsInner(this.restClient().retrofit(), this);
        this.virtualRouters = new VirtualRoutersInner(this.restClient().retrofit(), this);
        this.virtualRouterPeerings = new VirtualRouterPeeringsInner(this.restClient().retrofit(), this);
        this.virtualWans = new VirtualWansInner(this.restClient().retrofit(), this);
        this.vpnSites = new VpnSitesInner(this.restClient().retrofit(), this);
        this.vpnSiteLinks = new VpnSiteLinksInner(this.restClient().retrofit(), this);
        this.vpnSitesConfigurations = new VpnSitesConfigurationsInner(this.restClient().retrofit(), this);
        this.vpnServerConfigurations = new VpnServerConfigurationsInner(this.restClient().retrofit(), this);
        this.virtualHubs = new VirtualHubsInner(this.restClient().retrofit(), this);
        this.hubVirtualNetworkConnections = new HubVirtualNetworkConnectionsInner(this.restClient().retrofit(), this);
        this.vpnGateways = new VpnGatewaysInner(this.restClient().retrofit(), this);
        this.vpnConnections = new VpnConnectionsInner(this.restClient().retrofit(), this);
        this.vpnSiteLinkConnections = new VpnSiteLinkConnectionsInner(this.restClient().retrofit(), this);
        this.vpnLinkConnections = new VpnLinkConnectionsInner(this.restClient().retrofit(), this);
        this.p2sVpnGateways = new P2sVpnGatewaysInner(this.restClient().retrofit(), this);
        this.vpnServerConfigurationsAssociatedWithVirtualWans = new VpnServerConfigurationsAssociatedWithVirtualWansInner(this.restClient().retrofit(), this);
        this.virtualHubRouteTableV2s = new VirtualHubRouteTableV2sInner(this.restClient().retrofit(), this);
        this.webApplicationFirewallPolicies = new WebApplicationFirewallPoliciesInner(this.restClient().retrofit(), this);
        this.azureClient = new AzureClient((AzureServiceClient)this);
        this.initializeService();
    }

    public String userAgent() {
        return String.format("%s (%s)", super.userAgent(), "NetworkManagementClient");
    }

    private void initializeService() {
        this.service = (NetworkManagementClientService)this.restClient().retrofit().create(NetworkManagementClientService.class);
    }

    public PagedList<BastionShareableLinkInner> putBastionShareableLink(String resourceGroupName, String bastionHostName) {
        ServiceResponse response = (ServiceResponse)this.putBastionShareableLinkSinglePageAsync(resourceGroupName, bastionHostName).toBlocking().single();
        return new PagedList<BastionShareableLinkInner>((Page)response.body()){

            public Page<BastionShareableLinkInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)NetworkManagementClientImpl.this.putBastionShareableLinkNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<BastionShareableLinkInner>> putBastionShareableLinkAsync(String resourceGroupName, String bastionHostName, ListOperationCallback<BastionShareableLinkInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.putBastionShareableLinkSinglePageAsync(resourceGroupName, bastionHostName), (Func1)new Func1<String, Observable<ServiceResponse<Page<BastionShareableLinkInner>>>>(){

            public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> call(String nextPageLink) {
                return NetworkManagementClientImpl.this.putBastionShareableLinkNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<BastionShareableLinkInner>> putBastionShareableLinkAsync(String resourceGroupName, String bastionHostName) {
        return this.putBastionShareableLinkWithServiceResponseAsync(resourceGroupName, bastionHostName).map((Func1)new Func1<ServiceResponse<Page<BastionShareableLinkInner>>, Page<BastionShareableLinkInner>>(){

            public Page<BastionShareableLinkInner> call(ServiceResponse<Page<BastionShareableLinkInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> putBastionShareableLinkWithServiceResponseAsync(String resourceGroupName, String bastionHostName) {
        return this.putBastionShareableLinkSinglePageAsync(resourceGroupName, bastionHostName).concatMap((Func1)new Func1<ServiceResponse<Page<BastionShareableLinkInner>>, Observable<ServiceResponse<Page<BastionShareableLinkInner>>>>(){

            public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> call(ServiceResponse<Page<BastionShareableLinkInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(NetworkManagementClientImpl.this.putBastionShareableLinkNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> putBastionShareableLinkSinglePageAsync(String resourceGroupName, String bastionHostName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (bastionHostName == null) {
            throw new IllegalArgumentException("Parameter bastionHostName is required and cannot be null.");
        }
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        Object vms = null;
        BastionShareableLinkListRequest bslRequest = new BastionShareableLinkListRequest();
        bslRequest.withVms(null);
        return this.service.putBastionShareableLink(resourceGroupName, bastionHostName, this.subscriptionId(), "2019-11-01", this.acceptLanguage(), bslRequest, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BastionShareableLinkInner>>>>(){

            public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = NetworkManagementClientImpl.this.putBastionShareableLinkDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<BastionShareableLinkInner> putBastionShareableLink(String resourceGroupName, String bastionHostName, List<BastionShareableLinkInner> vms) {
        ServiceResponse response = (ServiceResponse)this.putBastionShareableLinkSinglePageAsync(resourceGroupName, bastionHostName, vms).toBlocking().single();
        return new PagedList<BastionShareableLinkInner>((Page)response.body()){

            public Page<BastionShareableLinkInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)NetworkManagementClientImpl.this.putBastionShareableLinkNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<BastionShareableLinkInner>> putBastionShareableLinkAsync(String resourceGroupName, String bastionHostName, List<BastionShareableLinkInner> vms, ListOperationCallback<BastionShareableLinkInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.putBastionShareableLinkSinglePageAsync(resourceGroupName, bastionHostName, vms), (Func1)new Func1<String, Observable<ServiceResponse<Page<BastionShareableLinkInner>>>>(){

            public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> call(String nextPageLink) {
                return NetworkManagementClientImpl.this.putBastionShareableLinkNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<BastionShareableLinkInner>> putBastionShareableLinkAsync(String resourceGroupName, String bastionHostName, List<BastionShareableLinkInner> vms) {
        return this.putBastionShareableLinkWithServiceResponseAsync(resourceGroupName, bastionHostName, vms).map((Func1)new Func1<ServiceResponse<Page<BastionShareableLinkInner>>, Page<BastionShareableLinkInner>>(){

            public Page<BastionShareableLinkInner> call(ServiceResponse<Page<BastionShareableLinkInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> putBastionShareableLinkWithServiceResponseAsync(String resourceGroupName, String bastionHostName, List<BastionShareableLinkInner> vms) {
        return this.putBastionShareableLinkSinglePageAsync(resourceGroupName, bastionHostName, vms).concatMap((Func1)new Func1<ServiceResponse<Page<BastionShareableLinkInner>>, Observable<ServiceResponse<Page<BastionShareableLinkInner>>>>(){

            public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> call(ServiceResponse<Page<BastionShareableLinkInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(NetworkManagementClientImpl.this.putBastionShareableLinkNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> putBastionShareableLinkSinglePageAsync(String resourceGroupName, String bastionHostName, List<BastionShareableLinkInner> vms) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (bastionHostName == null) {
            throw new IllegalArgumentException("Parameter bastionHostName is required and cannot be null.");
        }
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        Validator.validate(vms);
        String apiVersion = "2019-11-01";
        BastionShareableLinkListRequest bslRequest = new BastionShareableLinkListRequest();
        bslRequest.withVms(vms);
        return this.service.putBastionShareableLink(resourceGroupName, bastionHostName, this.subscriptionId(), "2019-11-01", this.acceptLanguage(), bslRequest, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BastionShareableLinkInner>>>>(){

            public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = NetworkManagementClientImpl.this.putBastionShareableLinkDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<BastionShareableLinkInner>> putBastionShareableLinkDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException, InterruptedException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<PageImpl<BastionShareableLinkInner>>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<BastionShareableLinkInner> beginPutBastionShareableLink(String resourceGroupName, String bastionHostName) {
        ServiceResponse response = (ServiceResponse)this.beginPutBastionShareableLinkSinglePageAsync(resourceGroupName, bastionHostName).toBlocking().single();
        return new PagedList<BastionShareableLinkInner>((Page)response.body()){

            public Page<BastionShareableLinkInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)NetworkManagementClientImpl.this.beginPutBastionShareableLinkNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<BastionShareableLinkInner>> beginPutBastionShareableLinkAsync(String resourceGroupName, String bastionHostName, ListOperationCallback<BastionShareableLinkInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.beginPutBastionShareableLinkSinglePageAsync(resourceGroupName, bastionHostName), (Func1)new Func1<String, Observable<ServiceResponse<Page<BastionShareableLinkInner>>>>(){

            public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> call(String nextPageLink) {
                return NetworkManagementClientImpl.this.beginPutBastionShareableLinkNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<BastionShareableLinkInner>> beginPutBastionShareableLinkAsync(String resourceGroupName, String bastionHostName) {
        return this.beginPutBastionShareableLinkWithServiceResponseAsync(resourceGroupName, bastionHostName).map((Func1)new Func1<ServiceResponse<Page<BastionShareableLinkInner>>, Page<BastionShareableLinkInner>>(){

            public Page<BastionShareableLinkInner> call(ServiceResponse<Page<BastionShareableLinkInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> beginPutBastionShareableLinkWithServiceResponseAsync(String resourceGroupName, String bastionHostName) {
        return this.beginPutBastionShareableLinkSinglePageAsync(resourceGroupName, bastionHostName).concatMap((Func1)new Func1<ServiceResponse<Page<BastionShareableLinkInner>>, Observable<ServiceResponse<Page<BastionShareableLinkInner>>>>(){

            public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> call(ServiceResponse<Page<BastionShareableLinkInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(NetworkManagementClientImpl.this.beginPutBastionShareableLinkNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> beginPutBastionShareableLinkSinglePageAsync(String resourceGroupName, String bastionHostName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (bastionHostName == null) {
            throw new IllegalArgumentException("Parameter bastionHostName is required and cannot be null.");
        }
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        Object vms = null;
        BastionShareableLinkListRequest bslRequest = new BastionShareableLinkListRequest();
        bslRequest.withVms(null);
        return this.service.beginPutBastionShareableLink(resourceGroupName, bastionHostName, this.subscriptionId(), "2019-11-01", this.acceptLanguage(), bslRequest, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BastionShareableLinkInner>>>>(){

            public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = NetworkManagementClientImpl.this.beginPutBastionShareableLinkDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<BastionShareableLinkInner> beginPutBastionShareableLink(String resourceGroupName, String bastionHostName, List<BastionShareableLinkInner> vms) {
        ServiceResponse response = (ServiceResponse)this.beginPutBastionShareableLinkSinglePageAsync(resourceGroupName, bastionHostName, vms).toBlocking().single();
        return new PagedList<BastionShareableLinkInner>((Page)response.body()){

            public Page<BastionShareableLinkInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)NetworkManagementClientImpl.this.beginPutBastionShareableLinkNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<BastionShareableLinkInner>> beginPutBastionShareableLinkAsync(String resourceGroupName, String bastionHostName, List<BastionShareableLinkInner> vms, ListOperationCallback<BastionShareableLinkInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.beginPutBastionShareableLinkSinglePageAsync(resourceGroupName, bastionHostName, vms), (Func1)new Func1<String, Observable<ServiceResponse<Page<BastionShareableLinkInner>>>>(){

            public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> call(String nextPageLink) {
                return NetworkManagementClientImpl.this.beginPutBastionShareableLinkNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<BastionShareableLinkInner>> beginPutBastionShareableLinkAsync(String resourceGroupName, String bastionHostName, List<BastionShareableLinkInner> vms) {
        return this.beginPutBastionShareableLinkWithServiceResponseAsync(resourceGroupName, bastionHostName, vms).map((Func1)new Func1<ServiceResponse<Page<BastionShareableLinkInner>>, Page<BastionShareableLinkInner>>(){

            public Page<BastionShareableLinkInner> call(ServiceResponse<Page<BastionShareableLinkInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> beginPutBastionShareableLinkWithServiceResponseAsync(String resourceGroupName, String bastionHostName, List<BastionShareableLinkInner> vms) {
        return this.beginPutBastionShareableLinkSinglePageAsync(resourceGroupName, bastionHostName, vms).concatMap((Func1)new Func1<ServiceResponse<Page<BastionShareableLinkInner>>, Observable<ServiceResponse<Page<BastionShareableLinkInner>>>>(){

            public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> call(ServiceResponse<Page<BastionShareableLinkInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(NetworkManagementClientImpl.this.beginPutBastionShareableLinkNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> beginPutBastionShareableLinkSinglePageAsync(String resourceGroupName, String bastionHostName, List<BastionShareableLinkInner> vms) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (bastionHostName == null) {
            throw new IllegalArgumentException("Parameter bastionHostName is required and cannot be null.");
        }
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        Validator.validate(vms);
        String apiVersion = "2019-11-01";
        BastionShareableLinkListRequest bslRequest = new BastionShareableLinkListRequest();
        bslRequest.withVms(vms);
        return this.service.beginPutBastionShareableLink(resourceGroupName, bastionHostName, this.subscriptionId(), "2019-11-01", this.acceptLanguage(), bslRequest, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BastionShareableLinkInner>>>>(){

            public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = NetworkManagementClientImpl.this.beginPutBastionShareableLinkDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<BastionShareableLinkInner>> beginPutBastionShareableLinkDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<PageImpl<BastionShareableLinkInner>>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void deleteBastionShareableLink(String resourceGroupName, String bastionHostName) {
        ((ServiceResponse)this.deleteBastionShareableLinkWithServiceResponseAsync(resourceGroupName, bastionHostName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteBastionShareableLinkAsync(String resourceGroupName, String bastionHostName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteBastionShareableLinkWithServiceResponseAsync(resourceGroupName, bastionHostName), serviceCallback);
    }

    public Observable<Void> deleteBastionShareableLinkAsync(String resourceGroupName, String bastionHostName) {
        return this.deleteBastionShareableLinkWithServiceResponseAsync(resourceGroupName, bastionHostName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteBastionShareableLinkWithServiceResponseAsync(String resourceGroupName, String bastionHostName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (bastionHostName == null) {
            throw new IllegalArgumentException("Parameter bastionHostName is required and cannot be null.");
        }
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        Object vmsConverted = null;
        BastionShareableLinkListRequest bslRequest = new BastionShareableLinkListRequest();
        bslRequest.withVms(null);
        Observable<Response<ResponseBody>> observable = this.service.deleteBastionShareableLink(resourceGroupName, bastionHostName, this.subscriptionId(), "2019-11-01", this.acceptLanguage(), bslRequest, this.userAgent());
        return this.getAzureClient().getPostOrDeleteResultAsync(observable, new LongRunningOperationOptions().withFinalStateVia(LongRunningFinalState.LOCATION), new TypeToken<Void>(){}.getType());
    }

    public void deleteBastionShareableLink(String resourceGroupName, String bastionHostName, List<BastionShareableLinkInner> vms) {
        ((ServiceResponse)this.deleteBastionShareableLinkWithServiceResponseAsync(resourceGroupName, bastionHostName, vms).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteBastionShareableLinkAsync(String resourceGroupName, String bastionHostName, List<BastionShareableLinkInner> vms, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteBastionShareableLinkWithServiceResponseAsync(resourceGroupName, bastionHostName, vms), serviceCallback);
    }

    public Observable<Void> deleteBastionShareableLinkAsync(String resourceGroupName, String bastionHostName, List<BastionShareableLinkInner> vms) {
        return this.deleteBastionShareableLinkWithServiceResponseAsync(resourceGroupName, bastionHostName, vms).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteBastionShareableLinkWithServiceResponseAsync(String resourceGroupName, String bastionHostName, List<BastionShareableLinkInner> vms) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (bastionHostName == null) {
            throw new IllegalArgumentException("Parameter bastionHostName is required and cannot be null.");
        }
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        Validator.validate(vms);
        String apiVersion = "2019-11-01";
        BastionShareableLinkListRequest bslRequest = new BastionShareableLinkListRequest();
        bslRequest.withVms(vms);
        Observable<Response<ResponseBody>> observable = this.service.deleteBastionShareableLink(resourceGroupName, bastionHostName, this.subscriptionId(), "2019-11-01", this.acceptLanguage(), bslRequest, this.userAgent());
        return this.getAzureClient().getPostOrDeleteResultAsync(observable, new LongRunningOperationOptions().withFinalStateVia(LongRunningFinalState.LOCATION), new TypeToken<Void>(){}.getType());
    }

    public void beginDeleteBastionShareableLink(String resourceGroupName, String bastionHostName) {
        ((ServiceResponse)this.beginDeleteBastionShareableLinkWithServiceResponseAsync(resourceGroupName, bastionHostName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteBastionShareableLinkAsync(String resourceGroupName, String bastionHostName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteBastionShareableLinkWithServiceResponseAsync(resourceGroupName, bastionHostName), serviceCallback);
    }

    public Observable<Void> beginDeleteBastionShareableLinkAsync(String resourceGroupName, String bastionHostName) {
        return this.beginDeleteBastionShareableLinkWithServiceResponseAsync(resourceGroupName, bastionHostName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteBastionShareableLinkWithServiceResponseAsync(String resourceGroupName, String bastionHostName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (bastionHostName == null) {
            throw new IllegalArgumentException("Parameter bastionHostName is required and cannot be null.");
        }
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        Object vms = null;
        BastionShareableLinkListRequest bslRequest = new BastionShareableLinkListRequest();
        bslRequest.withVms(null);
        return this.service.beginDeleteBastionShareableLink(resourceGroupName, bastionHostName, this.subscriptionId(), "2019-11-01", this.acceptLanguage(), bslRequest, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = NetworkManagementClientImpl.this.beginDeleteBastionShareableLinkDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public void beginDeleteBastionShareableLink(String resourceGroupName, String bastionHostName, List<BastionShareableLinkInner> vms) {
        ((ServiceResponse)this.beginDeleteBastionShareableLinkWithServiceResponseAsync(resourceGroupName, bastionHostName, vms).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteBastionShareableLinkAsync(String resourceGroupName, String bastionHostName, List<BastionShareableLinkInner> vms, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteBastionShareableLinkWithServiceResponseAsync(resourceGroupName, bastionHostName, vms), serviceCallback);
    }

    public Observable<Void> beginDeleteBastionShareableLinkAsync(String resourceGroupName, String bastionHostName, List<BastionShareableLinkInner> vms) {
        return this.beginDeleteBastionShareableLinkWithServiceResponseAsync(resourceGroupName, bastionHostName, vms).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteBastionShareableLinkWithServiceResponseAsync(String resourceGroupName, String bastionHostName, List<BastionShareableLinkInner> vms) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (bastionHostName == null) {
            throw new IllegalArgumentException("Parameter bastionHostName is required and cannot be null.");
        }
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        Validator.validate(vms);
        String apiVersion = "2019-11-01";
        BastionShareableLinkListRequest bslRequest = new BastionShareableLinkListRequest();
        bslRequest.withVms(vms);
        return this.service.beginDeleteBastionShareableLink(resourceGroupName, bastionHostName, this.subscriptionId(), "2019-11-01", this.acceptLanguage(), bslRequest, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = NetworkManagementClientImpl.this.beginDeleteBastionShareableLinkDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteBastionShareableLinkDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<BastionShareableLinkInner> getBastionShareableLink(String resourceGroupName, String bastionHostName) {
        ServiceResponse response = (ServiceResponse)this.getBastionShareableLinkSinglePageAsync(resourceGroupName, bastionHostName).toBlocking().single();
        return new PagedList<BastionShareableLinkInner>((Page)response.body()){

            public Page<BastionShareableLinkInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)NetworkManagementClientImpl.this.getBastionShareableLinkNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<BastionShareableLinkInner>> getBastionShareableLinkAsync(String resourceGroupName, String bastionHostName, ListOperationCallback<BastionShareableLinkInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.getBastionShareableLinkSinglePageAsync(resourceGroupName, bastionHostName), (Func1)new Func1<String, Observable<ServiceResponse<Page<BastionShareableLinkInner>>>>(){

            public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> call(String nextPageLink) {
                return NetworkManagementClientImpl.this.getBastionShareableLinkNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<BastionShareableLinkInner>> getBastionShareableLinkAsync(String resourceGroupName, String bastionHostName) {
        return this.getBastionShareableLinkWithServiceResponseAsync(resourceGroupName, bastionHostName).map((Func1)new Func1<ServiceResponse<Page<BastionShareableLinkInner>>, Page<BastionShareableLinkInner>>(){

            public Page<BastionShareableLinkInner> call(ServiceResponse<Page<BastionShareableLinkInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> getBastionShareableLinkWithServiceResponseAsync(String resourceGroupName, String bastionHostName) {
        return this.getBastionShareableLinkSinglePageAsync(resourceGroupName, bastionHostName).concatMap((Func1)new Func1<ServiceResponse<Page<BastionShareableLinkInner>>, Observable<ServiceResponse<Page<BastionShareableLinkInner>>>>(){

            public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> call(ServiceResponse<Page<BastionShareableLinkInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(NetworkManagementClientImpl.this.getBastionShareableLinkNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> getBastionShareableLinkSinglePageAsync(String resourceGroupName, String bastionHostName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (bastionHostName == null) {
            throw new IllegalArgumentException("Parameter bastionHostName is required and cannot be null.");
        }
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        Object vms = null;
        BastionShareableLinkListRequest bslRequest = new BastionShareableLinkListRequest();
        bslRequest.withVms(null);
        return this.service.getBastionShareableLink(resourceGroupName, bastionHostName, this.subscriptionId(), "2019-11-01", this.acceptLanguage(), bslRequest, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BastionShareableLinkInner>>>>(){

            public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = NetworkManagementClientImpl.this.getBastionShareableLinkDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<BastionShareableLinkInner> getBastionShareableLink(String resourceGroupName, String bastionHostName, List<BastionShareableLinkInner> vms) {
        ServiceResponse response = (ServiceResponse)this.getBastionShareableLinkSinglePageAsync(resourceGroupName, bastionHostName, vms).toBlocking().single();
        return new PagedList<BastionShareableLinkInner>((Page)response.body()){

            public Page<BastionShareableLinkInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)NetworkManagementClientImpl.this.getBastionShareableLinkNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<BastionShareableLinkInner>> getBastionShareableLinkAsync(String resourceGroupName, String bastionHostName, List<BastionShareableLinkInner> vms, ListOperationCallback<BastionShareableLinkInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.getBastionShareableLinkSinglePageAsync(resourceGroupName, bastionHostName, vms), (Func1)new Func1<String, Observable<ServiceResponse<Page<BastionShareableLinkInner>>>>(){

            public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> call(String nextPageLink) {
                return NetworkManagementClientImpl.this.getBastionShareableLinkNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<BastionShareableLinkInner>> getBastionShareableLinkAsync(String resourceGroupName, String bastionHostName, List<BastionShareableLinkInner> vms) {
        return this.getBastionShareableLinkWithServiceResponseAsync(resourceGroupName, bastionHostName, vms).map((Func1)new Func1<ServiceResponse<Page<BastionShareableLinkInner>>, Page<BastionShareableLinkInner>>(){

            public Page<BastionShareableLinkInner> call(ServiceResponse<Page<BastionShareableLinkInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> getBastionShareableLinkWithServiceResponseAsync(String resourceGroupName, String bastionHostName, List<BastionShareableLinkInner> vms) {
        return this.getBastionShareableLinkSinglePageAsync(resourceGroupName, bastionHostName, vms).concatMap((Func1)new Func1<ServiceResponse<Page<BastionShareableLinkInner>>, Observable<ServiceResponse<Page<BastionShareableLinkInner>>>>(){

            public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> call(ServiceResponse<Page<BastionShareableLinkInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(NetworkManagementClientImpl.this.getBastionShareableLinkNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> getBastionShareableLinkSinglePageAsync(String resourceGroupName, String bastionHostName, List<BastionShareableLinkInner> vms) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (bastionHostName == null) {
            throw new IllegalArgumentException("Parameter bastionHostName is required and cannot be null.");
        }
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        Validator.validate(vms);
        String apiVersion = "2019-11-01";
        BastionShareableLinkListRequest bslRequest = new BastionShareableLinkListRequest();
        bslRequest.withVms(vms);
        return this.service.getBastionShareableLink(resourceGroupName, bastionHostName, this.subscriptionId(), "2019-11-01", this.acceptLanguage(), bslRequest, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BastionShareableLinkInner>>>>(){

            public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = NetworkManagementClientImpl.this.getBastionShareableLinkDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<BastionShareableLinkInner>> getBastionShareableLinkDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<PageImpl<BastionShareableLinkInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<BastionActiveSessionInner> getActiveSessions(String resourceGroupName, String bastionHostName) {
        ServiceResponse response = (ServiceResponse)this.getActiveSessionsSinglePageAsync(resourceGroupName, bastionHostName).toBlocking().single();
        return new PagedList<BastionActiveSessionInner>((Page)response.body()){

            public Page<BastionActiveSessionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)NetworkManagementClientImpl.this.getActiveSessionsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<BastionActiveSessionInner>> getActiveSessionsAsync(String resourceGroupName, String bastionHostName, ListOperationCallback<BastionActiveSessionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.getActiveSessionsSinglePageAsync(resourceGroupName, bastionHostName), (Func1)new Func1<String, Observable<ServiceResponse<Page<BastionActiveSessionInner>>>>(){

            public Observable<ServiceResponse<Page<BastionActiveSessionInner>>> call(String nextPageLink) {
                return NetworkManagementClientImpl.this.getActiveSessionsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<BastionActiveSessionInner>> getActiveSessionsAsync(String resourceGroupName, String bastionHostName) {
        return this.getActiveSessionsWithServiceResponseAsync(resourceGroupName, bastionHostName).map((Func1)new Func1<ServiceResponse<Page<BastionActiveSessionInner>>, Page<BastionActiveSessionInner>>(){

            public Page<BastionActiveSessionInner> call(ServiceResponse<Page<BastionActiveSessionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<BastionActiveSessionInner>>> getActiveSessionsWithServiceResponseAsync(String resourceGroupName, String bastionHostName) {
        return this.getActiveSessionsSinglePageAsync(resourceGroupName, bastionHostName).concatMap((Func1)new Func1<ServiceResponse<Page<BastionActiveSessionInner>>, Observable<ServiceResponse<Page<BastionActiveSessionInner>>>>(){

            public Observable<ServiceResponse<Page<BastionActiveSessionInner>>> call(ServiceResponse<Page<BastionActiveSessionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(NetworkManagementClientImpl.this.getActiveSessionsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<BastionActiveSessionInner>>> getActiveSessionsSinglePageAsync(String resourceGroupName, String bastionHostName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (bastionHostName == null) {
            throw new IllegalArgumentException("Parameter bastionHostName is required and cannot be null.");
        }
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.getActiveSessions(resourceGroupName, bastionHostName, this.subscriptionId(), "2019-11-01", this.acceptLanguage(), this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BastionActiveSessionInner>>>>(){

            public Observable<ServiceResponse<Page<BastionActiveSessionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = NetworkManagementClientImpl.this.getActiveSessionsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<BastionActiveSessionInner>> getActiveSessionsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException, InterruptedException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<PageImpl<BastionActiveSessionInner>>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<BastionActiveSessionInner> beginGetActiveSessions(String resourceGroupName, String bastionHostName) {
        ServiceResponse response = (ServiceResponse)this.beginGetActiveSessionsSinglePageAsync(resourceGroupName, bastionHostName).toBlocking().single();
        return new PagedList<BastionActiveSessionInner>((Page)response.body()){

            public Page<BastionActiveSessionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)NetworkManagementClientImpl.this.beginGetActiveSessionsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<BastionActiveSessionInner>> beginGetActiveSessionsAsync(String resourceGroupName, String bastionHostName, ListOperationCallback<BastionActiveSessionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.beginGetActiveSessionsSinglePageAsync(resourceGroupName, bastionHostName), (Func1)new Func1<String, Observable<ServiceResponse<Page<BastionActiveSessionInner>>>>(){

            public Observable<ServiceResponse<Page<BastionActiveSessionInner>>> call(String nextPageLink) {
                return NetworkManagementClientImpl.this.beginGetActiveSessionsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<BastionActiveSessionInner>> beginGetActiveSessionsAsync(String resourceGroupName, String bastionHostName) {
        return this.beginGetActiveSessionsWithServiceResponseAsync(resourceGroupName, bastionHostName).map((Func1)new Func1<ServiceResponse<Page<BastionActiveSessionInner>>, Page<BastionActiveSessionInner>>(){

            public Page<BastionActiveSessionInner> call(ServiceResponse<Page<BastionActiveSessionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<BastionActiveSessionInner>>> beginGetActiveSessionsWithServiceResponseAsync(String resourceGroupName, String bastionHostName) {
        return this.beginGetActiveSessionsSinglePageAsync(resourceGroupName, bastionHostName).concatMap((Func1)new Func1<ServiceResponse<Page<BastionActiveSessionInner>>, Observable<ServiceResponse<Page<BastionActiveSessionInner>>>>(){

            public Observable<ServiceResponse<Page<BastionActiveSessionInner>>> call(ServiceResponse<Page<BastionActiveSessionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(NetworkManagementClientImpl.this.beginGetActiveSessionsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<BastionActiveSessionInner>>> beginGetActiveSessionsSinglePageAsync(String resourceGroupName, String bastionHostName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (bastionHostName == null) {
            throw new IllegalArgumentException("Parameter bastionHostName is required and cannot be null.");
        }
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.beginGetActiveSessions(resourceGroupName, bastionHostName, this.subscriptionId(), "2019-11-01", this.acceptLanguage(), this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BastionActiveSessionInner>>>>(){

            public Observable<ServiceResponse<Page<BastionActiveSessionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = NetworkManagementClientImpl.this.beginGetActiveSessionsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<BastionActiveSessionInner>> beginGetActiveSessionsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<PageImpl<BastionActiveSessionInner>>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<BastionSessionStateInner> disconnectActiveSessions(String resourceGroupName, String bastionHostName) {
        ServiceResponse response = (ServiceResponse)this.disconnectActiveSessionsSinglePageAsync(resourceGroupName, bastionHostName).toBlocking().single();
        return new PagedList<BastionSessionStateInner>((Page)response.body()){

            public Page<BastionSessionStateInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)NetworkManagementClientImpl.this.disconnectActiveSessionsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<BastionSessionStateInner>> disconnectActiveSessionsAsync(String resourceGroupName, String bastionHostName, ListOperationCallback<BastionSessionStateInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.disconnectActiveSessionsSinglePageAsync(resourceGroupName, bastionHostName), (Func1)new Func1<String, Observable<ServiceResponse<Page<BastionSessionStateInner>>>>(){

            public Observable<ServiceResponse<Page<BastionSessionStateInner>>> call(String nextPageLink) {
                return NetworkManagementClientImpl.this.disconnectActiveSessionsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<BastionSessionStateInner>> disconnectActiveSessionsAsync(String resourceGroupName, String bastionHostName) {
        return this.disconnectActiveSessionsWithServiceResponseAsync(resourceGroupName, bastionHostName).map((Func1)new Func1<ServiceResponse<Page<BastionSessionStateInner>>, Page<BastionSessionStateInner>>(){

            public Page<BastionSessionStateInner> call(ServiceResponse<Page<BastionSessionStateInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<BastionSessionStateInner>>> disconnectActiveSessionsWithServiceResponseAsync(String resourceGroupName, String bastionHostName) {
        return this.disconnectActiveSessionsSinglePageAsync(resourceGroupName, bastionHostName).concatMap((Func1)new Func1<ServiceResponse<Page<BastionSessionStateInner>>, Observable<ServiceResponse<Page<BastionSessionStateInner>>>>(){

            public Observable<ServiceResponse<Page<BastionSessionStateInner>>> call(ServiceResponse<Page<BastionSessionStateInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(NetworkManagementClientImpl.this.disconnectActiveSessionsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<BastionSessionStateInner>>> disconnectActiveSessionsSinglePageAsync(String resourceGroupName, String bastionHostName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (bastionHostName == null) {
            throw new IllegalArgumentException("Parameter bastionHostName is required and cannot be null.");
        }
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        Object sessionIds = null;
        SessionIds sessionIds1 = new SessionIds();
        sessionIds1.withSessionIds(null);
        return this.service.disconnectActiveSessions(resourceGroupName, bastionHostName, this.subscriptionId(), "2019-11-01", this.acceptLanguage(), sessionIds1, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BastionSessionStateInner>>>>(){

            public Observable<ServiceResponse<Page<BastionSessionStateInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = NetworkManagementClientImpl.this.disconnectActiveSessionsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<BastionSessionStateInner> disconnectActiveSessions(String resourceGroupName, String bastionHostName, List<String> sessionIds) {
        ServiceResponse response = (ServiceResponse)this.disconnectActiveSessionsSinglePageAsync(resourceGroupName, bastionHostName, sessionIds).toBlocking().single();
        return new PagedList<BastionSessionStateInner>((Page)response.body()){

            public Page<BastionSessionStateInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)NetworkManagementClientImpl.this.disconnectActiveSessionsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<BastionSessionStateInner>> disconnectActiveSessionsAsync(String resourceGroupName, String bastionHostName, List<String> sessionIds, ListOperationCallback<BastionSessionStateInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.disconnectActiveSessionsSinglePageAsync(resourceGroupName, bastionHostName, sessionIds), (Func1)new Func1<String, Observable<ServiceResponse<Page<BastionSessionStateInner>>>>(){

            public Observable<ServiceResponse<Page<BastionSessionStateInner>>> call(String nextPageLink) {
                return NetworkManagementClientImpl.this.disconnectActiveSessionsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<BastionSessionStateInner>> disconnectActiveSessionsAsync(String resourceGroupName, String bastionHostName, List<String> sessionIds) {
        return this.disconnectActiveSessionsWithServiceResponseAsync(resourceGroupName, bastionHostName, sessionIds).map((Func1)new Func1<ServiceResponse<Page<BastionSessionStateInner>>, Page<BastionSessionStateInner>>(){

            public Page<BastionSessionStateInner> call(ServiceResponse<Page<BastionSessionStateInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<BastionSessionStateInner>>> disconnectActiveSessionsWithServiceResponseAsync(String resourceGroupName, String bastionHostName, List<String> sessionIds) {
        return this.disconnectActiveSessionsSinglePageAsync(resourceGroupName, bastionHostName, sessionIds).concatMap((Func1)new Func1<ServiceResponse<Page<BastionSessionStateInner>>, Observable<ServiceResponse<Page<BastionSessionStateInner>>>>(){

            public Observable<ServiceResponse<Page<BastionSessionStateInner>>> call(ServiceResponse<Page<BastionSessionStateInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(NetworkManagementClientImpl.this.disconnectActiveSessionsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<BastionSessionStateInner>>> disconnectActiveSessionsSinglePageAsync(String resourceGroupName, String bastionHostName, List<String> sessionIds) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (bastionHostName == null) {
            throw new IllegalArgumentException("Parameter bastionHostName is required and cannot be null.");
        }
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        Validator.validate(sessionIds);
        String apiVersion = "2019-11-01";
        SessionIds sessionIds1 = new SessionIds();
        sessionIds1.withSessionIds(sessionIds);
        return this.service.disconnectActiveSessions(resourceGroupName, bastionHostName, this.subscriptionId(), "2019-11-01", this.acceptLanguage(), sessionIds1, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BastionSessionStateInner>>>>(){

            public Observable<ServiceResponse<Page<BastionSessionStateInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = NetworkManagementClientImpl.this.disconnectActiveSessionsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<BastionSessionStateInner>> disconnectActiveSessionsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<PageImpl<BastionSessionStateInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DnsNameAvailabilityResultInner checkDnsNameAvailability(String location, String domainNameLabel) {
        return (DnsNameAvailabilityResultInner)((ServiceResponse)this.checkDnsNameAvailabilityWithServiceResponseAsync(location, domainNameLabel).toBlocking().single()).body();
    }

    public ServiceFuture<DnsNameAvailabilityResultInner> checkDnsNameAvailabilityAsync(String location, String domainNameLabel, ServiceCallback<DnsNameAvailabilityResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.checkDnsNameAvailabilityWithServiceResponseAsync(location, domainNameLabel), serviceCallback);
    }

    public Observable<DnsNameAvailabilityResultInner> checkDnsNameAvailabilityAsync(String location, String domainNameLabel) {
        return this.checkDnsNameAvailabilityWithServiceResponseAsync(location, domainNameLabel).map((Func1)new Func1<ServiceResponse<DnsNameAvailabilityResultInner>, DnsNameAvailabilityResultInner>(){

            public DnsNameAvailabilityResultInner call(ServiceResponse<DnsNameAvailabilityResultInner> response) {
                return (DnsNameAvailabilityResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<DnsNameAvailabilityResultInner>> checkDnsNameAvailabilityWithServiceResponseAsync(String location, String domainNameLabel) {
        if (location == null) {
            throw new IllegalArgumentException("Parameter location is required and cannot be null.");
        }
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        if (domainNameLabel == null) {
            throw new IllegalArgumentException("Parameter domainNameLabel is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.checkDnsNameAvailability(location, this.subscriptionId(), domainNameLabel, "2019-11-01", this.acceptLanguage(), this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DnsNameAvailabilityResultInner>>>(){

            public Observable<ServiceResponse<DnsNameAvailabilityResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = NetworkManagementClientImpl.this.checkDnsNameAvailabilityDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DnsNameAvailabilityResultInner> checkDnsNameAvailabilityDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<DnsNameAvailabilityResultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public VirtualWanSecurityProvidersInner supportedSecurityProviders(String resourceGroupName, String virtualWANName) {
        return (VirtualWanSecurityProvidersInner)((ServiceResponse)this.supportedSecurityProvidersWithServiceResponseAsync(resourceGroupName, virtualWANName).toBlocking().single()).body();
    }

    public ServiceFuture<VirtualWanSecurityProvidersInner> supportedSecurityProvidersAsync(String resourceGroupName, String virtualWANName, ServiceCallback<VirtualWanSecurityProvidersInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.supportedSecurityProvidersWithServiceResponseAsync(resourceGroupName, virtualWANName), serviceCallback);
    }

    public Observable<VirtualWanSecurityProvidersInner> supportedSecurityProvidersAsync(String resourceGroupName, String virtualWANName) {
        return this.supportedSecurityProvidersWithServiceResponseAsync(resourceGroupName, virtualWANName).map((Func1)new Func1<ServiceResponse<VirtualWanSecurityProvidersInner>, VirtualWanSecurityProvidersInner>(){

            public VirtualWanSecurityProvidersInner call(ServiceResponse<VirtualWanSecurityProvidersInner> response) {
                return (VirtualWanSecurityProvidersInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<VirtualWanSecurityProvidersInner>> supportedSecurityProvidersWithServiceResponseAsync(String resourceGroupName, String virtualWANName) {
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualWANName == null) {
            throw new IllegalArgumentException("Parameter virtualWANName is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.supportedSecurityProviders(this.subscriptionId(), resourceGroupName, virtualWANName, "2019-11-01", this.acceptLanguage(), this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualWanSecurityProvidersInner>>>(){

            public Observable<ServiceResponse<VirtualWanSecurityProvidersInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = NetworkManagementClientImpl.this.supportedSecurityProvidersDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VirtualWanSecurityProvidersInner> supportedSecurityProvidersDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<VirtualWanSecurityProvidersInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public VpnProfileResponseInner generatevirtualwanvpnserverconfigurationvpnprofile(String resourceGroupName, String virtualWANName, VirtualWanVpnProfileParameters vpnClientParams) {
        return (VpnProfileResponseInner)((ServiceResponse)this.generatevirtualwanvpnserverconfigurationvpnprofileWithServiceResponseAsync(resourceGroupName, virtualWANName, vpnClientParams).toBlocking().last()).body();
    }

    public ServiceFuture<VpnProfileResponseInner> generatevirtualwanvpnserverconfigurationvpnprofileAsync(String resourceGroupName, String virtualWANName, VirtualWanVpnProfileParameters vpnClientParams, ServiceCallback<VpnProfileResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.generatevirtualwanvpnserverconfigurationvpnprofileWithServiceResponseAsync(resourceGroupName, virtualWANName, vpnClientParams), serviceCallback);
    }

    public Observable<VpnProfileResponseInner> generatevirtualwanvpnserverconfigurationvpnprofileAsync(String resourceGroupName, String virtualWANName, VirtualWanVpnProfileParameters vpnClientParams) {
        return this.generatevirtualwanvpnserverconfigurationvpnprofileWithServiceResponseAsync(resourceGroupName, virtualWANName, vpnClientParams).map((Func1)new Func1<ServiceResponse<VpnProfileResponseInner>, VpnProfileResponseInner>(){

            public VpnProfileResponseInner call(ServiceResponse<VpnProfileResponseInner> response) {
                return (VpnProfileResponseInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<VpnProfileResponseInner>> generatevirtualwanvpnserverconfigurationvpnprofileWithServiceResponseAsync(String resourceGroupName, String virtualWANName, VirtualWanVpnProfileParameters vpnClientParams) {
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualWANName == null) {
            throw new IllegalArgumentException("Parameter virtualWANName is required and cannot be null.");
        }
        if (vpnClientParams == null) {
            throw new IllegalArgumentException("Parameter vpnClientParams is required and cannot be null.");
        }
        Validator.validate((Object)vpnClientParams);
        String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = this.service.generatevirtualwanvpnserverconfigurationvpnprofile(this.subscriptionId(), resourceGroupName, virtualWANName, vpnClientParams, "2019-11-01", this.acceptLanguage(), this.userAgent());
        return this.getAzureClient().getPostOrDeleteResultAsync(observable, new LongRunningOperationOptions().withFinalStateVia(LongRunningFinalState.LOCATION), new TypeToken<VpnProfileResponseInner>(){}.getType());
    }

    public VpnProfileResponseInner beginGeneratevirtualwanvpnserverconfigurationvpnprofile(String resourceGroupName, String virtualWANName, VirtualWanVpnProfileParameters vpnClientParams) {
        return (VpnProfileResponseInner)((ServiceResponse)this.beginGeneratevirtualwanvpnserverconfigurationvpnprofileWithServiceResponseAsync(resourceGroupName, virtualWANName, vpnClientParams).toBlocking().single()).body();
    }

    public ServiceFuture<VpnProfileResponseInner> beginGeneratevirtualwanvpnserverconfigurationvpnprofileAsync(String resourceGroupName, String virtualWANName, VirtualWanVpnProfileParameters vpnClientParams, ServiceCallback<VpnProfileResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginGeneratevirtualwanvpnserverconfigurationvpnprofileWithServiceResponseAsync(resourceGroupName, virtualWANName, vpnClientParams), serviceCallback);
    }

    public Observable<VpnProfileResponseInner> beginGeneratevirtualwanvpnserverconfigurationvpnprofileAsync(String resourceGroupName, String virtualWANName, VirtualWanVpnProfileParameters vpnClientParams) {
        return this.beginGeneratevirtualwanvpnserverconfigurationvpnprofileWithServiceResponseAsync(resourceGroupName, virtualWANName, vpnClientParams).map((Func1)new Func1<ServiceResponse<VpnProfileResponseInner>, VpnProfileResponseInner>(){

            public VpnProfileResponseInner call(ServiceResponse<VpnProfileResponseInner> response) {
                return (VpnProfileResponseInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<VpnProfileResponseInner>> beginGeneratevirtualwanvpnserverconfigurationvpnprofileWithServiceResponseAsync(String resourceGroupName, String virtualWANName, VirtualWanVpnProfileParameters vpnClientParams) {
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualWANName == null) {
            throw new IllegalArgumentException("Parameter virtualWANName is required and cannot be null.");
        }
        if (vpnClientParams == null) {
            throw new IllegalArgumentException("Parameter vpnClientParams is required and cannot be null.");
        }
        Validator.validate((Object)vpnClientParams);
        String apiVersion = "2019-11-01";
        return this.service.beginGeneratevirtualwanvpnserverconfigurationvpnprofile(this.subscriptionId(), resourceGroupName, virtualWANName, vpnClientParams, "2019-11-01", this.acceptLanguage(), this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VpnProfileResponseInner>>>(){

            public Observable<ServiceResponse<VpnProfileResponseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = NetworkManagementClientImpl.this.beginGeneratevirtualwanvpnserverconfigurationvpnprofileDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VpnProfileResponseInner> beginGeneratevirtualwanvpnserverconfigurationvpnprofileDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<VpnProfileResponseInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<BastionShareableLinkInner> putBastionShareableLinkNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.putBastionShareableLinkNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<BastionShareableLinkInner>((Page)response.body()){

            public Page<BastionShareableLinkInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)NetworkManagementClientImpl.this.putBastionShareableLinkNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<BastionShareableLinkInner>> putBastionShareableLinkNextAsync(String nextPageLink, ServiceFuture<List<BastionShareableLinkInner>> serviceFuture, ListOperationCallback<BastionShareableLinkInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.putBastionShareableLinkNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<BastionShareableLinkInner>>>>(){

            public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> call(String nextPageLink) {
                return NetworkManagementClientImpl.this.putBastionShareableLinkNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<BastionShareableLinkInner>> putBastionShareableLinkNextAsync(String nextPageLink) {
        return this.putBastionShareableLinkNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<BastionShareableLinkInner>>, Page<BastionShareableLinkInner>>(){

            public Page<BastionShareableLinkInner> call(ServiceResponse<Page<BastionShareableLinkInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> putBastionShareableLinkNextWithServiceResponseAsync(String nextPageLink) {
        return this.putBastionShareableLinkNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<BastionShareableLinkInner>>, Observable<ServiceResponse<Page<BastionShareableLinkInner>>>>(){

            public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> call(ServiceResponse<Page<BastionShareableLinkInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(NetworkManagementClientImpl.this.putBastionShareableLinkNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> putBastionShareableLinkNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.putBastionShareableLinkNext(nextUrl, this.acceptLanguage(), this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BastionShareableLinkInner>>>>(){

            public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = NetworkManagementClientImpl.this.putBastionShareableLinkNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<BastionShareableLinkInner>> putBastionShareableLinkNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException, InterruptedException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<PageImpl<BastionShareableLinkInner>>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<BastionShareableLinkInner> beginPutBastionShareableLinkNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.beginPutBastionShareableLinkNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<BastionShareableLinkInner>((Page)response.body()){

            public Page<BastionShareableLinkInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)NetworkManagementClientImpl.this.beginPutBastionShareableLinkNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<BastionShareableLinkInner>> beginPutBastionShareableLinkNextAsync(String nextPageLink, ServiceFuture<List<BastionShareableLinkInner>> serviceFuture, ListOperationCallback<BastionShareableLinkInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.beginPutBastionShareableLinkNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<BastionShareableLinkInner>>>>(){

            public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> call(String nextPageLink) {
                return NetworkManagementClientImpl.this.beginPutBastionShareableLinkNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<BastionShareableLinkInner>> beginPutBastionShareableLinkNextAsync(String nextPageLink) {
        return this.beginPutBastionShareableLinkNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<BastionShareableLinkInner>>, Page<BastionShareableLinkInner>>(){

            public Page<BastionShareableLinkInner> call(ServiceResponse<Page<BastionShareableLinkInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> beginPutBastionShareableLinkNextWithServiceResponseAsync(String nextPageLink) {
        return this.beginPutBastionShareableLinkNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<BastionShareableLinkInner>>, Observable<ServiceResponse<Page<BastionShareableLinkInner>>>>(){

            public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> call(ServiceResponse<Page<BastionShareableLinkInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(NetworkManagementClientImpl.this.beginPutBastionShareableLinkNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> beginPutBastionShareableLinkNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.beginPutBastionShareableLinkNext(nextUrl, this.acceptLanguage(), this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BastionShareableLinkInner>>>>(){

            public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = NetworkManagementClientImpl.this.beginPutBastionShareableLinkNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<BastionShareableLinkInner>> beginPutBastionShareableLinkNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<PageImpl<BastionShareableLinkInner>>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<BastionShareableLinkInner> getBastionShareableLinkNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.getBastionShareableLinkNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<BastionShareableLinkInner>((Page)response.body()){

            public Page<BastionShareableLinkInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)NetworkManagementClientImpl.this.getBastionShareableLinkNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<BastionShareableLinkInner>> getBastionShareableLinkNextAsync(String nextPageLink, ServiceFuture<List<BastionShareableLinkInner>> serviceFuture, ListOperationCallback<BastionShareableLinkInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.getBastionShareableLinkNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<BastionShareableLinkInner>>>>(){

            public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> call(String nextPageLink) {
                return NetworkManagementClientImpl.this.getBastionShareableLinkNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<BastionShareableLinkInner>> getBastionShareableLinkNextAsync(String nextPageLink) {
        return this.getBastionShareableLinkNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<BastionShareableLinkInner>>, Page<BastionShareableLinkInner>>(){

            public Page<BastionShareableLinkInner> call(ServiceResponse<Page<BastionShareableLinkInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> getBastionShareableLinkNextWithServiceResponseAsync(String nextPageLink) {
        return this.getBastionShareableLinkNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<BastionShareableLinkInner>>, Observable<ServiceResponse<Page<BastionShareableLinkInner>>>>(){

            public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> call(ServiceResponse<Page<BastionShareableLinkInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(NetworkManagementClientImpl.this.getBastionShareableLinkNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> getBastionShareableLinkNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.getBastionShareableLinkNext(nextUrl, this.acceptLanguage(), this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BastionShareableLinkInner>>>>(){

            public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = NetworkManagementClientImpl.this.getBastionShareableLinkNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<BastionShareableLinkInner>> getBastionShareableLinkNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<PageImpl<BastionShareableLinkInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<BastionActiveSessionInner> getActiveSessionsNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.getActiveSessionsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<BastionActiveSessionInner>((Page)response.body()){

            public Page<BastionActiveSessionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)NetworkManagementClientImpl.this.getActiveSessionsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<BastionActiveSessionInner>> getActiveSessionsNextAsync(String nextPageLink, ServiceFuture<List<BastionActiveSessionInner>> serviceFuture, ListOperationCallback<BastionActiveSessionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.getActiveSessionsNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<BastionActiveSessionInner>>>>(){

            public Observable<ServiceResponse<Page<BastionActiveSessionInner>>> call(String nextPageLink) {
                return NetworkManagementClientImpl.this.getActiveSessionsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<BastionActiveSessionInner>> getActiveSessionsNextAsync(String nextPageLink) {
        return this.getActiveSessionsNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<BastionActiveSessionInner>>, Page<BastionActiveSessionInner>>(){

            public Page<BastionActiveSessionInner> call(ServiceResponse<Page<BastionActiveSessionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<BastionActiveSessionInner>>> getActiveSessionsNextWithServiceResponseAsync(String nextPageLink) {
        return this.getActiveSessionsNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<BastionActiveSessionInner>>, Observable<ServiceResponse<Page<BastionActiveSessionInner>>>>(){

            public Observable<ServiceResponse<Page<BastionActiveSessionInner>>> call(ServiceResponse<Page<BastionActiveSessionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(NetworkManagementClientImpl.this.getActiveSessionsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<BastionActiveSessionInner>>> getActiveSessionsNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.getActiveSessionsNext(nextUrl, this.acceptLanguage(), this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BastionActiveSessionInner>>>>(){

            public Observable<ServiceResponse<Page<BastionActiveSessionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = NetworkManagementClientImpl.this.getActiveSessionsNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<BastionActiveSessionInner>> getActiveSessionsNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException, InterruptedException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<PageImpl<BastionActiveSessionInner>>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<BastionActiveSessionInner> beginGetActiveSessionsNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.beginGetActiveSessionsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<BastionActiveSessionInner>((Page)response.body()){

            public Page<BastionActiveSessionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)NetworkManagementClientImpl.this.beginGetActiveSessionsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<BastionActiveSessionInner>> beginGetActiveSessionsNextAsync(String nextPageLink, ServiceFuture<List<BastionActiveSessionInner>> serviceFuture, ListOperationCallback<BastionActiveSessionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.beginGetActiveSessionsNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<BastionActiveSessionInner>>>>(){

            public Observable<ServiceResponse<Page<BastionActiveSessionInner>>> call(String nextPageLink) {
                return NetworkManagementClientImpl.this.beginGetActiveSessionsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<BastionActiveSessionInner>> beginGetActiveSessionsNextAsync(String nextPageLink) {
        return this.beginGetActiveSessionsNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<BastionActiveSessionInner>>, Page<BastionActiveSessionInner>>(){

            public Page<BastionActiveSessionInner> call(ServiceResponse<Page<BastionActiveSessionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<BastionActiveSessionInner>>> beginGetActiveSessionsNextWithServiceResponseAsync(String nextPageLink) {
        return this.beginGetActiveSessionsNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<BastionActiveSessionInner>>, Observable<ServiceResponse<Page<BastionActiveSessionInner>>>>(){

            public Observable<ServiceResponse<Page<BastionActiveSessionInner>>> call(ServiceResponse<Page<BastionActiveSessionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(NetworkManagementClientImpl.this.beginGetActiveSessionsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<BastionActiveSessionInner>>> beginGetActiveSessionsNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.beginGetActiveSessionsNext(nextUrl, this.acceptLanguage(), this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BastionActiveSessionInner>>>>(){

            public Observable<ServiceResponse<Page<BastionActiveSessionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = NetworkManagementClientImpl.this.beginGetActiveSessionsNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<BastionActiveSessionInner>> beginGetActiveSessionsNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<PageImpl<BastionActiveSessionInner>>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<BastionSessionStateInner> disconnectActiveSessionsNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.disconnectActiveSessionsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<BastionSessionStateInner>((Page)response.body()){

            public Page<BastionSessionStateInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)NetworkManagementClientImpl.this.disconnectActiveSessionsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<BastionSessionStateInner>> disconnectActiveSessionsNextAsync(String nextPageLink, ServiceFuture<List<BastionSessionStateInner>> serviceFuture, ListOperationCallback<BastionSessionStateInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.disconnectActiveSessionsNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<BastionSessionStateInner>>>>(){

            public Observable<ServiceResponse<Page<BastionSessionStateInner>>> call(String nextPageLink) {
                return NetworkManagementClientImpl.this.disconnectActiveSessionsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<BastionSessionStateInner>> disconnectActiveSessionsNextAsync(String nextPageLink) {
        return this.disconnectActiveSessionsNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<BastionSessionStateInner>>, Page<BastionSessionStateInner>>(){

            public Page<BastionSessionStateInner> call(ServiceResponse<Page<BastionSessionStateInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<BastionSessionStateInner>>> disconnectActiveSessionsNextWithServiceResponseAsync(String nextPageLink) {
        return this.disconnectActiveSessionsNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<BastionSessionStateInner>>, Observable<ServiceResponse<Page<BastionSessionStateInner>>>>(){

            public Observable<ServiceResponse<Page<BastionSessionStateInner>>> call(ServiceResponse<Page<BastionSessionStateInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(NetworkManagementClientImpl.this.disconnectActiveSessionsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<BastionSessionStateInner>>> disconnectActiveSessionsNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.disconnectActiveSessionsNext(nextUrl, this.acceptLanguage(), this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BastionSessionStateInner>>>>(){

            public Observable<ServiceResponse<Page<BastionSessionStateInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = NetworkManagementClientImpl.this.disconnectActiveSessionsNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<BastionSessionStateInner>> disconnectActiveSessionsNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<PageImpl<BastionSessionStateInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface NetworkManagementClientService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkManagementClient putBastionShareableLink"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/bastionHosts/{bastionHostName}/createShareableLinks")
        public Observable<Response<ResponseBody>> putBastionShareableLink(@Path(value="resourceGroupName") String var1, @Path(value="bastionHostName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body BastionShareableLinkListRequest var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkManagementClient beginPutBastionShareableLink"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/bastionHosts/{bastionHostName}/createShareableLinks")
        public Observable<Response<ResponseBody>> beginPutBastionShareableLink(@Path(value="resourceGroupName") String var1, @Path(value="bastionHostName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body BastionShareableLinkListRequest var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkManagementClient deleteBastionShareableLink"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/bastionHosts/{bastionHostName}/deleteShareableLinks")
        public Observable<Response<ResponseBody>> deleteBastionShareableLink(@Path(value="resourceGroupName") String var1, @Path(value="bastionHostName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body BastionShareableLinkListRequest var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkManagementClient beginDeleteBastionShareableLink"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/bastionHosts/{bastionHostName}/deleteShareableLinks")
        public Observable<Response<ResponseBody>> beginDeleteBastionShareableLink(@Path(value="resourceGroupName") String var1, @Path(value="bastionHostName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body BastionShareableLinkListRequest var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkManagementClient getBastionShareableLink"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/bastionHosts/{bastionHostName}/getShareableLinks")
        public Observable<Response<ResponseBody>> getBastionShareableLink(@Path(value="resourceGroupName") String var1, @Path(value="bastionHostName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body BastionShareableLinkListRequest var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkManagementClient getActiveSessions"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/bastionHosts/{bastionHostName}/getActiveSessions")
        public Observable<Response<ResponseBody>> getActiveSessions(@Path(value="resourceGroupName") String var1, @Path(value="bastionHostName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkManagementClient beginGetActiveSessions"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/bastionHosts/{bastionHostName}/getActiveSessions")
        public Observable<Response<ResponseBody>> beginGetActiveSessions(@Path(value="resourceGroupName") String var1, @Path(value="bastionHostName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkManagementClient disconnectActiveSessions"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/bastionHosts/{bastionHostName}/disconnectActiveSessions")
        public Observable<Response<ResponseBody>> disconnectActiveSessions(@Path(value="resourceGroupName") String var1, @Path(value="bastionHostName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body SessionIds var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkManagementClient checkDnsNameAvailability"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Network/locations/{location}/CheckDnsNameAvailability")
        public Observable<Response<ResponseBody>> checkDnsNameAvailability(@Path(value="location") String var1, @Path(value="subscriptionId") String var2, @Query(value="domainNameLabel") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkManagementClient supportedSecurityProviders"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualWans/{virtualWANName}/supportedSecurityProviders")
        public Observable<Response<ResponseBody>> supportedSecurityProviders(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="virtualWANName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkManagementClient generatevirtualwanvpnserverconfigurationvpnprofile"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualWans/{virtualWANName}/GenerateVpnProfile")
        public Observable<Response<ResponseBody>> generatevirtualwanvpnserverconfigurationvpnprofile(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="virtualWANName") String var3, @Body VirtualWanVpnProfileParameters var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkManagementClient beginGeneratevirtualwanvpnserverconfigurationvpnprofile"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualWans/{virtualWANName}/GenerateVpnProfile")
        public Observable<Response<ResponseBody>> beginGeneratevirtualwanvpnserverconfigurationvpnprofile(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="virtualWANName") String var3, @Body VirtualWanVpnProfileParameters var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkManagementClient putBastionShareableLinkNext"})
        @GET
        public Observable<Response<ResponseBody>> putBastionShareableLinkNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkManagementClient beginPutBastionShareableLinkNext"})
        @GET
        public Observable<Response<ResponseBody>> beginPutBastionShareableLinkNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkManagementClient getBastionShareableLinkNext"})
        @GET
        public Observable<Response<ResponseBody>> getBastionShareableLinkNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkManagementClient getActiveSessionsNext"})
        @GET
        public Observable<Response<ResponseBody>> getActiveSessionsNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkManagementClient beginGetActiveSessionsNext"})
        @GET
        public Observable<Response<ResponseBody>> beginGetActiveSessionsNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkManagementClient disconnectActiveSessionsNext"})
        @GET
        public Observable<Response<ResponseBody>> disconnectActiveSessionsNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

