/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.network.ErrorResponseException;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.Path;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in FlowLogs.
 */
public class FlowLogsInner {
    /** The Retrofit service to perform REST calls. */
    private FlowLogsService service;
    /** The service client containing this operation class. */
    private NetworkManagementClientImpl client;

    /**
     * Initializes an instance of FlowLogsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public FlowLogsInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = retrofit.create(FlowLogsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for FlowLogs to be
     * used by Retrofit to perform actually REST calls.
     */
    interface FlowLogsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.FlowLogs createOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/flowLogs/{flowLogName}")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("networkWatcherName") String networkWatcherName, @Path("flowLogName") String flowLogName, @Path("subscriptionId") String subscriptionId, @Body FlowLogInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.FlowLogs beginCreateOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/flowLogs/{flowLogName}")
        Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("networkWatcherName") String networkWatcherName, @Path("flowLogName") String flowLogName, @Path("subscriptionId") String subscriptionId, @Body FlowLogInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.FlowLogs get" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/flowLogs/{flowLogName}")
        Observable<Response<ResponseBody>> get(@Path("resourceGroupName") String resourceGroupName, @Path("networkWatcherName") String networkWatcherName, @Path("flowLogName") String flowLogName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.FlowLogs delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/flowLogs/{flowLogName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("resourceGroupName") String resourceGroupName, @Path("networkWatcherName") String networkWatcherName, @Path("flowLogName") String flowLogName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.FlowLogs beginDelete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/flowLogs/{flowLogName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDelete(@Path("resourceGroupName") String resourceGroupName, @Path("networkWatcherName") String networkWatcherName, @Path("flowLogName") String flowLogName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.FlowLogs list" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/flowLogs")
        Observable<Response<ResponseBody>> list(@Path("resourceGroupName") String resourceGroupName, @Path("networkWatcherName") String networkWatcherName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.FlowLogs listNext" })
        @GET
        Observable<Response<ResponseBody>> listNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Create or update a flow log for the specified network security group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param flowLogName The name of the flow log.
     * @param parameters Parameters that define the create or update flow log resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the FlowLogInner object if successful.
     */
    public FlowLogInner createOrUpdate(String resourceGroupName, String networkWatcherName, String flowLogName, FlowLogInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, networkWatcherName, flowLogName, parameters).toBlocking().last().body();
    }

    /**
     * Create or update a flow log for the specified network security group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param flowLogName The name of the flow log.
     * @param parameters Parameters that define the create or update flow log resource.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<FlowLogInner> createOrUpdateAsync(String resourceGroupName, String networkWatcherName, String flowLogName, FlowLogInner parameters, final ServiceCallback<FlowLogInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, networkWatcherName, flowLogName, parameters), serviceCallback);
    }

    /**
     * Create or update a flow log for the specified network security group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param flowLogName The name of the flow log.
     * @param parameters Parameters that define the create or update flow log resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<FlowLogInner> createOrUpdateAsync(String resourceGroupName, String networkWatcherName, String flowLogName, FlowLogInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, networkWatcherName, flowLogName, parameters).map(new Func1<ServiceResponse<FlowLogInner>, FlowLogInner>() {
            @Override
            public FlowLogInner call(ServiceResponse<FlowLogInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create or update a flow log for the specified network security group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param flowLogName The name of the flow log.
     * @param parameters Parameters that define the create or update flow log resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<FlowLogInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String networkWatcherName, String flowLogName, FlowLogInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (flowLogName == null) {
            throw new IllegalArgumentException("Parameter flowLogName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = service.createOrUpdate(resourceGroupName, networkWatcherName, flowLogName, this.client.subscriptionId(), parameters, apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<FlowLogInner>() { }.getType());
    }

    /**
     * Create or update a flow log for the specified network security group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param flowLogName The name of the flow log.
     * @param parameters Parameters that define the create or update flow log resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the FlowLogInner object if successful.
     */
    public FlowLogInner beginCreateOrUpdate(String resourceGroupName, String networkWatcherName, String flowLogName, FlowLogInner parameters) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, networkWatcherName, flowLogName, parameters).toBlocking().single().body();
    }

    /**
     * Create or update a flow log for the specified network security group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param flowLogName The name of the flow log.
     * @param parameters Parameters that define the create or update flow log resource.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<FlowLogInner> beginCreateOrUpdateAsync(String resourceGroupName, String networkWatcherName, String flowLogName, FlowLogInner parameters, final ServiceCallback<FlowLogInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, networkWatcherName, flowLogName, parameters), serviceCallback);
    }

    /**
     * Create or update a flow log for the specified network security group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param flowLogName The name of the flow log.
     * @param parameters Parameters that define the create or update flow log resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the FlowLogInner object
     */
    public Observable<FlowLogInner> beginCreateOrUpdateAsync(String resourceGroupName, String networkWatcherName, String flowLogName, FlowLogInner parameters) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, networkWatcherName, flowLogName, parameters).map(new Func1<ServiceResponse<FlowLogInner>, FlowLogInner>() {
            @Override
            public FlowLogInner call(ServiceResponse<FlowLogInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create or update a flow log for the specified network security group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param flowLogName The name of the flow log.
     * @param parameters Parameters that define the create or update flow log resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the FlowLogInner object
     */
    public Observable<ServiceResponse<FlowLogInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String networkWatcherName, String flowLogName, FlowLogInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (flowLogName == null) {
            throw new IllegalArgumentException("Parameter flowLogName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String apiVersion = "2019-11-01";
        return service.beginCreateOrUpdate(resourceGroupName, networkWatcherName, flowLogName, this.client.subscriptionId(), parameters, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<FlowLogInner>>>() {
                @Override
                public Observable<ServiceResponse<FlowLogInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<FlowLogInner> clientResponse = beginCreateOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<FlowLogInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<FlowLogInner, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<FlowLogInner>() { }.getType())
                .register(201, new TypeToken<FlowLogInner>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

    /**
     * Gets a flow log resource by name.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param flowLogName The name of the flow log resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the FlowLogInner object if successful.
     */
    public FlowLogInner get(String resourceGroupName, String networkWatcherName, String flowLogName) {
        return getWithServiceResponseAsync(resourceGroupName, networkWatcherName, flowLogName).toBlocking().single().body();
    }

    /**
     * Gets a flow log resource by name.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param flowLogName The name of the flow log resource.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<FlowLogInner> getAsync(String resourceGroupName, String networkWatcherName, String flowLogName, final ServiceCallback<FlowLogInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(resourceGroupName, networkWatcherName, flowLogName), serviceCallback);
    }

    /**
     * Gets a flow log resource by name.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param flowLogName The name of the flow log resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the FlowLogInner object
     */
    public Observable<FlowLogInner> getAsync(String resourceGroupName, String networkWatcherName, String flowLogName) {
        return getWithServiceResponseAsync(resourceGroupName, networkWatcherName, flowLogName).map(new Func1<ServiceResponse<FlowLogInner>, FlowLogInner>() {
            @Override
            public FlowLogInner call(ServiceResponse<FlowLogInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets a flow log resource by name.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param flowLogName The name of the flow log resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the FlowLogInner object
     */
    public Observable<ServiceResponse<FlowLogInner>> getWithServiceResponseAsync(String resourceGroupName, String networkWatcherName, String flowLogName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (flowLogName == null) {
            throw new IllegalArgumentException("Parameter flowLogName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        return service.get(resourceGroupName, networkWatcherName, flowLogName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<FlowLogInner>>>() {
                @Override
                public Observable<ServiceResponse<FlowLogInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<FlowLogInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<FlowLogInner> getDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<FlowLogInner, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<FlowLogInner>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

    /**
     * Deletes the specified flow log resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param flowLogName The name of the flow log resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String networkWatcherName, String flowLogName) {
        deleteWithServiceResponseAsync(resourceGroupName, networkWatcherName, flowLogName).toBlocking().last().body();
    }

    /**
     * Deletes the specified flow log resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param flowLogName The name of the flow log resource.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String networkWatcherName, String flowLogName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, networkWatcherName, flowLogName), serviceCallback);
    }

    /**
     * Deletes the specified flow log resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param flowLogName The name of the flow log resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String networkWatcherName, String flowLogName) {
        return deleteWithServiceResponseAsync(resourceGroupName, networkWatcherName, flowLogName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes the specified flow log resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param flowLogName The name of the flow log resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String networkWatcherName, String flowLogName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (flowLogName == null) {
            throw new IllegalArgumentException("Parameter flowLogName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = service.delete(resourceGroupName, networkWatcherName, flowLogName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes the specified flow log resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param flowLogName The name of the flow log resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDelete(String resourceGroupName, String networkWatcherName, String flowLogName) {
        beginDeleteWithServiceResponseAsync(resourceGroupName, networkWatcherName, flowLogName).toBlocking().single().body();
    }

    /**
     * Deletes the specified flow log resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param flowLogName The name of the flow log resource.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String networkWatcherName, String flowLogName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteWithServiceResponseAsync(resourceGroupName, networkWatcherName, flowLogName), serviceCallback);
    }

    /**
     * Deletes the specified flow log resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param flowLogName The name of the flow log resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAsync(String resourceGroupName, String networkWatcherName, String flowLogName) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, networkWatcherName, flowLogName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes the specified flow log resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param flowLogName The name of the flow log resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String networkWatcherName, String flowLogName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (flowLogName == null) {
            throw new IllegalArgumentException("Parameter flowLogName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        return service.beginDelete(resourceGroupName, networkWatcherName, flowLogName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

    /**
     * Lists all flow log resources for the specified Network Watcher.
     *
     * @param resourceGroupName The name of the resource group containing Network Watcher.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;FlowLogInner&gt; object if successful.
     */
    public PagedList<FlowLogInner> list(final String resourceGroupName, final String networkWatcherName) {
        ServiceResponse<Page<FlowLogInner>> response = listSinglePageAsync(resourceGroupName, networkWatcherName).toBlocking().single();
        return new PagedList<FlowLogInner>(response.body()) {
            @Override
            public Page<FlowLogInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all flow log resources for the specified Network Watcher.
     *
     * @param resourceGroupName The name of the resource group containing Network Watcher.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<FlowLogInner>> listAsync(final String resourceGroupName, final String networkWatcherName, final ListOperationCallback<FlowLogInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(resourceGroupName, networkWatcherName),
            new Func1<String, Observable<ServiceResponse<Page<FlowLogInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<FlowLogInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all flow log resources for the specified Network Watcher.
     *
     * @param resourceGroupName The name of the resource group containing Network Watcher.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;FlowLogInner&gt; object
     */
    public Observable<Page<FlowLogInner>> listAsync(final String resourceGroupName, final String networkWatcherName) {
        return listWithServiceResponseAsync(resourceGroupName, networkWatcherName)
            .map(new Func1<ServiceResponse<Page<FlowLogInner>>, Page<FlowLogInner>>() {
                @Override
                public Page<FlowLogInner> call(ServiceResponse<Page<FlowLogInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all flow log resources for the specified Network Watcher.
     *
     * @param resourceGroupName The name of the resource group containing Network Watcher.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;FlowLogInner&gt; object
     */
    public Observable<ServiceResponse<Page<FlowLogInner>>> listWithServiceResponseAsync(final String resourceGroupName, final String networkWatcherName) {
        return listSinglePageAsync(resourceGroupName, networkWatcherName)
            .concatMap(new Func1<ServiceResponse<Page<FlowLogInner>>, Observable<ServiceResponse<Page<FlowLogInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<FlowLogInner>>> call(ServiceResponse<Page<FlowLogInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all flow log resources for the specified Network Watcher.
     *
    ServiceResponse<PageImpl<FlowLogInner>> * @param resourceGroupName The name of the resource group containing Network Watcher.
    ServiceResponse<PageImpl<FlowLogInner>> * @param networkWatcherName The name of the Network Watcher resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;FlowLogInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<FlowLogInner>>> listSinglePageAsync(final String resourceGroupName, final String networkWatcherName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        return service.list(resourceGroupName, networkWatcherName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<FlowLogInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<FlowLogInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<FlowLogInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<FlowLogInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<FlowLogInner>> listDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<FlowLogInner>, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<FlowLogInner>>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

    /**
     * Lists all flow log resources for the specified Network Watcher.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;FlowLogInner&gt; object if successful.
     */
    public PagedList<FlowLogInner> listNext(final String nextPageLink) {
        ServiceResponse<Page<FlowLogInner>> response = listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<FlowLogInner>(response.body()) {
            @Override
            public Page<FlowLogInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all flow log resources for the specified Network Watcher.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<FlowLogInner>> listNextAsync(final String nextPageLink, final ServiceFuture<List<FlowLogInner>> serviceFuture, final ListOperationCallback<FlowLogInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<FlowLogInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<FlowLogInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all flow log resources for the specified Network Watcher.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;FlowLogInner&gt; object
     */
    public Observable<Page<FlowLogInner>> listNextAsync(final String nextPageLink) {
        return listNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<FlowLogInner>>, Page<FlowLogInner>>() {
                @Override
                public Page<FlowLogInner> call(ServiceResponse<Page<FlowLogInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all flow log resources for the specified Network Watcher.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;FlowLogInner&gt; object
     */
    public Observable<ServiceResponse<Page<FlowLogInner>>> listNextWithServiceResponseAsync(final String nextPageLink) {
        return listNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<FlowLogInner>>, Observable<ServiceResponse<Page<FlowLogInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<FlowLogInner>>> call(ServiceResponse<Page<FlowLogInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all flow log resources for the specified Network Watcher.
     *
    ServiceResponse<PageImpl<FlowLogInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;FlowLogInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<FlowLogInner>>> listNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<FlowLogInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<FlowLogInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<FlowLogInner>> result = listNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<FlowLogInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<FlowLogInner>> listNextDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<FlowLogInner>, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<FlowLogInner>>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

}
