/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.network.implementation.BackendAddressPoolInner;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.PageImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class LoadBalancerBackendAddressPoolsInner {
    private LoadBalancerBackendAddressPoolsService service;
    private NetworkManagementClientImpl client;

    public LoadBalancerBackendAddressPoolsInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (LoadBalancerBackendAddressPoolsService)retrofit.create(LoadBalancerBackendAddressPoolsService.class);
        this.client = client;
    }

    public PagedList<BackendAddressPoolInner> list(String resourceGroupName, String loadBalancerName) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(resourceGroupName, loadBalancerName).toBlocking().single();
        return new PagedList<BackendAddressPoolInner>((Page)response.body()){

            public Page<BackendAddressPoolInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)LoadBalancerBackendAddressPoolsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<BackendAddressPoolInner>> listAsync(String resourceGroupName, String loadBalancerName, ListOperationCallback<BackendAddressPoolInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(resourceGroupName, loadBalancerName), (Func1)new Func1<String, Observable<ServiceResponse<Page<BackendAddressPoolInner>>>>(){

            public Observable<ServiceResponse<Page<BackendAddressPoolInner>>> call(String nextPageLink) {
                return LoadBalancerBackendAddressPoolsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<BackendAddressPoolInner>> listAsync(String resourceGroupName, String loadBalancerName) {
        return this.listWithServiceResponseAsync(resourceGroupName, loadBalancerName).map((Func1)new Func1<ServiceResponse<Page<BackendAddressPoolInner>>, Page<BackendAddressPoolInner>>(){

            public Page<BackendAddressPoolInner> call(ServiceResponse<Page<BackendAddressPoolInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<BackendAddressPoolInner>>> listWithServiceResponseAsync(String resourceGroupName, String loadBalancerName) {
        return this.listSinglePageAsync(resourceGroupName, loadBalancerName).concatMap((Func1)new Func1<ServiceResponse<Page<BackendAddressPoolInner>>, Observable<ServiceResponse<Page<BackendAddressPoolInner>>>>(){

            public Observable<ServiceResponse<Page<BackendAddressPoolInner>>> call(ServiceResponse<Page<BackendAddressPoolInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(LoadBalancerBackendAddressPoolsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<BackendAddressPoolInner>>> listSinglePageAsync(String resourceGroupName, String loadBalancerName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (loadBalancerName == null) {
            throw new IllegalArgumentException("Parameter loadBalancerName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.list(resourceGroupName, loadBalancerName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BackendAddressPoolInner>>>>(){

            public Observable<ServiceResponse<Page<BackendAddressPoolInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = LoadBalancerBackendAddressPoolsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<BackendAddressPoolInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<BackendAddressPoolInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public BackendAddressPoolInner get(String resourceGroupName, String loadBalancerName, String backendAddressPoolName) {
        return (BackendAddressPoolInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, loadBalancerName, backendAddressPoolName).toBlocking().single()).body());
    }

    public ServiceFuture<BackendAddressPoolInner> getAsync(String resourceGroupName, String loadBalancerName, String backendAddressPoolName, ServiceCallback<BackendAddressPoolInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, loadBalancerName, backendAddressPoolName), serviceCallback);
    }

    public Observable<BackendAddressPoolInner> getAsync(String resourceGroupName, String loadBalancerName, String backendAddressPoolName) {
        return this.getWithServiceResponseAsync(resourceGroupName, loadBalancerName, backendAddressPoolName).map((Func1)new Func1<ServiceResponse<BackendAddressPoolInner>, BackendAddressPoolInner>(){

            public BackendAddressPoolInner call(ServiceResponse<BackendAddressPoolInner> response) {
                return (BackendAddressPoolInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<BackendAddressPoolInner>> getWithServiceResponseAsync(String resourceGroupName, String loadBalancerName, String backendAddressPoolName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (loadBalancerName == null) {
            throw new IllegalArgumentException("Parameter loadBalancerName is required and cannot be null.");
        }
        if (backendAddressPoolName == null) {
            throw new IllegalArgumentException("Parameter backendAddressPoolName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.get(resourceGroupName, loadBalancerName, backendAddressPoolName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<BackendAddressPoolInner>>>(){

            public Observable<ServiceResponse<BackendAddressPoolInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = LoadBalancerBackendAddressPoolsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<BackendAddressPoolInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<BackendAddressPoolInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<BackendAddressPoolInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<BackendAddressPoolInner>((Page)response.body()){

            public Page<BackendAddressPoolInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)LoadBalancerBackendAddressPoolsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<BackendAddressPoolInner>> listNextAsync(String nextPageLink, ServiceFuture<List<BackendAddressPoolInner>> serviceFuture, ListOperationCallback<BackendAddressPoolInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<BackendAddressPoolInner>>>>(){

            public Observable<ServiceResponse<Page<BackendAddressPoolInner>>> call(String nextPageLink) {
                return LoadBalancerBackendAddressPoolsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<BackendAddressPoolInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<BackendAddressPoolInner>>, Page<BackendAddressPoolInner>>(){

            public Page<BackendAddressPoolInner> call(ServiceResponse<Page<BackendAddressPoolInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<BackendAddressPoolInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<BackendAddressPoolInner>>, Observable<ServiceResponse<Page<BackendAddressPoolInner>>>>(){

            public Observable<ServiceResponse<Page<BackendAddressPoolInner>>> call(ServiceResponse<Page<BackendAddressPoolInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(LoadBalancerBackendAddressPoolsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<BackendAddressPoolInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BackendAddressPoolInner>>>>(){

            public Observable<ServiceResponse<Page<BackendAddressPoolInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = LoadBalancerBackendAddressPoolsInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<BackendAddressPoolInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<BackendAddressPoolInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface LoadBalancerBackendAddressPoolsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.LoadBalancerBackendAddressPools list"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/backendAddressPools")
        public Observable<Response<ResponseBody>> list(@Path(value="resourceGroupName") String var1, @Path(value="loadBalancerName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.LoadBalancerBackendAddressPools get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/backendAddressPools/{backendAddressPoolName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="loadBalancerName") String var2, @Path(value="backendAddressPoolName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.LoadBalancerBackendAddressPools listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

