/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.network.TagsObject;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in VpnSites.
 */
public class VpnSitesInner implements InnerSupportsGet<VpnSiteInner>, InnerSupportsDelete<Void>, InnerSupportsListing<VpnSiteInner> {
    /** The Retrofit service to perform REST calls. */
    private VpnSitesService service;
    /** The service client containing this operation class. */
    private NetworkManagementClientImpl client;

    /**
     * Initializes an instance of VpnSitesInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public VpnSitesInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = retrofit.create(VpnSitesService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for VpnSites to be
     * used by Retrofit to perform actually REST calls.
     */
    interface VpnSitesService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnSites getByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/vpnSites/{vpnSiteName}")
        Observable<Response<ResponseBody>> getByResourceGroup(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("vpnSiteName") String vpnSiteName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnSites createOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/vpnSites/{vpnSiteName}")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("vpnSiteName") String vpnSiteName, @Query("api-version") String apiVersion, @Body VpnSiteInner vpnSiteParameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnSites beginCreateOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/vpnSites/{vpnSiteName}")
        Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("vpnSiteName") String vpnSiteName, @Query("api-version") String apiVersion, @Body VpnSiteInner vpnSiteParameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnSites updateTags" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/vpnSites/{vpnSiteName}")
        Observable<Response<ResponseBody>> updateTags(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("vpnSiteName") String vpnSiteName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body TagsObject vpnSiteParameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnSites delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/vpnSites/{vpnSiteName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("vpnSiteName") String vpnSiteName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnSites beginDelete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/vpnSites/{vpnSiteName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDelete(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("vpnSiteName") String vpnSiteName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnSites listByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/vpnSites")
        Observable<Response<ResponseBody>> listByResourceGroup(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnSites list" })
        @GET("subscriptions/{subscriptionId}/providers/Microsoft.Network/vpnSites")
        Observable<Response<ResponseBody>> list(@Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnSites listByResourceGroupNext" })
        @GET
        Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnSites listNext" })
        @GET
        Observable<Response<ResponseBody>> listNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Retrieves the details of a VPN site.
     *
     * @param resourceGroupName The resource group name of the VpnSite.
     * @param vpnSiteName The name of the VpnSite being retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the VpnSiteInner object if successful.
     */
    public VpnSiteInner getByResourceGroup(String resourceGroupName, String vpnSiteName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, vpnSiteName).toBlocking().single().body();
    }

    /**
     * Retrieves the details of a VPN site.
     *
     * @param resourceGroupName The resource group name of the VpnSite.
     * @param vpnSiteName The name of the VpnSite being retrieved.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<VpnSiteInner> getByResourceGroupAsync(String resourceGroupName, String vpnSiteName, final ServiceCallback<VpnSiteInner> serviceCallback) {
        return ServiceFuture.fromResponse(getByResourceGroupWithServiceResponseAsync(resourceGroupName, vpnSiteName), serviceCallback);
    }

    /**
     * Retrieves the details of a VPN site.
     *
     * @param resourceGroupName The resource group name of the VpnSite.
     * @param vpnSiteName The name of the VpnSite being retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VpnSiteInner object
     */
    public Observable<VpnSiteInner> getByResourceGroupAsync(String resourceGroupName, String vpnSiteName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, vpnSiteName).map(new Func1<ServiceResponse<VpnSiteInner>, VpnSiteInner>() {
            @Override
            public VpnSiteInner call(ServiceResponse<VpnSiteInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Retrieves the details of a VPN site.
     *
     * @param resourceGroupName The resource group name of the VpnSite.
     * @param vpnSiteName The name of the VpnSite being retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VpnSiteInner object
     */
    public Observable<ServiceResponse<VpnSiteInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String vpnSiteName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vpnSiteName == null) {
            throw new IllegalArgumentException("Parameter vpnSiteName is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        return service.getByResourceGroup(this.client.subscriptionId(), resourceGroupName, vpnSiteName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<VpnSiteInner>>>() {
                @Override
                public Observable<ServiceResponse<VpnSiteInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<VpnSiteInner> clientResponse = getByResourceGroupDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<VpnSiteInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<VpnSiteInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<VpnSiteInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Creates a VpnSite resource if it doesn't exist else updates the existing VpnSite.
     *
     * @param resourceGroupName The resource group name of the VpnSite.
     * @param vpnSiteName The name of the VpnSite being created or updated.
     * @param vpnSiteParameters Parameters supplied to create or update VpnSite.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the VpnSiteInner object if successful.
     */
    public VpnSiteInner createOrUpdate(String resourceGroupName, String vpnSiteName, VpnSiteInner vpnSiteParameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, vpnSiteName, vpnSiteParameters).toBlocking().last().body();
    }

    /**
     * Creates a VpnSite resource if it doesn't exist else updates the existing VpnSite.
     *
     * @param resourceGroupName The resource group name of the VpnSite.
     * @param vpnSiteName The name of the VpnSite being created or updated.
     * @param vpnSiteParameters Parameters supplied to create or update VpnSite.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<VpnSiteInner> createOrUpdateAsync(String resourceGroupName, String vpnSiteName, VpnSiteInner vpnSiteParameters, final ServiceCallback<VpnSiteInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, vpnSiteName, vpnSiteParameters), serviceCallback);
    }

    /**
     * Creates a VpnSite resource if it doesn't exist else updates the existing VpnSite.
     *
     * @param resourceGroupName The resource group name of the VpnSite.
     * @param vpnSiteName The name of the VpnSite being created or updated.
     * @param vpnSiteParameters Parameters supplied to create or update VpnSite.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<VpnSiteInner> createOrUpdateAsync(String resourceGroupName, String vpnSiteName, VpnSiteInner vpnSiteParameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, vpnSiteName, vpnSiteParameters).map(new Func1<ServiceResponse<VpnSiteInner>, VpnSiteInner>() {
            @Override
            public VpnSiteInner call(ServiceResponse<VpnSiteInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a VpnSite resource if it doesn't exist else updates the existing VpnSite.
     *
     * @param resourceGroupName The resource group name of the VpnSite.
     * @param vpnSiteName The name of the VpnSite being created or updated.
     * @param vpnSiteParameters Parameters supplied to create or update VpnSite.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<VpnSiteInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String vpnSiteName, VpnSiteInner vpnSiteParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vpnSiteName == null) {
            throw new IllegalArgumentException("Parameter vpnSiteName is required and cannot be null.");
        }
        if (vpnSiteParameters == null) {
            throw new IllegalArgumentException("Parameter vpnSiteParameters is required and cannot be null.");
        }
        Validator.validate(vpnSiteParameters);
        final String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = service.createOrUpdate(this.client.subscriptionId(), resourceGroupName, vpnSiteName, apiVersion, vpnSiteParameters, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<VpnSiteInner>() { }.getType());
    }

    /**
     * Creates a VpnSite resource if it doesn't exist else updates the existing VpnSite.
     *
     * @param resourceGroupName The resource group name of the VpnSite.
     * @param vpnSiteName The name of the VpnSite being created or updated.
     * @param vpnSiteParameters Parameters supplied to create or update VpnSite.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the VpnSiteInner object if successful.
     */
    public VpnSiteInner beginCreateOrUpdate(String resourceGroupName, String vpnSiteName, VpnSiteInner vpnSiteParameters) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, vpnSiteName, vpnSiteParameters).toBlocking().single().body();
    }

    /**
     * Creates a VpnSite resource if it doesn't exist else updates the existing VpnSite.
     *
     * @param resourceGroupName The resource group name of the VpnSite.
     * @param vpnSiteName The name of the VpnSite being created or updated.
     * @param vpnSiteParameters Parameters supplied to create or update VpnSite.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<VpnSiteInner> beginCreateOrUpdateAsync(String resourceGroupName, String vpnSiteName, VpnSiteInner vpnSiteParameters, final ServiceCallback<VpnSiteInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, vpnSiteName, vpnSiteParameters), serviceCallback);
    }

    /**
     * Creates a VpnSite resource if it doesn't exist else updates the existing VpnSite.
     *
     * @param resourceGroupName The resource group name of the VpnSite.
     * @param vpnSiteName The name of the VpnSite being created or updated.
     * @param vpnSiteParameters Parameters supplied to create or update VpnSite.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VpnSiteInner object
     */
    public Observable<VpnSiteInner> beginCreateOrUpdateAsync(String resourceGroupName, String vpnSiteName, VpnSiteInner vpnSiteParameters) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, vpnSiteName, vpnSiteParameters).map(new Func1<ServiceResponse<VpnSiteInner>, VpnSiteInner>() {
            @Override
            public VpnSiteInner call(ServiceResponse<VpnSiteInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a VpnSite resource if it doesn't exist else updates the existing VpnSite.
     *
     * @param resourceGroupName The resource group name of the VpnSite.
     * @param vpnSiteName The name of the VpnSite being created or updated.
     * @param vpnSiteParameters Parameters supplied to create or update VpnSite.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VpnSiteInner object
     */
    public Observable<ServiceResponse<VpnSiteInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String vpnSiteName, VpnSiteInner vpnSiteParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vpnSiteName == null) {
            throw new IllegalArgumentException("Parameter vpnSiteName is required and cannot be null.");
        }
        if (vpnSiteParameters == null) {
            throw new IllegalArgumentException("Parameter vpnSiteParameters is required and cannot be null.");
        }
        Validator.validate(vpnSiteParameters);
        final String apiVersion = "2019-11-01";
        return service.beginCreateOrUpdate(this.client.subscriptionId(), resourceGroupName, vpnSiteName, apiVersion, vpnSiteParameters, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<VpnSiteInner>>>() {
                @Override
                public Observable<ServiceResponse<VpnSiteInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<VpnSiteInner> clientResponse = beginCreateOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<VpnSiteInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<VpnSiteInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<VpnSiteInner>() { }.getType())
                .register(201, new TypeToken<VpnSiteInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Updates VpnSite tags.
     *
     * @param resourceGroupName The resource group name of the VpnSite.
     * @param vpnSiteName The name of the VpnSite being updated.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the VpnSiteInner object if successful.
     */
    public VpnSiteInner updateTags(String resourceGroupName, String vpnSiteName) {
        return updateTagsWithServiceResponseAsync(resourceGroupName, vpnSiteName).toBlocking().single().body();
    }

    /**
     * Updates VpnSite tags.
     *
     * @param resourceGroupName The resource group name of the VpnSite.
     * @param vpnSiteName The name of the VpnSite being updated.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<VpnSiteInner> updateTagsAsync(String resourceGroupName, String vpnSiteName, final ServiceCallback<VpnSiteInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateTagsWithServiceResponseAsync(resourceGroupName, vpnSiteName), serviceCallback);
    }

    /**
     * Updates VpnSite tags.
     *
     * @param resourceGroupName The resource group name of the VpnSite.
     * @param vpnSiteName The name of the VpnSite being updated.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VpnSiteInner object
     */
    public Observable<VpnSiteInner> updateTagsAsync(String resourceGroupName, String vpnSiteName) {
        return updateTagsWithServiceResponseAsync(resourceGroupName, vpnSiteName).map(new Func1<ServiceResponse<VpnSiteInner>, VpnSiteInner>() {
            @Override
            public VpnSiteInner call(ServiceResponse<VpnSiteInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates VpnSite tags.
     *
     * @param resourceGroupName The resource group name of the VpnSite.
     * @param vpnSiteName The name of the VpnSite being updated.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VpnSiteInner object
     */
    public Observable<ServiceResponse<VpnSiteInner>> updateTagsWithServiceResponseAsync(String resourceGroupName, String vpnSiteName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vpnSiteName == null) {
            throw new IllegalArgumentException("Parameter vpnSiteName is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        final Map<String, String> tags = null;
        TagsObject vpnSiteParameters = new TagsObject();
        vpnSiteParameters.withTags(null);
        return service.updateTags(this.client.subscriptionId(), resourceGroupName, vpnSiteName, apiVersion, this.client.acceptLanguage(), vpnSiteParameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<VpnSiteInner>>>() {
                @Override
                public Observable<ServiceResponse<VpnSiteInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<VpnSiteInner> clientResponse = updateTagsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Updates VpnSite tags.
     *
     * @param resourceGroupName The resource group name of the VpnSite.
     * @param vpnSiteName The name of the VpnSite being updated.
     * @param tags Resource tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the VpnSiteInner object if successful.
     */
    public VpnSiteInner updateTags(String resourceGroupName, String vpnSiteName, Map<String, String> tags) {
        return updateTagsWithServiceResponseAsync(resourceGroupName, vpnSiteName, tags).toBlocking().single().body();
    }

    /**
     * Updates VpnSite tags.
     *
     * @param resourceGroupName The resource group name of the VpnSite.
     * @param vpnSiteName The name of the VpnSite being updated.
     * @param tags Resource tags.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<VpnSiteInner> updateTagsAsync(String resourceGroupName, String vpnSiteName, Map<String, String> tags, final ServiceCallback<VpnSiteInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateTagsWithServiceResponseAsync(resourceGroupName, vpnSiteName, tags), serviceCallback);
    }

    /**
     * Updates VpnSite tags.
     *
     * @param resourceGroupName The resource group name of the VpnSite.
     * @param vpnSiteName The name of the VpnSite being updated.
     * @param tags Resource tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VpnSiteInner object
     */
    public Observable<VpnSiteInner> updateTagsAsync(String resourceGroupName, String vpnSiteName, Map<String, String> tags) {
        return updateTagsWithServiceResponseAsync(resourceGroupName, vpnSiteName, tags).map(new Func1<ServiceResponse<VpnSiteInner>, VpnSiteInner>() {
            @Override
            public VpnSiteInner call(ServiceResponse<VpnSiteInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates VpnSite tags.
     *
     * @param resourceGroupName The resource group name of the VpnSite.
     * @param vpnSiteName The name of the VpnSite being updated.
     * @param tags Resource tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VpnSiteInner object
     */
    public Observable<ServiceResponse<VpnSiteInner>> updateTagsWithServiceResponseAsync(String resourceGroupName, String vpnSiteName, Map<String, String> tags) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vpnSiteName == null) {
            throw new IllegalArgumentException("Parameter vpnSiteName is required and cannot be null.");
        }
        Validator.validate(tags);
        final String apiVersion = "2019-11-01";
        TagsObject vpnSiteParameters = new TagsObject();
        vpnSiteParameters.withTags(tags);
        return service.updateTags(this.client.subscriptionId(), resourceGroupName, vpnSiteName, apiVersion, this.client.acceptLanguage(), vpnSiteParameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<VpnSiteInner>>>() {
                @Override
                public Observable<ServiceResponse<VpnSiteInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<VpnSiteInner> clientResponse = updateTagsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<VpnSiteInner> updateTagsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<VpnSiteInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<VpnSiteInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes a VpnSite.
     *
     * @param resourceGroupName The resource group name of the VpnSite.
     * @param vpnSiteName The name of the VpnSite being deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String vpnSiteName) {
        deleteWithServiceResponseAsync(resourceGroupName, vpnSiteName).toBlocking().last().body();
    }

    /**
     * Deletes a VpnSite.
     *
     * @param resourceGroupName The resource group name of the VpnSite.
     * @param vpnSiteName The name of the VpnSite being deleted.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String vpnSiteName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, vpnSiteName), serviceCallback);
    }

    /**
     * Deletes a VpnSite.
     *
     * @param resourceGroupName The resource group name of the VpnSite.
     * @param vpnSiteName The name of the VpnSite being deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String vpnSiteName) {
        return deleteWithServiceResponseAsync(resourceGroupName, vpnSiteName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a VpnSite.
     *
     * @param resourceGroupName The resource group name of the VpnSite.
     * @param vpnSiteName The name of the VpnSite being deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String vpnSiteName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vpnSiteName == null) {
            throw new IllegalArgumentException("Parameter vpnSiteName is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = service.delete(this.client.subscriptionId(), resourceGroupName, vpnSiteName, apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes a VpnSite.
     *
     * @param resourceGroupName The resource group name of the VpnSite.
     * @param vpnSiteName The name of the VpnSite being deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDelete(String resourceGroupName, String vpnSiteName) {
        beginDeleteWithServiceResponseAsync(resourceGroupName, vpnSiteName).toBlocking().single().body();
    }

    /**
     * Deletes a VpnSite.
     *
     * @param resourceGroupName The resource group name of the VpnSite.
     * @param vpnSiteName The name of the VpnSite being deleted.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String vpnSiteName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteWithServiceResponseAsync(resourceGroupName, vpnSiteName), serviceCallback);
    }

    /**
     * Deletes a VpnSite.
     *
     * @param resourceGroupName The resource group name of the VpnSite.
     * @param vpnSiteName The name of the VpnSite being deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAsync(String resourceGroupName, String vpnSiteName) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, vpnSiteName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a VpnSite.
     *
     * @param resourceGroupName The resource group name of the VpnSite.
     * @param vpnSiteName The name of the VpnSite being deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String vpnSiteName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vpnSiteName == null) {
            throw new IllegalArgumentException("Parameter vpnSiteName is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        return service.beginDelete(this.client.subscriptionId(), resourceGroupName, vpnSiteName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all the vpnSites in a resource group.
     *
     * @param resourceGroupName The resource group name of the VpnSite.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;VpnSiteInner&gt; object if successful.
     */
    public PagedList<VpnSiteInner> listByResourceGroup(final String resourceGroupName) {
        ServiceResponse<Page<VpnSiteInner>> response = listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<VpnSiteInner>(response.body()) {
            @Override
            public Page<VpnSiteInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all the vpnSites in a resource group.
     *
     * @param resourceGroupName The resource group name of the VpnSite.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<VpnSiteInner>> listByResourceGroupAsync(final String resourceGroupName, final ListOperationCallback<VpnSiteInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupSinglePageAsync(resourceGroupName),
            new Func1<String, Observable<ServiceResponse<Page<VpnSiteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VpnSiteInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all the vpnSites in a resource group.
     *
     * @param resourceGroupName The resource group name of the VpnSite.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VpnSiteInner&gt; object
     */
    public Observable<Page<VpnSiteInner>> listByResourceGroupAsync(final String resourceGroupName) {
        return listByResourceGroupWithServiceResponseAsync(resourceGroupName)
            .map(new Func1<ServiceResponse<Page<VpnSiteInner>>, Page<VpnSiteInner>>() {
                @Override
                public Page<VpnSiteInner> call(ServiceResponse<Page<VpnSiteInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all the vpnSites in a resource group.
     *
     * @param resourceGroupName The resource group name of the VpnSite.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VpnSiteInner&gt; object
     */
    public Observable<ServiceResponse<Page<VpnSiteInner>>> listByResourceGroupWithServiceResponseAsync(final String resourceGroupName) {
        return listByResourceGroupSinglePageAsync(resourceGroupName)
            .concatMap(new Func1<ServiceResponse<Page<VpnSiteInner>>, Observable<ServiceResponse<Page<VpnSiteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VpnSiteInner>>> call(ServiceResponse<Page<VpnSiteInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all the vpnSites in a resource group.
     *
    ServiceResponse<PageImpl<VpnSiteInner>> * @param resourceGroupName The resource group name of the VpnSite.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;VpnSiteInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<VpnSiteInner>>> listByResourceGroupSinglePageAsync(final String resourceGroupName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        return service.listByResourceGroup(this.client.subscriptionId(), resourceGroupName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VpnSiteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VpnSiteInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<VpnSiteInner>> result = listByResourceGroupDelegate(response);
                        return Observable.just(new ServiceResponse<Page<VpnSiteInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<VpnSiteInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<VpnSiteInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<VpnSiteInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all the VpnSites in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;VpnSiteInner&gt; object if successful.
     */
    public PagedList<VpnSiteInner> list() {
        ServiceResponse<Page<VpnSiteInner>> response = listSinglePageAsync().toBlocking().single();
        return new PagedList<VpnSiteInner>(response.body()) {
            @Override
            public Page<VpnSiteInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all the VpnSites in a subscription.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<VpnSiteInner>> listAsync(final ListOperationCallback<VpnSiteInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(),
            new Func1<String, Observable<ServiceResponse<Page<VpnSiteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VpnSiteInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all the VpnSites in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VpnSiteInner&gt; object
     */
    public Observable<Page<VpnSiteInner>> listAsync() {
        return listWithServiceResponseAsync()
            .map(new Func1<ServiceResponse<Page<VpnSiteInner>>, Page<VpnSiteInner>>() {
                @Override
                public Page<VpnSiteInner> call(ServiceResponse<Page<VpnSiteInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all the VpnSites in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VpnSiteInner&gt; object
     */
    public Observable<ServiceResponse<Page<VpnSiteInner>>> listWithServiceResponseAsync() {
        return listSinglePageAsync()
            .concatMap(new Func1<ServiceResponse<Page<VpnSiteInner>>, Observable<ServiceResponse<Page<VpnSiteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VpnSiteInner>>> call(ServiceResponse<Page<VpnSiteInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all the VpnSites in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;VpnSiteInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<VpnSiteInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        return service.list(this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VpnSiteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VpnSiteInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<VpnSiteInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<VpnSiteInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<VpnSiteInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<VpnSiteInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<VpnSiteInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all the vpnSites in a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;VpnSiteInner&gt; object if successful.
     */
    public PagedList<VpnSiteInner> listByResourceGroupNext(final String nextPageLink) {
        ServiceResponse<Page<VpnSiteInner>> response = listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<VpnSiteInner>(response.body()) {
            @Override
            public Page<VpnSiteInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all the vpnSites in a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<VpnSiteInner>> listByResourceGroupNextAsync(final String nextPageLink, final ServiceFuture<List<VpnSiteInner>> serviceFuture, final ListOperationCallback<VpnSiteInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<VpnSiteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VpnSiteInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all the vpnSites in a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VpnSiteInner&gt; object
     */
    public Observable<Page<VpnSiteInner>> listByResourceGroupNextAsync(final String nextPageLink) {
        return listByResourceGroupNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<VpnSiteInner>>, Page<VpnSiteInner>>() {
                @Override
                public Page<VpnSiteInner> call(ServiceResponse<Page<VpnSiteInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all the vpnSites in a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VpnSiteInner&gt; object
     */
    public Observable<ServiceResponse<Page<VpnSiteInner>>> listByResourceGroupNextWithServiceResponseAsync(final String nextPageLink) {
        return listByResourceGroupNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<VpnSiteInner>>, Observable<ServiceResponse<Page<VpnSiteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VpnSiteInner>>> call(ServiceResponse<Page<VpnSiteInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all the vpnSites in a resource group.
     *
    ServiceResponse<PageImpl<VpnSiteInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;VpnSiteInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<VpnSiteInner>>> listByResourceGroupNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VpnSiteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VpnSiteInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<VpnSiteInner>> result = listByResourceGroupNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<VpnSiteInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<VpnSiteInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<VpnSiteInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<VpnSiteInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all the VpnSites in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;VpnSiteInner&gt; object if successful.
     */
    public PagedList<VpnSiteInner> listNext(final String nextPageLink) {
        ServiceResponse<Page<VpnSiteInner>> response = listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<VpnSiteInner>(response.body()) {
            @Override
            public Page<VpnSiteInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all the VpnSites in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<VpnSiteInner>> listNextAsync(final String nextPageLink, final ServiceFuture<List<VpnSiteInner>> serviceFuture, final ListOperationCallback<VpnSiteInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<VpnSiteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VpnSiteInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all the VpnSites in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VpnSiteInner&gt; object
     */
    public Observable<Page<VpnSiteInner>> listNextAsync(final String nextPageLink) {
        return listNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<VpnSiteInner>>, Page<VpnSiteInner>>() {
                @Override
                public Page<VpnSiteInner> call(ServiceResponse<Page<VpnSiteInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all the VpnSites in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VpnSiteInner&gt; object
     */
    public Observable<ServiceResponse<Page<VpnSiteInner>>> listNextWithServiceResponseAsync(final String nextPageLink) {
        return listNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<VpnSiteInner>>, Observable<ServiceResponse<Page<VpnSiteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VpnSiteInner>>> call(ServiceResponse<Page<VpnSiteInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all the VpnSites in a subscription.
     *
    ServiceResponse<PageImpl<VpnSiteInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;VpnSiteInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<VpnSiteInner>>> listNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VpnSiteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VpnSiteInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<VpnSiteInner>> result = listNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<VpnSiteInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<VpnSiteInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<VpnSiteInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<VpnSiteInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
