/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.network.implementation.ExpressRouteLinkInner;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.PageImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class ExpressRouteLinksInner {
    private ExpressRouteLinksService service;
    private NetworkManagementClientImpl client;

    public ExpressRouteLinksInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (ExpressRouteLinksService)retrofit.create(ExpressRouteLinksService.class);
        this.client = client;
    }

    public ExpressRouteLinkInner get(String resourceGroupName, String expressRoutePortName, String linkName) {
        return (ExpressRouteLinkInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, expressRoutePortName, linkName).toBlocking().single()).body());
    }

    public ServiceFuture<ExpressRouteLinkInner> getAsync(String resourceGroupName, String expressRoutePortName, String linkName, ServiceCallback<ExpressRouteLinkInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, expressRoutePortName, linkName), serviceCallback);
    }

    public Observable<ExpressRouteLinkInner> getAsync(String resourceGroupName, String expressRoutePortName, String linkName) {
        return this.getWithServiceResponseAsync(resourceGroupName, expressRoutePortName, linkName).map((Func1)new Func1<ServiceResponse<ExpressRouteLinkInner>, ExpressRouteLinkInner>(){

            public ExpressRouteLinkInner call(ServiceResponse<ExpressRouteLinkInner> response) {
                return (ExpressRouteLinkInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ExpressRouteLinkInner>> getWithServiceResponseAsync(String resourceGroupName, String expressRoutePortName, String linkName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (expressRoutePortName == null) {
            throw new IllegalArgumentException("Parameter expressRoutePortName is required and cannot be null.");
        }
        if (linkName == null) {
            throw new IllegalArgumentException("Parameter linkName is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.get(this.client.subscriptionId(), resourceGroupName, expressRoutePortName, linkName, "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ExpressRouteLinkInner>>>(){

            public Observable<ServiceResponse<ExpressRouteLinkInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ExpressRouteLinksInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ExpressRouteLinkInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ExpressRouteLinkInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ExpressRouteLinkInner> list(String resourceGroupName, String expressRoutePortName) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(resourceGroupName, expressRoutePortName).toBlocking().single();
        return new PagedList<ExpressRouteLinkInner>((Page)response.body()){

            public Page<ExpressRouteLinkInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ExpressRouteLinksInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ExpressRouteLinkInner>> listAsync(String resourceGroupName, String expressRoutePortName, ListOperationCallback<ExpressRouteLinkInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(resourceGroupName, expressRoutePortName), (Func1)new Func1<String, Observable<ServiceResponse<Page<ExpressRouteLinkInner>>>>(){

            public Observable<ServiceResponse<Page<ExpressRouteLinkInner>>> call(String nextPageLink) {
                return ExpressRouteLinksInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ExpressRouteLinkInner>> listAsync(String resourceGroupName, String expressRoutePortName) {
        return this.listWithServiceResponseAsync(resourceGroupName, expressRoutePortName).map((Func1)new Func1<ServiceResponse<Page<ExpressRouteLinkInner>>, Page<ExpressRouteLinkInner>>(){

            public Page<ExpressRouteLinkInner> call(ServiceResponse<Page<ExpressRouteLinkInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ExpressRouteLinkInner>>> listWithServiceResponseAsync(String resourceGroupName, String expressRoutePortName) {
        return this.listSinglePageAsync(resourceGroupName, expressRoutePortName).concatMap((Func1)new Func1<ServiceResponse<Page<ExpressRouteLinkInner>>, Observable<ServiceResponse<Page<ExpressRouteLinkInner>>>>(){

            public Observable<ServiceResponse<Page<ExpressRouteLinkInner>>> call(ServiceResponse<Page<ExpressRouteLinkInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ExpressRouteLinksInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ExpressRouteLinkInner>>> listSinglePageAsync(String resourceGroupName, String expressRoutePortName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (expressRoutePortName == null) {
            throw new IllegalArgumentException("Parameter expressRoutePortName is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.list(this.client.subscriptionId(), resourceGroupName, expressRoutePortName, "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ExpressRouteLinkInner>>>>(){

            public Observable<ServiceResponse<Page<ExpressRouteLinkInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ExpressRouteLinksInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ExpressRouteLinkInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ExpressRouteLinkInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ExpressRouteLinkInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ExpressRouteLinkInner>((Page)response.body()){

            public Page<ExpressRouteLinkInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ExpressRouteLinksInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ExpressRouteLinkInner>> listNextAsync(String nextPageLink, ServiceFuture<List<ExpressRouteLinkInner>> serviceFuture, ListOperationCallback<ExpressRouteLinkInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ExpressRouteLinkInner>>>>(){

            public Observable<ServiceResponse<Page<ExpressRouteLinkInner>>> call(String nextPageLink) {
                return ExpressRouteLinksInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ExpressRouteLinkInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ExpressRouteLinkInner>>, Page<ExpressRouteLinkInner>>(){

            public Page<ExpressRouteLinkInner> call(ServiceResponse<Page<ExpressRouteLinkInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ExpressRouteLinkInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ExpressRouteLinkInner>>, Observable<ServiceResponse<Page<ExpressRouteLinkInner>>>>(){

            public Observable<ServiceResponse<Page<ExpressRouteLinkInner>>> call(ServiceResponse<Page<ExpressRouteLinkInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ExpressRouteLinksInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ExpressRouteLinkInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ExpressRouteLinkInner>>>>(){

            public Observable<ServiceResponse<Page<ExpressRouteLinkInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ExpressRouteLinksInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ExpressRouteLinkInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ExpressRouteLinkInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ExpressRouteLinksService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ExpressRouteLinks get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/ExpressRoutePorts/{expressRoutePortName}/links/{linkName}")
        public Observable<Response<ResponseBody>> get(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="expressRoutePortName") String var3, @Path(value="linkName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ExpressRouteLinks list"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/ExpressRoutePorts/{expressRoutePortName}/links")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="expressRoutePortName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ExpressRouteLinks listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

