/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network.implementation;

import java.util.List;
import com.microsoft.azure.SubResource;
import com.microsoft.azure.management.network.ProvisioningState;
import com.microsoft.azure.management.network.AzureFirewallThreatIntelMode;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.rest.SkipParentValidation;
import com.microsoft.azure.Resource;

/**
 * FirewallPolicy Resource.
 */
@JsonFlatten
@SkipParentValidation
public class FirewallPolicyInner extends Resource {
    /**
     * List of references to FirewallPolicyRuleGroups.
     */
    @JsonProperty(value = "properties.ruleGroups", access = JsonProperty.Access.WRITE_ONLY)
    private List<SubResource> ruleGroups;

    /**
     * The provisioning state of the firewall policy resource. Possible values
     * include: 'Succeeded', 'Updating', 'Deleting', 'Failed'.
     */
    @JsonProperty(value = "properties.provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    /**
     * The parent firewall policy from which rules are inherited.
     */
    @JsonProperty(value = "properties.basePolicy")
    private SubResource basePolicy;

    /**
     * List of references to Azure Firewalls that this Firewall Policy is
     * associated with.
     */
    @JsonProperty(value = "properties.firewalls", access = JsonProperty.Access.WRITE_ONLY)
    private List<SubResource> firewalls;

    /**
     * List of references to Child Firewall Policies.
     */
    @JsonProperty(value = "properties.childPolicies", access = JsonProperty.Access.WRITE_ONLY)
    private List<SubResource> childPolicies;

    /**
     * The operation mode for Threat Intelligence. Possible values include:
     * 'Alert', 'Deny', 'Off'.
     */
    @JsonProperty(value = "properties.threatIntelMode")
    private AzureFirewallThreatIntelMode threatIntelMode;

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    @JsonProperty(value = "etag", access = JsonProperty.Access.WRITE_ONLY)
    private String etag;

    /**
     * Resource ID.
     */
    @JsonProperty(value = "id")
    private String id;

    /**
     * Get list of references to FirewallPolicyRuleGroups.
     *
     * @return the ruleGroups value
     */
    public List<SubResource> ruleGroups() {
        return this.ruleGroups;
    }

    /**
     * Get the provisioning state of the firewall policy resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'.
     *
     * @return the provisioningState value
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the parent firewall policy from which rules are inherited.
     *
     * @return the basePolicy value
     */
    public SubResource basePolicy() {
        return this.basePolicy;
    }

    /**
     * Set the parent firewall policy from which rules are inherited.
     *
     * @param basePolicy the basePolicy value to set
     * @return the FirewallPolicyInner object itself.
     */
    public FirewallPolicyInner withBasePolicy(SubResource basePolicy) {
        this.basePolicy = basePolicy;
        return this;
    }

    /**
     * Get list of references to Azure Firewalls that this Firewall Policy is associated with.
     *
     * @return the firewalls value
     */
    public List<SubResource> firewalls() {
        return this.firewalls;
    }

    /**
     * Get list of references to Child Firewall Policies.
     *
     * @return the childPolicies value
     */
    public List<SubResource> childPolicies() {
        return this.childPolicies;
    }

    /**
     * Get the operation mode for Threat Intelligence. Possible values include: 'Alert', 'Deny', 'Off'.
     *
     * @return the threatIntelMode value
     */
    public AzureFirewallThreatIntelMode threatIntelMode() {
        return this.threatIntelMode;
    }

    /**
     * Set the operation mode for Threat Intelligence. Possible values include: 'Alert', 'Deny', 'Off'.
     *
     * @param threatIntelMode the threatIntelMode value to set
     * @return the FirewallPolicyInner object itself.
     */
    public FirewallPolicyInner withThreatIntelMode(AzureFirewallThreatIntelMode threatIntelMode) {
        this.threatIntelMode = threatIntelMode;
        return this;
    }

    /**
     * Get a unique read-only string that changes whenever the resource is updated.
     *
     * @return the etag value
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Get resource ID.
     *
     * @return the id value
     */
    public String id() {
        return this.id;
    }

    /**
     * Set resource ID.
     *
     * @param id the id value to set
     * @return the FirewallPolicyInner object itself.
     */
    public FirewallPolicyInner withId(String id) {
        this.id = id;
        return this;
    }

}
