/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network;

import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * State details.
 */
public class AvailableProvidersListState {
    /**
     * The state name.
     */
    @JsonProperty(value = "stateName")
    private String stateName;

    /**
     * A list of Internet service providers.
     */
    @JsonProperty(value = "providers")
    private List<String> providers;

    /**
     * List of available cities or towns in the state.
     */
    @JsonProperty(value = "cities")
    private List<AvailableProvidersListCity> cities;

    /**
     * Get the stateName value.
     *
     * @return the stateName value
     */
    public String stateName() {
        return this.stateName;
    }

    /**
     * Set the stateName value.
     *
     * @param stateName the stateName value to set
     * @return the AvailableProvidersListState object itself.
     */
    public AvailableProvidersListState withStateName(String stateName) {
        this.stateName = stateName;
        return this;
    }

    /**
     * Get the providers value.
     *
     * @return the providers value
     */
    public List<String> providers() {
        return this.providers;
    }

    /**
     * Set the providers value.
     *
     * @param providers the providers value to set
     * @return the AvailableProvidersListState object itself.
     */
    public AvailableProvidersListState withProviders(List<String> providers) {
        this.providers = providers;
        return this;
    }

    /**
     * Get the cities value.
     *
     * @return the cities value
     */
    public List<AvailableProvidersListCity> cities() {
        return this.cities;
    }

    /**
     * Set the cities value.
     *
     * @param cities the cities value to set
     * @return the AvailableProvidersListState object itself.
     */
    public AvailableProvidersListState withCities(List<AvailableProvidersListCity> cities) {
        this.cities = cities;
        return this;
    }

}
