/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network;

import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.network.ExpressRouteCircuitPeering;
import com.microsoft.azure.management.network.ExpressRouteCircuitPeerings;
import com.microsoft.azure.management.network.ExpressRouteCircuitServiceProviderProperties;
import com.microsoft.azure.management.network.ExpressRouteCircuitSkuType;
import com.microsoft.azure.management.network.ServiceProviderProvisioningState;
import com.microsoft.azure.management.network.implementation.ExpressRouteCircuitInner;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.resources.fluentcore.arm.models.GroupableResource;
import com.microsoft.azure.management.resources.fluentcore.arm.models.Resource;
import com.microsoft.azure.management.resources.fluentcore.model.Appliable;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.Refreshable;
import com.microsoft.azure.management.resources.fluentcore.model.Updatable;
import java.util.Map;

@Fluent
@Beta(value=Beta.SinceVersion.V1_4_0)
public interface ExpressRouteCircuit
extends GroupableResource<NetworkManager, ExpressRouteCircuitInner>,
Refreshable<ExpressRouteCircuit>,
Updatable<Update> {
    public ExpressRouteCircuitPeerings peerings();

    public ExpressRouteCircuitSkuType sku();

    public boolean isAllowClassicOperations();

    public String circuitProvisioningState();

    public ServiceProviderProvisioningState serviceProviderProvisioningState();

    public Map<String, ExpressRouteCircuitPeering> peeringsMap();

    public String serviceKey();

    public String serviceProviderNotes();

    public ExpressRouteCircuitServiceProviderProperties serviceProviderProperties();

    public String provisioningState();

    public static interface Update
    extends Appliable<ExpressRouteCircuit>,
    Resource.UpdateWithTags<Update>,
    UpdateStages.WithBandwidth,
    UpdateStages.WithSku,
    UpdateStages.WithAllowClassicOperations,
    UpdateStages.WithAuthorization {
    }

    public static interface UpdateStages {

        public static interface WithAuthorization {
            public Update withAuthorization(String var1);
        }

        public static interface WithAllowClassicOperations {
            public Update withClassicOperations();

            public Update withoutClassicOperations();
        }

        public static interface WithSku {
            public Update withSku(ExpressRouteCircuitSkuType var1);
        }

        public static interface WithBandwidth {
            public Update withBandwidthInMbps(int var1);
        }
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<ExpressRouteCircuit>,
        Resource.DefinitionWithTags<WithCreate>,
        WithAllowClassicOperations,
        WithAuthorization {
        }

        public static interface WithAuthorization {
            public WithCreate withAuthorization(String var1);
        }

        public static interface WithAllowClassicOperations {
            public WithCreate withClassicOperations();
        }

        public static interface WithSku {
            public WithCreate withSku(ExpressRouteCircuitSkuType var1);
        }

        public static interface WithBandwidth {
            public WithSku withBandwidthInMbps(int var1);
        }

        public static interface WithPeeringLocation {
            public WithBandwidth withPeeringLocation(String var1);
        }

        public static interface WithServiceProvider {
            public WithPeeringLocation withServiceProvider(String var1);
        }

        public static interface WithGroup
        extends GroupableResource.DefinitionStages.WithGroup<WithServiceProvider> {
        }

        public static interface Blank
        extends Resource.DefinitionWithRegion<WithGroup> {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithGroup,
    DefinitionStages.WithServiceProvider,
    DefinitionStages.WithPeeringLocation,
    DefinitionStages.WithBandwidth,
    DefinitionStages.WithSku,
    DefinitionStages.WithCreate {
    }
}

