/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network;

import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.network.BgpSettings;
import com.microsoft.azure.management.network.implementation.LocalNetworkGatewayInner;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.resources.fluentcore.arm.models.GroupableResource;
import com.microsoft.azure.management.resources.fluentcore.arm.models.Resource;
import com.microsoft.azure.management.resources.fluentcore.model.Appliable;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.Refreshable;
import com.microsoft.azure.management.resources.fluentcore.model.Updatable;
import java.util.Set;

@Fluent
@Beta(value=Beta.SinceVersion.V1_3_0)
public interface LocalNetworkGateway
extends GroupableResource<NetworkManager, LocalNetworkGatewayInner>,
Refreshable<LocalNetworkGateway>,
Updatable<Update> {
    public String ipAddress();

    public BgpSettings bgpSettings();

    public Set<String> addressSpaces();

    public String provisioningState();

    public static interface Update
    extends Appliable<LocalNetworkGateway>,
    Resource.UpdateWithTags<Update>,
    UpdateStages.WithIPAddress,
    UpdateStages.WithAddressSpace,
    UpdateStages.WithBgp {
    }

    public static interface UpdateStages {

        public static interface WithBgp {
            public Update withBgp(long var1, String var3);

            public Update withoutBgp();
        }

        public static interface WithAddressSpace {
            public Update withAddressSpace(String var1);

            public Update withoutAddressSpace(String var1);
        }

        public static interface WithIPAddress {
            public Update withIPAddress(String var1);
        }
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<LocalNetworkGateway>,
        Resource.DefinitionWithTags<WithCreate>,
        WithAddressSpace,
        WithBgp {
        }

        public static interface WithBgp {
            public WithCreate withBgp(long var1, String var3);
        }

        public static interface WithAddressSpace {
            public WithCreate withAddressSpace(String var1);
        }

        public static interface WithIPAddress {
            public WithAddressSpace withIPAddress(String var1);
        }

        public static interface WithGroup
        extends GroupableResource.DefinitionStages.WithGroup<WithIPAddress> {
        }

        public static interface Blank
        extends Resource.DefinitionWithRegion<WithGroup> {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithGroup,
    DefinitionStages.WithIPAddress,
    DefinitionStages.WithCreate {
    }
}

