/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.network.implementation.EndpointServiceResultInner;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.PageImpl;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class AvailableEndpointServicesInner {
    private AvailableEndpointServicesService service;
    private NetworkManagementClientImpl client;

    public AvailableEndpointServicesInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (AvailableEndpointServicesService)retrofit.create(AvailableEndpointServicesService.class);
        this.client = client;
    }

    public PagedList<EndpointServiceResultInner> list(String location) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(location).toBlocking().single();
        return new PagedList<EndpointServiceResultInner>((Page)response.body()){

            public Page<EndpointServiceResultInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)AvailableEndpointServicesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<EndpointServiceResultInner>> listAsync(String location, ListOperationCallback<EndpointServiceResultInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(location), (Func1)new Func1<String, Observable<ServiceResponse<Page<EndpointServiceResultInner>>>>(){

            public Observable<ServiceResponse<Page<EndpointServiceResultInner>>> call(String nextPageLink) {
                return AvailableEndpointServicesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<EndpointServiceResultInner>> listAsync(String location) {
        return this.listWithServiceResponseAsync(location).map((Func1)new Func1<ServiceResponse<Page<EndpointServiceResultInner>>, Page<EndpointServiceResultInner>>(){

            public Page<EndpointServiceResultInner> call(ServiceResponse<Page<EndpointServiceResultInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<EndpointServiceResultInner>>> listWithServiceResponseAsync(String location) {
        return this.listSinglePageAsync(location).concatMap((Func1)new Func1<ServiceResponse<Page<EndpointServiceResultInner>>, Observable<ServiceResponse<Page<EndpointServiceResultInner>>>>(){

            public Observable<ServiceResponse<Page<EndpointServiceResultInner>>> call(ServiceResponse<Page<EndpointServiceResultInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(AvailableEndpointServicesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<EndpointServiceResultInner>>> listSinglePageAsync(String location) {
        if (location == null) {
            throw new IllegalArgumentException("Parameter location is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-02-01";
        return this.service.list(location, this.client.subscriptionId(), "2018-02-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<EndpointServiceResultInner>>>>(){

            public Observable<ServiceResponse<Page<EndpointServiceResultInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = AvailableEndpointServicesInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<EndpointServiceResultInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<EndpointServiceResultInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<EndpointServiceResultInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<EndpointServiceResultInner>((Page)response.body()){

            public Page<EndpointServiceResultInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)AvailableEndpointServicesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<EndpointServiceResultInner>> listNextAsync(String nextPageLink, ServiceFuture<List<EndpointServiceResultInner>> serviceFuture, ListOperationCallback<EndpointServiceResultInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<EndpointServiceResultInner>>>>(){

            public Observable<ServiceResponse<Page<EndpointServiceResultInner>>> call(String nextPageLink) {
                return AvailableEndpointServicesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<EndpointServiceResultInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<EndpointServiceResultInner>>, Page<EndpointServiceResultInner>>(){

            public Page<EndpointServiceResultInner> call(ServiceResponse<Page<EndpointServiceResultInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<EndpointServiceResultInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<EndpointServiceResultInner>>, Observable<ServiceResponse<Page<EndpointServiceResultInner>>>>(){

            public Observable<ServiceResponse<Page<EndpointServiceResultInner>>> call(ServiceResponse<Page<EndpointServiceResultInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(AvailableEndpointServicesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<EndpointServiceResultInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<EndpointServiceResultInner>>>>(){

            public Observable<ServiceResponse<Page<EndpointServiceResultInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = AvailableEndpointServicesInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<EndpointServiceResultInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<EndpointServiceResultInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface AvailableEndpointServicesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.AvailableEndpointServices list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Network/locations/{location}/virtualNetworkAvailableEndpointServices")
        public Observable<Response<ResponseBody>> list(@Path(value="location") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.AvailableEndpointServices listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

