/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.network.ConnectionStatus;
import com.microsoft.azure.management.network.ConnectivityCheck;
import com.microsoft.azure.management.network.ConnectivityDestination;
import com.microsoft.azure.management.network.ConnectivityHop;
import com.microsoft.azure.management.network.ConnectivityParameters;
import com.microsoft.azure.management.network.ConnectivitySource;
import com.microsoft.azure.management.network.implementation.ConnectivityInformationInner;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.network.implementation.NetworkWatcherImpl;
import com.microsoft.azure.management.network.model.HasNetworkInterfaces;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.ExecutableImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import java.util.List;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
public class ConnectivityCheckImpl
extends ExecutableImpl<ConnectivityCheck>
implements ConnectivityCheck,
ConnectivityCheck.Definition {
    private final NetworkWatcherImpl parent;
    private ConnectivityParameters parameters = new ConnectivityParameters();
    private ConnectivityInformationInner result;

    ConnectivityCheckImpl(NetworkWatcherImpl parent) {
        this.parent = parent;
    }

    @Override
    public ConnectivityCheckImpl fromSourceVirtualMachine(String sourceResourceId) {
        this.ensureConnectivitySource().withResourceId(sourceResourceId);
        return this;
    }

    @Override
    public ConnectivityCheck.DefinitionStages.WithExecute fromSourceVirtualMachine(HasNetworkInterfaces vm) {
        this.ensureConnectivitySource().withResourceId(vm.id());
        return this;
    }

    @Override
    public ConnectivityCheckImpl toDestinationResourceId(String resourceId) {
        this.ensureConnectivityDestination().withResourceId(resourceId);
        return this;
    }

    @Override
    public ConnectivityCheckImpl toDestinationAddress(String address) {
        this.ensureConnectivityDestination().withAddress(address);
        return this;
    }

    @Override
    public ConnectivityCheckImpl toDestinationPort(int port) {
        this.ensureConnectivityDestination().withPort(port);
        return this;
    }

    @Override
    public ConnectivityCheck.DefinitionStages.WithExecute fromSourcePort(int port) {
        this.ensureConnectivitySource().withPort(port);
        return this;
    }

    private ConnectivitySource ensureConnectivitySource() {
        if (this.parameters.source() == null) {
            this.parameters.withSource(new ConnectivitySource());
        }
        return this.parameters.source();
    }

    private ConnectivityDestination ensureConnectivityDestination() {
        if (this.parameters.destination() == null) {
            this.parameters.withDestination(new ConnectivityDestination());
        }
        return this.parameters.destination();
    }

    public NetworkWatcherImpl parent() {
        return this.parent;
    }

    @Override
    public List<ConnectivityHop> hops() {
        return this.result.hops();
    }

    @Override
    public ConnectionStatus connectionStatus() {
        return this.result.connectionStatus();
    }

    @Override
    public int avgLatencyInMs() {
        return Utils.toPrimitiveInt((Integer)this.result.avgLatencyInMs());
    }

    @Override
    public int minLatencyInMs() {
        return Utils.toPrimitiveInt((Integer)this.result.minLatencyInMs());
    }

    @Override
    public int maxLatencyInMs() {
        return Utils.toPrimitiveInt((Integer)this.result.maxLatencyInMs());
    }

    @Override
    public int probesSent() {
        return Utils.toPrimitiveInt((Integer)this.result.probesSent());
    }

    @Override
    public int probesFailed() {
        return Utils.toPrimitiveInt((Integer)this.result.probesFailed());
    }

    public Observable<ConnectivityCheck> executeWorkAsync() {
        return ((NetworkManagementClientImpl)((Object)((NetworkManager)this.parent().manager()).inner())).networkWatchers().checkConnectivityAsync(this.parent.resourceGroupName(), this.parent.name(), this.parameters).map((Func1)new Func1<ConnectivityInformationInner, ConnectivityCheck>(){

            public ConnectivityCheck call(ConnectivityInformationInner connectivityInformation) {
                ConnectivityCheckImpl.this.result = connectivityInformation;
                return ConnectivityCheckImpl.this;
            }
        });
    }
}

