/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.network.TagsObject;
import com.microsoft.azure.management.network.implementation.ExpressRouteCircuitsArpTableListResultInner;
import com.microsoft.azure.management.network.implementation.ExpressRouteCircuitsRoutesTableListResultInner;
import com.microsoft.azure.management.network.implementation.ExpressRouteCrossConnectionInner;
import com.microsoft.azure.management.network.implementation.ExpressRouteCrossConnectionsRoutesTableSummaryListResultInner;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.PageImpl;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class ExpressRouteCrossConnectionsInner
implements InnerSupportsGet<ExpressRouteCrossConnectionInner>,
InnerSupportsListing<ExpressRouteCrossConnectionInner> {
    private ExpressRouteCrossConnectionsService service;
    private NetworkManagementClientImpl client;

    public ExpressRouteCrossConnectionsInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (ExpressRouteCrossConnectionsService)retrofit.create(ExpressRouteCrossConnectionsService.class);
        this.client = client;
    }

    public PagedList<ExpressRouteCrossConnectionInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<ExpressRouteCrossConnectionInner>((Page)response.body()){

            public Page<ExpressRouteCrossConnectionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ExpressRouteCrossConnectionsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ExpressRouteCrossConnectionInner>> listAsync(ListOperationCallback<ExpressRouteCrossConnectionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<ExpressRouteCrossConnectionInner>>>>(){

            public Observable<ServiceResponse<Page<ExpressRouteCrossConnectionInner>>> call(String nextPageLink) {
                return ExpressRouteCrossConnectionsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ExpressRouteCrossConnectionInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<ExpressRouteCrossConnectionInner>>, Page<ExpressRouteCrossConnectionInner>>(){

            public Page<ExpressRouteCrossConnectionInner> call(ServiceResponse<Page<ExpressRouteCrossConnectionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ExpressRouteCrossConnectionInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<ExpressRouteCrossConnectionInner>>, Observable<ServiceResponse<Page<ExpressRouteCrossConnectionInner>>>>(){

            public Observable<ServiceResponse<Page<ExpressRouteCrossConnectionInner>>> call(ServiceResponse<Page<ExpressRouteCrossConnectionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ExpressRouteCrossConnectionsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ExpressRouteCrossConnectionInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-02-01";
        return this.service.list(this.client.subscriptionId(), "2018-02-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ExpressRouteCrossConnectionInner>>>>(){

            public Observable<ServiceResponse<Page<ExpressRouteCrossConnectionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ExpressRouteCrossConnectionsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ExpressRouteCrossConnectionInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ExpressRouteCrossConnectionInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ExpressRouteCrossConnectionInner> listByResourceGroup(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<ExpressRouteCrossConnectionInner>((Page)response.body()){

            public Page<ExpressRouteCrossConnectionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ExpressRouteCrossConnectionsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ExpressRouteCrossConnectionInner>> listByResourceGroupAsync(String resourceGroupName, ListOperationCallback<ExpressRouteCrossConnectionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<ExpressRouteCrossConnectionInner>>>>(){

            public Observable<ServiceResponse<Page<ExpressRouteCrossConnectionInner>>> call(String nextPageLink) {
                return ExpressRouteCrossConnectionsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ExpressRouteCrossConnectionInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<ExpressRouteCrossConnectionInner>>, Page<ExpressRouteCrossConnectionInner>>(){

            public Page<ExpressRouteCrossConnectionInner> call(ServiceResponse<Page<ExpressRouteCrossConnectionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ExpressRouteCrossConnectionInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<ExpressRouteCrossConnectionInner>>, Observable<ServiceResponse<Page<ExpressRouteCrossConnectionInner>>>>(){

            public Observable<ServiceResponse<Page<ExpressRouteCrossConnectionInner>>> call(ServiceResponse<Page<ExpressRouteCrossConnectionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ExpressRouteCrossConnectionsInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ExpressRouteCrossConnectionInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-02-01";
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), "2018-02-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ExpressRouteCrossConnectionInner>>>>(){

            public Observable<ServiceResponse<Page<ExpressRouteCrossConnectionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ExpressRouteCrossConnectionsInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ExpressRouteCrossConnectionInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ExpressRouteCrossConnectionInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ExpressRouteCrossConnectionInner getByResourceGroup(String resourceGroupName, String crossConnectionName) {
        return (ExpressRouteCrossConnectionInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, crossConnectionName).toBlocking().single()).body());
    }

    public ServiceFuture<ExpressRouteCrossConnectionInner> getByResourceGroupAsync(String resourceGroupName, String crossConnectionName, ServiceCallback<ExpressRouteCrossConnectionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, crossConnectionName), serviceCallback);
    }

    public Observable<ExpressRouteCrossConnectionInner> getByResourceGroupAsync(String resourceGroupName, String crossConnectionName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, crossConnectionName).map((Func1)new Func1<ServiceResponse<ExpressRouteCrossConnectionInner>, ExpressRouteCrossConnectionInner>(){

            public ExpressRouteCrossConnectionInner call(ServiceResponse<ExpressRouteCrossConnectionInner> response) {
                return (ExpressRouteCrossConnectionInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ExpressRouteCrossConnectionInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String crossConnectionName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (crossConnectionName == null) {
            throw new IllegalArgumentException("Parameter crossConnectionName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-02-01";
        return this.service.getByResourceGroup(resourceGroupName, crossConnectionName, this.client.subscriptionId(), "2018-02-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ExpressRouteCrossConnectionInner>>>(){

            public Observable<ServiceResponse<ExpressRouteCrossConnectionInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ExpressRouteCrossConnectionsInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ExpressRouteCrossConnectionInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ExpressRouteCrossConnectionInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ExpressRouteCrossConnectionInner createOrUpdate(String resourceGroupName, String crossConnectionName, ExpressRouteCrossConnectionInner parameters) {
        return (ExpressRouteCrossConnectionInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, crossConnectionName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<ExpressRouteCrossConnectionInner> createOrUpdateAsync(String resourceGroupName, String crossConnectionName, ExpressRouteCrossConnectionInner parameters, ServiceCallback<ExpressRouteCrossConnectionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, crossConnectionName, parameters), serviceCallback);
    }

    public Observable<ExpressRouteCrossConnectionInner> createOrUpdateAsync(String resourceGroupName, String crossConnectionName, ExpressRouteCrossConnectionInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, crossConnectionName, parameters).map((Func1)new Func1<ServiceResponse<ExpressRouteCrossConnectionInner>, ExpressRouteCrossConnectionInner>(){

            public ExpressRouteCrossConnectionInner call(ServiceResponse<ExpressRouteCrossConnectionInner> response) {
                return (ExpressRouteCrossConnectionInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ExpressRouteCrossConnectionInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String crossConnectionName, ExpressRouteCrossConnectionInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (crossConnectionName == null) {
            throw new IllegalArgumentException("Parameter crossConnectionName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2018-02-01";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, crossConnectionName, this.client.subscriptionId(), parameters, "2018-02-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ExpressRouteCrossConnectionInner>(){}.getType());
    }

    public ExpressRouteCrossConnectionInner beginCreateOrUpdate(String resourceGroupName, String crossConnectionName, ExpressRouteCrossConnectionInner parameters) {
        return (ExpressRouteCrossConnectionInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, crossConnectionName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<ExpressRouteCrossConnectionInner> beginCreateOrUpdateAsync(String resourceGroupName, String crossConnectionName, ExpressRouteCrossConnectionInner parameters, ServiceCallback<ExpressRouteCrossConnectionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, crossConnectionName, parameters), serviceCallback);
    }

    public Observable<ExpressRouteCrossConnectionInner> beginCreateOrUpdateAsync(String resourceGroupName, String crossConnectionName, ExpressRouteCrossConnectionInner parameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, crossConnectionName, parameters).map((Func1)new Func1<ServiceResponse<ExpressRouteCrossConnectionInner>, ExpressRouteCrossConnectionInner>(){

            public ExpressRouteCrossConnectionInner call(ServiceResponse<ExpressRouteCrossConnectionInner> response) {
                return (ExpressRouteCrossConnectionInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ExpressRouteCrossConnectionInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String crossConnectionName, ExpressRouteCrossConnectionInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (crossConnectionName == null) {
            throw new IllegalArgumentException("Parameter crossConnectionName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2018-02-01";
        return this.service.beginCreateOrUpdate(resourceGroupName, crossConnectionName, this.client.subscriptionId(), parameters, "2018-02-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ExpressRouteCrossConnectionInner>>>(){

            public Observable<ServiceResponse<ExpressRouteCrossConnectionInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ExpressRouteCrossConnectionsInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ExpressRouteCrossConnectionInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ExpressRouteCrossConnectionInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ExpressRouteCrossConnectionInner updateTags(String resourceGroupName, String crossConnectionName) {
        return (ExpressRouteCrossConnectionInner)((Object)((ServiceResponse)this.updateTagsWithServiceResponseAsync(resourceGroupName, crossConnectionName).toBlocking().last()).body());
    }

    public ServiceFuture<ExpressRouteCrossConnectionInner> updateTagsAsync(String resourceGroupName, String crossConnectionName, ServiceCallback<ExpressRouteCrossConnectionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateTagsWithServiceResponseAsync(resourceGroupName, crossConnectionName), serviceCallback);
    }

    public Observable<ExpressRouteCrossConnectionInner> updateTagsAsync(String resourceGroupName, String crossConnectionName) {
        return this.updateTagsWithServiceResponseAsync(resourceGroupName, crossConnectionName).map((Func1)new Func1<ServiceResponse<ExpressRouteCrossConnectionInner>, ExpressRouteCrossConnectionInner>(){

            public ExpressRouteCrossConnectionInner call(ServiceResponse<ExpressRouteCrossConnectionInner> response) {
                return (ExpressRouteCrossConnectionInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ExpressRouteCrossConnectionInner>> updateTagsWithServiceResponseAsync(String resourceGroupName, String crossConnectionName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (crossConnectionName == null) {
            throw new IllegalArgumentException("Parameter crossConnectionName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-02-01";
        Object tags = null;
        TagsObject crossConnectionParameters = new TagsObject();
        crossConnectionParameters.withTags(null);
        Observable<Response<ResponseBody>> observable = this.service.updateTags(resourceGroupName, crossConnectionName, this.client.subscriptionId(), "2018-02-01", this.client.acceptLanguage(), crossConnectionParameters, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ExpressRouteCrossConnectionInner>(){}.getType());
    }

    public ExpressRouteCrossConnectionInner updateTags(String resourceGroupName, String crossConnectionName, Map<String, String> tags) {
        return (ExpressRouteCrossConnectionInner)((Object)((ServiceResponse)this.updateTagsWithServiceResponseAsync(resourceGroupName, crossConnectionName, tags).toBlocking().last()).body());
    }

    public ServiceFuture<ExpressRouteCrossConnectionInner> updateTagsAsync(String resourceGroupName, String crossConnectionName, Map<String, String> tags, ServiceCallback<ExpressRouteCrossConnectionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateTagsWithServiceResponseAsync(resourceGroupName, crossConnectionName, tags), serviceCallback);
    }

    public Observable<ExpressRouteCrossConnectionInner> updateTagsAsync(String resourceGroupName, String crossConnectionName, Map<String, String> tags) {
        return this.updateTagsWithServiceResponseAsync(resourceGroupName, crossConnectionName, tags).map((Func1)new Func1<ServiceResponse<ExpressRouteCrossConnectionInner>, ExpressRouteCrossConnectionInner>(){

            public ExpressRouteCrossConnectionInner call(ServiceResponse<ExpressRouteCrossConnectionInner> response) {
                return (ExpressRouteCrossConnectionInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ExpressRouteCrossConnectionInner>> updateTagsWithServiceResponseAsync(String resourceGroupName, String crossConnectionName, Map<String, String> tags) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (crossConnectionName == null) {
            throw new IllegalArgumentException("Parameter crossConnectionName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        Validator.validate(tags);
        String apiVersion = "2018-02-01";
        TagsObject crossConnectionParameters = new TagsObject();
        crossConnectionParameters.withTags(tags);
        Observable<Response<ResponseBody>> observable = this.service.updateTags(resourceGroupName, crossConnectionName, this.client.subscriptionId(), "2018-02-01", this.client.acceptLanguage(), crossConnectionParameters, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ExpressRouteCrossConnectionInner>(){}.getType());
    }

    public ExpressRouteCrossConnectionInner beginUpdateTags(String resourceGroupName, String crossConnectionName) {
        return (ExpressRouteCrossConnectionInner)((Object)((ServiceResponse)this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, crossConnectionName).toBlocking().single()).body());
    }

    public ServiceFuture<ExpressRouteCrossConnectionInner> beginUpdateTagsAsync(String resourceGroupName, String crossConnectionName, ServiceCallback<ExpressRouteCrossConnectionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, crossConnectionName), serviceCallback);
    }

    public Observable<ExpressRouteCrossConnectionInner> beginUpdateTagsAsync(String resourceGroupName, String crossConnectionName) {
        return this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, crossConnectionName).map((Func1)new Func1<ServiceResponse<ExpressRouteCrossConnectionInner>, ExpressRouteCrossConnectionInner>(){

            public ExpressRouteCrossConnectionInner call(ServiceResponse<ExpressRouteCrossConnectionInner> response) {
                return (ExpressRouteCrossConnectionInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ExpressRouteCrossConnectionInner>> beginUpdateTagsWithServiceResponseAsync(String resourceGroupName, String crossConnectionName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (crossConnectionName == null) {
            throw new IllegalArgumentException("Parameter crossConnectionName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-02-01";
        Object tags = null;
        TagsObject crossConnectionParameters = new TagsObject();
        crossConnectionParameters.withTags(null);
        return this.service.beginUpdateTags(resourceGroupName, crossConnectionName, this.client.subscriptionId(), "2018-02-01", this.client.acceptLanguage(), crossConnectionParameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ExpressRouteCrossConnectionInner>>>(){

            public Observable<ServiceResponse<ExpressRouteCrossConnectionInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ExpressRouteCrossConnectionsInner.this.beginUpdateTagsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public ExpressRouteCrossConnectionInner beginUpdateTags(String resourceGroupName, String crossConnectionName, Map<String, String> tags) {
        return (ExpressRouteCrossConnectionInner)((Object)((ServiceResponse)this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, crossConnectionName, tags).toBlocking().single()).body());
    }

    public ServiceFuture<ExpressRouteCrossConnectionInner> beginUpdateTagsAsync(String resourceGroupName, String crossConnectionName, Map<String, String> tags, ServiceCallback<ExpressRouteCrossConnectionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, crossConnectionName, tags), serviceCallback);
    }

    public Observable<ExpressRouteCrossConnectionInner> beginUpdateTagsAsync(String resourceGroupName, String crossConnectionName, Map<String, String> tags) {
        return this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, crossConnectionName, tags).map((Func1)new Func1<ServiceResponse<ExpressRouteCrossConnectionInner>, ExpressRouteCrossConnectionInner>(){

            public ExpressRouteCrossConnectionInner call(ServiceResponse<ExpressRouteCrossConnectionInner> response) {
                return (ExpressRouteCrossConnectionInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ExpressRouteCrossConnectionInner>> beginUpdateTagsWithServiceResponseAsync(String resourceGroupName, String crossConnectionName, Map<String, String> tags) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (crossConnectionName == null) {
            throw new IllegalArgumentException("Parameter crossConnectionName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        Validator.validate(tags);
        String apiVersion = "2018-02-01";
        TagsObject crossConnectionParameters = new TagsObject();
        crossConnectionParameters.withTags(tags);
        return this.service.beginUpdateTags(resourceGroupName, crossConnectionName, this.client.subscriptionId(), "2018-02-01", this.client.acceptLanguage(), crossConnectionParameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ExpressRouteCrossConnectionInner>>>(){

            public Observable<ServiceResponse<ExpressRouteCrossConnectionInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ExpressRouteCrossConnectionsInner.this.beginUpdateTagsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ExpressRouteCrossConnectionInner> beginUpdateTagsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ExpressRouteCrossConnectionInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ExpressRouteCircuitsArpTableListResultInner listArpTable(String resourceGroupName, String crossConnectionName, String peeringName, String devicePath) {
        return (ExpressRouteCircuitsArpTableListResultInner)((ServiceResponse)this.listArpTableWithServiceResponseAsync(resourceGroupName, crossConnectionName, peeringName, devicePath).toBlocking().last()).body();
    }

    public ServiceFuture<ExpressRouteCircuitsArpTableListResultInner> listArpTableAsync(String resourceGroupName, String crossConnectionName, String peeringName, String devicePath, ServiceCallback<ExpressRouteCircuitsArpTableListResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.listArpTableWithServiceResponseAsync(resourceGroupName, crossConnectionName, peeringName, devicePath), serviceCallback);
    }

    public Observable<ExpressRouteCircuitsArpTableListResultInner> listArpTableAsync(String resourceGroupName, String crossConnectionName, String peeringName, String devicePath) {
        return this.listArpTableWithServiceResponseAsync(resourceGroupName, crossConnectionName, peeringName, devicePath).map((Func1)new Func1<ServiceResponse<ExpressRouteCircuitsArpTableListResultInner>, ExpressRouteCircuitsArpTableListResultInner>(){

            public ExpressRouteCircuitsArpTableListResultInner call(ServiceResponse<ExpressRouteCircuitsArpTableListResultInner> response) {
                return (ExpressRouteCircuitsArpTableListResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ExpressRouteCircuitsArpTableListResultInner>> listArpTableWithServiceResponseAsync(String resourceGroupName, String crossConnectionName, String peeringName, String devicePath) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (crossConnectionName == null) {
            throw new IllegalArgumentException("Parameter crossConnectionName is required and cannot be null.");
        }
        if (peeringName == null) {
            throw new IllegalArgumentException("Parameter peeringName is required and cannot be null.");
        }
        if (devicePath == null) {
            throw new IllegalArgumentException("Parameter devicePath is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-02-01";
        Observable<Response<ResponseBody>> observable = this.service.listArpTable(resourceGroupName, crossConnectionName, peeringName, devicePath, this.client.subscriptionId(), "2018-02-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<ExpressRouteCircuitsArpTableListResultInner>(){}.getType());
    }

    public ExpressRouteCircuitsArpTableListResultInner beginListArpTable(String resourceGroupName, String crossConnectionName, String peeringName, String devicePath) {
        return (ExpressRouteCircuitsArpTableListResultInner)((ServiceResponse)this.beginListArpTableWithServiceResponseAsync(resourceGroupName, crossConnectionName, peeringName, devicePath).toBlocking().single()).body();
    }

    public ServiceFuture<ExpressRouteCircuitsArpTableListResultInner> beginListArpTableAsync(String resourceGroupName, String crossConnectionName, String peeringName, String devicePath, ServiceCallback<ExpressRouteCircuitsArpTableListResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginListArpTableWithServiceResponseAsync(resourceGroupName, crossConnectionName, peeringName, devicePath), serviceCallback);
    }

    public Observable<ExpressRouteCircuitsArpTableListResultInner> beginListArpTableAsync(String resourceGroupName, String crossConnectionName, String peeringName, String devicePath) {
        return this.beginListArpTableWithServiceResponseAsync(resourceGroupName, crossConnectionName, peeringName, devicePath).map((Func1)new Func1<ServiceResponse<ExpressRouteCircuitsArpTableListResultInner>, ExpressRouteCircuitsArpTableListResultInner>(){

            public ExpressRouteCircuitsArpTableListResultInner call(ServiceResponse<ExpressRouteCircuitsArpTableListResultInner> response) {
                return (ExpressRouteCircuitsArpTableListResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ExpressRouteCircuitsArpTableListResultInner>> beginListArpTableWithServiceResponseAsync(String resourceGroupName, String crossConnectionName, String peeringName, String devicePath) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (crossConnectionName == null) {
            throw new IllegalArgumentException("Parameter crossConnectionName is required and cannot be null.");
        }
        if (peeringName == null) {
            throw new IllegalArgumentException("Parameter peeringName is required and cannot be null.");
        }
        if (devicePath == null) {
            throw new IllegalArgumentException("Parameter devicePath is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-02-01";
        return this.service.beginListArpTable(resourceGroupName, crossConnectionName, peeringName, devicePath, this.client.subscriptionId(), "2018-02-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ExpressRouteCircuitsArpTableListResultInner>>>(){

            public Observable<ServiceResponse<ExpressRouteCircuitsArpTableListResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ExpressRouteCrossConnectionsInner.this.beginListArpTableDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ExpressRouteCircuitsArpTableListResultInner> beginListArpTableDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ExpressRouteCircuitsArpTableListResultInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ExpressRouteCrossConnectionsRoutesTableSummaryListResultInner listRoutesTableSummary(String resourceGroupName, String crossConnectionName, String peeringName, String devicePath) {
        return (ExpressRouteCrossConnectionsRoutesTableSummaryListResultInner)((ServiceResponse)this.listRoutesTableSummaryWithServiceResponseAsync(resourceGroupName, crossConnectionName, peeringName, devicePath).toBlocking().last()).body();
    }

    public ServiceFuture<ExpressRouteCrossConnectionsRoutesTableSummaryListResultInner> listRoutesTableSummaryAsync(String resourceGroupName, String crossConnectionName, String peeringName, String devicePath, ServiceCallback<ExpressRouteCrossConnectionsRoutesTableSummaryListResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.listRoutesTableSummaryWithServiceResponseAsync(resourceGroupName, crossConnectionName, peeringName, devicePath), serviceCallback);
    }

    public Observable<ExpressRouteCrossConnectionsRoutesTableSummaryListResultInner> listRoutesTableSummaryAsync(String resourceGroupName, String crossConnectionName, String peeringName, String devicePath) {
        return this.listRoutesTableSummaryWithServiceResponseAsync(resourceGroupName, crossConnectionName, peeringName, devicePath).map((Func1)new Func1<ServiceResponse<ExpressRouteCrossConnectionsRoutesTableSummaryListResultInner>, ExpressRouteCrossConnectionsRoutesTableSummaryListResultInner>(){

            public ExpressRouteCrossConnectionsRoutesTableSummaryListResultInner call(ServiceResponse<ExpressRouteCrossConnectionsRoutesTableSummaryListResultInner> response) {
                return (ExpressRouteCrossConnectionsRoutesTableSummaryListResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ExpressRouteCrossConnectionsRoutesTableSummaryListResultInner>> listRoutesTableSummaryWithServiceResponseAsync(String resourceGroupName, String crossConnectionName, String peeringName, String devicePath) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (crossConnectionName == null) {
            throw new IllegalArgumentException("Parameter crossConnectionName is required and cannot be null.");
        }
        if (peeringName == null) {
            throw new IllegalArgumentException("Parameter peeringName is required and cannot be null.");
        }
        if (devicePath == null) {
            throw new IllegalArgumentException("Parameter devicePath is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-02-01";
        Observable<Response<ResponseBody>> observable = this.service.listRoutesTableSummary(resourceGroupName, crossConnectionName, peeringName, devicePath, this.client.subscriptionId(), "2018-02-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<ExpressRouteCrossConnectionsRoutesTableSummaryListResultInner>(){}.getType());
    }

    public ExpressRouteCrossConnectionsRoutesTableSummaryListResultInner beginListRoutesTableSummary(String resourceGroupName, String crossConnectionName, String peeringName, String devicePath) {
        return (ExpressRouteCrossConnectionsRoutesTableSummaryListResultInner)((ServiceResponse)this.beginListRoutesTableSummaryWithServiceResponseAsync(resourceGroupName, crossConnectionName, peeringName, devicePath).toBlocking().single()).body();
    }

    public ServiceFuture<ExpressRouteCrossConnectionsRoutesTableSummaryListResultInner> beginListRoutesTableSummaryAsync(String resourceGroupName, String crossConnectionName, String peeringName, String devicePath, ServiceCallback<ExpressRouteCrossConnectionsRoutesTableSummaryListResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginListRoutesTableSummaryWithServiceResponseAsync(resourceGroupName, crossConnectionName, peeringName, devicePath), serviceCallback);
    }

    public Observable<ExpressRouteCrossConnectionsRoutesTableSummaryListResultInner> beginListRoutesTableSummaryAsync(String resourceGroupName, String crossConnectionName, String peeringName, String devicePath) {
        return this.beginListRoutesTableSummaryWithServiceResponseAsync(resourceGroupName, crossConnectionName, peeringName, devicePath).map((Func1)new Func1<ServiceResponse<ExpressRouteCrossConnectionsRoutesTableSummaryListResultInner>, ExpressRouteCrossConnectionsRoutesTableSummaryListResultInner>(){

            public ExpressRouteCrossConnectionsRoutesTableSummaryListResultInner call(ServiceResponse<ExpressRouteCrossConnectionsRoutesTableSummaryListResultInner> response) {
                return (ExpressRouteCrossConnectionsRoutesTableSummaryListResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ExpressRouteCrossConnectionsRoutesTableSummaryListResultInner>> beginListRoutesTableSummaryWithServiceResponseAsync(String resourceGroupName, String crossConnectionName, String peeringName, String devicePath) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (crossConnectionName == null) {
            throw new IllegalArgumentException("Parameter crossConnectionName is required and cannot be null.");
        }
        if (peeringName == null) {
            throw new IllegalArgumentException("Parameter peeringName is required and cannot be null.");
        }
        if (devicePath == null) {
            throw new IllegalArgumentException("Parameter devicePath is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-02-01";
        return this.service.beginListRoutesTableSummary(resourceGroupName, crossConnectionName, peeringName, devicePath, this.client.subscriptionId(), "2018-02-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ExpressRouteCrossConnectionsRoutesTableSummaryListResultInner>>>(){

            public Observable<ServiceResponse<ExpressRouteCrossConnectionsRoutesTableSummaryListResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ExpressRouteCrossConnectionsInner.this.beginListRoutesTableSummaryDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ExpressRouteCrossConnectionsRoutesTableSummaryListResultInner> beginListRoutesTableSummaryDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ExpressRouteCrossConnectionsRoutesTableSummaryListResultInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ExpressRouteCircuitsRoutesTableListResultInner listRoutesTable(String resourceGroupName, String crossConnectionName, String peeringName, String devicePath) {
        return (ExpressRouteCircuitsRoutesTableListResultInner)((ServiceResponse)this.listRoutesTableWithServiceResponseAsync(resourceGroupName, crossConnectionName, peeringName, devicePath).toBlocking().last()).body();
    }

    public ServiceFuture<ExpressRouteCircuitsRoutesTableListResultInner> listRoutesTableAsync(String resourceGroupName, String crossConnectionName, String peeringName, String devicePath, ServiceCallback<ExpressRouteCircuitsRoutesTableListResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.listRoutesTableWithServiceResponseAsync(resourceGroupName, crossConnectionName, peeringName, devicePath), serviceCallback);
    }

    public Observable<ExpressRouteCircuitsRoutesTableListResultInner> listRoutesTableAsync(String resourceGroupName, String crossConnectionName, String peeringName, String devicePath) {
        return this.listRoutesTableWithServiceResponseAsync(resourceGroupName, crossConnectionName, peeringName, devicePath).map((Func1)new Func1<ServiceResponse<ExpressRouteCircuitsRoutesTableListResultInner>, ExpressRouteCircuitsRoutesTableListResultInner>(){

            public ExpressRouteCircuitsRoutesTableListResultInner call(ServiceResponse<ExpressRouteCircuitsRoutesTableListResultInner> response) {
                return (ExpressRouteCircuitsRoutesTableListResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ExpressRouteCircuitsRoutesTableListResultInner>> listRoutesTableWithServiceResponseAsync(String resourceGroupName, String crossConnectionName, String peeringName, String devicePath) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (crossConnectionName == null) {
            throw new IllegalArgumentException("Parameter crossConnectionName is required and cannot be null.");
        }
        if (peeringName == null) {
            throw new IllegalArgumentException("Parameter peeringName is required and cannot be null.");
        }
        if (devicePath == null) {
            throw new IllegalArgumentException("Parameter devicePath is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-02-01";
        Observable<Response<ResponseBody>> observable = this.service.listRoutesTable(resourceGroupName, crossConnectionName, peeringName, devicePath, this.client.subscriptionId(), "2018-02-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<ExpressRouteCircuitsRoutesTableListResultInner>(){}.getType());
    }

    public ExpressRouteCircuitsRoutesTableListResultInner beginListRoutesTable(String resourceGroupName, String crossConnectionName, String peeringName, String devicePath) {
        return (ExpressRouteCircuitsRoutesTableListResultInner)((ServiceResponse)this.beginListRoutesTableWithServiceResponseAsync(resourceGroupName, crossConnectionName, peeringName, devicePath).toBlocking().single()).body();
    }

    public ServiceFuture<ExpressRouteCircuitsRoutesTableListResultInner> beginListRoutesTableAsync(String resourceGroupName, String crossConnectionName, String peeringName, String devicePath, ServiceCallback<ExpressRouteCircuitsRoutesTableListResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginListRoutesTableWithServiceResponseAsync(resourceGroupName, crossConnectionName, peeringName, devicePath), serviceCallback);
    }

    public Observable<ExpressRouteCircuitsRoutesTableListResultInner> beginListRoutesTableAsync(String resourceGroupName, String crossConnectionName, String peeringName, String devicePath) {
        return this.beginListRoutesTableWithServiceResponseAsync(resourceGroupName, crossConnectionName, peeringName, devicePath).map((Func1)new Func1<ServiceResponse<ExpressRouteCircuitsRoutesTableListResultInner>, ExpressRouteCircuitsRoutesTableListResultInner>(){

            public ExpressRouteCircuitsRoutesTableListResultInner call(ServiceResponse<ExpressRouteCircuitsRoutesTableListResultInner> response) {
                return (ExpressRouteCircuitsRoutesTableListResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ExpressRouteCircuitsRoutesTableListResultInner>> beginListRoutesTableWithServiceResponseAsync(String resourceGroupName, String crossConnectionName, String peeringName, String devicePath) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (crossConnectionName == null) {
            throw new IllegalArgumentException("Parameter crossConnectionName is required and cannot be null.");
        }
        if (peeringName == null) {
            throw new IllegalArgumentException("Parameter peeringName is required and cannot be null.");
        }
        if (devicePath == null) {
            throw new IllegalArgumentException("Parameter devicePath is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-02-01";
        return this.service.beginListRoutesTable(resourceGroupName, crossConnectionName, peeringName, devicePath, this.client.subscriptionId(), "2018-02-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ExpressRouteCircuitsRoutesTableListResultInner>>>(){

            public Observable<ServiceResponse<ExpressRouteCircuitsRoutesTableListResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ExpressRouteCrossConnectionsInner.this.beginListRoutesTableDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ExpressRouteCircuitsRoutesTableListResultInner> beginListRoutesTableDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ExpressRouteCircuitsRoutesTableListResultInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ExpressRouteCrossConnectionInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ExpressRouteCrossConnectionInner>((Page)response.body()){

            public Page<ExpressRouteCrossConnectionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ExpressRouteCrossConnectionsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ExpressRouteCrossConnectionInner>> listNextAsync(String nextPageLink, ServiceFuture<List<ExpressRouteCrossConnectionInner>> serviceFuture, ListOperationCallback<ExpressRouteCrossConnectionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ExpressRouteCrossConnectionInner>>>>(){

            public Observable<ServiceResponse<Page<ExpressRouteCrossConnectionInner>>> call(String nextPageLink) {
                return ExpressRouteCrossConnectionsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ExpressRouteCrossConnectionInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ExpressRouteCrossConnectionInner>>, Page<ExpressRouteCrossConnectionInner>>(){

            public Page<ExpressRouteCrossConnectionInner> call(ServiceResponse<Page<ExpressRouteCrossConnectionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ExpressRouteCrossConnectionInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ExpressRouteCrossConnectionInner>>, Observable<ServiceResponse<Page<ExpressRouteCrossConnectionInner>>>>(){

            public Observable<ServiceResponse<Page<ExpressRouteCrossConnectionInner>>> call(ServiceResponse<Page<ExpressRouteCrossConnectionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ExpressRouteCrossConnectionsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ExpressRouteCrossConnectionInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ExpressRouteCrossConnectionInner>>>>(){

            public Observable<ServiceResponse<Page<ExpressRouteCrossConnectionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ExpressRouteCrossConnectionsInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ExpressRouteCrossConnectionInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ExpressRouteCrossConnectionInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ExpressRouteCrossConnectionInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ExpressRouteCrossConnectionInner>((Page)response.body()){

            public Page<ExpressRouteCrossConnectionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ExpressRouteCrossConnectionsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ExpressRouteCrossConnectionInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<ExpressRouteCrossConnectionInner>> serviceFuture, ListOperationCallback<ExpressRouteCrossConnectionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ExpressRouteCrossConnectionInner>>>>(){

            public Observable<ServiceResponse<Page<ExpressRouteCrossConnectionInner>>> call(String nextPageLink) {
                return ExpressRouteCrossConnectionsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ExpressRouteCrossConnectionInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ExpressRouteCrossConnectionInner>>, Page<ExpressRouteCrossConnectionInner>>(){

            public Page<ExpressRouteCrossConnectionInner> call(ServiceResponse<Page<ExpressRouteCrossConnectionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ExpressRouteCrossConnectionInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ExpressRouteCrossConnectionInner>>, Observable<ServiceResponse<Page<ExpressRouteCrossConnectionInner>>>>(){

            public Observable<ServiceResponse<Page<ExpressRouteCrossConnectionInner>>> call(ServiceResponse<Page<ExpressRouteCrossConnectionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ExpressRouteCrossConnectionsInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ExpressRouteCrossConnectionInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ExpressRouteCrossConnectionInner>>>>(){

            public Observable<ServiceResponse<Page<ExpressRouteCrossConnectionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ExpressRouteCrossConnectionsInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ExpressRouteCrossConnectionInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ExpressRouteCrossConnectionInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ExpressRouteCrossConnectionsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ExpressRouteCrossConnections list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Network/expressRouteCrossConnections")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ExpressRouteCrossConnections listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCrossConnections")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ExpressRouteCrossConnections getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCrossConnections/{crossConnectionName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="crossConnectionName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ExpressRouteCrossConnections createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCrossConnections/{crossConnectionName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="crossConnectionName") String var2, @Path(value="subscriptionId") String var3, @Body ExpressRouteCrossConnectionInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ExpressRouteCrossConnections beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCrossConnections/{crossConnectionName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="crossConnectionName") String var2, @Path(value="subscriptionId") String var3, @Body ExpressRouteCrossConnectionInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ExpressRouteCrossConnections updateTags"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCrossConnections/{crossConnectionName}")
        public Observable<Response<ResponseBody>> updateTags(@Path(value="resourceGroupName") String var1, @Path(value="crossConnectionName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body TagsObject var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ExpressRouteCrossConnections beginUpdateTags"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCrossConnections/{crossConnectionName}")
        public Observable<Response<ResponseBody>> beginUpdateTags(@Path(value="resourceGroupName") String var1, @Path(value="crossConnectionName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body TagsObject var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ExpressRouteCrossConnections listArpTable"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCrossConnections/{crossConnectionName}/peerings/{peeringName}/arpTables/{devicePath}")
        public Observable<Response<ResponseBody>> listArpTable(@Path(value="resourceGroupName") String var1, @Path(value="crossConnectionName") String var2, @Path(value="peeringName") String var3, @Path(value="devicePath") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ExpressRouteCrossConnections beginListArpTable"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCrossConnections/{crossConnectionName}/peerings/{peeringName}/arpTables/{devicePath}")
        public Observable<Response<ResponseBody>> beginListArpTable(@Path(value="resourceGroupName") String var1, @Path(value="crossConnectionName") String var2, @Path(value="peeringName") String var3, @Path(value="devicePath") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ExpressRouteCrossConnections listRoutesTableSummary"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCrossConnections/{crossConnectionName}/peerings/{peeringName}/routeTablesSummary/{devicePath}")
        public Observable<Response<ResponseBody>> listRoutesTableSummary(@Path(value="resourceGroupName") String var1, @Path(value="crossConnectionName") String var2, @Path(value="peeringName") String var3, @Path(value="devicePath") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ExpressRouteCrossConnections beginListRoutesTableSummary"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCrossConnections/{crossConnectionName}/peerings/{peeringName}/routeTablesSummary/{devicePath}")
        public Observable<Response<ResponseBody>> beginListRoutesTableSummary(@Path(value="resourceGroupName") String var1, @Path(value="crossConnectionName") String var2, @Path(value="peeringName") String var3, @Path(value="devicePath") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ExpressRouteCrossConnections listRoutesTable"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCrossConnections/{crossConnectionName}/peerings/{peeringName}/routeTables/{devicePath}")
        public Observable<Response<ResponseBody>> listRoutesTable(@Path(value="resourceGroupName") String var1, @Path(value="crossConnectionName") String var2, @Path(value="peeringName") String var3, @Path(value="devicePath") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ExpressRouteCrossConnections beginListRoutesTable"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCrossConnections/{crossConnectionName}/peerings/{peeringName}/routeTables/{devicePath}")
        public Observable<Response<ResponseBody>> beginListRoutesTable(@Path(value="resourceGroupName") String var1, @Path(value="crossConnectionName") String var2, @Path(value="peeringName") String var3, @Path(value="devicePath") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ExpressRouteCrossConnections listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ExpressRouteCrossConnections listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

