/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.network.implementation.InboundNatRuleInner;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.PageImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class InboundNatRulesInner {
    private InboundNatRulesService service;
    private NetworkManagementClientImpl client;

    public InboundNatRulesInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (InboundNatRulesService)retrofit.create(InboundNatRulesService.class);
        this.client = client;
    }

    public PagedList<InboundNatRuleInner> list(String resourceGroupName, String loadBalancerName) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(resourceGroupName, loadBalancerName).toBlocking().single();
        return new PagedList<InboundNatRuleInner>((Page)response.body()){

            public Page<InboundNatRuleInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)InboundNatRulesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<InboundNatRuleInner>> listAsync(String resourceGroupName, String loadBalancerName, ListOperationCallback<InboundNatRuleInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(resourceGroupName, loadBalancerName), (Func1)new Func1<String, Observable<ServiceResponse<Page<InboundNatRuleInner>>>>(){

            public Observable<ServiceResponse<Page<InboundNatRuleInner>>> call(String nextPageLink) {
                return InboundNatRulesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<InboundNatRuleInner>> listAsync(String resourceGroupName, String loadBalancerName) {
        return this.listWithServiceResponseAsync(resourceGroupName, loadBalancerName).map((Func1)new Func1<ServiceResponse<Page<InboundNatRuleInner>>, Page<InboundNatRuleInner>>(){

            public Page<InboundNatRuleInner> call(ServiceResponse<Page<InboundNatRuleInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<InboundNatRuleInner>>> listWithServiceResponseAsync(String resourceGroupName, String loadBalancerName) {
        return this.listSinglePageAsync(resourceGroupName, loadBalancerName).concatMap((Func1)new Func1<ServiceResponse<Page<InboundNatRuleInner>>, Observable<ServiceResponse<Page<InboundNatRuleInner>>>>(){

            public Observable<ServiceResponse<Page<InboundNatRuleInner>>> call(ServiceResponse<Page<InboundNatRuleInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(InboundNatRulesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<InboundNatRuleInner>>> listSinglePageAsync(String resourceGroupName, String loadBalancerName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (loadBalancerName == null) {
            throw new IllegalArgumentException("Parameter loadBalancerName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-02-01";
        return this.service.list(resourceGroupName, loadBalancerName, this.client.subscriptionId(), "2018-02-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<InboundNatRuleInner>>>>(){

            public Observable<ServiceResponse<Page<InboundNatRuleInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = InboundNatRulesInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<InboundNatRuleInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<InboundNatRuleInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String loadBalancerName, String inboundNatRuleName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, loadBalancerName, inboundNatRuleName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String loadBalancerName, String inboundNatRuleName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, loadBalancerName, inboundNatRuleName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String loadBalancerName, String inboundNatRuleName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, loadBalancerName, inboundNatRuleName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String loadBalancerName, String inboundNatRuleName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (loadBalancerName == null) {
            throw new IllegalArgumentException("Parameter loadBalancerName is required and cannot be null.");
        }
        if (inboundNatRuleName == null) {
            throw new IllegalArgumentException("Parameter inboundNatRuleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-02-01";
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, loadBalancerName, inboundNatRuleName, this.client.subscriptionId(), "2018-02-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String loadBalancerName, String inboundNatRuleName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, loadBalancerName, inboundNatRuleName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String loadBalancerName, String inboundNatRuleName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, loadBalancerName, inboundNatRuleName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String loadBalancerName, String inboundNatRuleName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, loadBalancerName, inboundNatRuleName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String loadBalancerName, String inboundNatRuleName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (loadBalancerName == null) {
            throw new IllegalArgumentException("Parameter loadBalancerName is required and cannot be null.");
        }
        if (inboundNatRuleName == null) {
            throw new IllegalArgumentException("Parameter inboundNatRuleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-02-01";
        return this.service.beginDelete(resourceGroupName, loadBalancerName, inboundNatRuleName, this.client.subscriptionId(), "2018-02-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = InboundNatRulesInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public InboundNatRuleInner get(String resourceGroupName, String loadBalancerName, String inboundNatRuleName) {
        return (InboundNatRuleInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, loadBalancerName, inboundNatRuleName).toBlocking().single()).body());
    }

    public ServiceFuture<InboundNatRuleInner> getAsync(String resourceGroupName, String loadBalancerName, String inboundNatRuleName, ServiceCallback<InboundNatRuleInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, loadBalancerName, inboundNatRuleName), serviceCallback);
    }

    public Observable<InboundNatRuleInner> getAsync(String resourceGroupName, String loadBalancerName, String inboundNatRuleName) {
        return this.getWithServiceResponseAsync(resourceGroupName, loadBalancerName, inboundNatRuleName).map((Func1)new Func1<ServiceResponse<InboundNatRuleInner>, InboundNatRuleInner>(){

            public InboundNatRuleInner call(ServiceResponse<InboundNatRuleInner> response) {
                return (InboundNatRuleInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<InboundNatRuleInner>> getWithServiceResponseAsync(String resourceGroupName, String loadBalancerName, String inboundNatRuleName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (loadBalancerName == null) {
            throw new IllegalArgumentException("Parameter loadBalancerName is required and cannot be null.");
        }
        if (inboundNatRuleName == null) {
            throw new IllegalArgumentException("Parameter inboundNatRuleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-02-01";
        String expand = null;
        return this.service.get(resourceGroupName, loadBalancerName, inboundNatRuleName, this.client.subscriptionId(), "2018-02-01", expand, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<InboundNatRuleInner>>>(){

            public Observable<ServiceResponse<InboundNatRuleInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = InboundNatRulesInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public InboundNatRuleInner get(String resourceGroupName, String loadBalancerName, String inboundNatRuleName, String expand) {
        return (InboundNatRuleInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, loadBalancerName, inboundNatRuleName, expand).toBlocking().single()).body());
    }

    public ServiceFuture<InboundNatRuleInner> getAsync(String resourceGroupName, String loadBalancerName, String inboundNatRuleName, String expand, ServiceCallback<InboundNatRuleInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, loadBalancerName, inboundNatRuleName, expand), serviceCallback);
    }

    public Observable<InboundNatRuleInner> getAsync(String resourceGroupName, String loadBalancerName, String inboundNatRuleName, String expand) {
        return this.getWithServiceResponseAsync(resourceGroupName, loadBalancerName, inboundNatRuleName, expand).map((Func1)new Func1<ServiceResponse<InboundNatRuleInner>, InboundNatRuleInner>(){

            public InboundNatRuleInner call(ServiceResponse<InboundNatRuleInner> response) {
                return (InboundNatRuleInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<InboundNatRuleInner>> getWithServiceResponseAsync(String resourceGroupName, String loadBalancerName, String inboundNatRuleName, String expand) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (loadBalancerName == null) {
            throw new IllegalArgumentException("Parameter loadBalancerName is required and cannot be null.");
        }
        if (inboundNatRuleName == null) {
            throw new IllegalArgumentException("Parameter inboundNatRuleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-02-01";
        return this.service.get(resourceGroupName, loadBalancerName, inboundNatRuleName, this.client.subscriptionId(), "2018-02-01", expand, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<InboundNatRuleInner>>>(){

            public Observable<ServiceResponse<InboundNatRuleInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = InboundNatRulesInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<InboundNatRuleInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<InboundNatRuleInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public InboundNatRuleInner createOrUpdate(String resourceGroupName, String loadBalancerName, String inboundNatRuleName, InboundNatRuleInner inboundNatRuleParameters) {
        return (InboundNatRuleInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, loadBalancerName, inboundNatRuleName, inboundNatRuleParameters).toBlocking().last()).body());
    }

    public ServiceFuture<InboundNatRuleInner> createOrUpdateAsync(String resourceGroupName, String loadBalancerName, String inboundNatRuleName, InboundNatRuleInner inboundNatRuleParameters, ServiceCallback<InboundNatRuleInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, loadBalancerName, inboundNatRuleName, inboundNatRuleParameters), serviceCallback);
    }

    public Observable<InboundNatRuleInner> createOrUpdateAsync(String resourceGroupName, String loadBalancerName, String inboundNatRuleName, InboundNatRuleInner inboundNatRuleParameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, loadBalancerName, inboundNatRuleName, inboundNatRuleParameters).map((Func1)new Func1<ServiceResponse<InboundNatRuleInner>, InboundNatRuleInner>(){

            public InboundNatRuleInner call(ServiceResponse<InboundNatRuleInner> response) {
                return (InboundNatRuleInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<InboundNatRuleInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String loadBalancerName, String inboundNatRuleName, InboundNatRuleInner inboundNatRuleParameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (loadBalancerName == null) {
            throw new IllegalArgumentException("Parameter loadBalancerName is required and cannot be null.");
        }
        if (inboundNatRuleName == null) {
            throw new IllegalArgumentException("Parameter inboundNatRuleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (inboundNatRuleParameters == null) {
            throw new IllegalArgumentException("Parameter inboundNatRuleParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)inboundNatRuleParameters));
        String apiVersion = "2018-02-01";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, loadBalancerName, inboundNatRuleName, this.client.subscriptionId(), inboundNatRuleParameters, "2018-02-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<InboundNatRuleInner>(){}.getType());
    }

    public InboundNatRuleInner beginCreateOrUpdate(String resourceGroupName, String loadBalancerName, String inboundNatRuleName, InboundNatRuleInner inboundNatRuleParameters) {
        return (InboundNatRuleInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, loadBalancerName, inboundNatRuleName, inboundNatRuleParameters).toBlocking().single()).body());
    }

    public ServiceFuture<InboundNatRuleInner> beginCreateOrUpdateAsync(String resourceGroupName, String loadBalancerName, String inboundNatRuleName, InboundNatRuleInner inboundNatRuleParameters, ServiceCallback<InboundNatRuleInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, loadBalancerName, inboundNatRuleName, inboundNatRuleParameters), serviceCallback);
    }

    public Observable<InboundNatRuleInner> beginCreateOrUpdateAsync(String resourceGroupName, String loadBalancerName, String inboundNatRuleName, InboundNatRuleInner inboundNatRuleParameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, loadBalancerName, inboundNatRuleName, inboundNatRuleParameters).map((Func1)new Func1<ServiceResponse<InboundNatRuleInner>, InboundNatRuleInner>(){

            public InboundNatRuleInner call(ServiceResponse<InboundNatRuleInner> response) {
                return (InboundNatRuleInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<InboundNatRuleInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String loadBalancerName, String inboundNatRuleName, InboundNatRuleInner inboundNatRuleParameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (loadBalancerName == null) {
            throw new IllegalArgumentException("Parameter loadBalancerName is required and cannot be null.");
        }
        if (inboundNatRuleName == null) {
            throw new IllegalArgumentException("Parameter inboundNatRuleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (inboundNatRuleParameters == null) {
            throw new IllegalArgumentException("Parameter inboundNatRuleParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)inboundNatRuleParameters));
        String apiVersion = "2018-02-01";
        return this.service.beginCreateOrUpdate(resourceGroupName, loadBalancerName, inboundNatRuleName, this.client.subscriptionId(), inboundNatRuleParameters, "2018-02-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<InboundNatRuleInner>>>(){

            public Observable<ServiceResponse<InboundNatRuleInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = InboundNatRulesInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<InboundNatRuleInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<InboundNatRuleInner>(){}.getType()).register(201, new TypeToken<InboundNatRuleInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<InboundNatRuleInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<InboundNatRuleInner>((Page)response.body()){

            public Page<InboundNatRuleInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)InboundNatRulesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<InboundNatRuleInner>> listNextAsync(String nextPageLink, ServiceFuture<List<InboundNatRuleInner>> serviceFuture, ListOperationCallback<InboundNatRuleInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<InboundNatRuleInner>>>>(){

            public Observable<ServiceResponse<Page<InboundNatRuleInner>>> call(String nextPageLink) {
                return InboundNatRulesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<InboundNatRuleInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<InboundNatRuleInner>>, Page<InboundNatRuleInner>>(){

            public Page<InboundNatRuleInner> call(ServiceResponse<Page<InboundNatRuleInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<InboundNatRuleInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<InboundNatRuleInner>>, Observable<ServiceResponse<Page<InboundNatRuleInner>>>>(){

            public Observable<ServiceResponse<Page<InboundNatRuleInner>>> call(ServiceResponse<Page<InboundNatRuleInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(InboundNatRulesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<InboundNatRuleInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<InboundNatRuleInner>>>>(){

            public Observable<ServiceResponse<Page<InboundNatRuleInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = InboundNatRulesInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<InboundNatRuleInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<InboundNatRuleInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface InboundNatRulesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.InboundNatRules list"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/inboundNatRules")
        public Observable<Response<ResponseBody>> list(@Path(value="resourceGroupName") String var1, @Path(value="loadBalancerName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.InboundNatRules delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/inboundNatRules/{inboundNatRuleName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="loadBalancerName") String var2, @Path(value="inboundNatRuleName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.InboundNatRules beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/inboundNatRules/{inboundNatRuleName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="loadBalancerName") String var2, @Path(value="inboundNatRuleName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.InboundNatRules get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/inboundNatRules/{inboundNatRuleName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="loadBalancerName") String var2, @Path(value="inboundNatRuleName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Query(value="$expand") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.InboundNatRules createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/inboundNatRules/{inboundNatRuleName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="loadBalancerName") String var2, @Path(value="inboundNatRuleName") String var3, @Path(value="subscriptionId") String var4, @Body InboundNatRuleInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.InboundNatRules beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/inboundNatRules/{inboundNatRuleName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="loadBalancerName") String var2, @Path(value="inboundNatRuleName") String var3, @Path(value="subscriptionId") String var4, @Body InboundNatRuleInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.InboundNatRules listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

