/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.network.TagsObject;
import com.microsoft.azure.management.network.implementation.LoadBalancerInner;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.PageImpl;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class LoadBalancersInner
implements InnerSupportsGet<LoadBalancerInner>,
InnerSupportsDelete<Void>,
InnerSupportsListing<LoadBalancerInner> {
    private LoadBalancersService service;
    private NetworkManagementClientImpl client;

    public LoadBalancersInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (LoadBalancersService)retrofit.create(LoadBalancersService.class);
        this.client = client;
    }

    public void delete(String resourceGroupName, String loadBalancerName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, loadBalancerName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String loadBalancerName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, loadBalancerName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String loadBalancerName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, loadBalancerName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String loadBalancerName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (loadBalancerName == null) {
            throw new IllegalArgumentException("Parameter loadBalancerName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-02-01";
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, loadBalancerName, this.client.subscriptionId(), "2018-02-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String loadBalancerName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, loadBalancerName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String loadBalancerName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, loadBalancerName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String loadBalancerName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, loadBalancerName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String loadBalancerName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (loadBalancerName == null) {
            throw new IllegalArgumentException("Parameter loadBalancerName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-02-01";
        return this.service.beginDelete(resourceGroupName, loadBalancerName, this.client.subscriptionId(), "2018-02-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = LoadBalancersInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public LoadBalancerInner getByResourceGroup(String resourceGroupName, String loadBalancerName) {
        return (LoadBalancerInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, loadBalancerName).toBlocking().single()).body());
    }

    public ServiceFuture<LoadBalancerInner> getByResourceGroupAsync(String resourceGroupName, String loadBalancerName, ServiceCallback<LoadBalancerInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, loadBalancerName), serviceCallback);
    }

    public Observable<LoadBalancerInner> getByResourceGroupAsync(String resourceGroupName, String loadBalancerName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, loadBalancerName).map((Func1)new Func1<ServiceResponse<LoadBalancerInner>, LoadBalancerInner>(){

            public LoadBalancerInner call(ServiceResponse<LoadBalancerInner> response) {
                return (LoadBalancerInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<LoadBalancerInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String loadBalancerName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (loadBalancerName == null) {
            throw new IllegalArgumentException("Parameter loadBalancerName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-02-01";
        String expand = null;
        return this.service.getByResourceGroup(resourceGroupName, loadBalancerName, this.client.subscriptionId(), "2018-02-01", expand, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<LoadBalancerInner>>>(){

            public Observable<ServiceResponse<LoadBalancerInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = LoadBalancersInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public LoadBalancerInner getByResourceGroup(String resourceGroupName, String loadBalancerName, String expand) {
        return (LoadBalancerInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, loadBalancerName, expand).toBlocking().single()).body());
    }

    public ServiceFuture<LoadBalancerInner> getByResourceGroupAsync(String resourceGroupName, String loadBalancerName, String expand, ServiceCallback<LoadBalancerInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, loadBalancerName, expand), serviceCallback);
    }

    public Observable<LoadBalancerInner> getByResourceGroupAsync(String resourceGroupName, String loadBalancerName, String expand) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, loadBalancerName, expand).map((Func1)new Func1<ServiceResponse<LoadBalancerInner>, LoadBalancerInner>(){

            public LoadBalancerInner call(ServiceResponse<LoadBalancerInner> response) {
                return (LoadBalancerInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<LoadBalancerInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String loadBalancerName, String expand) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (loadBalancerName == null) {
            throw new IllegalArgumentException("Parameter loadBalancerName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-02-01";
        return this.service.getByResourceGroup(resourceGroupName, loadBalancerName, this.client.subscriptionId(), "2018-02-01", expand, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<LoadBalancerInner>>>(){

            public Observable<ServiceResponse<LoadBalancerInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = LoadBalancersInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<LoadBalancerInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<LoadBalancerInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public LoadBalancerInner createOrUpdate(String resourceGroupName, String loadBalancerName, LoadBalancerInner parameters) {
        return (LoadBalancerInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, loadBalancerName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<LoadBalancerInner> createOrUpdateAsync(String resourceGroupName, String loadBalancerName, LoadBalancerInner parameters, ServiceCallback<LoadBalancerInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, loadBalancerName, parameters), serviceCallback);
    }

    public Observable<LoadBalancerInner> createOrUpdateAsync(String resourceGroupName, String loadBalancerName, LoadBalancerInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, loadBalancerName, parameters).map((Func1)new Func1<ServiceResponse<LoadBalancerInner>, LoadBalancerInner>(){

            public LoadBalancerInner call(ServiceResponse<LoadBalancerInner> response) {
                return (LoadBalancerInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<LoadBalancerInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String loadBalancerName, LoadBalancerInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (loadBalancerName == null) {
            throw new IllegalArgumentException("Parameter loadBalancerName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2018-02-01";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, loadBalancerName, this.client.subscriptionId(), parameters, "2018-02-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<LoadBalancerInner>(){}.getType());
    }

    public LoadBalancerInner beginCreateOrUpdate(String resourceGroupName, String loadBalancerName, LoadBalancerInner parameters) {
        return (LoadBalancerInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, loadBalancerName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<LoadBalancerInner> beginCreateOrUpdateAsync(String resourceGroupName, String loadBalancerName, LoadBalancerInner parameters, ServiceCallback<LoadBalancerInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, loadBalancerName, parameters), serviceCallback);
    }

    public Observable<LoadBalancerInner> beginCreateOrUpdateAsync(String resourceGroupName, String loadBalancerName, LoadBalancerInner parameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, loadBalancerName, parameters).map((Func1)new Func1<ServiceResponse<LoadBalancerInner>, LoadBalancerInner>(){

            public LoadBalancerInner call(ServiceResponse<LoadBalancerInner> response) {
                return (LoadBalancerInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<LoadBalancerInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String loadBalancerName, LoadBalancerInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (loadBalancerName == null) {
            throw new IllegalArgumentException("Parameter loadBalancerName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2018-02-01";
        return this.service.beginCreateOrUpdate(resourceGroupName, loadBalancerName, this.client.subscriptionId(), parameters, "2018-02-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<LoadBalancerInner>>>(){

            public Observable<ServiceResponse<LoadBalancerInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = LoadBalancersInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<LoadBalancerInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<LoadBalancerInner>(){}.getType()).register(201, new TypeToken<LoadBalancerInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public LoadBalancerInner updateTags(String resourceGroupName, String loadBalancerName) {
        return (LoadBalancerInner)((Object)((ServiceResponse)this.updateTagsWithServiceResponseAsync(resourceGroupName, loadBalancerName).toBlocking().last()).body());
    }

    public ServiceFuture<LoadBalancerInner> updateTagsAsync(String resourceGroupName, String loadBalancerName, ServiceCallback<LoadBalancerInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateTagsWithServiceResponseAsync(resourceGroupName, loadBalancerName), serviceCallback);
    }

    public Observable<LoadBalancerInner> updateTagsAsync(String resourceGroupName, String loadBalancerName) {
        return this.updateTagsWithServiceResponseAsync(resourceGroupName, loadBalancerName).map((Func1)new Func1<ServiceResponse<LoadBalancerInner>, LoadBalancerInner>(){

            public LoadBalancerInner call(ServiceResponse<LoadBalancerInner> response) {
                return (LoadBalancerInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<LoadBalancerInner>> updateTagsWithServiceResponseAsync(String resourceGroupName, String loadBalancerName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (loadBalancerName == null) {
            throw new IllegalArgumentException("Parameter loadBalancerName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-02-01";
        Object tags = null;
        TagsObject parameters = new TagsObject();
        parameters.withTags(null);
        Observable<Response<ResponseBody>> observable = this.service.updateTags(resourceGroupName, loadBalancerName, this.client.subscriptionId(), "2018-02-01", this.client.acceptLanguage(), parameters, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<LoadBalancerInner>(){}.getType());
    }

    public LoadBalancerInner updateTags(String resourceGroupName, String loadBalancerName, Map<String, String> tags) {
        return (LoadBalancerInner)((Object)((ServiceResponse)this.updateTagsWithServiceResponseAsync(resourceGroupName, loadBalancerName, tags).toBlocking().last()).body());
    }

    public ServiceFuture<LoadBalancerInner> updateTagsAsync(String resourceGroupName, String loadBalancerName, Map<String, String> tags, ServiceCallback<LoadBalancerInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateTagsWithServiceResponseAsync(resourceGroupName, loadBalancerName, tags), serviceCallback);
    }

    public Observable<LoadBalancerInner> updateTagsAsync(String resourceGroupName, String loadBalancerName, Map<String, String> tags) {
        return this.updateTagsWithServiceResponseAsync(resourceGroupName, loadBalancerName, tags).map((Func1)new Func1<ServiceResponse<LoadBalancerInner>, LoadBalancerInner>(){

            public LoadBalancerInner call(ServiceResponse<LoadBalancerInner> response) {
                return (LoadBalancerInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<LoadBalancerInner>> updateTagsWithServiceResponseAsync(String resourceGroupName, String loadBalancerName, Map<String, String> tags) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (loadBalancerName == null) {
            throw new IllegalArgumentException("Parameter loadBalancerName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        Validator.validate(tags);
        String apiVersion = "2018-02-01";
        TagsObject parameters = new TagsObject();
        parameters.withTags(tags);
        Observable<Response<ResponseBody>> observable = this.service.updateTags(resourceGroupName, loadBalancerName, this.client.subscriptionId(), "2018-02-01", this.client.acceptLanguage(), parameters, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<LoadBalancerInner>(){}.getType());
    }

    public LoadBalancerInner beginUpdateTags(String resourceGroupName, String loadBalancerName) {
        return (LoadBalancerInner)((Object)((ServiceResponse)this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, loadBalancerName).toBlocking().single()).body());
    }

    public ServiceFuture<LoadBalancerInner> beginUpdateTagsAsync(String resourceGroupName, String loadBalancerName, ServiceCallback<LoadBalancerInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, loadBalancerName), serviceCallback);
    }

    public Observable<LoadBalancerInner> beginUpdateTagsAsync(String resourceGroupName, String loadBalancerName) {
        return this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, loadBalancerName).map((Func1)new Func1<ServiceResponse<LoadBalancerInner>, LoadBalancerInner>(){

            public LoadBalancerInner call(ServiceResponse<LoadBalancerInner> response) {
                return (LoadBalancerInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<LoadBalancerInner>> beginUpdateTagsWithServiceResponseAsync(String resourceGroupName, String loadBalancerName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (loadBalancerName == null) {
            throw new IllegalArgumentException("Parameter loadBalancerName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-02-01";
        Object tags = null;
        TagsObject parameters = new TagsObject();
        parameters.withTags(null);
        return this.service.beginUpdateTags(resourceGroupName, loadBalancerName, this.client.subscriptionId(), "2018-02-01", this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<LoadBalancerInner>>>(){

            public Observable<ServiceResponse<LoadBalancerInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = LoadBalancersInner.this.beginUpdateTagsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public LoadBalancerInner beginUpdateTags(String resourceGroupName, String loadBalancerName, Map<String, String> tags) {
        return (LoadBalancerInner)((Object)((ServiceResponse)this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, loadBalancerName, tags).toBlocking().single()).body());
    }

    public ServiceFuture<LoadBalancerInner> beginUpdateTagsAsync(String resourceGroupName, String loadBalancerName, Map<String, String> tags, ServiceCallback<LoadBalancerInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, loadBalancerName, tags), serviceCallback);
    }

    public Observable<LoadBalancerInner> beginUpdateTagsAsync(String resourceGroupName, String loadBalancerName, Map<String, String> tags) {
        return this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, loadBalancerName, tags).map((Func1)new Func1<ServiceResponse<LoadBalancerInner>, LoadBalancerInner>(){

            public LoadBalancerInner call(ServiceResponse<LoadBalancerInner> response) {
                return (LoadBalancerInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<LoadBalancerInner>> beginUpdateTagsWithServiceResponseAsync(String resourceGroupName, String loadBalancerName, Map<String, String> tags) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (loadBalancerName == null) {
            throw new IllegalArgumentException("Parameter loadBalancerName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        Validator.validate(tags);
        String apiVersion = "2018-02-01";
        TagsObject parameters = new TagsObject();
        parameters.withTags(tags);
        return this.service.beginUpdateTags(resourceGroupName, loadBalancerName, this.client.subscriptionId(), "2018-02-01", this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<LoadBalancerInner>>>(){

            public Observable<ServiceResponse<LoadBalancerInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = LoadBalancersInner.this.beginUpdateTagsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<LoadBalancerInner> beginUpdateTagsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<LoadBalancerInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<LoadBalancerInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<LoadBalancerInner>((Page)response.body()){

            public Page<LoadBalancerInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)LoadBalancersInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<LoadBalancerInner>> listAsync(ListOperationCallback<LoadBalancerInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<LoadBalancerInner>>>>(){

            public Observable<ServiceResponse<Page<LoadBalancerInner>>> call(String nextPageLink) {
                return LoadBalancersInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<LoadBalancerInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<LoadBalancerInner>>, Page<LoadBalancerInner>>(){

            public Page<LoadBalancerInner> call(ServiceResponse<Page<LoadBalancerInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<LoadBalancerInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<LoadBalancerInner>>, Observable<ServiceResponse<Page<LoadBalancerInner>>>>(){

            public Observable<ServiceResponse<Page<LoadBalancerInner>>> call(ServiceResponse<Page<LoadBalancerInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(LoadBalancersInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<LoadBalancerInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-02-01";
        return this.service.list(this.client.subscriptionId(), "2018-02-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<LoadBalancerInner>>>>(){

            public Observable<ServiceResponse<Page<LoadBalancerInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = LoadBalancersInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<LoadBalancerInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<LoadBalancerInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<LoadBalancerInner> listByResourceGroup(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<LoadBalancerInner>((Page)response.body()){

            public Page<LoadBalancerInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)LoadBalancersInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<LoadBalancerInner>> listByResourceGroupAsync(String resourceGroupName, ListOperationCallback<LoadBalancerInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<LoadBalancerInner>>>>(){

            public Observable<ServiceResponse<Page<LoadBalancerInner>>> call(String nextPageLink) {
                return LoadBalancersInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<LoadBalancerInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<LoadBalancerInner>>, Page<LoadBalancerInner>>(){

            public Page<LoadBalancerInner> call(ServiceResponse<Page<LoadBalancerInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<LoadBalancerInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<LoadBalancerInner>>, Observable<ServiceResponse<Page<LoadBalancerInner>>>>(){

            public Observable<ServiceResponse<Page<LoadBalancerInner>>> call(ServiceResponse<Page<LoadBalancerInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(LoadBalancersInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<LoadBalancerInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-02-01";
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), "2018-02-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<LoadBalancerInner>>>>(){

            public Observable<ServiceResponse<Page<LoadBalancerInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = LoadBalancersInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<LoadBalancerInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<LoadBalancerInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<LoadBalancerInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<LoadBalancerInner>((Page)response.body()){

            public Page<LoadBalancerInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)LoadBalancersInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<LoadBalancerInner>> listNextAsync(String nextPageLink, ServiceFuture<List<LoadBalancerInner>> serviceFuture, ListOperationCallback<LoadBalancerInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<LoadBalancerInner>>>>(){

            public Observable<ServiceResponse<Page<LoadBalancerInner>>> call(String nextPageLink) {
                return LoadBalancersInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<LoadBalancerInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<LoadBalancerInner>>, Page<LoadBalancerInner>>(){

            public Page<LoadBalancerInner> call(ServiceResponse<Page<LoadBalancerInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<LoadBalancerInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<LoadBalancerInner>>, Observable<ServiceResponse<Page<LoadBalancerInner>>>>(){

            public Observable<ServiceResponse<Page<LoadBalancerInner>>> call(ServiceResponse<Page<LoadBalancerInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(LoadBalancersInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<LoadBalancerInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<LoadBalancerInner>>>>(){

            public Observable<ServiceResponse<Page<LoadBalancerInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = LoadBalancersInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<LoadBalancerInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<LoadBalancerInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<LoadBalancerInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<LoadBalancerInner>((Page)response.body()){

            public Page<LoadBalancerInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)LoadBalancersInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<LoadBalancerInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<LoadBalancerInner>> serviceFuture, ListOperationCallback<LoadBalancerInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<LoadBalancerInner>>>>(){

            public Observable<ServiceResponse<Page<LoadBalancerInner>>> call(String nextPageLink) {
                return LoadBalancersInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<LoadBalancerInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<LoadBalancerInner>>, Page<LoadBalancerInner>>(){

            public Page<LoadBalancerInner> call(ServiceResponse<Page<LoadBalancerInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<LoadBalancerInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<LoadBalancerInner>>, Observable<ServiceResponse<Page<LoadBalancerInner>>>>(){

            public Observable<ServiceResponse<Page<LoadBalancerInner>>> call(ServiceResponse<Page<LoadBalancerInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(LoadBalancersInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<LoadBalancerInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<LoadBalancerInner>>>>(){

            public Observable<ServiceResponse<Page<LoadBalancerInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = LoadBalancersInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<LoadBalancerInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<LoadBalancerInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface LoadBalancersService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.LoadBalancers delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="loadBalancerName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.LoadBalancers beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="loadBalancerName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.LoadBalancers getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="loadBalancerName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Query(value="$expand") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.LoadBalancers createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="loadBalancerName") String var2, @Path(value="subscriptionId") String var3, @Body LoadBalancerInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.LoadBalancers beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="loadBalancerName") String var2, @Path(value="subscriptionId") String var3, @Body LoadBalancerInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.LoadBalancers updateTags"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}")
        public Observable<Response<ResponseBody>> updateTags(@Path(value="resourceGroupName") String var1, @Path(value="loadBalancerName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body TagsObject var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.LoadBalancers beginUpdateTags"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}")
        public Observable<Response<ResponseBody>> beginUpdateTags(@Path(value="resourceGroupName") String var1, @Path(value="loadBalancerName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body TagsObject var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.LoadBalancers list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Network/loadBalancers")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.LoadBalancers listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.LoadBalancers listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.LoadBalancers listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

