/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.Resource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.network.IPAllocationMethod;
import com.microsoft.azure.management.network.LoadBalancer;
import com.microsoft.azure.management.network.Network;
import com.microsoft.azure.management.network.NetworkInterface;
import com.microsoft.azure.management.network.NetworkSecurityGroup;
import com.microsoft.azure.management.network.NicIPConfiguration;
import com.microsoft.azure.management.network.PublicIPAddress;
import com.microsoft.azure.management.network.implementation.NetworkInterfaceIPConfigurationInner;
import com.microsoft.azure.management.network.implementation.NetworkInterfaceInner;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.network.implementation.NetworkSecurityGroupInner;
import com.microsoft.azure.management.network.implementation.NicIPConfigurationImpl;
import com.microsoft.azure.management.resources.ResourceGroup;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupableParentResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.utils.ResourceNamer;
import com.microsoft.azure.management.resources.fluentcore.utils.SdkContext;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class NetworkInterfaceImpl
extends GroupableParentResourceImpl<NetworkInterface, NetworkInterfaceInner, NetworkInterfaceImpl, NetworkManager>
implements NetworkInterface,
NetworkInterface.Definition,
NetworkInterface.Update {
    private final String nicName;
    protected final ResourceNamer namer;
    private Map<String, NicIPConfiguration> nicIPConfigurations;
    private String creatableNetworkSecurityGroupKey;
    private NetworkSecurityGroup existingNetworkSecurityGroupToAssociate;
    private NetworkSecurityGroup networkSecurityGroup;

    NetworkInterfaceImpl(String name, NetworkInterfaceInner innerModel, NetworkManager networkManager) {
        super(name, (Resource)innerModel, (ManagerBase)networkManager);
        this.nicName = name;
        this.namer = SdkContext.getResourceNamerFactory().createResourceNamer(this.nicName);
        this.initializeChildrenFromInner();
    }

    public Observable<NetworkInterface> refreshAsync() {
        return super.refreshAsync().map((Func1)new Func1<NetworkInterface, NetworkInterface>(){

            public NetworkInterface call(NetworkInterface networkInterface) {
                NetworkInterfaceImpl impl = (NetworkInterfaceImpl)networkInterface;
                impl.clearCachedRelatedResources();
                impl.initializeChildrenFromInner();
                return impl;
            }
        });
    }

    protected Observable<NetworkInterfaceInner> getInnerAsync() {
        return ((NetworkManagementClientImpl)((Object)((NetworkManager)this.manager()).inner())).networkInterfaces().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public NetworkInterfaceImpl withAcceleratedNetworking() {
        ((NetworkInterfaceInner)((Object)this.inner())).withEnableAcceleratedNetworking(true);
        return this;
    }

    @Override
    public NetworkInterfaceImpl withoutAcceleratedNetworking() {
        ((NetworkInterfaceInner)((Object)this.inner())).withEnableAcceleratedNetworking(false);
        return this;
    }

    @Override
    public NetworkInterfaceImpl withNewPrimaryNetwork(Creatable<Network> creatable) {
        this.primaryIPConfiguration().withNewNetwork((Creatable)creatable);
        return this;
    }

    @Override
    public NetworkInterfaceImpl withNewPrimaryNetwork(String name, String addressSpaceCidr) {
        this.primaryIPConfiguration().withNewNetwork(name, addressSpaceCidr);
        return this;
    }

    @Override
    public NetworkInterfaceImpl withNewPrimaryNetwork(String addressSpaceCidr) {
        this.primaryIPConfiguration().withNewNetwork(addressSpaceCidr);
        return this;
    }

    @Override
    public NetworkInterfaceImpl withExistingPrimaryNetwork(Network network) {
        this.primaryIPConfiguration().withExistingNetwork(network);
        return this;
    }

    @Override
    public NetworkInterfaceImpl withNewPrimaryPublicIPAddress(Creatable<PublicIPAddress> creatable) {
        this.primaryIPConfiguration().withNewPublicIPAddress((Creatable)creatable);
        return this;
    }

    @Override
    public NetworkInterfaceImpl withNewPrimaryPublicIPAddress() {
        this.primaryIPConfiguration().withNewPublicIPAddress();
        return this;
    }

    @Override
    public NetworkInterfaceImpl withNewPrimaryPublicIPAddress(String leafDnsLabel) {
        this.primaryIPConfiguration().withNewPublicIPAddress(leafDnsLabel);
        return this;
    }

    @Override
    public NetworkInterfaceImpl withExistingLoadBalancerBackend(LoadBalancer loadBalancer, String backendName) {
        this.primaryIPConfiguration().withExistingLoadBalancerBackend(loadBalancer, backendName);
        return this;
    }

    @Override
    public NetworkInterfaceImpl withExistingLoadBalancerInboundNatRule(LoadBalancer loadBalancer, String inboundNatRuleName) {
        this.primaryIPConfiguration().withExistingLoadBalancerInboundNatRule(loadBalancer, inboundNatRuleName);
        return this;
    }

    @Override
    public NetworkInterface.Update withoutLoadBalancerBackends() {
        for (NicIPConfiguration ipConfig : this.ipConfigurations().values()) {
            this.updateIPConfiguration(ipConfig.name()).withoutLoadBalancerBackends();
        }
        return this;
    }

    @Override
    public NetworkInterface.Update withoutLoadBalancerInboundNatRules() {
        for (NicIPConfiguration ipConfig : this.ipConfigurations().values()) {
            this.updateIPConfiguration(ipConfig.name()).withoutLoadBalancerInboundNatRules();
        }
        return this;
    }

    @Override
    public NetworkInterfaceImpl withoutPrimaryPublicIPAddress() {
        this.primaryIPConfiguration().withoutPublicIPAddress();
        return this;
    }

    @Override
    public NetworkInterfaceImpl withExistingPrimaryPublicIPAddress(PublicIPAddress publicIPAddress) {
        this.primaryIPConfiguration().withExistingPublicIPAddress(publicIPAddress);
        return this;
    }

    @Override
    public NetworkInterfaceImpl withPrimaryPrivateIPAddressDynamic() {
        this.primaryIPConfiguration().withPrivateIPAddressDynamic();
        return this;
    }

    @Override
    public NetworkInterfaceImpl withPrimaryPrivateIPAddressStatic(String staticPrivateIPAddress) {
        this.primaryIPConfiguration().withPrivateIPAddressStatic(staticPrivateIPAddress);
        return this;
    }

    @Override
    public NetworkInterfaceImpl withNewNetworkSecurityGroup(Creatable<NetworkSecurityGroup> creatable) {
        if (this.creatableNetworkSecurityGroupKey == null) {
            this.creatableNetworkSecurityGroupKey = this.addDependency(creatable);
        }
        return this;
    }

    @Override
    public NetworkInterfaceImpl withExistingNetworkSecurityGroup(NetworkSecurityGroup networkSecurityGroup) {
        this.existingNetworkSecurityGroupToAssociate = networkSecurityGroup;
        return this;
    }

    @Override
    public NetworkInterfaceImpl withoutNetworkSecurityGroup() {
        ((NetworkInterfaceInner)((Object)this.inner())).withNetworkSecurityGroup(null);
        return this;
    }

    public NicIPConfigurationImpl defineSecondaryIPConfiguration(String name) {
        return this.prepareNewNicIPConfiguration(name);
    }

    @Override
    public NicIPConfigurationImpl updateIPConfiguration(String name) {
        return (NicIPConfigurationImpl)this.nicIPConfigurations.get(name);
    }

    @Override
    public NetworkInterfaceImpl withIPForwarding() {
        ((NetworkInterfaceInner)((Object)this.inner())).withEnableIPForwarding(true);
        return this;
    }

    @Override
    public NetworkInterfaceImpl withoutIPConfiguration(String name) {
        this.nicIPConfigurations.remove(name);
        return this;
    }

    @Override
    public NetworkInterfaceImpl withoutIPForwarding() {
        ((NetworkInterfaceInner)((Object)this.inner())).withEnableIPForwarding(false);
        return this;
    }

    @Override
    public NetworkInterfaceImpl withDnsServer(String ipAddress) {
        this.dnsServerIPs().add(ipAddress);
        return this;
    }

    @Override
    public NetworkInterfaceImpl withoutDnsServer(String ipAddress) {
        this.dnsServerIPs().remove(ipAddress);
        return this;
    }

    @Override
    public NetworkInterfaceImpl withAzureDnsServer() {
        this.dnsServerIPs().clear();
        return this;
    }

    @Override
    public NetworkInterfaceImpl withSubnet(String name) {
        this.primaryIPConfiguration().withSubnet(name);
        return this;
    }

    @Override
    public NetworkInterfaceImpl withInternalDnsNameLabel(String dnsNameLabel) {
        ((NetworkInterfaceInner)((Object)this.inner())).dnsSettings().withInternalDnsNameLabel(dnsNameLabel);
        return this;
    }

    @Override
    public boolean isAcceleratedNetworkingEnabled() {
        return Utils.toPrimitiveBoolean((Boolean)((NetworkInterfaceInner)((Object)this.inner())).enableAcceleratedNetworking());
    }

    @Override
    public String virtualMachineId() {
        if (((NetworkInterfaceInner)((Object)this.inner())).virtualMachine() != null) {
            return ((NetworkInterfaceInner)((Object)this.inner())).virtualMachine().id();
        }
        return null;
    }

    @Override
    public boolean isIPForwardingEnabled() {
        return Utils.toPrimitiveBoolean((Boolean)((NetworkInterfaceInner)((Object)this.inner())).enableIPForwarding());
    }

    @Override
    public String macAddress() {
        return ((NetworkInterfaceInner)((Object)this.inner())).macAddress();
    }

    @Override
    public String internalDnsNameLabel() {
        return ((NetworkInterfaceInner)((Object)this.inner())).dnsSettings() != null ? ((NetworkInterfaceInner)((Object)this.inner())).dnsSettings().internalDnsNameLabel() : null;
    }

    @Override
    public String internalDomainNameSuffix() {
        return ((NetworkInterfaceInner)((Object)this.inner())).dnsSettings() != null ? ((NetworkInterfaceInner)((Object)this.inner())).dnsSettings().internalDomainNameSuffix() : null;
    }

    @Override
    public List<String> appliedDnsServers() {
        ArrayList dnsServers = new ArrayList();
        if (((NetworkInterfaceInner)((Object)this.inner())).dnsSettings() == null) {
            return Collections.unmodifiableList(dnsServers);
        }
        if (((NetworkInterfaceInner)((Object)this.inner())).dnsSettings().appliedDnsServers() == null) {
            return Collections.unmodifiableList(dnsServers);
        }
        return Collections.unmodifiableList(((NetworkInterfaceInner)((Object)this.inner())).dnsSettings().appliedDnsServers());
    }

    @Override
    public String internalFqdn() {
        return ((NetworkInterfaceInner)((Object)this.inner())).dnsSettings() != null ? ((NetworkInterfaceInner)((Object)this.inner())).dnsSettings().internalFqdn() : null;
    }

    @Override
    public List<String> dnsServers() {
        return this.dnsServerIPs();
    }

    @Override
    public String primaryPrivateIP() {
        return this.primaryIPConfiguration().privateIPAddress();
    }

    @Override
    public IPAllocationMethod primaryPrivateIPAllocationMethod() {
        return this.primaryIPConfiguration().privateIPAllocationMethod();
    }

    @Override
    public Map<String, NicIPConfiguration> ipConfigurations() {
        return Collections.unmodifiableMap(this.nicIPConfigurations);
    }

    @Override
    public String networkSecurityGroupId() {
        return ((NetworkInterfaceInner)((Object)this.inner())).networkSecurityGroup() != null ? ((NetworkInterfaceInner)((Object)this.inner())).networkSecurityGroup().id() : null;
    }

    @Override
    public NetworkSecurityGroup getNetworkSecurityGroup() {
        if (this.networkSecurityGroup == null && this.networkSecurityGroupId() != null) {
            String id = this.networkSecurityGroupId();
            this.networkSecurityGroup = (NetworkSecurityGroup)((NetworkManager)this.myManager).networkSecurityGroups().getByResourceGroup(ResourceUtils.groupFromResourceId((String)id), ResourceUtils.nameFromResourceId((String)id));
        }
        return this.networkSecurityGroup;
    }

    @Override
    public NicIPConfigurationImpl primaryIPConfiguration() {
        NicIPConfigurationImpl primaryIPConfig = null;
        if (this.nicIPConfigurations.size() == 0) {
            primaryIPConfig = this.prepareNewNicIPConfiguration("primary");
            ((NetworkInterfaceIPConfigurationInner)((Object)primaryIPConfig.inner())).withPrimary(true);
            this.withIPConfiguration(primaryIPConfig);
        } else if (this.nicIPConfigurations.size() == 1) {
            primaryIPConfig = (NicIPConfigurationImpl)this.nicIPConfigurations.values().iterator().next();
        } else {
            for (NicIPConfiguration ipConfig : this.nicIPConfigurations.values()) {
                if (!ipConfig.isPrimary()) continue;
                primaryIPConfig = (NicIPConfigurationImpl)ipConfig;
                break;
            }
        }
        return primaryIPConfig;
    }

    private List<String> dnsServerIPs() {
        ArrayList<String> dnsServers = new ArrayList<String>();
        if (((NetworkInterfaceInner)((Object)this.inner())).dnsSettings() == null) {
            return dnsServers;
        }
        if (((NetworkInterfaceInner)((Object)this.inner())).dnsSettings().dnsServers() == null) {
            return dnsServers;
        }
        return ((NetworkInterfaceInner)((Object)this.inner())).dnsSettings().dnsServers();
    }

    protected void initializeChildrenFromInner() {
        this.nicIPConfigurations = new TreeMap<String, NicIPConfiguration>();
        List<NetworkInterfaceIPConfigurationInner> inners = ((NetworkInterfaceInner)((Object)this.inner())).ipConfigurations();
        if (inners != null) {
            for (NetworkInterfaceIPConfigurationInner inner : inners) {
                NicIPConfigurationImpl nicIPConfiguration = new NicIPConfigurationImpl(inner, this, (NetworkManager)this.myManager, false);
                this.nicIPConfigurations.put(nicIPConfiguration.name(), nicIPConfiguration);
            }
        }
    }

    private NicIPConfigurationImpl prepareNewNicIPConfiguration(String name) {
        NicIPConfigurationImpl nicIPConfiguration = NicIPConfigurationImpl.prepareNicIPConfiguration(name, this, (NetworkManager)this.myManager);
        return nicIPConfiguration;
    }

    private void clearCachedRelatedResources() {
        this.networkSecurityGroup = null;
    }

    NetworkInterfaceImpl withIPConfiguration(NicIPConfigurationImpl nicIPConfiguration) {
        this.nicIPConfigurations.put(nicIPConfiguration.name(), nicIPConfiguration);
        return this;
    }

    void addToCreatableDependencies(Creatable<? extends com.microsoft.azure.management.resources.fluentcore.arm.models.Resource> creatableResource) {
        this.addDependency(creatableResource);
    }

    com.microsoft.azure.management.resources.fluentcore.arm.models.Resource createdDependencyResource(String key) {
        return (com.microsoft.azure.management.resources.fluentcore.arm.models.Resource)this.taskResult(key);
    }

    Creatable<ResourceGroup> newGroup() {
        return this.creatableGroup;
    }

    protected Observable<NetworkInterfaceInner> createInner() {
        return ((NetworkManagementClientImpl)((Object)((NetworkManager)this.manager()).inner())).networkInterfaces().createOrUpdateAsync(this.resourceGroupName(), this.name(), (NetworkInterfaceInner)((Object)this.inner()));
    }

    protected void afterCreating() {
        this.clearCachedRelatedResources();
    }

    protected void beforeCreating() {
        NetworkSecurityGroup networkSecurityGroup = null;
        if (this.creatableNetworkSecurityGroupKey != null) {
            networkSecurityGroup = (NetworkSecurityGroup)this.taskResult(this.creatableNetworkSecurityGroupKey);
        } else if (this.existingNetworkSecurityGroupToAssociate != null) {
            networkSecurityGroup = this.existingNetworkSecurityGroupToAssociate;
        }
        if (networkSecurityGroup != null) {
            ((NetworkInterfaceInner)((Object)this.inner())).withNetworkSecurityGroup(new NetworkSecurityGroupInner().withId(networkSecurityGroup.id()));
        }
        NicIPConfigurationImpl.ensureConfigurations(this.nicIPConfigurations.values());
        ((NetworkInterfaceInner)((Object)this.inner())).withIpConfigurations(this.innersFromWrappers(this.nicIPConfigurations.values()));
    }
}

