/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.SubResource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.network.Network;
import com.microsoft.azure.management.network.NetworkPeering;
import com.microsoft.azure.management.network.NetworkPeeringGatewayUse;
import com.microsoft.azure.management.network.VirtualNetworkPeeringState;
import com.microsoft.azure.management.network.implementation.NetworkImpl;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.network.implementation.VirtualNetworkPeeringInner;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.models.IndependentChild;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.IndependentChildImpl;
import com.microsoft.azure.management.resources.fluentcore.model.Indexable;
import com.microsoft.azure.management.resources.fluentcore.utils.SdkContext;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import rx.Observable;
import rx.functions.Action1;
import rx.functions.Func1;

@LangDefinition
class NetworkPeeringImpl
extends IndependentChildImpl<NetworkPeering, Network, VirtualNetworkPeeringInner, NetworkPeeringImpl, NetworkManager>
implements NetworkPeering,
NetworkPeering.Definition,
NetworkPeering.Update,
IndependentChild.DefinitionStages.WithParentResource<NetworkPeering, Network> {
    private NetworkImpl parent;
    private Network remoteNetwork;
    private Boolean remoteAccess;
    private Boolean remoteForwarding;
    private Boolean startGatewayUseByRemoteNetwork;
    private Boolean allowGatewayUseOnRemoteNetwork;

    NetworkPeeringImpl(VirtualNetworkPeeringInner inner, NetworkImpl parent) {
        super(inner.name(), (Object)inner, (Object)parent.manager());
        this.parent = parent;
        this.remoteAccess = null;
        this.remoteForwarding = null;
    }

    @Override
    public boolean isSameSubscription() {
        if (this.remoteNetworkId() == null) {
            return false;
        }
        String localSubscriptionId = ResourceUtils.subscriptionFromResourceId((String)this.id());
        String remoteSubscriptionId = ResourceUtils.subscriptionFromResourceId((String)this.remoteNetworkId());
        return localSubscriptionId.equalsIgnoreCase(remoteSubscriptionId);
    }

    @Override
    public VirtualNetworkPeeringState state() {
        return ((VirtualNetworkPeeringInner)((Object)this.inner())).peeringState();
    }

    public String name() {
        return ((VirtualNetworkPeeringInner)((Object)this.inner())).name();
    }

    public String id() {
        return ((VirtualNetworkPeeringInner)((Object)this.inner())).id();
    }

    @Override
    public String networkId() {
        return this.parent.id();
    }

    @Override
    public String remoteNetworkId() {
        return ((VirtualNetworkPeeringInner)((Object)this.inner())).remoteVirtualNetwork() != null ? ((VirtualNetworkPeeringInner)((Object)this.inner())).remoteVirtualNetwork().id() : null;
    }

    @Override
    public boolean isTrafficForwardingFromRemoteNetworkAllowed() {
        return Utils.toPrimitiveBoolean((Boolean)((VirtualNetworkPeeringInner)((Object)this.inner())).allowForwardedTraffic());
    }

    private boolean isAccessFromRemoteNetworkAllowed() {
        return Utils.toPrimitiveBoolean((Boolean)((VirtualNetworkPeeringInner)((Object)this.inner())).allowVirtualNetworkAccess());
    }

    private NetworkPeeringImpl withoutAccessFromRemoteNetwork() {
        ((VirtualNetworkPeeringInner)((Object)this.inner())).withAllowVirtualNetworkAccess(false);
        return this;
    }

    private NetworkPeeringImpl withAccessFromRemoteNetwork() {
        ((VirtualNetworkPeeringInner)((Object)this.inner())).withAllowVirtualNetworkAccess(true);
        return this;
    }

    @Override
    public NetworkPeeringImpl withAccessBetweenBothNetworks() {
        return this.withAccessFromRemoteNetwork().withAccessToRemoteNetwork();
    }

    @Override
    public NetworkPeeringImpl withoutAccessFromEitherNetwork() {
        return this.withoutAccessFromRemoteNetwork().withoutAccessToRemoteNetwork();
    }

    @Override
    public NetworkPeeringImpl withRemoteNetwork(String resourceId) {
        SubResource networkRef = new SubResource().withId(resourceId);
        ((VirtualNetworkPeeringInner)((Object)this.inner())).withRemoteVirtualNetwork(networkRef);
        return this;
    }

    @Override
    public NetworkPeeringImpl withRemoteNetwork(Network network) {
        if (network != null) {
            this.remoteNetwork = network;
            return this.withRemoteNetwork(network.id());
        }
        return this;
    }

    @Override
    public NetworkPeeringImpl withTrafficForwardingFromRemoteNetwork() {
        ((VirtualNetworkPeeringInner)((Object)this.inner())).withAllowForwardedTraffic(true);
        return this;
    }

    @Override
    public NetworkPeeringImpl withoutTrafficForwardingFromRemoteNetwork() {
        ((VirtualNetworkPeeringInner)((Object)this.inner())).withAllowForwardedTraffic(false);
        return this;
    }

    @Override
    public NetworkPeeringImpl withoutTrafficForwardingFromEitherNetwork() {
        return this.withoutTrafficForwardingFromRemoteNetwork().withoutTrafficForwardingToRemoteNetwork();
    }

    @Override
    public NetworkPeeringImpl withTrafficForwardingToRemoteNetwork() {
        this.remoteForwarding = true;
        return this;
    }

    @Override
    public NetworkPeeringImpl withoutTrafficForwardingToRemoteNetwork() {
        this.remoteForwarding = false;
        return this;
    }

    @Override
    public NetworkPeeringImpl withTrafficForwardingBetweenBothNetworks() {
        return this.withTrafficForwardingFromRemoteNetwork().withTrafficForwardingToRemoteNetwork();
    }

    private NetworkPeeringImpl withoutAccessToRemoteNetwork() {
        this.remoteAccess = false;
        return this;
    }

    private NetworkPeeringImpl withAccessToRemoteNetwork() {
        this.remoteAccess = true;
        return this;
    }

    @Override
    public NetworkPeeringImpl withGatewayUseByRemoteNetworkAllowed() {
        ((VirtualNetworkPeeringInner)((Object)this.inner())).withAllowGatewayTransit(true).withUseRemoteGateways(false);
        this.startGatewayUseByRemoteNetwork = null;
        this.allowGatewayUseOnRemoteNetwork = false;
        return this;
    }

    @Override
    public NetworkPeeringImpl withGatewayUseByRemoteNetworkStarted() {
        this.startGatewayUseByRemoteNetwork = true;
        this.allowGatewayUseOnRemoteNetwork = false;
        return this.withGatewayUseByRemoteNetworkAllowed();
    }

    @Override
    public NetworkPeeringImpl withGatewayUseOnRemoteNetworkStarted() {
        ((VirtualNetworkPeeringInner)((Object)this.inner())).withAllowGatewayTransit(false).withUseRemoteGateways(true);
        this.startGatewayUseByRemoteNetwork = false;
        this.allowGatewayUseOnRemoteNetwork = true;
        return this;
    }

    @Override
    public NetworkPeeringImpl withoutAnyGatewayUse() {
        ((VirtualNetworkPeeringInner)((Object)this.inner())).withAllowGatewayTransit(false);
        return this.withoutGatewayUseOnRemoteNetwork().withoutGatewayUseByRemoteNetwork();
    }

    @Override
    public NetworkPeeringImpl withoutGatewayUseByRemoteNetwork() {
        this.startGatewayUseByRemoteNetwork = false;
        this.allowGatewayUseOnRemoteNetwork = false;
        return this;
    }

    @Override
    public NetworkPeeringImpl withoutGatewayUseOnRemoteNetwork() {
        ((VirtualNetworkPeeringInner)((Object)this.inner())).withUseRemoteGateways(false);
        return this;
    }

    @Override
    public boolean checkAccessBetweenNetworks() {
        if (!Utils.toPrimitiveBoolean((Boolean)((VirtualNetworkPeeringInner)((Object)this.inner())).allowVirtualNetworkAccess())) {
            return false;
        }
        NetworkPeering remotePeering = this.getRemotePeering();
        if (remotePeering == null) {
            return false;
        }
        return Utils.toPrimitiveBoolean((Boolean)((VirtualNetworkPeeringInner)((Object)remotePeering.inner())).allowVirtualNetworkAccess());
    }

    protected Observable<NetworkPeering> createChildResourceAsync() {
        final NetworkPeeringImpl localPeering = this;
        String networkName = ResourceUtils.nameFromResourceId((String)this.networkId());
        return ((NetworkManagementClientImpl)((Object)((NetworkManager)((Object)this.manager())).inner())).virtualNetworkPeerings().createOrUpdateAsync(this.parent.resourceGroupName(), networkName, this.name(), (VirtualNetworkPeeringInner)((Object)this.inner())).doOnNext((Action1)new Action1<VirtualNetworkPeeringInner>(){

            public void call(VirtualNetworkPeeringInner inner) {
                if (inner != null) {
                    NetworkPeeringImpl.this.setInner((Object)inner);
                }
            }
        }).flatMap((Func1)new Func1<VirtualNetworkPeeringInner, Observable<Network>>(){

            public Observable<Network> call(VirtualNetworkPeeringInner inner) {
                SubResource networkRef = inner.remoteVirtualNetwork();
                if (localPeering.isSameSubscription()) {
                    return ((NetworkManager)((Object)localPeering.manager())).networks().getByIdAsync(networkRef.id());
                }
                return Observable.just(null);
            }
        }).flatMap((Func1)new Func1<Network, Observable<Indexable>>(){

            public Observable<Indexable> call(final Network remoteNetwork) {
                if (remoteNetwork == null) {
                    return Observable.just(null);
                }
                return remoteNetwork.peerings().listAsync().firstOrDefault(null, (Func1)new Func1<NetworkPeering, Boolean>(){

                    public Boolean call(NetworkPeering remotePeering) {
                        return remotePeering != null && remotePeering.remoteNetworkId() != null && remotePeering.remoteNetworkId().equalsIgnoreCase(localPeering.parent.id());
                    }
                }).flatMap((Func1)new Func1<NetworkPeering, Observable<Indexable>>(){

                    public Observable<Indexable> call(NetworkPeering remotePeering) {
                        if (remotePeering != null) {
                            NetworkPeering.Update remotePeeringUpdate = (NetworkPeering.Update)remotePeering.update();
                            boolean isUpdateNeeded = false;
                            if (localPeering.remoteForwarding != null) {
                                if (localPeering.remoteForwarding.booleanValue() && !remotePeering.isTrafficForwardingFromRemoteNetworkAllowed()) {
                                    isUpdateNeeded = true;
                                    remotePeeringUpdate = remotePeeringUpdate.withTrafficForwardingFromRemoteNetwork();
                                } else if (!localPeering.remoteForwarding.booleanValue() && remotePeering.isTrafficForwardingFromRemoteNetworkAllowed()) {
                                    isUpdateNeeded = true;
                                    remotePeeringUpdate = remotePeeringUpdate.withoutTrafficForwardingFromRemoteNetwork();
                                }
                            }
                            if (localPeering.remoteAccess != null) {
                                if (localPeering.remoteAccess.booleanValue() && !((NetworkPeeringImpl)remotePeering).isAccessFromRemoteNetworkAllowed()) {
                                    isUpdateNeeded = true;
                                    remotePeeringUpdate = ((NetworkPeeringImpl)remotePeeringUpdate).withAccessFromRemoteNetwork();
                                } else if (!localPeering.remoteAccess.booleanValue() && ((NetworkPeeringImpl)remotePeering).isAccessFromRemoteNetworkAllowed()) {
                                    isUpdateNeeded = true;
                                    remotePeeringUpdate = ((NetworkPeeringImpl)remotePeeringUpdate).withoutAccessFromRemoteNetwork();
                                }
                            }
                            if (localPeering.allowGatewayUseOnRemoteNetwork != null) {
                                if (localPeering.allowGatewayUseOnRemoteNetwork.booleanValue() && remotePeering.gatewayUse() != NetworkPeeringGatewayUse.BY_REMOTE_NETWORK) {
                                    isUpdateNeeded = true;
                                    remotePeeringUpdate.withGatewayUseByRemoteNetworkAllowed();
                                } else if (!localPeering.allowGatewayUseOnRemoteNetwork.booleanValue() && remotePeering.gatewayUse() == NetworkPeeringGatewayUse.BY_REMOTE_NETWORK) {
                                    isUpdateNeeded = true;
                                    remotePeeringUpdate.withoutGatewayUseByRemoteNetwork();
                                }
                            }
                            if (localPeering.startGatewayUseByRemoteNetwork != null) {
                                if (localPeering.startGatewayUseByRemoteNetwork.booleanValue() && remotePeering.gatewayUse() != NetworkPeeringGatewayUse.ON_REMOTE_NETWORK) {
                                    remotePeeringUpdate.withGatewayUseOnRemoteNetworkStarted();
                                    isUpdateNeeded = true;
                                } else if (!localPeering.startGatewayUseByRemoteNetwork.booleanValue() && remotePeering.gatewayUse() == NetworkPeeringGatewayUse.ON_REMOTE_NETWORK) {
                                    remotePeeringUpdate.withoutGatewayUseOnRemoteNetwork();
                                    isUpdateNeeded = true;
                                }
                            }
                            if (isUpdateNeeded) {
                                localPeering.remoteForwarding = null;
                                localPeering.remoteAccess = null;
                                localPeering.startGatewayUseByRemoteNetwork = null;
                                localPeering.allowGatewayUseOnRemoteNetwork = null;
                                return remotePeeringUpdate.applyAsync().last().cast(Indexable.class);
                            }
                            return Observable.just((Object)localPeering);
                        }
                        String peeringName = SdkContext.randomResourceName((String)"peer", (int)15);
                        NetworkPeering.DefinitionStages.WithCreate remotePeeringDefinition = ((NetworkPeering.DefinitionStages.Blank)remoteNetwork.peerings().define(peeringName)).withRemoteNetwork(localPeering.parent.id());
                        if (localPeering.startGatewayUseByRemoteNetwork != null && localPeering.startGatewayUseByRemoteNetwork.booleanValue()) {
                            remotePeeringDefinition.withGatewayUseOnRemoteNetworkStarted();
                        }
                        if (localPeering.allowGatewayUseOnRemoteNetwork != null && localPeering.allowGatewayUseOnRemoteNetwork.booleanValue()) {
                            remotePeeringDefinition.withGatewayUseByRemoteNetworkAllowed();
                        }
                        if (localPeering.remoteAccess != null && !localPeering.remoteAccess.booleanValue()) {
                            ((NetworkPeeringImpl)remotePeeringDefinition).withoutAccessFromRemoteNetwork();
                        }
                        if (localPeering.remoteForwarding != null && localPeering.remoteForwarding.booleanValue()) {
                            remotePeeringDefinition.withTrafficForwardingFromRemoteNetwork();
                        }
                        localPeering.remoteAccess = null;
                        localPeering.remoteForwarding = null;
                        localPeering.startGatewayUseByRemoteNetwork = null;
                        localPeering.allowGatewayUseOnRemoteNetwork = null;
                        return remotePeeringDefinition.createAsync().last();
                    }
                });
            }
        }).flatMap((Func1)new Func1<Indexable, Observable<Network>>(){

            public Observable<Network> call(Indexable remotePeering) {
                return localPeering.parent != null ? localPeering.parent.refreshAsync() : Observable.just((Object)null);
            }
        }).flatMap((Func1)new Func1<Network, Observable<Network>>(){

            public Observable<Network> call(Network t) {
                if (localPeering.remoteNetwork != null && localPeering.isSameSubscription()) {
                    return localPeering.remoteNetwork.refreshAsync();
                }
                return Observable.just(null);
            }
        }).map((Func1)new Func1<Network, NetworkPeering>(){

            public NetworkPeering call(Network n) {
                return localPeering;
            }
        });
    }

    protected Observable<VirtualNetworkPeeringInner> getInnerAsync() {
        this.remoteNetwork = null;
        return ((NetworkManagementClientImpl)((Object)((NetworkManager)((Object)this.manager())).inner())).virtualNetworkPeerings().getAsync(this.resourceGroupName(), ResourceUtils.nameFromResourceId((String)this.networkId()), ((VirtualNetworkPeeringInner)((Object)this.inner())).name());
    }

    @Override
    public Network getRemoteNetwork() {
        return (Network)this.getRemoteNetworkAsync().toBlocking().last();
    }

    @Override
    public Observable<Network> getRemoteNetworkAsync() {
        final NetworkPeeringImpl self = this;
        if (self.remoteNetwork != null) {
            return Observable.just((Object)self.remoteNetwork);
        }
        if (this.isSameSubscription()) {
            return ((NetworkManager)((Object)this.manager())).networks().getByIdAsync(this.remoteNetworkId()).doOnNext((Action1)new Action1<Network>(){

                public void call(Network network) {
                    self.remoteNetwork = network;
                }
            });
        }
        self.remoteNetwork = null;
        return Observable.just(null);
    }

    @Override
    public NetworkPeering getRemotePeering() {
        Network network = this.getRemoteNetwork();
        return network != null ? network.peerings().getByRemoteNetwork(this.networkId()) : null;
    }

    @Override
    public Observable<NetworkPeering> getRemotePeeringAsync() {
        final NetworkPeeringImpl self = this;
        return this.getRemoteNetworkAsync().flatMap((Func1)new Func1<Network, Observable<NetworkPeering>>(){

            public Observable<NetworkPeering> call(Network remoteNetwork) {
                if (remoteNetwork == null) {
                    return Observable.just(null);
                }
                return remoteNetwork.peerings().getByRemoteNetworkAsync(self.networkId());
            }
        });
    }

    @Override
    public NetworkPeeringGatewayUse gatewayUse() {
        if (Utils.toPrimitiveBoolean((Boolean)((VirtualNetworkPeeringInner)((Object)this.inner())).allowGatewayTransit())) {
            return NetworkPeeringGatewayUse.BY_REMOTE_NETWORK;
        }
        if (Utils.toPrimitiveBoolean((Boolean)((VirtualNetworkPeeringInner)((Object)this.inner())).useRemoteGateways())) {
            return NetworkPeeringGatewayUse.ON_REMOTE_NETWORK;
        }
        return NetworkPeeringGatewayUse.NONE;
    }
}

