/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.network.PCFilter;
import com.microsoft.azure.management.network.PacketCapture;
import com.microsoft.azure.management.network.PacketCaptureFilter;
import com.microsoft.azure.management.network.PcProtocol;
import com.microsoft.azure.management.network.implementation.PacketCaptureImpl;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableWrapperImpl;
import java.util.List;

@LangDefinition
class PCFilterImpl
extends IndexableWrapperImpl<PacketCaptureFilter>
implements PCFilter,
PCFilter.Definition<PacketCapture.DefinitionStages.WithCreate> {
    private static final String DELIMITER = ";";
    private static final String RANGE_DELIMITER = "-";
    private PacketCaptureImpl parent;

    PCFilterImpl(PacketCaptureFilter inner, PacketCaptureImpl parent) {
        super((Object)inner);
        this.parent = parent;
    }

    @Override
    public PcProtocol protocol() {
        return ((PacketCaptureFilter)this.inner()).protocol();
    }

    @Override
    public String localIPAddress() {
        return ((PacketCaptureFilter)this.inner()).localIPAddress();
    }

    @Override
    public String remoteIPAddress() {
        return ((PacketCaptureFilter)this.inner()).remoteIPAddress();
    }

    @Override
    public String localPort() {
        return ((PacketCaptureFilter)this.inner()).localPort();
    }

    @Override
    public String remotePort() {
        return ((PacketCaptureFilter)this.inner()).remotePort();
    }

    @Override
    public PCFilterImpl withProtocol(PcProtocol protocol) {
        ((PacketCaptureFilter)this.inner()).withProtocol(protocol);
        return this;
    }

    public PCFilterImpl withLocalIPAddress(String ipAddress) {
        ((PacketCaptureFilter)this.inner()).withLocalIPAddress(ipAddress);
        return this;
    }

    @Override
    public PCFilter.Definition<PacketCapture.DefinitionStages.WithCreate> withLocalIPAddressesRange(String startIPAddress, String endIPAddress) {
        ((PacketCaptureFilter)this.inner()).withLocalIPAddress(startIPAddress + RANGE_DELIMITER + endIPAddress);
        return this;
    }

    @Override
    public PCFilter.Definition<PacketCapture.DefinitionStages.WithCreate> withLocalIPAddresses(List<String> ipAddresses) {
        StringBuilder ipAddressesString = new StringBuilder();
        for (String ipAddress : ipAddresses) {
            ipAddressesString.append(ipAddress).append(DELIMITER);
        }
        ((PacketCaptureFilter)this.inner()).withLocalIPAddress(ipAddressesString.substring(0, ipAddressesString.length() - 1));
        return this;
    }

    public PCFilterImpl withRemoteIPAddress(String ipAddress) {
        ((PacketCaptureFilter)this.inner()).withRemoteIPAddress(ipAddress);
        return this;
    }

    @Override
    public PCFilter.Definition<PacketCapture.DefinitionStages.WithCreate> withRemoteIPAddressesRange(String startIPAddress, String endIPAddress) {
        ((PacketCaptureFilter)this.inner()).withRemoteIPAddress(startIPAddress + RANGE_DELIMITER + endIPAddress);
        return this;
    }

    @Override
    public PCFilter.Definition<PacketCapture.DefinitionStages.WithCreate> withRemoteIPAddresses(List<String> ipAddresses) {
        StringBuilder ipAddressesString = new StringBuilder();
        for (String ipAddress : ipAddresses) {
            ipAddressesString.append(ipAddress).append(DELIMITER);
        }
        ((PacketCaptureFilter)this.inner()).withRemoteIPAddress(ipAddressesString.substring(0, ipAddressesString.length() - 1));
        return this;
    }

    public PacketCapture parent() {
        return this.parent;
    }

    public PacketCaptureImpl attach() {
        this.parent.attachPCFilter(this);
        return this.parent;
    }

    @Override
    public PCFilter.Definition<PacketCapture.DefinitionStages.WithCreate> withLocalPort(int port) {
        ((PacketCaptureFilter)this.inner()).withLocalPort(String.valueOf(port));
        return this;
    }

    @Override
    public PCFilter.Definition<PacketCapture.DefinitionStages.WithCreate> withLocalPortRange(int startPort, int endPort) {
        ((PacketCaptureFilter)this.inner()).withLocalPort(startPort + RANGE_DELIMITER + endPort);
        return this;
    }

    @Override
    public PCFilter.Definition<PacketCapture.DefinitionStages.WithCreate> withLocalPorts(List<Integer> ports) {
        StringBuilder portsString = new StringBuilder();
        for (int port : ports) {
            portsString.append(port).append(DELIMITER);
        }
        ((PacketCaptureFilter)this.inner()).withLocalPort(portsString.substring(0, portsString.length() - 1));
        return this;
    }

    @Override
    public PCFilter.Definition<PacketCapture.DefinitionStages.WithCreate> withRemotePort(int port) {
        ((PacketCaptureFilter)this.inner()).withRemotePort(String.valueOf(port));
        return this;
    }

    @Override
    public PCFilter.Definition<PacketCapture.DefinitionStages.WithCreate> withRemotePortRange(int startPort, int endPort) {
        ((PacketCaptureFilter)this.inner()).withRemotePort(startPort + RANGE_DELIMITER + endPort);
        return this;
    }

    @Override
    public PCFilter.Definition<PacketCapture.DefinitionStages.WithCreate> withRemotePorts(List<Integer> ports) {
        StringBuilder portsString = new StringBuilder();
        for (int port : ports) {
            portsString.append(port).append(DELIMITER);
        }
        ((PacketCaptureFilter)this.inner()).withRemotePort(portsString.substring(0, portsString.length() - 1));
        return this;
    }
}

