/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.Resource;
import com.microsoft.azure.SubResource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.network.ExpressRouteCircuit;
import com.microsoft.azure.management.network.IpsecPolicy;
import com.microsoft.azure.management.network.LocalNetworkGateway;
import com.microsoft.azure.management.network.TunnelConnectionHealth;
import com.microsoft.azure.management.network.VirtualNetworkGateway;
import com.microsoft.azure.management.network.VirtualNetworkGatewayConnection;
import com.microsoft.azure.management.network.VirtualNetworkGatewayConnectionStatus;
import com.microsoft.azure.management.network.VirtualNetworkGatewayConnectionType;
import com.microsoft.azure.management.network.implementation.LocalNetworkGatewayInner;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.network.implementation.VirtualNetworkGatewayConnectionInner;
import com.microsoft.azure.management.network.implementation.VirtualNetworkGatewayImpl;
import com.microsoft.azure.management.network.implementation.VirtualNetworkGatewayInner;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import java.util.Collection;
import java.util.Collections;
import rx.Observable;

@LangDefinition
public class VirtualNetworkGatewayConnectionImpl
extends GroupableResourceImpl<VirtualNetworkGatewayConnection, VirtualNetworkGatewayConnectionInner, VirtualNetworkGatewayConnectionImpl, NetworkManager>
implements VirtualNetworkGatewayConnection,
VirtualNetworkGatewayConnection.Definition,
VirtualNetworkGatewayConnection.Update {
    private final VirtualNetworkGateway parent;

    VirtualNetworkGatewayConnectionImpl(String name, VirtualNetworkGatewayImpl parent, VirtualNetworkGatewayConnectionInner inner) {
        super(name, (Resource)inner, parent.manager());
        this.parent = parent;
    }

    public VirtualNetworkGateway parent() {
        return this.parent;
    }

    @Override
    public String authorizationKey() {
        return ((VirtualNetworkGatewayConnectionInner)((Object)this.inner())).authorizationKey();
    }

    @Override
    public String virtualNetworkGateway1Id() {
        if (((VirtualNetworkGatewayConnectionInner)((Object)this.inner())).virtualNetworkGateway1() == null) {
            return null;
        }
        return ((VirtualNetworkGatewayConnectionInner)((Object)this.inner())).virtualNetworkGateway1().id();
    }

    @Override
    public String virtualNetworkGateway2Id() {
        if (((VirtualNetworkGatewayConnectionInner)((Object)this.inner())).virtualNetworkGateway2() == null) {
            return null;
        }
        return ((VirtualNetworkGatewayConnectionInner)((Object)this.inner())).virtualNetworkGateway2().id();
    }

    @Override
    public String localNetworkGateway2Id() {
        if (((VirtualNetworkGatewayConnectionInner)((Object)this.inner())).localNetworkGateway2() == null) {
            return null;
        }
        return ((VirtualNetworkGatewayConnectionInner)((Object)this.inner())).localNetworkGateway2().id();
    }

    @Override
    public VirtualNetworkGatewayConnectionType connectionType() {
        return ((VirtualNetworkGatewayConnectionInner)((Object)this.inner())).connectionType();
    }

    @Override
    public int routingWeight() {
        return Utils.toPrimitiveInt((Integer)((VirtualNetworkGatewayConnectionInner)((Object)this.inner())).routingWeight());
    }

    @Override
    public String sharedKey() {
        return ((VirtualNetworkGatewayConnectionInner)((Object)this.inner())).sharedKey();
    }

    @Override
    public VirtualNetworkGatewayConnectionStatus connectionStatus() {
        return ((VirtualNetworkGatewayConnectionInner)((Object)this.inner())).connectionStatus();
    }

    @Override
    public Collection<TunnelConnectionHealth> tunnelConnectionStatus() {
        return Collections.unmodifiableCollection(((VirtualNetworkGatewayConnectionInner)((Object)this.inner())).tunnelConnectionStatus());
    }

    @Override
    public long egressBytesTransferred() {
        return Utils.toPrimitiveLong((Long)((VirtualNetworkGatewayConnectionInner)((Object)this.inner())).egressBytesTransferred());
    }

    @Override
    public long ingressBytesTransferred() {
        return Utils.toPrimitiveLong((Long)((VirtualNetworkGatewayConnectionInner)((Object)this.inner())).ingressBytesTransferred());
    }

    @Override
    public String peerId() {
        return ((VirtualNetworkGatewayConnectionInner)((Object)this.inner())).peer() == null ? null : ((VirtualNetworkGatewayConnectionInner)((Object)this.inner())).peer().id();
    }

    @Override
    public boolean isBgpEnabled() {
        return Utils.toPrimitiveBoolean((Boolean)((VirtualNetworkGatewayConnectionInner)((Object)this.inner())).enableBgp());
    }

    @Override
    public boolean usePolicyBasedTrafficSelectors() {
        return Utils.toPrimitiveBoolean((Boolean)((VirtualNetworkGatewayConnectionInner)((Object)this.inner())).usePolicyBasedTrafficSelectors());
    }

    @Override
    public Collection<IpsecPolicy> ipsecPolicies() {
        return Collections.unmodifiableCollection(((VirtualNetworkGatewayConnectionInner)((Object)this.inner())).ipsecPolicies());
    }

    @Override
    public String provisioningState() {
        return ((VirtualNetworkGatewayConnectionInner)((Object)this.inner())).provisioningState();
    }

    @Override
    public VirtualNetworkGatewayConnectionImpl withSiteToSite() {
        ((VirtualNetworkGatewayConnectionInner)((Object)this.inner())).withConnectionType(VirtualNetworkGatewayConnectionType.IPSEC);
        return this;
    }

    @Override
    public VirtualNetworkGatewayConnectionImpl withVNetToVNet() {
        ((VirtualNetworkGatewayConnectionInner)((Object)this.inner())).withConnectionType(VirtualNetworkGatewayConnectionType.VNET2VNET);
        return this;
    }

    @Override
    public VirtualNetworkGatewayConnectionImpl withExpressRoute(String circuitId) {
        ((VirtualNetworkGatewayConnectionInner)((Object)this.inner())).withConnectionType(VirtualNetworkGatewayConnectionType.EXPRESS_ROUTE);
        ((VirtualNetworkGatewayConnectionInner)((Object)this.inner())).withPeer(new SubResource().withId(circuitId));
        return this;
    }

    @Override
    public VirtualNetworkGatewayConnectionImpl withExpressRoute(ExpressRouteCircuit circuit) {
        return this.withExpressRoute(circuit.id());
    }

    @Override
    public VirtualNetworkGatewayConnectionImpl withLocalNetworkGateway(LocalNetworkGateway localNetworkGateway) {
        ((VirtualNetworkGatewayConnectionInner)((Object)this.inner())).withLocalNetworkGateway2((LocalNetworkGatewayInner)((Object)localNetworkGateway.inner()));
        return this;
    }

    @Override
    public VirtualNetworkGatewayConnectionImpl withSecondVirtualNetworkGateway(VirtualNetworkGateway virtualNetworkGateway2) {
        ((VirtualNetworkGatewayConnectionInner)((Object)this.inner())).withVirtualNetworkGateway2((VirtualNetworkGatewayInner)((Object)virtualNetworkGateway2.inner()));
        return this;
    }

    @Override
    public VirtualNetworkGatewayConnectionImpl withSharedKey(String sharedKey) {
        ((VirtualNetworkGatewayConnectionInner)((Object)this.inner())).withSharedKey(sharedKey);
        return this;
    }

    @Override
    public VirtualNetworkGatewayConnectionImpl withBgp() {
        ((VirtualNetworkGatewayConnectionInner)((Object)this.inner())).withEnableBgp(true);
        return this;
    }

    @Override
    public VirtualNetworkGatewayConnectionImpl withoutBgp() {
        ((VirtualNetworkGatewayConnectionInner)((Object)this.inner())).withEnableBgp(false);
        return this;
    }

    @Override
    public VirtualNetworkGatewayConnectionImpl withAuthorization(String authorizationKey) {
        ((VirtualNetworkGatewayConnectionInner)((Object)this.inner())).withAuthorizationKey(authorizationKey);
        return this;
    }

    protected Observable<VirtualNetworkGatewayConnectionInner> getInnerAsync() {
        return ((NetworkManagementClientImpl)((Object)((NetworkManager)this.myManager).inner())).virtualNetworkGatewayConnections().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    public Observable<VirtualNetworkGatewayConnection> createResourceAsync() {
        this.beforeCreating();
        return ((NetworkManagementClientImpl)((Object)((NetworkManager)this.myManager).inner())).virtualNetworkGatewayConnections().createOrUpdateAsync(this.resourceGroupName(), this.name(), (VirtualNetworkGatewayConnectionInner)((Object)this.inner())).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    private void beforeCreating() {
        ((VirtualNetworkGatewayConnectionInner)((Object)this.inner())).withVirtualNetworkGateway1((VirtualNetworkGatewayInner)((Object)this.parent.inner()));
    }
}

