/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.redis;

import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.apigeneration.Method;
import com.microsoft.azure.management.redis.DayOfWeek;
import com.microsoft.azure.management.redis.RedisAccessKeys;
import com.microsoft.azure.management.redis.RedisCachePremium;
import com.microsoft.azure.management.redis.RedisKeyType;
import com.microsoft.azure.management.redis.ScheduleEntry;
import com.microsoft.azure.management.redis.Sku;
import com.microsoft.azure.management.redis.implementation.RedisManager;
import com.microsoft.azure.management.redis.implementation.RedisResourceInner;
import com.microsoft.azure.management.resources.fluentcore.arm.models.GroupableResource;
import com.microsoft.azure.management.resources.fluentcore.arm.models.HasId;
import com.microsoft.azure.management.resources.fluentcore.arm.models.Resource;
import com.microsoft.azure.management.resources.fluentcore.model.Appliable;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.Refreshable;
import com.microsoft.azure.management.resources.fluentcore.model.Updatable;
import java.util.List;
import java.util.Map;
import org.joda.time.Period;

@Fluent
public interface RedisCache
extends GroupableResource<RedisManager, RedisResourceInner>,
Refreshable<RedisCache>,
Updatable<Update> {
    @Method
    public RedisCachePremium asPremium();

    public boolean isPremium();

    public String provisioningState();

    public String hostName();

    public int port();

    public int sslPort();

    public String redisVersion();

    public Sku sku();

    public Map<String, String> redisConfiguration();

    public boolean nonSslPort();

    public int shardCount();

    public String subnetId();

    public String staticIP();

    @Method
    public RedisAccessKeys getKeys();

    public RedisAccessKeys keys();

    @Method
    public RedisAccessKeys refreshKeys();

    public RedisAccessKeys regenerateKey(RedisKeyType var1);

    public static interface Update
    extends Appliable<RedisCache>,
    Resource.UpdateWithTags<Update>,
    UpdateStages.WithSku,
    UpdateStages.WithNonSslPort,
    UpdateStages.WithRedisConfiguration {
        public Update withSubnet(HasId var1, String var2);

        public Update withStaticIP(String var1);

        public Update withShardCount(int var1);

        public Update withPatchSchedule(DayOfWeek var1, int var2);

        public Update withPatchSchedule(DayOfWeek var1, int var2, Period var3);

        public Update withPatchSchedule(ScheduleEntry var1);

        public Update withPatchSchedule(List<ScheduleEntry> var1);
    }

    public static interface UpdateStages {

        public static interface WithRedisConfiguration {
            public Update withRedisConfiguration(Map<String, String> var1);

            public Update withRedisConfiguration(String var1, String var2);

            public Update withoutRedisConfiguration();

            public Update withoutRedisConfiguration(String var1);
        }

        public static interface WithNonSslPort {
            public Update withNonSslPort();

            public Update withoutNonSslPort();
        }

        public static interface WithSku {
            public Update withBasicSku(int var1);

            public Update withStandardSku();

            public Update withStandardSku(int var1);

            public Update withPremiumSku();

            public Update withPremiumSku(int var1);
        }
    }

    public static interface DefinitionStages {

        public static interface WithPremiumSkuCreate
        extends WithCreate {
            public WithPremiumSkuCreate withShardCount(int var1);

            public WithPremiumSkuCreate withPatchSchedule(DayOfWeek var1, int var2);

            public WithPremiumSkuCreate withPatchSchedule(DayOfWeek var1, int var2, Period var3);

            public WithPremiumSkuCreate withPatchSchedule(ScheduleEntry var1);

            public WithPremiumSkuCreate withPatchSchedule(List<ScheduleEntry> var1);
        }

        public static interface WithCreate
        extends Creatable<RedisCache>,
        Resource.DefinitionWithTags<WithCreate> {
            public WithCreate withNonSslPort();

            public WithCreate withRedisConfiguration(Map<String, String> var1);

            public WithCreate withRedisConfiguration(String var1, String var2);

            public WithCreate withSubnet(HasId var1, String var2);

            public WithCreate withStaticIP(String var1);
        }

        public static interface WithSku {
            public WithCreate withBasicSku();

            public WithCreate withBasicSku(int var1);

            public WithCreate withStandardSku();

            public WithCreate withStandardSku(int var1);

            public WithPremiumSkuCreate withPremiumSku();

            public WithPremiumSkuCreate withPremiumSku(int var1);
        }

        public static interface WithGroup
        extends GroupableResource.DefinitionStages.WithGroup<WithSku> {
        }

        public static interface Blank
        extends Resource.DefinitionWithRegion<WithGroup> {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithGroup,
    DefinitionStages.WithSku,
    DefinitionStages.WithCreate,
    DefinitionStages.WithPremiumSkuCreate {
    }
}

