/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.redis.implementation;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.microsoft.azure.Resource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.apigeneration.Method;
import com.microsoft.azure.management.redis.DayOfWeek;
import com.microsoft.azure.management.redis.RebootType;
import com.microsoft.azure.management.redis.RedisAccessKeys;
import com.microsoft.azure.management.redis.RedisCache;
import com.microsoft.azure.management.redis.RedisCachePremium;
import com.microsoft.azure.management.redis.RedisKeyType;
import com.microsoft.azure.management.redis.ScheduleEntry;
import com.microsoft.azure.management.redis.Sku;
import com.microsoft.azure.management.redis.SkuFamily;
import com.microsoft.azure.management.redis.SkuName;
import com.microsoft.azure.management.redis.implementation.ExportRDBParametersInner;
import com.microsoft.azure.management.redis.implementation.ImportRDBParametersInner;
import com.microsoft.azure.management.redis.implementation.RedisAccessKeysImpl;
import com.microsoft.azure.management.redis.implementation.RedisAccessKeysInner;
import com.microsoft.azure.management.redis.implementation.RedisCreateParametersInner;
import com.microsoft.azure.management.redis.implementation.RedisManagementClientImpl;
import com.microsoft.azure.management.redis.implementation.RedisManager;
import com.microsoft.azure.management.redis.implementation.RedisPatchScheduleInner;
import com.microsoft.azure.management.redis.implementation.RedisRebootParametersInner;
import com.microsoft.azure.management.redis.implementation.RedisResourceInner;
import com.microsoft.azure.management.redis.implementation.RedisUpdateParametersInner;
import com.microsoft.azure.management.redis.implementation.ScheduleEntryInner;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.HasId;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.SdkContext;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.joda.time.Period;
import rx.Observable;
import rx.functions.Action1;

@LangDefinition
class RedisCacheImpl
extends GroupableResourceImpl<RedisCache, RedisResourceInner, RedisCacheImpl, RedisManager>
implements RedisCache,
RedisCachePremium,
RedisCache.Definition,
RedisCache.Update {
    private RedisAccessKeys cachedAccessKeys;
    private RedisCreateParametersInner createParameters = new RedisCreateParametersInner();
    private RedisUpdateParametersInner updateParameters;
    private Map<DayOfWeek, ScheduleEntry> scheduleEntries = new TreeMap<DayOfWeek, ScheduleEntry>();

    RedisCacheImpl(String name, RedisResourceInner innerModel, RedisManager redisManager) {
        super(name, (Resource)innerModel, (ManagerBase)redisManager);
    }

    @Override
    public String provisioningState() {
        return ((RedisResourceInner)((Object)this.inner())).provisioningState();
    }

    @Override
    public String hostName() {
        return ((RedisResourceInner)((Object)this.inner())).hostName();
    }

    @Override
    public int port() {
        return Utils.toPrimitiveInt((Integer)((RedisResourceInner)((Object)this.inner())).port());
    }

    @Override
    public int sslPort() {
        return Utils.toPrimitiveInt((Integer)((RedisResourceInner)((Object)this.inner())).sslPort());
    }

    @Override
    public String redisVersion() {
        return ((RedisResourceInner)((Object)this.inner())).redisVersion();
    }

    @Override
    public Sku sku() {
        return ((RedisResourceInner)((Object)this.inner())).sku();
    }

    @Override
    public boolean nonSslPort() {
        return ((RedisResourceInner)((Object)this.inner())).enableNonSslPort();
    }

    @Override
    public int shardCount() {
        return Utils.toPrimitiveInt((Integer)((RedisResourceInner)((Object)this.inner())).shardCount());
    }

    @Override
    public String subnetId() {
        return ((RedisResourceInner)((Object)this.inner())).subnetId();
    }

    @Override
    public String staticIP() {
        return ((RedisResourceInner)((Object)this.inner())).staticIP();
    }

    @Override
    public Map<String, String> redisConfiguration() {
        return Collections.unmodifiableMap(((RedisResourceInner)((Object)this.inner())).redisConfiguration());
    }

    @Override
    @Method
    public RedisCachePremium asPremium() {
        if (this.isPremium()) {
            return this;
        }
        return null;
    }

    @Override
    public boolean isPremium() {
        return this.sku().name().equals(SkuName.PREMIUM);
    }

    @Override
    public RedisAccessKeys keys() {
        if (this.cachedAccessKeys == null) {
            this.cachedAccessKeys = this.refreshKeys();
        }
        return this.cachedAccessKeys;
    }

    @Override
    public RedisAccessKeys getKeys() {
        return this.refreshKeys();
    }

    @Override
    public RedisAccessKeys refreshKeys() {
        RedisAccessKeysInner response = ((RedisManagementClientImpl)((Object)((RedisManager)this.manager()).inner())).redis().listKeys(this.resourceGroupName(), this.name());
        this.cachedAccessKeys = new RedisAccessKeysImpl(response);
        return this.cachedAccessKeys;
    }

    @Override
    public RedisAccessKeys regenerateKey(RedisKeyType keyType) {
        RedisAccessKeysInner response = ((RedisManagementClientImpl)((Object)((RedisManager)this.manager()).inner())).redis().regenerateKey(this.resourceGroupName(), this.name(), keyType);
        this.cachedAccessKeys = new RedisAccessKeysImpl(response);
        return this.cachedAccessKeys;
    }

    @Override
    public void forceReboot(RebootType rebootType) {
        RedisRebootParametersInner parameters = new RedisRebootParametersInner().withRebootType(rebootType);
        ((RedisManagementClientImpl)((Object)((RedisManager)this.manager()).inner())).redis().forceReboot(this.resourceGroupName(), this.name(), parameters);
    }

    @Override
    public void forceReboot(RebootType rebootType, int shardId) {
        RedisRebootParametersInner parameters = new RedisRebootParametersInner().withRebootType(rebootType).withShardId(shardId);
        ((RedisManagementClientImpl)((Object)((RedisManager)this.manager()).inner())).redis().forceReboot(this.resourceGroupName(), this.name(), parameters);
    }

    @Override
    public void importData(List<String> files) {
        ImportRDBParametersInner parameters = new ImportRDBParametersInner().withFiles(files);
        ((RedisManagementClientImpl)((Object)((RedisManager)this.manager()).inner())).redis().importData(this.resourceGroupName(), this.name(), parameters);
    }

    @Override
    public void importData(List<String> files, String fileFormat) {
        ImportRDBParametersInner parameters = new ImportRDBParametersInner().withFiles(files).withFormat(fileFormat);
        ((RedisManagementClientImpl)((Object)((RedisManager)this.manager()).inner())).redis().importData(this.resourceGroupName(), this.name(), parameters);
    }

    @Override
    public void exportData(String containerSASUrl, String prefix) {
        ExportRDBParametersInner parameters = new ExportRDBParametersInner().withContainer(containerSASUrl).withPrefix(prefix);
        ((RedisManagementClientImpl)((Object)((RedisManager)this.manager()).inner())).redis().exportData(this.resourceGroupName(), this.name(), parameters);
    }

    @Override
    public void exportData(String containerSASUrl, String prefix, String fileFormat) {
        ExportRDBParametersInner parameters = new ExportRDBParametersInner().withContainer(containerSASUrl).withPrefix(prefix).withFormat(fileFormat);
        ((RedisManagementClientImpl)((Object)((RedisManager)this.manager()).inner())).redis().exportData(this.resourceGroupName(), this.name(), parameters);
    }

    protected Observable<RedisResourceInner> getInnerAsync() {
        return ((RedisManagementClientImpl)((Object)((RedisManager)this.manager()).inner())).redis().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public RedisCacheImpl withNonSslPort() {
        if (this.isInCreateMode()) {
            this.createParameters.withEnableNonSslPort(true);
        } else {
            this.updateParameters.withEnableNonSslPort(true);
        }
        return this;
    }

    @Override
    public RedisCacheImpl withoutNonSslPort() {
        if (!this.isInCreateMode()) {
            this.updateParameters.withEnableNonSslPort(false);
        }
        return this;
    }

    @Override
    public RedisCacheImpl withRedisConfiguration(Map<String, String> redisConfiguration) {
        if (this.isInCreateMode()) {
            this.createParameters.withRedisConfiguration(redisConfiguration);
        } else {
            this.updateParameters.withRedisConfiguration(redisConfiguration);
        }
        return this;
    }

    @Override
    public RedisCacheImpl withRedisConfiguration(String key, String value) {
        if (this.isInCreateMode()) {
            if (this.createParameters.redisConfiguration() == null) {
                this.createParameters.withRedisConfiguration(new TreeMap<String, String>());
            }
            this.createParameters.redisConfiguration().put(key, value);
        } else {
            if (this.updateParameters.redisConfiguration() == null) {
                this.updateParameters.withRedisConfiguration(new TreeMap<String, String>());
            }
            this.updateParameters.redisConfiguration().put(key, value);
        }
        return this;
    }

    @Override
    public RedisCacheImpl withoutRedisConfiguration() {
        if (this.updateParameters.redisConfiguration() != null) {
            this.updateParameters.redisConfiguration().clear();
        }
        return this;
    }

    @Override
    public RedisCacheImpl withoutRedisConfiguration(String key) {
        if (this.updateParameters.redisConfiguration() != null && this.updateParameters.redisConfiguration().containsKey(key)) {
            this.updateParameters.redisConfiguration().remove(key);
        }
        return this;
    }

    @Override
    public RedisCacheImpl withSubnet(HasId networkResource, String subnetName) {
        if (networkResource != null) {
            String subnetId = networkResource.id() + "/subnets/" + subnetName;
            if (this.isInCreateMode()) {
                this.createParameters.withSubnetId(subnetId);
            } else {
                this.updateParameters.withSubnetId(subnetId);
            }
        }
        return this;
    }

    @Override
    public RedisCacheImpl withStaticIP(String staticIP) {
        if (this.isInCreateMode()) {
            this.createParameters.withStaticIP(staticIP);
        } else {
            this.updateParameters.withStaticIP(staticIP);
        }
        return this;
    }

    @Override
    public RedisCacheImpl withBasicSku() {
        if (this.isInCreateMode()) {
            this.createParameters.withSku(new Sku().withName(SkuName.BASIC).withFamily(SkuFamily.C));
        } else {
            this.updateParameters.withSku(new Sku().withName(SkuName.BASIC).withFamily(SkuFamily.C));
        }
        return this;
    }

    @Override
    public RedisCacheImpl withBasicSku(int capacity) {
        if (this.isInCreateMode()) {
            this.createParameters.withSku(new Sku().withName(SkuName.BASIC).withFamily(SkuFamily.C).withCapacity(capacity));
        } else {
            this.updateParameters.withSku(new Sku().withName(SkuName.BASIC).withFamily(SkuFamily.C).withCapacity(capacity));
        }
        return this;
    }

    @Override
    public RedisCacheImpl withStandardSku() {
        if (this.isInCreateMode()) {
            this.createParameters.withSku(new Sku().withName(SkuName.STANDARD).withFamily(SkuFamily.C));
        } else {
            this.updateParameters.withSku(new Sku().withName(SkuName.STANDARD).withFamily(SkuFamily.C));
        }
        return this;
    }

    @Override
    public RedisCacheImpl withStandardSku(int capacity) {
        if (this.isInCreateMode()) {
            this.createParameters.withSku(new Sku().withName(SkuName.STANDARD).withFamily(SkuFamily.C).withCapacity(capacity));
        } else {
            this.updateParameters.withSku(new Sku().withName(SkuName.STANDARD).withFamily(SkuFamily.C).withCapacity(capacity));
        }
        return this;
    }

    @Override
    public RedisCacheImpl withPremiumSku() {
        if (this.isInCreateMode()) {
            this.createParameters.withSku(new Sku().withName(SkuName.PREMIUM).withFamily(SkuFamily.P).withCapacity(1));
        } else {
            this.updateParameters.withSku(new Sku().withName(SkuName.PREMIUM).withFamily(SkuFamily.P).withCapacity(1));
        }
        return this;
    }

    @Override
    public RedisCacheImpl withPremiumSku(int capacity) {
        if (this.isInCreateMode()) {
            this.createParameters.withSku(new Sku().withName(SkuName.PREMIUM).withFamily(SkuFamily.P).withCapacity(capacity));
        } else {
            this.updateParameters.withSku(new Sku().withName(SkuName.PREMIUM).withFamily(SkuFamily.P).withCapacity(capacity));
        }
        return this;
    }

    @Override
    public RedisCacheImpl withShardCount(int shardCount) {
        if (this.isInCreateMode()) {
            this.createParameters.withShardCount(shardCount);
        } else {
            this.updateParameters.withShardCount(shardCount);
        }
        return this;
    }

    @Override
    public RedisCacheImpl withPatchSchedule(DayOfWeek dayOfWeek, int startHourUtc) {
        return this.withPatchSchedule(new ScheduleEntry().withDayOfWeek(dayOfWeek).withStartHourUtc(startHourUtc));
    }

    @Override
    public RedisCacheImpl withPatchSchedule(DayOfWeek dayOfWeek, int startHourUtc, Period maintenanceWindow) {
        return this.withPatchSchedule(new ScheduleEntry().withDayOfWeek(dayOfWeek).withStartHourUtc(startHourUtc).withMaintenanceWindow(maintenanceWindow));
    }

    @Override
    public RedisCacheImpl withPatchSchedule(List<ScheduleEntry> scheduleEntries) {
        this.scheduleEntries.clear();
        for (ScheduleEntry entry : scheduleEntries) {
            this.withPatchSchedule(entry);
        }
        return this;
    }

    @Override
    public RedisCacheImpl withPatchSchedule(ScheduleEntry scheduleEntry) {
        this.scheduleEntries.put(scheduleEntry.dayOfWeek(), scheduleEntry);
        return this;
    }

    @Override
    public List<ScheduleEntry> listPatchSchedules() {
        RedisPatchScheduleInner patchSchedules = ((RedisManagementClientImpl)((Object)((RedisManager)this.manager()).inner())).patchSchedules().get(this.resourceGroupName(), this.name());
        if (patchSchedules != null) {
            return Lists.transform(patchSchedules.scheduleEntries(), (Function)new Function<ScheduleEntryInner, ScheduleEntry>(){

                public ScheduleEntry apply(ScheduleEntryInner entryInner) {
                    return new ScheduleEntry(entryInner);
                }
            });
        }
        return null;
    }

    @Override
    public void deletePatchSchedule() {
        ((RedisManagementClientImpl)((Object)((RedisManager)this.manager()).inner())).patchSchedules().delete(this.resourceGroupName(), this.name());
    }

    private void updatePatchSchedules() {
        if (this.scheduleEntries != null && !this.scheduleEntries.isEmpty()) {
            RedisPatchScheduleInner parameters = new RedisPatchScheduleInner().withScheduleEntries(new ArrayList<ScheduleEntryInner>());
            for (ScheduleEntry entry : this.scheduleEntries.values()) {
                parameters.scheduleEntries().add(new ScheduleEntryInner().withDayOfWeek(entry.dayOfWeek()).withMaintenanceWindow(entry.maintenanceWindow()).withStartHourUtc(entry.startHourUtc()));
            }
            ((RedisManagementClientImpl)((Object)((RedisManager)this.manager()).inner())).patchSchedules().createOrUpdate(this.resourceGroupName(), this.name(), parameters.scheduleEntries());
        }
    }

    public RedisCacheImpl update() {
        this.updateParameters = new RedisUpdateParametersInner();
        this.scheduleEntries = new TreeMap<DayOfWeek, ScheduleEntry>();
        return (RedisCacheImpl)super.update();
    }

    public Observable<RedisCache> updateResourceAsync() {
        final RedisCacheImpl self = this;
        return ((RedisManagementClientImpl)((Object)((RedisManager)this.manager()).inner())).redis().updateAsync(this.resourceGroupName(), this.name(), this.updateParameters).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this)).doOnNext((Action1)new Action1<RedisCache>(){

            public void call(RedisCache redisCache) {
                while (!redisCache.provisioningState().equalsIgnoreCase("Succeeded")) {
                    SdkContext.sleep((int)30000);
                    RedisResourceInner innerResource = ((RedisManagementClientImpl)((Object)((RedisManager)self.manager()).inner())).redis().getByResourceGroup(RedisCacheImpl.this.resourceGroupName(), RedisCacheImpl.this.name());
                    ((RedisCacheImpl)redisCache).setInner((Object)innerResource);
                    self.setInner((Object)innerResource);
                }
                RedisCacheImpl.this.updatePatchSchedules();
            }
        });
    }

    public Observable<RedisCache> createResourceAsync() {
        this.createParameters.withLocation(this.regionName());
        this.createParameters.withTags(((RedisResourceInner)((Object)this.inner())).getTags());
        return ((RedisManagementClientImpl)((Object)((RedisManager)this.manager()).inner())).redis().createAsync(this.resourceGroupName(), this.name(), this.createParameters).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this)).doOnNext((Action1)new Action1<RedisCache>(){

            public void call(RedisCache redisCache) {
                RedisCacheImpl.this.updatePatchSchedules();
            }
        });
    }
}

