/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.redis.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.redis.RedisFirewallRuleCreateParameters;
import com.microsoft.azure.management.redis.implementation.PageImpl;
import com.microsoft.azure.management.redis.implementation.RedisFirewallRuleInner;
import com.microsoft.azure.management.redis.implementation.RedisManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class FirewallRulesInner {
    private FirewallRulesService service;
    private RedisManagementClientImpl client;

    public FirewallRulesInner(Retrofit retrofit, RedisManagementClientImpl client) {
        this.service = (FirewallRulesService)retrofit.create(FirewallRulesService.class);
        this.client = client;
    }

    public PagedList<RedisFirewallRuleInner> listByRedisResource(String resourceGroupName, String cacheName) {
        ServiceResponse response = (ServiceResponse)this.listByRedisResourceSinglePageAsync(resourceGroupName, cacheName).toBlocking().single();
        return new PagedList<RedisFirewallRuleInner>((Page)response.body()){

            public Page<RedisFirewallRuleInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)FirewallRulesInner.this.listByRedisResourceNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RedisFirewallRuleInner>> listByRedisResourceAsync(String resourceGroupName, String cacheName, ListOperationCallback<RedisFirewallRuleInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByRedisResourceSinglePageAsync(resourceGroupName, cacheName), (Func1)new Func1<String, Observable<ServiceResponse<Page<RedisFirewallRuleInner>>>>(){

            public Observable<ServiceResponse<Page<RedisFirewallRuleInner>>> call(String nextPageLink) {
                return FirewallRulesInner.this.listByRedisResourceNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RedisFirewallRuleInner>> listByRedisResourceAsync(String resourceGroupName, String cacheName) {
        return this.listByRedisResourceWithServiceResponseAsync(resourceGroupName, cacheName).map((Func1)new Func1<ServiceResponse<Page<RedisFirewallRuleInner>>, Page<RedisFirewallRuleInner>>(){

            public Page<RedisFirewallRuleInner> call(ServiceResponse<Page<RedisFirewallRuleInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RedisFirewallRuleInner>>> listByRedisResourceWithServiceResponseAsync(String resourceGroupName, String cacheName) {
        return this.listByRedisResourceSinglePageAsync(resourceGroupName, cacheName).concatMap((Func1)new Func1<ServiceResponse<Page<RedisFirewallRuleInner>>, Observable<ServiceResponse<Page<RedisFirewallRuleInner>>>>(){

            public Observable<ServiceResponse<Page<RedisFirewallRuleInner>>> call(ServiceResponse<Page<RedisFirewallRuleInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(FirewallRulesInner.this.listByRedisResourceNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RedisFirewallRuleInner>>> listByRedisResourceSinglePageAsync(String resourceGroupName, String cacheName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (cacheName == null) {
            throw new IllegalArgumentException("Parameter cacheName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listByRedisResource(this.client.subscriptionId(), resourceGroupName, cacheName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RedisFirewallRuleInner>>>>(){

            public Observable<ServiceResponse<Page<RedisFirewallRuleInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = FirewallRulesInner.this.listByRedisResourceDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<RedisFirewallRuleInner>> listByRedisResourceDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<RedisFirewallRuleInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public RedisFirewallRuleInner createOrUpdate(String resourceGroupName, String cacheName, String ruleName, RedisFirewallRuleCreateParameters parameters) {
        return (RedisFirewallRuleInner)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, cacheName, ruleName, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<RedisFirewallRuleInner> createOrUpdateAsync(String resourceGroupName, String cacheName, String ruleName, RedisFirewallRuleCreateParameters parameters, ServiceCallback<RedisFirewallRuleInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, cacheName, ruleName, parameters), serviceCallback);
    }

    public Observable<RedisFirewallRuleInner> createOrUpdateAsync(String resourceGroupName, String cacheName, String ruleName, RedisFirewallRuleCreateParameters parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, cacheName, ruleName, parameters).map((Func1)new Func1<ServiceResponse<RedisFirewallRuleInner>, RedisFirewallRuleInner>(){

            public RedisFirewallRuleInner call(ServiceResponse<RedisFirewallRuleInner> response) {
                return (RedisFirewallRuleInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<RedisFirewallRuleInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String cacheName, String ruleName, RedisFirewallRuleCreateParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (cacheName == null) {
            throw new IllegalArgumentException("Parameter cacheName is required and cannot be null.");
        }
        if (ruleName == null) {
            throw new IllegalArgumentException("Parameter ruleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.createOrUpdate(resourceGroupName, cacheName, ruleName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RedisFirewallRuleInner>>>(){

            public Observable<ServiceResponse<RedisFirewallRuleInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = FirewallRulesInner.this.createOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<RedisFirewallRuleInner> createOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<RedisFirewallRuleInner>(){}.getType()).register(201, new TypeToken<RedisFirewallRuleInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public RedisFirewallRuleInner get(String resourceGroupName, String cacheName, String ruleName) {
        return (RedisFirewallRuleInner)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, cacheName, ruleName).toBlocking().single()).body();
    }

    public ServiceFuture<RedisFirewallRuleInner> getAsync(String resourceGroupName, String cacheName, String ruleName, ServiceCallback<RedisFirewallRuleInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, cacheName, ruleName), serviceCallback);
    }

    public Observable<RedisFirewallRuleInner> getAsync(String resourceGroupName, String cacheName, String ruleName) {
        return this.getWithServiceResponseAsync(resourceGroupName, cacheName, ruleName).map((Func1)new Func1<ServiceResponse<RedisFirewallRuleInner>, RedisFirewallRuleInner>(){

            public RedisFirewallRuleInner call(ServiceResponse<RedisFirewallRuleInner> response) {
                return (RedisFirewallRuleInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<RedisFirewallRuleInner>> getWithServiceResponseAsync(String resourceGroupName, String cacheName, String ruleName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (cacheName == null) {
            throw new IllegalArgumentException("Parameter cacheName is required and cannot be null.");
        }
        if (ruleName == null) {
            throw new IllegalArgumentException("Parameter ruleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.get(resourceGroupName, cacheName, ruleName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RedisFirewallRuleInner>>>(){

            public Observable<ServiceResponse<RedisFirewallRuleInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = FirewallRulesInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<RedisFirewallRuleInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<RedisFirewallRuleInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String cacheName, String ruleName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, cacheName, ruleName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String cacheName, String ruleName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, cacheName, ruleName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String cacheName, String ruleName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, cacheName, ruleName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String cacheName, String ruleName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (cacheName == null) {
            throw new IllegalArgumentException("Parameter cacheName is required and cannot be null.");
        }
        if (ruleName == null) {
            throw new IllegalArgumentException("Parameter ruleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.delete(resourceGroupName, cacheName, ruleName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = FirewallRulesInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<RedisFirewallRuleInner> listByRedisResourceNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByRedisResourceNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<RedisFirewallRuleInner>((Page)response.body()){

            public Page<RedisFirewallRuleInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)FirewallRulesInner.this.listByRedisResourceNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RedisFirewallRuleInner>> listByRedisResourceNextAsync(String nextPageLink, ServiceFuture<List<RedisFirewallRuleInner>> serviceFuture, ListOperationCallback<RedisFirewallRuleInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByRedisResourceNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<RedisFirewallRuleInner>>>>(){

            public Observable<ServiceResponse<Page<RedisFirewallRuleInner>>> call(String nextPageLink) {
                return FirewallRulesInner.this.listByRedisResourceNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RedisFirewallRuleInner>> listByRedisResourceNextAsync(String nextPageLink) {
        return this.listByRedisResourceNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<RedisFirewallRuleInner>>, Page<RedisFirewallRuleInner>>(){

            public Page<RedisFirewallRuleInner> call(ServiceResponse<Page<RedisFirewallRuleInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RedisFirewallRuleInner>>> listByRedisResourceNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByRedisResourceNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<RedisFirewallRuleInner>>, Observable<ServiceResponse<Page<RedisFirewallRuleInner>>>>(){

            public Observable<ServiceResponse<Page<RedisFirewallRuleInner>>> call(ServiceResponse<Page<RedisFirewallRuleInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(FirewallRulesInner.this.listByRedisResourceNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RedisFirewallRuleInner>>> listByRedisResourceNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByRedisResourceNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RedisFirewallRuleInner>>>>(){

            public Observable<ServiceResponse<Page<RedisFirewallRuleInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = FirewallRulesInner.this.listByRedisResourceNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<RedisFirewallRuleInner>> listByRedisResourceNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<RedisFirewallRuleInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface FirewallRulesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.redis.FirewallRules listByRedisResource"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/Redis/{cacheName}/firewallRules")
        public Observable<Response<ResponseBody>> listByRedisResource(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="cacheName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.redis.FirewallRules createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/Redis/{cacheName}/firewallRules/{ruleName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="cacheName") String var2, @Path(value="ruleName") String var3, @Path(value="subscriptionId") String var4, @Body RedisFirewallRuleCreateParameters var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.redis.FirewallRules get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/Redis/{cacheName}/firewallRules/{ruleName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="cacheName") String var2, @Path(value="ruleName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.redis.FirewallRules delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/Redis/{cacheName}/firewallRules/{ruleName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="cacheName") String var2, @Path(value="ruleName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.redis.FirewallRules listByRedisResourceNext"})
        @GET
        public Observable<Response<ResponseBody>> listByRedisResourceNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

