/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.redis;

import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for RebootType.
 */
public final class RebootType {
    /** Static value PrimaryNode for RebootType. */
    public static final RebootType PRIMARY_NODE = new RebootType("PrimaryNode");

    /** Static value SecondaryNode for RebootType. */
    public static final RebootType SECONDARY_NODE = new RebootType("SecondaryNode");

    /** Static value AllNodes for RebootType. */
    public static final RebootType ALL_NODES = new RebootType("AllNodes");

    private String value;

    /**
     * Creates a custom value for RebootType.
     * @param value the custom value
     */
    public RebootType(String value) {
        this.value = value;
    }

    @JsonValue
    @Override
    public String toString() {
        return value;
    }

    @Override
    public int hashCode() {
        return value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof RebootType)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        RebootType rhs = (RebootType) obj;
        if (value == null) {
            return rhs.value == null;
        } else {
            return value.equals(rhs.value);
        }
    }
}
