/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.redis;

import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for SkuFamily.
 */
public final class SkuFamily {
    /** Static value C for SkuFamily. */
    public static final SkuFamily C = new SkuFamily("C");

    /** Static value P for SkuFamily. */
    public static final SkuFamily P = new SkuFamily("P");

    private String value;

    /**
     * Creates a custom value for SkuFamily.
     * @param value the custom value
     */
    public SkuFamily(String value) {
        this.value = value;
    }

    @JsonValue
    @Override
    public String toString() {
        return value;
    }

    @Override
    public int hashCode() {
        return value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof SkuFamily)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        SkuFamily rhs = (SkuFamily) obj;
        if (value == null) {
            return rhs.value == null;
        } else {
            return value.equals(rhs.value);
        }
    }
}
