/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.redis.implementation;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Parameters for Redis export operation.
 */
public class ExportRDBParametersInner {
    /**
     * File format.
     */
    @JsonProperty(value = "format")
    private String format;

    /**
     * Prefix to use for exported files.
     */
    @JsonProperty(value = "prefix", required = true)
    private String prefix;

    /**
     * Container name to export to.
     */
    @JsonProperty(value = "container", required = true)
    private String container;

    /**
     * Get the format value.
     *
     * @return the format value
     */
    public String format() {
        return this.format;
    }

    /**
     * Set the format value.
     *
     * @param format the format value to set
     * @return the ExportRDBParametersInner object itself.
     */
    public ExportRDBParametersInner withFormat(String format) {
        this.format = format;
        return this;
    }

    /**
     * Get the prefix value.
     *
     * @return the prefix value
     */
    public String prefix() {
        return this.prefix;
    }

    /**
     * Set the prefix value.
     *
     * @param prefix the prefix value to set
     * @return the ExportRDBParametersInner object itself.
     */
    public ExportRDBParametersInner withPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    /**
     * Get the container value.
     *
     * @return the container value
     */
    public String container() {
        return this.container;
    }

    /**
     * Set the container value.
     *
     * @param container the container value to set
     * @return the ExportRDBParametersInner object itself.
     */
    public ExportRDBParametersInner withContainer(String container) {
        this.container = container;
        return this;
    }

}
