/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.redis.implementation;

import com.microsoft.azure.management.redis.ReplicationRole;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;

/**
 * Response to put/get linked server (with properties) for Redis cache.
 */
@JsonFlatten
public class RedisLinkedServerWithPropertiesInner extends ProxyResourceInner {
    /**
     * Fully qualified resourceId of the linked redis cache.
     */
    @JsonProperty(value = "properties.linkedRedisCacheId", required = true)
    private String linkedRedisCacheId;

    /**
     * Location of the linked redis cache.
     */
    @JsonProperty(value = "properties.linkedRedisCacheLocation", required = true)
    private String linkedRedisCacheLocation;

    /**
     * Role of the linked server. Possible values include: 'Primary',
     * 'Secondary'.
     */
    @JsonProperty(value = "properties.serverRole", required = true)
    private ReplicationRole serverRole;

    /**
     * Terminal state of the link between primary and secondary redis cache.
     */
    @JsonProperty(value = "properties.provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;

    /**
     * Get the linkedRedisCacheId value.
     *
     * @return the linkedRedisCacheId value
     */
    public String linkedRedisCacheId() {
        return this.linkedRedisCacheId;
    }

    /**
     * Set the linkedRedisCacheId value.
     *
     * @param linkedRedisCacheId the linkedRedisCacheId value to set
     * @return the RedisLinkedServerWithPropertiesInner object itself.
     */
    public RedisLinkedServerWithPropertiesInner withLinkedRedisCacheId(String linkedRedisCacheId) {
        this.linkedRedisCacheId = linkedRedisCacheId;
        return this;
    }

    /**
     * Get the linkedRedisCacheLocation value.
     *
     * @return the linkedRedisCacheLocation value
     */
    public String linkedRedisCacheLocation() {
        return this.linkedRedisCacheLocation;
    }

    /**
     * Set the linkedRedisCacheLocation value.
     *
     * @param linkedRedisCacheLocation the linkedRedisCacheLocation value to set
     * @return the RedisLinkedServerWithPropertiesInner object itself.
     */
    public RedisLinkedServerWithPropertiesInner withLinkedRedisCacheLocation(String linkedRedisCacheLocation) {
        this.linkedRedisCacheLocation = linkedRedisCacheLocation;
        return this;
    }

    /**
     * Get the serverRole value.
     *
     * @return the serverRole value
     */
    public ReplicationRole serverRole() {
        return this.serverRole;
    }

    /**
     * Set the serverRole value.
     *
     * @param serverRole the serverRole value to set
     * @return the RedisLinkedServerWithPropertiesInner object itself.
     */
    public RedisLinkedServerWithPropertiesInner withServerRole(ReplicationRole serverRole) {
        this.serverRole = serverRole;
        return this;
    }

    /**
     * Get the provisioningState value.
     *
     * @return the provisioningState value
     */
    public String provisioningState() {
        return this.provisioningState;
    }

}
