/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.redis;

import java.util.Collection;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.microsoft.rest.ExpandableStringEnum;

/**
 * Defines values for RebootType.
 */
public final class RebootType extends ExpandableStringEnum<RebootType> {
    /** Static value PrimaryNode for RebootType. */
    public static final RebootType PRIMARY_NODE = fromString("PrimaryNode");

    /** Static value SecondaryNode for RebootType. */
    public static final RebootType SECONDARY_NODE = fromString("SecondaryNode");

    /** Static value AllNodes for RebootType. */
    public static final RebootType ALL_NODES = fromString("AllNodes");

    /**
     * Creates or finds a RebootType from its string representation.
     * @param name a name to look for
     * @return the corresponding RebootType
     */
    @JsonCreator
    public static RebootType fromString(String name) {
        return fromString(name, RebootType.class);
    }

    /**
     * @return known RebootType values
     */
    public static Collection<RebootType> values() {
        return values(RebootType.class);
    }
}
