/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources;

import com.microsoft.azure.management.resources.FeatureClientImpl;
import com.microsoft.azure.management.resources.Features;
import com.microsoft.azure.management.resources.models.FeatureOperationsListResult;
import com.microsoft.azure.management.resources.models.FeatureProperties;
import com.microsoft.azure.management.resources.models.FeatureResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;

public class FeaturesImpl
implements ServiceOperations<FeatureClientImpl>,
Features {
    private FeatureClientImpl client;

    FeaturesImpl(FeatureClientImpl client) {
        this.client = client;
    }

    public FeatureClientImpl getClient() {
        return this.client;
    }

    @Override
    public Future<FeatureResponse> getAsync(final String resourceProviderNamespace, final String featureName) {
        return this.getClient().getExecutorService().submit(new Callable<FeatureResponse>(){

            @Override
            public FeatureResponse call() throws Exception {
                return FeaturesImpl.this.get(resourceProviderNamespace, featureName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FeatureResponse get(String resourceProviderNamespace, String featureName) throws IOException, ServiceException {
        String baseUrl;
        if (resourceProviderNamespace == null) {
            throw new NullPointerException("resourceProviderNamespace");
        }
        if (featureName == null) {
            throw new NullPointerException("featureName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceProviderNamespace", resourceProviderNamespace);
            tracingParameters.put("featureName", featureName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/providers/Microsoft.Features/providers/";
        url = url + URLEncoder.encode(resourceProviderNamespace, "UTF-8");
        url = url + "/features/";
        url = url + URLEncoder.encode(featureName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2014-08-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            FeatureResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new FeatureResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                String responseDocContent = IOUtils.toString((InputStream)responseContent);
                if (!(responseDocContent == null) && responseDocContent.length() > 0) {
                    responseDoc = objectMapper.readTree(responseDocContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode typeValue;
                    JsonNode idValue;
                    JsonNode propertiesValue;
                    JsonNode nameValue = responseDoc.get("name");
                    if (nameValue != null && !(nameValue instanceof NullNode)) {
                        String nameInstance = nameValue.getTextValue();
                        result.setName(nameInstance);
                    }
                    if ((propertiesValue = responseDoc.get("properties")) != null && !(propertiesValue instanceof NullNode)) {
                        FeatureProperties propertiesInstance = new FeatureProperties();
                        result.setProperties(propertiesInstance);
                        JsonNode stateValue = propertiesValue.get("state");
                        if (stateValue != null && !(stateValue instanceof NullNode)) {
                            String stateInstance = stateValue.getTextValue();
                            propertiesInstance.setState(stateInstance);
                        }
                    }
                    if ((idValue = responseDoc.get("id")) != null && !(idValue instanceof NullNode)) {
                        String idInstance = idValue.getTextValue();
                        result.setId(idInstance);
                    }
                    if ((typeValue = responseDoc.get("type")) != null && !(typeValue instanceof NullNode)) {
                        String typeInstance = typeValue.getTextValue();
                        result.setType(typeInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            FeatureResponse featureResponse = result;
            return featureResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<FeatureOperationsListResult> listAsync(final String resourceProviderNamespace) {
        return this.getClient().getExecutorService().submit(new Callable<FeatureOperationsListResult>(){

            @Override
            public FeatureOperationsListResult call() throws Exception {
                return FeaturesImpl.this.list(resourceProviderNamespace);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FeatureOperationsListResult list(String resourceProviderNamespace) throws IOException, ServiceException {
        String baseUrl;
        if (resourceProviderNamespace == null) {
            throw new NullPointerException("resourceProviderNamespace");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceProviderNamespace", resourceProviderNamespace);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/providers/Microsoft.Features/providers/";
        url = url + URLEncoder.encode(resourceProviderNamespace, "UTF-8");
        url = url + "/features";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2014-08-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            FeatureOperationsListResult result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new FeatureOperationsListResult();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                String responseDocContent = IOUtils.toString((InputStream)responseContent);
                if (!(responseDocContent == null) && responseDocContent.length() > 0) {
                    responseDoc = objectMapper.readTree(responseDocContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode nextLinkValue;
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && !(valueArray instanceof NullNode)) {
                        for (JsonNode valueValue : (ArrayNode)valueArray) {
                            JsonNode typeValue;
                            JsonNode idValue;
                            JsonNode propertiesValue;
                            FeatureResponse featureResponseInstance = new FeatureResponse();
                            result.getFeatures().add(featureResponseInstance);
                            JsonNode nameValue = valueValue.get("name");
                            if (nameValue != null && !(nameValue instanceof NullNode)) {
                                String nameInstance = nameValue.getTextValue();
                                featureResponseInstance.setName(nameInstance);
                            }
                            if ((propertiesValue = valueValue.get("properties")) != null && !(propertiesValue instanceof NullNode)) {
                                FeatureProperties propertiesInstance = new FeatureProperties();
                                featureResponseInstance.setProperties(propertiesInstance);
                                JsonNode stateValue = propertiesValue.get("state");
                                if (stateValue != null && !(stateValue instanceof NullNode)) {
                                    String stateInstance = stateValue.getTextValue();
                                    propertiesInstance.setState(stateInstance);
                                }
                            }
                            if ((idValue = valueValue.get("id")) != null && !(idValue instanceof NullNode)) {
                                String idInstance = idValue.getTextValue();
                                featureResponseInstance.setId(idInstance);
                            }
                            if ((typeValue = valueValue.get("type")) == null || typeValue instanceof NullNode) continue;
                            String typeInstance = typeValue.getTextValue();
                            featureResponseInstance.setType(typeInstance);
                        }
                    }
                    if ((nextLinkValue = responseDoc.get("nextLink")) != null && !(nextLinkValue instanceof NullNode)) {
                        String nextLinkInstance = nextLinkValue.getTextValue();
                        result.setNextLink(nextLinkInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            FeatureOperationsListResult featureOperationsListResult = result;
            return featureOperationsListResult;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<FeatureOperationsListResult> listAllAsync() {
        return this.getClient().getExecutorService().submit(new Callable<FeatureOperationsListResult>(){

            @Override
            public FeatureOperationsListResult call() throws Exception {
                return FeaturesImpl.this.listAll();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FeatureOperationsListResult listAll() throws IOException, ServiceException {
        String baseUrl;
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap tracingParameters = new HashMap();
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listAllAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/providers/Microsoft.Features/features";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2014-08-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            FeatureOperationsListResult result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new FeatureOperationsListResult();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                String responseDocContent = IOUtils.toString((InputStream)responseContent);
                if (!(responseDocContent == null) && responseDocContent.length() > 0) {
                    responseDoc = objectMapper.readTree(responseDocContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode nextLinkValue;
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && !(valueArray instanceof NullNode)) {
                        for (JsonNode valueValue : (ArrayNode)valueArray) {
                            JsonNode typeValue;
                            JsonNode idValue;
                            JsonNode propertiesValue;
                            FeatureResponse featureResponseInstance = new FeatureResponse();
                            result.getFeatures().add(featureResponseInstance);
                            JsonNode nameValue = valueValue.get("name");
                            if (nameValue != null && !(nameValue instanceof NullNode)) {
                                String nameInstance = nameValue.getTextValue();
                                featureResponseInstance.setName(nameInstance);
                            }
                            if ((propertiesValue = valueValue.get("properties")) != null && !(propertiesValue instanceof NullNode)) {
                                FeatureProperties propertiesInstance = new FeatureProperties();
                                featureResponseInstance.setProperties(propertiesInstance);
                                JsonNode stateValue = propertiesValue.get("state");
                                if (stateValue != null && !(stateValue instanceof NullNode)) {
                                    String stateInstance = stateValue.getTextValue();
                                    propertiesInstance.setState(stateInstance);
                                }
                            }
                            if ((idValue = valueValue.get("id")) != null && !(idValue instanceof NullNode)) {
                                String idInstance = idValue.getTextValue();
                                featureResponseInstance.setId(idInstance);
                            }
                            if ((typeValue = valueValue.get("type")) == null || typeValue instanceof NullNode) continue;
                            String typeInstance = typeValue.getTextValue();
                            featureResponseInstance.setType(typeInstance);
                        }
                    }
                    if ((nextLinkValue = responseDoc.get("nextLink")) != null && !(nextLinkValue instanceof NullNode)) {
                        String nextLinkInstance = nextLinkValue.getTextValue();
                        result.setNextLink(nextLinkInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            FeatureOperationsListResult featureOperationsListResult = result;
            return featureOperationsListResult;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<FeatureOperationsListResult> listAllNextAsync(final String nextLink) {
        return this.getClient().getExecutorService().submit(new Callable<FeatureOperationsListResult>(){

            @Override
            public FeatureOperationsListResult call() throws Exception {
                return FeaturesImpl.this.listAllNext(nextLink);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FeatureOperationsListResult listAllNext(String nextLink) throws IOException, ServiceException {
        if (nextLink == null) {
            throw new NullPointerException("nextLink");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("nextLink", nextLink);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listAllNextAsync", tracingParameters);
        }
        String url = "";
        url = url + nextLink;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            FeatureOperationsListResult result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new FeatureOperationsListResult();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                String responseDocContent = IOUtils.toString((InputStream)responseContent);
                if (!(responseDocContent == null) && responseDocContent.length() > 0) {
                    responseDoc = objectMapper.readTree(responseDocContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode nextLinkValue;
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && !(valueArray instanceof NullNode)) {
                        for (JsonNode valueValue : (ArrayNode)valueArray) {
                            JsonNode typeValue;
                            JsonNode idValue;
                            JsonNode propertiesValue;
                            FeatureResponse featureResponseInstance = new FeatureResponse();
                            result.getFeatures().add(featureResponseInstance);
                            JsonNode nameValue = valueValue.get("name");
                            if (nameValue != null && !(nameValue instanceof NullNode)) {
                                String nameInstance = nameValue.getTextValue();
                                featureResponseInstance.setName(nameInstance);
                            }
                            if ((propertiesValue = valueValue.get("properties")) != null && !(propertiesValue instanceof NullNode)) {
                                FeatureProperties propertiesInstance = new FeatureProperties();
                                featureResponseInstance.setProperties(propertiesInstance);
                                JsonNode stateValue = propertiesValue.get("state");
                                if (stateValue != null && !(stateValue instanceof NullNode)) {
                                    String stateInstance = stateValue.getTextValue();
                                    propertiesInstance.setState(stateInstance);
                                }
                            }
                            if ((idValue = valueValue.get("id")) != null && !(idValue instanceof NullNode)) {
                                String idInstance = idValue.getTextValue();
                                featureResponseInstance.setId(idInstance);
                            }
                            if ((typeValue = valueValue.get("type")) == null || typeValue instanceof NullNode) continue;
                            String typeInstance = typeValue.getTextValue();
                            featureResponseInstance.setType(typeInstance);
                        }
                    }
                    if ((nextLinkValue = responseDoc.get("nextLink")) != null && !(nextLinkValue instanceof NullNode)) {
                        String nextLinkInstance = nextLinkValue.getTextValue();
                        result.setNextLink(nextLinkInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            FeatureOperationsListResult featureOperationsListResult = result;
            return featureOperationsListResult;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<FeatureOperationsListResult> listNextAsync(final String nextLink) {
        return this.getClient().getExecutorService().submit(new Callable<FeatureOperationsListResult>(){

            @Override
            public FeatureOperationsListResult call() throws Exception {
                return FeaturesImpl.this.listNext(nextLink);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FeatureOperationsListResult listNext(String nextLink) throws IOException, ServiceException {
        if (nextLink == null) {
            throw new NullPointerException("nextLink");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("nextLink", nextLink);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listNextAsync", tracingParameters);
        }
        String url = "";
        url = url + nextLink;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            FeatureOperationsListResult result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new FeatureOperationsListResult();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                String responseDocContent = IOUtils.toString((InputStream)responseContent);
                if (!(responseDocContent == null) && responseDocContent.length() > 0) {
                    responseDoc = objectMapper.readTree(responseDocContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode nextLinkValue;
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && !(valueArray instanceof NullNode)) {
                        for (JsonNode valueValue : (ArrayNode)valueArray) {
                            JsonNode typeValue;
                            JsonNode idValue;
                            JsonNode propertiesValue;
                            FeatureResponse featureResponseInstance = new FeatureResponse();
                            result.getFeatures().add(featureResponseInstance);
                            JsonNode nameValue = valueValue.get("name");
                            if (nameValue != null && !(nameValue instanceof NullNode)) {
                                String nameInstance = nameValue.getTextValue();
                                featureResponseInstance.setName(nameInstance);
                            }
                            if ((propertiesValue = valueValue.get("properties")) != null && !(propertiesValue instanceof NullNode)) {
                                FeatureProperties propertiesInstance = new FeatureProperties();
                                featureResponseInstance.setProperties(propertiesInstance);
                                JsonNode stateValue = propertiesValue.get("state");
                                if (stateValue != null && !(stateValue instanceof NullNode)) {
                                    String stateInstance = stateValue.getTextValue();
                                    propertiesInstance.setState(stateInstance);
                                }
                            }
                            if ((idValue = valueValue.get("id")) != null && !(idValue instanceof NullNode)) {
                                String idInstance = idValue.getTextValue();
                                featureResponseInstance.setId(idInstance);
                            }
                            if ((typeValue = valueValue.get("type")) == null || typeValue instanceof NullNode) continue;
                            String typeInstance = typeValue.getTextValue();
                            featureResponseInstance.setType(typeInstance);
                        }
                    }
                    if ((nextLinkValue = responseDoc.get("nextLink")) != null && !(nextLinkValue instanceof NullNode)) {
                        String nextLinkInstance = nextLinkValue.getTextValue();
                        result.setNextLink(nextLinkInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            FeatureOperationsListResult featureOperationsListResult = result;
            return featureOperationsListResult;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<FeatureResponse> registerAsync(final String resourceProviderNamespace, final String featureName) {
        return this.getClient().getExecutorService().submit(new Callable<FeatureResponse>(){

            @Override
            public FeatureResponse call() throws Exception {
                return FeaturesImpl.this.register(resourceProviderNamespace, featureName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FeatureResponse register(String resourceProviderNamespace, String featureName) throws IOException, ServiceException {
        String baseUrl;
        if (resourceProviderNamespace == null) {
            throw new NullPointerException("resourceProviderNamespace");
        }
        if (featureName == null) {
            throw new NullPointerException("featureName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceProviderNamespace", resourceProviderNamespace);
            tracingParameters.put("featureName", featureName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"registerAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/providers/Microsoft.Features/providers/";
        url = url + URLEncoder.encode(resourceProviderNamespace, "UTF-8");
        url = url + "/features/";
        url = url + URLEncoder.encode(featureName, "UTF-8");
        url = url + "/register";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2014-08-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            FeatureResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new FeatureResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                String responseDocContent = IOUtils.toString((InputStream)responseContent);
                if (!(responseDocContent == null) && responseDocContent.length() > 0) {
                    responseDoc = objectMapper.readTree(responseDocContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode typeValue;
                    JsonNode idValue;
                    JsonNode propertiesValue;
                    JsonNode nameValue = responseDoc.get("name");
                    if (nameValue != null && !(nameValue instanceof NullNode)) {
                        String nameInstance = nameValue.getTextValue();
                        result.setName(nameInstance);
                    }
                    if ((propertiesValue = responseDoc.get("properties")) != null && !(propertiesValue instanceof NullNode)) {
                        FeatureProperties propertiesInstance = new FeatureProperties();
                        result.setProperties(propertiesInstance);
                        JsonNode stateValue = propertiesValue.get("state");
                        if (stateValue != null && !(stateValue instanceof NullNode)) {
                            String stateInstance = stateValue.getTextValue();
                            propertiesInstance.setState(stateInstance);
                        }
                    }
                    if ((idValue = responseDoc.get("id")) != null && !(idValue instanceof NullNode)) {
                        String idInstance = idValue.getTextValue();
                        result.setId(idInstance);
                    }
                    if ((typeValue = responseDoc.get("type")) != null && !(typeValue instanceof NullNode)) {
                        String typeInstance = typeValue.getTextValue();
                        result.setType(typeInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            FeatureResponse featureResponse = result;
            return featureResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}

