/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources;

import com.microsoft.azure.management.resources.ProviderOperationsMetadataOperations;
import com.microsoft.azure.management.resources.ResourceManagementClientImpl;
import com.microsoft.azure.management.resources.models.Operation;
import com.microsoft.azure.management.resources.models.ProviderOperationsMetadata;
import com.microsoft.azure.management.resources.models.ProviderOperationsMetadataGetResult;
import com.microsoft.azure.management.resources.models.ProviderOperationsMetadataListResult;
import com.microsoft.azure.management.resources.models.ResourceType;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;

public class ProviderOperationsMetadataOperationsImpl
implements ServiceOperations<ResourceManagementClientImpl>,
ProviderOperationsMetadataOperations {
    private ResourceManagementClientImpl client;

    ProviderOperationsMetadataOperationsImpl(ResourceManagementClientImpl client) {
        this.client = client;
    }

    public ResourceManagementClientImpl getClient() {
        return this.client;
    }

    @Override
    public Future<ProviderOperationsMetadataGetResult> getAsync(final String resourceProviderNamespace) {
        return this.getClient().getExecutorService().submit(new Callable<ProviderOperationsMetadataGetResult>(){

            @Override
            public ProviderOperationsMetadataGetResult call() throws Exception {
                return ProviderOperationsMetadataOperationsImpl.this.get(resourceProviderNamespace);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProviderOperationsMetadataGetResult get(String resourceProviderNamespace) throws IOException, ServiceException, URISyntaxException {
        String baseUrl;
        if (resourceProviderNamespace == null) {
            throw new NullPointerException("resourceProviderNamespace");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceProviderNamespace", resourceProviderNamespace);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getAsync", tracingParameters);
        }
        String url = "";
        url = url + "/providers/Microsoft.Authorization/providerOperations/";
        url = url + URLEncoder.encode(resourceProviderNamespace, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-07-01");
        queryParameters.add("$expand=resourceTypes");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            ProviderOperationsMetadataGetResult result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ProviderOperationsMetadataGetResult();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                String responseDocContent = IOUtils.toString((InputStream)responseContent);
                if (!(responseDocContent == null) && responseDocContent.length() > 0) {
                    responseDoc = objectMapper.readTree(responseDocContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode operationsArray2;
                    JsonNode resourceTypesArray;
                    JsonNode displayNameValue;
                    JsonNode typeValue;
                    JsonNode nameValue;
                    ProviderOperationsMetadata providerInstance = new ProviderOperationsMetadata();
                    result.setProvider(providerInstance);
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && !(idValue instanceof NullNode)) {
                        String idInstance = idValue.getTextValue();
                        providerInstance.setId(idInstance);
                    }
                    if ((nameValue = responseDoc.get("name")) != null && !(nameValue instanceof NullNode)) {
                        String nameInstance = nameValue.getTextValue();
                        providerInstance.setName(nameInstance);
                    }
                    if ((typeValue = responseDoc.get("type")) != null && !(typeValue instanceof NullNode)) {
                        String typeInstance = typeValue.getTextValue();
                        providerInstance.setType(typeInstance);
                    }
                    if ((displayNameValue = responseDoc.get("displayName")) != null && !(displayNameValue instanceof NullNode)) {
                        String displayNameInstance = displayNameValue.getTextValue();
                        providerInstance.setDisplayName(displayNameInstance);
                    }
                    if ((resourceTypesArray = responseDoc.get("resourceTypes")) != null && !(resourceTypesArray instanceof NullNode)) {
                        for (JsonNode resourceTypesValue : (ArrayNode)resourceTypesArray) {
                            JsonNode operationsArray;
                            JsonNode displayNameValue2;
                            ResourceType resourceTypeInstance = new ResourceType();
                            providerInstance.getResourceTypes().add(resourceTypeInstance);
                            JsonNode nameValue2 = resourceTypesValue.get("name");
                            if (nameValue2 != null && !(nameValue2 instanceof NullNode)) {
                                String nameInstance2 = nameValue2.getTextValue();
                                resourceTypeInstance.setName(nameInstance2);
                            }
                            if ((displayNameValue2 = resourceTypesValue.get("displayName")) != null && !(displayNameValue2 instanceof NullNode)) {
                                String displayNameInstance2 = displayNameValue2.getTextValue();
                                resourceTypeInstance.setDisplayName(displayNameInstance2);
                            }
                            if ((operationsArray = resourceTypesValue.get("operations")) == null || operationsArray instanceof NullNode) continue;
                            for (JsonNode operationsValue : (ArrayNode)operationsArray) {
                                JsonNode propertiesValue;
                                JsonNode originValue;
                                JsonNode descriptionValue;
                                JsonNode displayNameValue3;
                                Operation operationInstance = new Operation();
                                resourceTypeInstance.getOperations().add(operationInstance);
                                JsonNode nameValue3 = operationsValue.get("name");
                                if (nameValue3 != null && !(nameValue3 instanceof NullNode)) {
                                    String nameInstance3 = nameValue3.getTextValue();
                                    operationInstance.setName(nameInstance3);
                                }
                                if ((displayNameValue3 = operationsValue.get("displayName")) != null && !(displayNameValue3 instanceof NullNode)) {
                                    String displayNameInstance3 = displayNameValue3.getTextValue();
                                    operationInstance.setDisplayName(displayNameInstance3);
                                }
                                if ((descriptionValue = operationsValue.get("description")) != null && !(descriptionValue instanceof NullNode)) {
                                    String descriptionInstance = descriptionValue.getTextValue();
                                    operationInstance.setDescription(descriptionInstance);
                                }
                                if ((originValue = operationsValue.get("origin")) != null && !(originValue instanceof NullNode)) {
                                    String originInstance = originValue.getTextValue();
                                    operationInstance.setOrigin(originInstance);
                                }
                                if ((propertiesValue = operationsValue.get("properties")) == null || propertiesValue instanceof NullNode) continue;
                                String propertiesInstance = propertiesValue.getTextValue();
                                operationInstance.setProperties(propertiesInstance);
                            }
                        }
                    }
                    if ((operationsArray2 = responseDoc.get("operations")) != null && !(operationsArray2 instanceof NullNode)) {
                        for (JsonNode operationsValue2 : (ArrayNode)operationsArray2) {
                            JsonNode propertiesValue2;
                            JsonNode originValue2;
                            JsonNode descriptionValue2;
                            JsonNode displayNameValue4;
                            Operation operationInstance2 = new Operation();
                            providerInstance.getOperations().add(operationInstance2);
                            JsonNode nameValue4 = operationsValue2.get("name");
                            if (nameValue4 != null && !(nameValue4 instanceof NullNode)) {
                                String nameInstance4 = nameValue4.getTextValue();
                                operationInstance2.setName(nameInstance4);
                            }
                            if ((displayNameValue4 = operationsValue2.get("displayName")) != null && !(displayNameValue4 instanceof NullNode)) {
                                String displayNameInstance4 = displayNameValue4.getTextValue();
                                operationInstance2.setDisplayName(displayNameInstance4);
                            }
                            if ((descriptionValue2 = operationsValue2.get("description")) != null && !(descriptionValue2 instanceof NullNode)) {
                                String descriptionInstance2 = descriptionValue2.getTextValue();
                                operationInstance2.setDescription(descriptionInstance2);
                            }
                            if ((originValue2 = operationsValue2.get("origin")) != null && !(originValue2 instanceof NullNode)) {
                                String originInstance2 = originValue2.getTextValue();
                                operationInstance2.setOrigin(originInstance2);
                            }
                            if ((propertiesValue2 = operationsValue2.get("properties")) == null || propertiesValue2 instanceof NullNode) continue;
                            String propertiesInstance2 = propertiesValue2.getTextValue();
                            operationInstance2.setProperties(propertiesInstance2);
                        }
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            ProviderOperationsMetadataGetResult providerOperationsMetadataGetResult = result;
            return providerOperationsMetadataGetResult;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<ProviderOperationsMetadataListResult> listAsync() {
        return this.getClient().getExecutorService().submit(new Callable<ProviderOperationsMetadataListResult>(){

            @Override
            public ProviderOperationsMetadataListResult call() throws Exception {
                return ProviderOperationsMetadataOperationsImpl.this.list();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProviderOperationsMetadataListResult list() throws IOException, ServiceException, URISyntaxException {
        String baseUrl;
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap tracingParameters = new HashMap();
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listAsync", tracingParameters);
        }
        String url = "";
        url = url + "/providers/Microsoft.Authorization/providerOperations";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-07-01");
        queryParameters.add("$expand=resourceTypes");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            ProviderOperationsMetadataListResult result = null;
            if (statusCode == 200) {
                JsonNode valueArray;
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ProviderOperationsMetadataListResult();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                String responseDocContent = IOUtils.toString((InputStream)responseContent);
                if (!(responseDocContent == null) && responseDocContent.length() > 0) {
                    responseDoc = objectMapper.readTree(responseDocContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode) && (valueArray = responseDoc.get("value")) != null && !(valueArray instanceof NullNode)) {
                    for (JsonNode valueValue : (ArrayNode)valueArray) {
                        JsonNode operationsArray2;
                        JsonNode resourceTypesArray;
                        JsonNode displayNameValue;
                        JsonNode typeValue;
                        JsonNode nameValue;
                        ProviderOperationsMetadata providerOperationsMetadataInstance = new ProviderOperationsMetadata();
                        result.getProviders().add(providerOperationsMetadataInstance);
                        JsonNode idValue = valueValue.get("id");
                        if (idValue != null && !(idValue instanceof NullNode)) {
                            String idInstance = idValue.getTextValue();
                            providerOperationsMetadataInstance.setId(idInstance);
                        }
                        if ((nameValue = valueValue.get("name")) != null && !(nameValue instanceof NullNode)) {
                            String nameInstance = nameValue.getTextValue();
                            providerOperationsMetadataInstance.setName(nameInstance);
                        }
                        if ((typeValue = valueValue.get("type")) != null && !(typeValue instanceof NullNode)) {
                            String typeInstance = typeValue.getTextValue();
                            providerOperationsMetadataInstance.setType(typeInstance);
                        }
                        if ((displayNameValue = valueValue.get("displayName")) != null && !(displayNameValue instanceof NullNode)) {
                            String displayNameInstance = displayNameValue.getTextValue();
                            providerOperationsMetadataInstance.setDisplayName(displayNameInstance);
                        }
                        if ((resourceTypesArray = valueValue.get("resourceTypes")) != null && !(resourceTypesArray instanceof NullNode)) {
                            for (JsonNode resourceTypesValue : (ArrayNode)resourceTypesArray) {
                                JsonNode operationsArray;
                                JsonNode displayNameValue2;
                                ResourceType resourceTypeInstance = new ResourceType();
                                providerOperationsMetadataInstance.getResourceTypes().add(resourceTypeInstance);
                                JsonNode nameValue2 = resourceTypesValue.get("name");
                                if (nameValue2 != null && !(nameValue2 instanceof NullNode)) {
                                    String nameInstance2 = nameValue2.getTextValue();
                                    resourceTypeInstance.setName(nameInstance2);
                                }
                                if ((displayNameValue2 = resourceTypesValue.get("displayName")) != null && !(displayNameValue2 instanceof NullNode)) {
                                    String displayNameInstance2 = displayNameValue2.getTextValue();
                                    resourceTypeInstance.setDisplayName(displayNameInstance2);
                                }
                                if ((operationsArray = resourceTypesValue.get("operations")) == null || operationsArray instanceof NullNode) continue;
                                for (JsonNode operationsValue : (ArrayNode)operationsArray) {
                                    JsonNode propertiesValue;
                                    JsonNode originValue;
                                    JsonNode descriptionValue;
                                    JsonNode displayNameValue3;
                                    Operation operationInstance = new Operation();
                                    resourceTypeInstance.getOperations().add(operationInstance);
                                    JsonNode nameValue3 = operationsValue.get("name");
                                    if (nameValue3 != null && !(nameValue3 instanceof NullNode)) {
                                        String nameInstance3 = nameValue3.getTextValue();
                                        operationInstance.setName(nameInstance3);
                                    }
                                    if ((displayNameValue3 = operationsValue.get("displayName")) != null && !(displayNameValue3 instanceof NullNode)) {
                                        String displayNameInstance3 = displayNameValue3.getTextValue();
                                        operationInstance.setDisplayName(displayNameInstance3);
                                    }
                                    if ((descriptionValue = operationsValue.get("description")) != null && !(descriptionValue instanceof NullNode)) {
                                        String descriptionInstance = descriptionValue.getTextValue();
                                        operationInstance.setDescription(descriptionInstance);
                                    }
                                    if ((originValue = operationsValue.get("origin")) != null && !(originValue instanceof NullNode)) {
                                        String originInstance = originValue.getTextValue();
                                        operationInstance.setOrigin(originInstance);
                                    }
                                    if ((propertiesValue = operationsValue.get("properties")) == null || propertiesValue instanceof NullNode) continue;
                                    String propertiesInstance = propertiesValue.getTextValue();
                                    operationInstance.setProperties(propertiesInstance);
                                }
                            }
                        }
                        if ((operationsArray2 = valueValue.get("operations")) == null || operationsArray2 instanceof NullNode) continue;
                        for (JsonNode operationsValue2 : (ArrayNode)operationsArray2) {
                            JsonNode propertiesValue2;
                            JsonNode originValue2;
                            JsonNode descriptionValue2;
                            JsonNode displayNameValue4;
                            Operation operationInstance2 = new Operation();
                            providerOperationsMetadataInstance.getOperations().add(operationInstance2);
                            JsonNode nameValue4 = operationsValue2.get("name");
                            if (nameValue4 != null && !(nameValue4 instanceof NullNode)) {
                                String nameInstance4 = nameValue4.getTextValue();
                                operationInstance2.setName(nameInstance4);
                            }
                            if ((displayNameValue4 = operationsValue2.get("displayName")) != null && !(displayNameValue4 instanceof NullNode)) {
                                String displayNameInstance4 = displayNameValue4.getTextValue();
                                operationInstance2.setDisplayName(displayNameInstance4);
                            }
                            if ((descriptionValue2 = operationsValue2.get("description")) != null && !(descriptionValue2 instanceof NullNode)) {
                                String descriptionInstance2 = descriptionValue2.getTextValue();
                                operationInstance2.setDescription(descriptionInstance2);
                            }
                            if ((originValue2 = operationsValue2.get("origin")) != null && !(originValue2 instanceof NullNode)) {
                                String originInstance2 = originValue2.getTextValue();
                                operationInstance2.setOrigin(originInstance2);
                            }
                            if ((propertiesValue2 = operationsValue2.get("properties")) == null || propertiesValue2 instanceof NullNode) continue;
                            String propertiesInstance2 = propertiesValue2.getTextValue();
                            operationInstance2.setProperties(propertiesInstance2);
                        }
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            ProviderOperationsMetadataListResult providerOperationsMetadataListResult = result;
            return providerOperationsMetadataListResult;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}

