/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources;

import com.microsoft.azure.management.resources.DeploymentOperationOperations;
import com.microsoft.azure.management.resources.DeploymentOperationOperationsImpl;
import com.microsoft.azure.management.resources.DeploymentOperations;
import com.microsoft.azure.management.resources.DeploymentOperationsImpl;
import com.microsoft.azure.management.resources.ProviderOperations;
import com.microsoft.azure.management.resources.ProviderOperationsImpl;
import com.microsoft.azure.management.resources.ProviderOperationsMetadataOperations;
import com.microsoft.azure.management.resources.ProviderOperationsMetadataOperationsImpl;
import com.microsoft.azure.management.resources.ResourceGroupOperations;
import com.microsoft.azure.management.resources.ResourceGroupOperationsImpl;
import com.microsoft.azure.management.resources.ResourceManagementClient;
import com.microsoft.azure.management.resources.ResourceOperations;
import com.microsoft.azure.management.resources.ResourceOperationsImpl;
import com.microsoft.azure.management.resources.ResourceProviderOperationDetailsOperations;
import com.microsoft.azure.management.resources.ResourceProviderOperationDetailsOperationsImpl;
import com.microsoft.azure.management.resources.TagOperations;
import com.microsoft.azure.management.resources.TagOperationsImpl;
import com.microsoft.azure.management.resources.models.LongRunningOperationResponse;
import com.microsoft.windowsazure.core.OperationStatus;
import com.microsoft.windowsazure.core.ServiceClient;
import com.microsoft.windowsazure.credentials.SubscriptionCloudCredentials;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;

public class ResourceManagementClientImpl
extends ServiceClient<ResourceManagementClient>
implements ResourceManagementClient {
    private String apiVersion = "2014-04-01-preview";
    private URI baseUri;
    private SubscriptionCloudCredentials credentials;
    private int longRunningOperationInitialTimeout = -1;
    private int longRunningOperationRetryTimeout = -1;
    private DeploymentOperationOperations deploymentOperations = new DeploymentOperationOperationsImpl(this);
    private DeploymentOperations deployments = new DeploymentOperationsImpl(this);
    private ProviderOperations providers = new ProviderOperationsImpl(this);
    private ProviderOperationsMetadataOperations providerOperationsMetadata = new ProviderOperationsMetadataOperationsImpl(this);
    private ResourceGroupOperations resourceGroups = new ResourceGroupOperationsImpl(this);
    private ResourceOperations resources = new ResourceOperationsImpl(this);
    private ResourceProviderOperationDetailsOperations resourceProviderOperationDetails = new ResourceProviderOperationDetailsOperationsImpl(this);
    private TagOperations tags = new TagOperationsImpl(this);

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public URI getBaseUri() {
        return this.baseUri;
    }

    @Override
    public SubscriptionCloudCredentials getCredentials() {
        return this.credentials;
    }

    @Override
    public int getLongRunningOperationInitialTimeout() {
        return this.longRunningOperationInitialTimeout;
    }

    @Override
    public void setLongRunningOperationInitialTimeout(int longRunningOperationInitialTimeoutValue) {
        this.longRunningOperationInitialTimeout = longRunningOperationInitialTimeoutValue;
    }

    @Override
    public int getLongRunningOperationRetryTimeout() {
        return this.longRunningOperationRetryTimeout;
    }

    @Override
    public void setLongRunningOperationRetryTimeout(int longRunningOperationRetryTimeoutValue) {
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeoutValue;
    }

    @Override
    public DeploymentOperationOperations getDeploymentOperationsOperations() {
        return this.deploymentOperations;
    }

    @Override
    public DeploymentOperations getDeploymentsOperations() {
        return this.deployments;
    }

    @Override
    public ProviderOperations getProvidersOperations() {
        return this.providers;
    }

    @Override
    public ProviderOperationsMetadataOperations getProviderOperationsMetadataOperations() {
        return this.providerOperationsMetadata;
    }

    @Override
    public ResourceGroupOperations getResourceGroupsOperations() {
        return this.resourceGroups;
    }

    @Override
    public ResourceOperations getResourcesOperations() {
        return this.resources;
    }

    @Override
    public ResourceProviderOperationDetailsOperations getResourceProviderOperationDetailsOperations() {
        return this.resourceProviderOperationDetails;
    }

    @Override
    public TagOperations getTagsOperations() {
        return this.tags;
    }

    public ResourceManagementClientImpl(HttpClientBuilder httpBuilder, ExecutorService executorService) {
        super(httpBuilder, executorService);
    }

    @Inject
    public ResourceManagementClientImpl(HttpClientBuilder httpBuilder, ExecutorService executorService, @Named(value="com.microsoft.windowsazure.Configuration.credentials") SubscriptionCloudCredentials credentials, @Named(value="management.uri") URI baseUri) {
        this(httpBuilder, executorService);
        if (credentials == null) {
            throw new NullPointerException("credentials");
        }
        this.credentials = credentials;
        if (baseUri == null) {
            try {
                this.baseUri = new URI("https://management.azure.com/");
            }
            catch (URISyntaxException uRISyntaxException) {}
        } else {
            this.baseUri = baseUri;
        }
    }

    public ResourceManagementClientImpl(HttpClientBuilder httpBuilder, ExecutorService executorService, SubscriptionCloudCredentials credentials) throws URISyntaxException {
        this(httpBuilder, executorService);
        if (credentials == null) {
            throw new NullPointerException("credentials");
        }
        this.credentials = credentials;
        this.baseUri = new URI("https://management.azure.com/");
    }

    public ResourceManagementClientImpl(HttpClientBuilder httpBuilder, ExecutorService executorService, SubscriptionCloudCredentials credentials, URI baseUri, String apiVersion, int longRunningOperationInitialTimeout, int longRunningOperationRetryTimeout) {
        this(httpBuilder, executorService);
        this.credentials = credentials;
        this.baseUri = baseUri;
        this.apiVersion = apiVersion;
        this.longRunningOperationInitialTimeout = longRunningOperationInitialTimeout;
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeout;
    }

    protected ResourceManagementClientImpl newInstance(HttpClientBuilder httpBuilder, ExecutorService executorService) {
        return new ResourceManagementClientImpl(httpBuilder, executorService, this.getCredentials(), this.getBaseUri(), this.getApiVersion(), this.getLongRunningOperationInitialTimeout(), this.getLongRunningOperationRetryTimeout());
    }

    @Override
    public Future<LongRunningOperationResponse> getLongRunningOperationStatusAsync(final String operationStatusLink) {
        return this.getExecutorService().submit(new Callable<LongRunningOperationResponse>(){

            @Override
            public LongRunningOperationResponse call() throws Exception {
                return ResourceManagementClientImpl.this.getLongRunningOperationStatus(operationStatusLink);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LongRunningOperationResponse getLongRunningOperationStatus(String operationStatusLink) throws IOException, ServiceException {
        if (operationStatusLink == null) {
            throw new NullPointerException("operationStatusLink");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("operationStatusLink", operationStatusLink);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getLongRunningOperationStatusAsync", tracingParameters);
        }
        String url = "";
        url = url + operationStatusLink;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2014-04-01-preview");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200 && statusCode != 202 && statusCode != 204) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            LongRunningOperationResponse result = null;
            result = new LongRunningOperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (statusCode == 409) {
                result.setStatus(OperationStatus.Failed);
            }
            if (statusCode == 204) {
                result.setStatus(OperationStatus.Succeeded);
            }
            if (statusCode == 200) {
                result.setStatus(OperationStatus.Succeeded);
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            LongRunningOperationResponse longRunningOperationResponse = result;
            return longRunningOperationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}

