/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.subscriptions;

import com.microsoft.azure.subscriptions.SubscriptionClient;
import com.microsoft.azure.subscriptions.SubscriptionOperations;
import com.microsoft.azure.subscriptions.SubscriptionOperationsImpl;
import com.microsoft.azure.subscriptions.TenantOperations;
import com.microsoft.azure.subscriptions.TenantOperationsImpl;
import com.microsoft.windowsazure.core.ServiceClient;
import com.microsoft.windowsazure.credentials.CloudCredentials;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.ExecutorService;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.http.impl.client.HttpClientBuilder;

public class SubscriptionClientImpl
extends ServiceClient<SubscriptionClient>
implements SubscriptionClient {
    private String apiVersion = "2014-04-01-preview";
    private URI baseUri;
    private CloudCredentials credentials;
    private int longRunningOperationInitialTimeout = -1;
    private int longRunningOperationRetryTimeout = -1;
    private SubscriptionOperations subscriptions = new SubscriptionOperationsImpl(this);
    private TenantOperations tenants = new TenantOperationsImpl(this);

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public URI getBaseUri() {
        return this.baseUri;
    }

    @Override
    public CloudCredentials getCredentials() {
        return this.credentials;
    }

    @Override
    public void setCredentials(CloudCredentials credentialsValue) {
        this.credentials = credentialsValue;
    }

    @Override
    public int getLongRunningOperationInitialTimeout() {
        return this.longRunningOperationInitialTimeout;
    }

    @Override
    public void setLongRunningOperationInitialTimeout(int longRunningOperationInitialTimeoutValue) {
        this.longRunningOperationInitialTimeout = longRunningOperationInitialTimeoutValue;
    }

    @Override
    public int getLongRunningOperationRetryTimeout() {
        return this.longRunningOperationRetryTimeout;
    }

    @Override
    public void setLongRunningOperationRetryTimeout(int longRunningOperationRetryTimeoutValue) {
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeoutValue;
    }

    @Override
    public SubscriptionOperations getSubscriptionsOperations() {
        return this.subscriptions;
    }

    @Override
    public TenantOperations getTenantsOperations() {
        return this.tenants;
    }

    public SubscriptionClientImpl(HttpClientBuilder httpBuilder, ExecutorService executorService) {
        super(httpBuilder, executorService);
    }

    @Inject
    public SubscriptionClientImpl(HttpClientBuilder httpBuilder, ExecutorService executorService, @Named(value="com.microsoft.windowsazure.Configuration.credentials") CloudCredentials credentials, @Named(value="management.uri") URI baseUri) {
        this(httpBuilder, executorService);
        if (credentials == null) {
            throw new NullPointerException("credentials");
        }
        this.credentials = credentials;
        if (baseUri == null) {
            try {
                this.baseUri = new URI("https://management.azure.com/");
            }
            catch (URISyntaxException uRISyntaxException) {}
        } else {
            this.baseUri = baseUri;
        }
    }

    public SubscriptionClientImpl(HttpClientBuilder httpBuilder, ExecutorService executorService, CloudCredentials credentials) throws URISyntaxException {
        this(httpBuilder, executorService);
        if (credentials == null) {
            throw new NullPointerException("credentials");
        }
        this.credentials = credentials;
        this.baseUri = new URI("https://management.azure.com/");
    }

    public SubscriptionClientImpl(HttpClientBuilder httpBuilder, ExecutorService executorService, CloudCredentials credentials, URI baseUri, String apiVersion, int longRunningOperationInitialTimeout, int longRunningOperationRetryTimeout) {
        this(httpBuilder, executorService);
        this.credentials = credentials;
        this.baseUri = baseUri;
        this.apiVersion = apiVersion;
        this.longRunningOperationInitialTimeout = longRunningOperationInitialTimeout;
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeout;
    }

    protected SubscriptionClientImpl newInstance(HttpClientBuilder httpBuilder, ExecutorService executorService) {
        return new SubscriptionClientImpl(httpBuilder, executorService, this.getCredentials(), this.getBaseUri(), this.getApiVersion(), this.getLongRunningOperationInitialTimeout(), this.getLongRunningOperationRetryTimeout());
    }
}

