/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.subscriptions;

import com.microsoft.azure.subscriptions.SubscriptionClientImpl;
import com.microsoft.azure.subscriptions.SubscriptionOperations;
import com.microsoft.azure.subscriptions.models.GetSubscriptionResult;
import com.microsoft.azure.subscriptions.models.Subscription;
import com.microsoft.azure.subscriptions.models.SubscriptionListResult;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;

public class SubscriptionOperationsImpl
implements ServiceOperations<SubscriptionClientImpl>,
SubscriptionOperations {
    private SubscriptionClientImpl client;

    SubscriptionOperationsImpl(SubscriptionClientImpl client) {
        this.client = client;
    }

    public SubscriptionClientImpl getClient() {
        return this.client;
    }

    @Override
    public Future<GetSubscriptionResult> getAsync(final String subscriptionId) {
        return this.getClient().getExecutorService().submit(new Callable<GetSubscriptionResult>(){

            @Override
            public GetSubscriptionResult call() throws Exception {
                return SubscriptionOperationsImpl.this.get(subscriptionId);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSubscriptionResult get(String subscriptionId) throws IOException, ServiceException {
        String baseUrl;
        if (subscriptionId == null) {
            throw new NullPointerException("subscriptionId");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("subscriptionId", subscriptionId);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        url = url + URLEncoder.encode(subscriptionId, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2014-04-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            GetSubscriptionResult result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new GetSubscriptionResult();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                String responseDocContent = IOUtils.toString((InputStream)responseContent);
                if (!(responseDocContent == null) && responseDocContent.length() > 0) {
                    responseDoc = objectMapper.readTree(responseDocContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode stateValue;
                    JsonNode displayNameValue;
                    JsonNode subscriptionIdValue;
                    Subscription subscriptionInstance = new Subscription();
                    result.setSubscription(subscriptionInstance);
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && !(idValue instanceof NullNode)) {
                        String idInstance = idValue.getTextValue();
                        subscriptionInstance.setId(idInstance);
                    }
                    if ((subscriptionIdValue = responseDoc.get("subscriptionId")) != null && !(subscriptionIdValue instanceof NullNode)) {
                        String subscriptionIdInstance = subscriptionIdValue.getTextValue();
                        subscriptionInstance.setSubscriptionId(subscriptionIdInstance);
                    }
                    if ((displayNameValue = responseDoc.get("displayName")) != null && !(displayNameValue instanceof NullNode)) {
                        String displayNameInstance = displayNameValue.getTextValue();
                        subscriptionInstance.setDisplayName(displayNameInstance);
                    }
                    if ((stateValue = responseDoc.get("state")) != null && !(stateValue instanceof NullNode)) {
                        String stateInstance = stateValue.getTextValue();
                        subscriptionInstance.setState(stateInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            GetSubscriptionResult getSubscriptionResult = result;
            return getSubscriptionResult;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<SubscriptionListResult> listAsync() {
        return this.getClient().getExecutorService().submit(new Callable<SubscriptionListResult>(){

            @Override
            public SubscriptionListResult call() throws Exception {
                return SubscriptionOperationsImpl.this.list();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SubscriptionListResult list() throws IOException, ServiceException {
        String baseUrl;
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap tracingParameters = new HashMap();
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2014-04-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            SubscriptionListResult result = null;
            if (statusCode == 200) {
                JsonNode valueArray;
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new SubscriptionListResult();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                String responseDocContent = IOUtils.toString((InputStream)responseContent);
                if (!(responseDocContent == null) && responseDocContent.length() > 0) {
                    responseDoc = objectMapper.readTree(responseDocContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode) && (valueArray = responseDoc.get("value")) != null && !(valueArray instanceof NullNode)) {
                    for (JsonNode valueValue : (ArrayNode)valueArray) {
                        JsonNode stateValue;
                        JsonNode displayNameValue;
                        JsonNode subscriptionIdValue;
                        Subscription subscriptionInstance = new Subscription();
                        result.getSubscriptions().add(subscriptionInstance);
                        JsonNode idValue = valueValue.get("id");
                        if (idValue != null && !(idValue instanceof NullNode)) {
                            String idInstance = idValue.getTextValue();
                            subscriptionInstance.setId(idInstance);
                        }
                        if ((subscriptionIdValue = valueValue.get("subscriptionId")) != null && !(subscriptionIdValue instanceof NullNode)) {
                            String subscriptionIdInstance = subscriptionIdValue.getTextValue();
                            subscriptionInstance.setSubscriptionId(subscriptionIdInstance);
                        }
                        if ((displayNameValue = valueValue.get("displayName")) != null && !(displayNameValue instanceof NullNode)) {
                            String displayNameInstance = displayNameValue.getTextValue();
                            subscriptionInstance.setDisplayName(displayNameInstance);
                        }
                        if ((stateValue = valueValue.get("state")) == null || stateValue instanceof NullNode) continue;
                        String stateInstance = stateValue.getTextValue();
                        subscriptionInstance.setState(stateInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            SubscriptionListResult subscriptionListResult = result;
            return subscriptionListResult;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}

