/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources;

import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.apigeneration.LangMethodDefinition;
import com.microsoft.azure.management.apigeneration.Method;
import com.microsoft.azure.management.resources.Dependency;
import com.microsoft.azure.management.resources.DeploymentExportResult;
import com.microsoft.azure.management.resources.DeploymentMode;
import com.microsoft.azure.management.resources.DeploymentOperations;
import com.microsoft.azure.management.resources.ParametersLink;
import com.microsoft.azure.management.resources.Provider;
import com.microsoft.azure.management.resources.ResourceGroup;
import com.microsoft.azure.management.resources.TemplateLink;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.management.resources.fluentcore.arm.models.GroupableResource;
import com.microsoft.azure.management.resources.fluentcore.model.Appliable;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.Refreshable;
import com.microsoft.azure.management.resources.fluentcore.model.Updatable;
import com.microsoft.azure.management.resources.fluentcore.model.Wrapper;
import com.microsoft.azure.management.resources.implementation.DeploymentExtendedInner;
import java.io.IOException;
import java.util.List;
import org.joda.time.DateTime;

@Fluent
public interface Deployment
extends Refreshable<Deployment>,
Updatable<Update>,
Wrapper<DeploymentExtendedInner> {
    public String resourceGroupName();

    public String name();

    public String provisioningState();

    public String correlationId();

    public DateTime timestamp();

    public Object outputs();

    public List<Provider> providers();

    public List<Dependency> dependencies();

    public Object template();

    public TemplateLink templateLink();

    public Object parameters();

    public ParametersLink parametersLink();

    public DeploymentMode mode();

    @LangMethodDefinition(AsType=LangMethodDefinition.LangMethodType.Property)
    public DeploymentOperations deploymentOperations();

    public void cancel();

    @Method
    public DeploymentExportResult exportTemplate();

    public static interface Update
    extends Appliable<Deployment>,
    UpdateStages.WithTemplate,
    UpdateStages.WithParameters,
    UpdateStages.WithMode {
    }

    public static interface UpdateStages {

        public static interface WithParameters {
            public Update withParameters(Object var1);

            public Update withParameters(String var1) throws IOException;

            public Update withParametersLink(String var1, String var2);
        }

        public static interface WithTemplate {
            public Update withTemplate(Object var1);

            public Update withTemplate(String var1) throws IOException;

            public Update withTemplateLink(String var1, String var2);
        }

        public static interface WithMode {
            public Update withMode(DeploymentMode var1);
        }
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<Deployment> {
            @Method
            public Deployment beginCreate();
        }

        public static interface WithMode {
            public WithCreate withMode(DeploymentMode var1);
        }

        public static interface WithParameters {
            public WithMode withParameters(Object var1);

            public WithMode withParameters(String var1) throws IOException;

            public WithMode withParametersLink(String var1, String var2);
        }

        public static interface WithTemplate {
            public WithParameters withTemplate(Object var1);

            public WithParameters withTemplate(String var1) throws IOException;

            public WithParameters withTemplateLink(String var1, String var2);
        }

        public static interface WithGroup
        extends GroupableResource.DefinitionStages.WithExistingResourceGroup<WithTemplate> {
            public WithTemplate withNewResourceGroup(String var1, Region var2);

            public WithTemplate withNewResourceGroup(Creatable<ResourceGroup> var1);
        }

        public static interface Blank
        extends WithGroup {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithGroup,
    DefinitionStages.WithTemplate,
    DefinitionStages.WithParameters,
    DefinitionStages.WithMode,
    DefinitionStages.WithCreate {
    }
}

