/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources.fluentcore.arm;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ResourceUtils {
    private ResourceUtils() {
    }

    public static String groupFromResourceId(String id) {
        return ResourceUtils.extractFromResourceId(id, "resource[gG]roups");
    }

    public static String resourceProviderFromResourceId(String id) {
        return ResourceUtils.extractFromResourceId(id, "providers");
    }

    public static String resourceTypeFromResourceId(String id) {
        String[] splits = id.split("/");
        return splits[splits.length - 2];
    }

    public static String parentResourcePathFromResourceId(String id) {
        return id.replace("/" + ResourceUtils.resourceTypeFromResourceId(id) + "/" + ResourceUtils.nameFromResourceId(id), "");
    }

    public static String extractFromResourceId(String id, String identifier) {
        if (id == null || identifier == null) {
            return id;
        }
        Pattern pattern = Pattern.compile(identifier + "/[-\\w\\._]+");
        Matcher matcher = pattern.matcher(id);
        if (matcher.find()) {
            return matcher.group().split("/")[1];
        }
        return null;
    }

    public static String nameFromResourceId(String id) {
        String[] splits = id.split("/");
        return splits[splits.length - 1];
    }
}

