/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation;

import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.CreatableWrappersImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.models.Resource;
import com.microsoft.azure.management.resources.fluentcore.collection.SupportsBatchCreation;
import com.microsoft.azure.management.resources.fluentcore.collection.SupportsDeleting;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.CreatedResources;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.CreatableUpdatableImpl;
import com.microsoft.rest.ServiceCall;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import rx.Observable;
import rx.functions.Func1;
import rx.observables.BlockingObservable;

public abstract class CreatableResourcesImpl<T extends Resource, ImplT extends T, InnerT>
extends CreatableWrappersImpl<T, ImplT, InnerT>
implements SupportsBatchCreation<T>,
SupportsDeleting {
    protected CreatableResourcesImpl() {
    }

    @Override
    @SafeVarargs
    public final CreatedResources<T> create(Creatable<T> ... creatables) {
        return (CreatedResources)BlockingObservable.from(this.createAsync(creatables)).single();
    }

    @Override
    public final CreatedResources<T> create(List<Creatable<T>> creatables) {
        return (CreatedResources)BlockingObservable.from(this.createAsync(creatables)).single();
    }

    @Override
    @SafeVarargs
    public final Observable<CreatedResources<T>> createAsync(Creatable<T> ... creatables) {
        CreatableUpdatableResourcesRootImpl rootResource = new CreatableUpdatableResourcesRootImpl();
        rootResource.addCreatableDependencies(creatables);
        return rootResource.createAsync().map(new Func1<CreatableUpdatableResourcesRoot<T>, CreatedResources<T>>(){

            public CreatedResources<T> call(CreatableUpdatableResourcesRoot<T> tCreatableUpdatableResourcesRoot) {
                return new CreatedResourcesImpl(tCreatableUpdatableResourcesRoot);
            }
        });
    }

    @Override
    public final Observable<CreatedResources<T>> createAsync(List<Creatable<T>> creatables) {
        CreatableUpdatableResourcesRootImpl rootResource = new CreatableUpdatableResourcesRootImpl();
        rootResource.addCreatableDependencies(creatables);
        return rootResource.createAsync().map(new Func1<CreatableUpdatableResourcesRoot<T>, CreatedResources<T>>(){

            public CreatedResources<T> call(CreatableUpdatableResourcesRoot<T> tCreatableUpdatableResourcesRoot) {
                return new CreatedResourcesImpl(tCreatableUpdatableResourcesRoot);
            }
        });
    }

    @Override
    @SafeVarargs
    public final ServiceCall<CreatedResources<T>> createAsync(ServiceCallback<CreatedResources<T>> callback, Creatable<T> ... creatables) {
        return ServiceCall.create((Observable)this.createAsync(creatables).map(new Func1<CreatedResources<T>, ServiceResponse<CreatedResources<T>>>(){

            public ServiceResponse<CreatedResources<T>> call(CreatedResources<T> ts) {
                return new ServiceResponse(ts, null);
            }
        }), callback);
    }

    @Override
    public final ServiceCall<CreatedResources<T>> createAsync(ServiceCallback<CreatedResources<T>> callback, List<Creatable<T>> creatables) {
        return ServiceCall.create((Observable)this.createAsync(creatables).map(new Func1<CreatedResources<T>, ServiceResponse<CreatedResources<T>>>(){

            public ServiceResponse<CreatedResources<T>> call(CreatedResources<T> ts) {
                return new ServiceResponse(ts, null);
            }
        }), callback);
    }

    @Override
    public void delete(String id) {
        this.deleteAsync(id).toBlocking().subscribe();
    }

    @Override
    public ServiceCall<Void> deleteAsync(String id, ServiceCallback<Void> callback) {
        return ServiceCall.create((Observable)this.deleteAsync(id).map((Func1)new Func1<Void, ServiceResponse<Void>>(){

            public ServiceResponse<Void> call(Void aVoid) {
                return new ServiceResponse((Object)aVoid, null);
            }
        }), callback);
    }

    private class CreatableUpdatableResourcesRootImpl<ResourceT extends Resource>
    extends CreatableUpdatableImpl<CreatableUpdatableResourcesRoot<ResourceT>, Object, CreatableUpdatableResourcesRootImpl<ResourceT>>
    implements CreatableUpdatableResourcesRoot<ResourceT> {
        private List<String> keys;

        CreatableUpdatableResourcesRootImpl() {
            super("CreatableUpdatableResourcesRoot", null);
            this.keys = new ArrayList<String>();
        }

        @Override
        public List<ResourceT> createdTopLevelResources() {
            ArrayList<Resource> resources = new ArrayList<Resource>();
            for (String resourceKey : this.keys) {
                resources.add((Resource)this.creatorUpdatorTaskGroup().createdResource(resourceKey));
            }
            return Collections.unmodifiableList(resources);
        }

        @Override
        public Resource createdRelatedResource(String key) {
            return (Resource)this.creatorUpdatorTaskGroup().createdResource(key);
        }

        void addCreatableDependencies(Creatable<T> ... creatables) {
            for (Creatable item : creatables) {
                this.keys.add(item.key());
                this.addCreatableDependency(item);
            }
        }

        void addCreatableDependencies(List<Creatable<T>> creatables) {
            for (Creatable item : creatables) {
                this.keys.add(item.key());
                this.addCreatableDependency(item);
            }
        }

        @Override
        public Observable<CreatableUpdatableResourcesRoot<ResourceT>> createResourceAsync() {
            return Observable.just((Object)this);
        }

        @Override
        public Observable<CreatableUpdatableResourcesRoot<ResourceT>> updateResourceAsync() {
            return this.createResourceAsync();
        }

        @Override
        public boolean isInCreateMode() {
            return true;
        }

        @Override
        public CreatableUpdatableResourcesRoot<ResourceT> refresh() {
            return null;
        }

        @Override
        public String id() {
            return null;
        }

        @Override
        public String type() {
            return null;
        }

        @Override
        public String regionName() {
            return null;
        }

        @Override
        public Region region() {
            return null;
        }

        @Override
        public Map<String, String> tags() {
            return null;
        }
    }

    static interface CreatableUpdatableResourcesRoot<ResourceT extends Resource>
    extends Resource {
        public List<ResourceT> createdTopLevelResources();

        public Resource createdRelatedResource(String var1);
    }

    private class CreatedResourcesImpl<ResourceT extends Resource>
    implements CreatedResources<ResourceT> {
        private CreatableUpdatableResourcesRoot<ResourceT> creatableUpdatableResourcesRoot;
        private final List<ResourceT> list;

        CreatedResourcesImpl(CreatableUpdatableResourcesRoot<ResourceT> creatableUpdatableResourcesRoot) {
            this.creatableUpdatableResourcesRoot = creatableUpdatableResourcesRoot;
            this.list = this.creatableUpdatableResourcesRoot.createdTopLevelResources();
        }

        @Override
        public Resource createdRelatedResource(String key) {
            return this.creatableUpdatableResourcesRoot.createdRelatedResource(key);
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.list.contains(o);
        }

        @Override
        public Iterator<ResourceT> iterator() {
            return this.list.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.list.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.list.toArray(a);
        }

        @Override
        public boolean add(ResourceT resourceT) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.list.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends ResourceT> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int index, Collection<? extends ResourceT> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ResourceT get(int index) {
            return (ResourceT)((Resource)this.list.get(index));
        }

        @Override
        public ResourceT set(int index, ResourceT element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int index, ResourceT element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ResourceT remove(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int indexOf(Object o) {
            return this.list.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.list.lastIndexOf(o);
        }

        @Override
        public ListIterator<ResourceT> listIterator() {
            return this.list.listIterator();
        }

        @Override
        public ListIterator<ResourceT> listIterator(int index) {
            return this.list.listIterator(index);
        }

        @Override
        public List<ResourceT> subList(int fromIndex, int toIndex) {
            return this.list.subList(fromIndex, toIndex);
        }
    }
}

