/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation;

import com.microsoft.azure.management.resources.fluentcore.arm.models.ExternalChildResource;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import rx.Observable;
import rx.exceptions.CompositeException;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.functions.Action2;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.subjects.PublishSubject;

public abstract class ExternalChildResourcesImpl<FluentModelTImpl extends ExternalChildResourceImpl<FluentModelT, InnerModelT, ParentImplT, ParentT>, FluentModelT extends ExternalChildResource<FluentModelT, ParentT>, InnerModelT, ParentImplT extends ParentT, ParentT> {
    private final ParentImplT parent;
    private final String childResourceName;
    private ConcurrentMap<String, FluentModelTImpl> collection = new ConcurrentHashMap<String, FluentModelTImpl>();

    protected ExternalChildResourcesImpl(ParentImplT parent, String childResourceName) {
        this.parent = parent;
        this.childResourceName = childResourceName;
    }

    public void refresh() {
        this.initializeCollection();
    }

    public Observable<FluentModelTImpl> commitAsync() {
        final ExternalChildResourcesImpl self = this;
        ArrayList<ExternalChildResourceImpl> items = new ArrayList<ExternalChildResourceImpl>();
        for (ExternalChildResourceImpl item : this.collection.values()) {
            items.add(item);
        }
        final List exceptionsList = Collections.synchronizedList(new ArrayList());
        Observable deleteStream = Observable.from(items).filter(new Func1<FluentModelTImpl, Boolean>(){

            public Boolean call(FluentModelTImpl childResource) {
                return ((ExternalChildResourceImpl)childResource).pendingOperation() == ExternalChildResourceImpl.PendingOperation.ToBeRemoved;
            }
        }).flatMap(new Func1<FluentModelTImpl, Observable<FluentModelTImpl>>(){

            public Observable<FluentModelTImpl> call(FluentModelTImpl childResource) {
                return ((ExternalChildResourceImpl)childResource).deleteAsync().map(new Func1<Void, FluentModelTImpl>((ExternalChildResourceImpl)childResource){
                    final /* synthetic */ ExternalChildResourceImpl val$childResource;
                    {
                        this.val$childResource = externalChildResourceImpl;
                    }

                    public FluentModelTImpl call(Void response) {
                        return this.val$childResource;
                    }
                }).doOnNext(new Action1<FluentModelTImpl>(){

                    public void call(FluentModelTImpl childResource) {
                        ((ExternalChildResourceImpl)childResource).setPendingOperation(ExternalChildResourceImpl.PendingOperation.None);
                        self.collection.remove(((ExternalChildResourceImpl)childResource).name());
                    }
                }).onErrorResumeNext(new Func1<Throwable, Observable<FluentModelTImpl>>(){

                    public Observable<FluentModelTImpl> call(Throwable throwable) {
                        exceptionsList.add(throwable);
                        return Observable.empty();
                    }
                });
            }
        });
        Observable createStream = Observable.from(items).filter(new Func1<FluentModelTImpl, Boolean>(){

            public Boolean call(FluentModelTImpl childResource) {
                return ((ExternalChildResourceImpl)childResource).pendingOperation() == ExternalChildResourceImpl.PendingOperation.ToBeCreated;
            }
        }).flatMap(new Func1<FluentModelTImpl, Observable<FluentModelTImpl>>(){

            public Observable<FluentModelTImpl> call(FluentModelTImpl childResource) {
                return ((ExternalChildResourceImpl)childResource).createAsync().map(new Func1<FluentModelT, FluentModelTImpl>((ExternalChildResourceImpl)childResource){
                    final /* synthetic */ ExternalChildResourceImpl val$childResource;
                    {
                        this.val$childResource = externalChildResourceImpl;
                    }

                    public FluentModelTImpl call(FluentModelT fluentModelT) {
                        return this.val$childResource;
                    }
                }).doOnNext(new Action1<FluentModelTImpl>((ExternalChildResourceImpl)childResource){
                    final /* synthetic */ ExternalChildResourceImpl val$childResource;
                    {
                        this.val$childResource = externalChildResourceImpl;
                    }

                    public void call(FluentModelTImpl fluentModelT) {
                        this.val$childResource.setPendingOperation(ExternalChildResourceImpl.PendingOperation.None);
                    }
                }).onErrorResumeNext(new Func1<Throwable, Observable<? extends FluentModelTImpl>>((ExternalChildResourceImpl)childResource){
                    final /* synthetic */ ExternalChildResourceImpl val$childResource;
                    {
                        this.val$childResource = externalChildResourceImpl;
                    }

                    public Observable<FluentModelTImpl> call(Throwable throwable) {
                        self.collection.remove(this.val$childResource.name());
                        exceptionsList.add(throwable);
                        return Observable.empty();
                    }
                });
            }
        });
        Observable updateStream = Observable.from(items).filter(new Func1<FluentModelTImpl, Boolean>(){

            public Boolean call(FluentModelTImpl childResource) {
                return ((ExternalChildResourceImpl)childResource).pendingOperation() == ExternalChildResourceImpl.PendingOperation.ToBeUpdated;
            }
        }).flatMap(new Func1<FluentModelTImpl, Observable<FluentModelTImpl>>(){

            public Observable<FluentModelTImpl> call(FluentModelTImpl childResource) {
                return ((ExternalChildResourceImpl)childResource).updateAsync().map(new Func1<FluentModelT, FluentModelTImpl>((ExternalChildResourceImpl)childResource){
                    final /* synthetic */ ExternalChildResourceImpl val$childResource;
                    {
                        this.val$childResource = externalChildResourceImpl;
                    }

                    public FluentModelTImpl call(FluentModelT e) {
                        return this.val$childResource;
                    }
                }).doOnNext(new Action1<FluentModelTImpl>(){

                    public void call(FluentModelTImpl childResource) {
                        ((ExternalChildResourceImpl)childResource).setPendingOperation(ExternalChildResourceImpl.PendingOperation.None);
                    }
                }).onErrorResumeNext(new Func1<Throwable, Observable<? extends FluentModelTImpl>>(){

                    public Observable<FluentModelTImpl> call(Throwable throwable) {
                        exceptionsList.add(throwable);
                        return Observable.empty();
                    }
                });
            }
        });
        final PublishSubject aggregatedErrorStream = PublishSubject.create();
        Observable operationsStream = Observable.merge((Observable)deleteStream, (Observable)createStream, (Observable)updateStream).doOnTerminate(new Action0(){

            public void call() {
                if (exceptionsList.isEmpty()) {
                    aggregatedErrorStream.onCompleted();
                } else {
                    aggregatedErrorStream.onError((Throwable)new CompositeException((Collection)exceptionsList));
                }
            }
        });
        Observable stream = Observable.concat((Observable)operationsStream, (Observable)aggregatedErrorStream);
        return stream;
    }

    public Observable<List<FluentModelTImpl>> commitAndGetAllAsync() {
        return this.commitAsync().collect(new Func0<List<FluentModelTImpl>>(){

            public List<FluentModelTImpl> call() {
                return new ArrayList();
            }
        }, new Action2<List<FluentModelTImpl>, FluentModelTImpl>(){

            public void call(List<FluentModelTImpl> state, FluentModelTImpl item) {
                state.add(item);
            }
        });
    }

    protected ParentImplT parent() {
        return this.parent;
    }

    protected Map<String, FluentModelTImpl> collection() {
        return this.collection;
    }

    protected FluentModelTImpl prepareDefine(String name) {
        if (this.find(name) != null) {
            throw new IllegalArgumentException("A child resource ('" + this.childResourceName + "') with name  '" + name + "' already exists");
        }
        FluentModelTImpl childResource = this.newChildResource(name);
        ((ExternalChildResourceImpl)childResource).setPendingOperation(ExternalChildResourceImpl.PendingOperation.ToBeCreated);
        return childResource;
    }

    protected FluentModelTImpl prepareUpdate(String name) {
        FluentModelTImpl childResource = this.find(name);
        if (childResource == null || ((ExternalChildResourceImpl)childResource).pendingOperation() == ExternalChildResourceImpl.PendingOperation.ToBeCreated) {
            throw new IllegalArgumentException("A child resource ('" + this.childResourceName + "') with name  '" + name + "' not found");
        }
        if (((ExternalChildResourceImpl)childResource).pendingOperation() == ExternalChildResourceImpl.PendingOperation.ToBeRemoved) {
            throw new IllegalArgumentException("A child resource ('" + this.childResourceName + "') with name  '" + name + "' is marked for deletion");
        }
        ((ExternalChildResourceImpl)childResource).setPendingOperation(ExternalChildResourceImpl.PendingOperation.ToBeUpdated);
        return childResource;
    }

    protected void prepareRemove(String name) {
        FluentModelTImpl childResource = this.find(name);
        if (childResource == null || ((ExternalChildResourceImpl)childResource).pendingOperation() == ExternalChildResourceImpl.PendingOperation.ToBeCreated) {
            throw new IllegalArgumentException("A child resource ('" + this.childResourceName + "') with name  '" + name + "' not found");
        }
        ((ExternalChildResourceImpl)childResource).setPendingOperation(ExternalChildResourceImpl.PendingOperation.ToBeRemoved);
    }

    protected void addChildResource(FluentModelTImpl childResource) {
        this.collection.put(((ExternalChildResourceImpl)childResource).name(), childResource);
    }

    protected void initializeCollection() {
        this.collection.clear();
        for (ExternalChildResourceImpl childResource : this.listChildResources()) {
            this.collection.put(childResource.name(), childResource);
        }
    }

    protected abstract List<FluentModelTImpl> listChildResources();

    protected abstract FluentModelTImpl newChildResource(String var1);

    private FluentModelTImpl find(String name) {
        for (Map.Entry entry : this.collection.entrySet()) {
            if (!((String)entry.getKey()).equalsIgnoreCase(name)) continue;
            return (FluentModelTImpl)((ExternalChildResourceImpl)entry.getValue());
        }
        return null;
    }
}

