/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation;

import com.microsoft.azure.Resource;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.SupportsDeletingByGroup;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.SupportsGettingByGroup;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.SupportsGettingById;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.CreatableResourcesImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.GroupableResource;
import com.microsoft.rest.ServiceCall;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceResponse;
import rx.Observable;
import rx.functions.Func1;

public abstract class GroupableResourcesImpl<T extends GroupableResource, ImplT extends T, InnerT extends Resource, InnerCollectionT, ManagerT extends ManagerBase>
extends CreatableResourcesImpl<T, ImplT, InnerT>
implements SupportsGettingById<T>,
SupportsGettingByGroup<T>,
SupportsDeletingByGroup {
    protected final InnerCollectionT innerCollection;
    protected final ManagerT myManager;

    protected GroupableResourcesImpl(InnerCollectionT innerCollection, ManagerT manager) {
        this.innerCollection = innerCollection;
        this.myManager = manager;
    }

    @Override
    public abstract T getByGroup(String var1, String var2);

    @Override
    public T getById(String id) {
        return (T)this.getByGroup(ResourceUtils.groupFromResourceId(id), ResourceUtils.nameFromResourceId(id));
    }

    @Override
    public void delete(String groupName, String name) {
        this.deleteAsync(groupName, name).toBlocking().subscribe();
    }

    @Override
    public ServiceCall<Void> deleteAsync(String groupName, String name, ServiceCallback<Void> callback) {
        return ServiceCall.create((Observable)this.deleteAsync(groupName, name).map((Func1)new Func1<Void, ServiceResponse<Void>>(){

            public ServiceResponse<Void> call(Void aVoid) {
                return new ServiceResponse((Object)aVoid, null);
            }
        }), callback);
    }

    @Override
    public Observable<Void> deleteAsync(String id) {
        return this.deleteAsync(ResourceUtils.groupFromResourceId(id), ResourceUtils.nameFromResourceId(id));
    }
}

