/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources.fluentcore.arm.implementation;

import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.RestClient;
import com.microsoft.azure.credentials.AzureTokenCredentials;
import com.microsoft.azure.management.resources.fluentcore.arm.AzureConfigurable;
import com.microsoft.rest.credentials.ServiceClientCredentials;
import java.lang.reflect.Field;
import java.net.Proxy;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.logging.HttpLoggingInterceptor;

public class AzureConfigurableImpl<T extends AzureConfigurable<T>>
implements AzureConfigurable<T> {
    protected RestClient.Builder.Buildable restClientBuilder = AzureEnvironment.AZURE.newRestClientBuilder();

    protected AzureConfigurableImpl() {
    }

    @Override
    public T withLogLevel(HttpLoggingInterceptor.Level level) {
        this.restClientBuilder = this.restClientBuilder.withLogLevel(level);
        return (T)this;
    }

    @Override
    public T withInterceptor(Interceptor interceptor) {
        this.restClientBuilder = this.restClientBuilder.withInterceptor(interceptor);
        return (T)this;
    }

    @Override
    public T withUserAgent(String userAgent) {
        this.restClientBuilder = this.restClientBuilder.withUserAgent(userAgent);
        return (T)this;
    }

    @Override
    public T withReadTimeout(long timeout, TimeUnit unit) {
        this.restClientBuilder = this.restClientBuilder.withReadTimeout(timeout, unit);
        return (T)this;
    }

    @Override
    public T withConnectionTimeout(long timeout, TimeUnit unit) {
        this.restClientBuilder = this.restClientBuilder.withConnectionTimeout(timeout, unit);
        return (T)this;
    }

    @Override
    public T withMaxIdleConnections(int maxIdleConnections) {
        this.restClientBuilder = this.restClientBuilder.withMaxIdleConnections(maxIdleConnections);
        return (T)this;
    }

    @Override
    public T withCallbackExecutor(Executor executor) {
        this.restClientBuilder = this.restClientBuilder.withCallbackExecutor(executor);
        return (T)this;
    }

    @Override
    public T withProxy(Proxy proxy) {
        this.restClientBuilder = this.restClientBuilder.withProxy(proxy);
        return (T)this;
    }

    protected RestClient buildRestClient(AzureTokenCredentials credentials) {
        this.restClientBuilder = this.modifyBaseUrl(this.restClientBuilder, credentials.getEnvironment().getBaseUrl());
        return this.restClientBuilder.withCredentials((ServiceClientCredentials)credentials).build();
    }

    protected RestClient buildRestClientForGraph(AzureTokenCredentials credentials) {
        this.restClientBuilder = this.modifyBaseUrl(this.restClientBuilder, credentials.getEnvironment().getGraphEndpoint());
        return this.restClientBuilder.withCredentials((ServiceClientCredentials)credentials).build();
    }

    private RestClient.Builder.Buildable modifyBaseUrl(RestClient.Builder.Buildable builder, String baseUrl) {
        try {
            Field enclosed = builder.getClass().getDeclaredField("this$0");
            enclosed.setAccessible(true);
            Object enclosedObj = enclosed.get(builder);
            Field url = enclosedObj.getClass().getDeclaredField("baseUrl");
            url.setAccessible(true);
            url.set(enclosedObj, baseUrl);
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            // empty catch block
        }
        return builder;
    }
}

