/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources.fluentcore.arm.models.implementation;

import com.microsoft.azure.management.resources.ResourceGroup;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.GroupableResource;
import com.microsoft.azure.management.resources.fluentcore.arm.models.Resource;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.ResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;

public abstract class GroupableResourceImpl<FluentModelT extends Resource, InnerModelT extends com.microsoft.azure.Resource, FluentModelImplT extends GroupableResourceImpl<FluentModelT, InnerModelT, FluentModelImplT, ManagerT>, ManagerT extends ManagerBase>
extends ResourceImpl<FluentModelT, InnerModelT, FluentModelImplT>
implements GroupableResource {
    protected final ManagerT myManager;
    protected Creatable<ResourceGroup> creatableGroup;
    private String groupName;

    protected GroupableResourceImpl(String name, InnerModelT innerObject, ManagerT manager) {
        super(name, innerObject);
        this.myManager = manager;
    }

    protected String resourceIdBase() {
        return "/subscriptions/" + ((ManagerBase)this.myManager).subscriptionId() + "/resourceGroups/" + this.resourceGroupName();
    }

    @Override
    public String resourceGroupName() {
        if (this.groupName == null) {
            return ResourceUtils.groupFromResourceId(this.id());
        }
        return this.groupName;
    }

    public final FluentModelImplT withNewResourceGroup(String groupName) {
        return this.withNewResourceGroup((Creatable)((ResourceGroup.DefinitionStages.Blank)((ManagerBase)this.myManager).resourceManager().resourceGroups().define(groupName)).withRegion(this.regionName()));
    }

    public final FluentModelImplT withNewResourceGroup() {
        return this.withNewResourceGroup(this.name() + "group");
    }

    public final FluentModelImplT withNewResourceGroup(Creatable<ResourceGroup> creatable) {
        this.groupName = creatable.name();
        this.creatableGroup = creatable;
        this.addCreatableDependency(creatable);
        return (FluentModelImplT)this;
    }

    public final FluentModelImplT withExistingResourceGroup(String groupName) {
        this.groupName = groupName;
        return (FluentModelImplT)this;
    }

    public final FluentModelImplT withExistingResourceGroup(ResourceGroup group) {
        return this.withExistingResourceGroup(group.name());
    }
}

