/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources.implementation;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.azure.management.resources.Dependency;
import com.microsoft.azure.management.resources.Deployment;
import com.microsoft.azure.management.resources.DeploymentExportResult;
import com.microsoft.azure.management.resources.DeploymentMode;
import com.microsoft.azure.management.resources.DeploymentOperations;
import com.microsoft.azure.management.resources.DeploymentProperties;
import com.microsoft.azure.management.resources.DeploymentPropertiesExtended;
import com.microsoft.azure.management.resources.ParametersLink;
import com.microsoft.azure.management.resources.Provider;
import com.microsoft.azure.management.resources.ResourceGroup;
import com.microsoft.azure.management.resources.TemplateLink;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.CreatableUpdatableImpl;
import com.microsoft.azure.management.resources.implementation.DeploymentExportResultImpl;
import com.microsoft.azure.management.resources.implementation.DeploymentExportResultInner;
import com.microsoft.azure.management.resources.implementation.DeploymentExtendedInner;
import com.microsoft.azure.management.resources.implementation.DeploymentInner;
import com.microsoft.azure.management.resources.implementation.DeploymentOperationsImpl;
import com.microsoft.azure.management.resources.implementation.DeploymentOperationsInner;
import com.microsoft.azure.management.resources.implementation.DeploymentsInner;
import com.microsoft.azure.management.resources.implementation.ProviderImpl;
import com.microsoft.azure.management.resources.implementation.ProviderInner;
import com.microsoft.azure.management.resources.implementation.ResourceManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;
import rx.Observable;

final class DeploymentImpl
extends CreatableUpdatableImpl<Deployment, DeploymentExtendedInner, DeploymentImpl>
implements Deployment,
Deployment.Definition,
Deployment.Update {
    private final DeploymentsInner client;
    private final DeploymentOperationsInner deploymentOperationsClient;
    private final ResourceManager resourceManager;
    private String resourceGroupName;
    private Creatable<ResourceGroup> creatableResourceGroup;
    private ObjectMapper objectMapper;

    DeploymentImpl(DeploymentExtendedInner innerModel, DeploymentsInner client, DeploymentOperationsInner deploymentOperationsClient, ResourceManager resourceManager) {
        super(innerModel.name(), innerModel);
        this.client = client;
        this.deploymentOperationsClient = deploymentOperationsClient;
        this.resourceGroupName = ResourceUtils.groupFromResourceId(innerModel.id());
        this.resourceManager = resourceManager;
        this.objectMapper = new ObjectMapper();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public String name() {
        return ((DeploymentExtendedInner)this.inner()).name();
    }

    @Override
    public String provisioningState() {
        if (((DeploymentExtendedInner)this.inner()).properties() == null) {
            return null;
        }
        return ((DeploymentExtendedInner)this.inner()).properties().provisioningState();
    }

    @Override
    public String correlationId() {
        if (((DeploymentExtendedInner)this.inner()).properties() == null) {
            return null;
        }
        return ((DeploymentExtendedInner)this.inner()).properties().correlationId();
    }

    @Override
    public DateTime timestamp() {
        if (((DeploymentExtendedInner)this.inner()).properties() == null) {
            return null;
        }
        return ((DeploymentExtendedInner)this.inner()).properties().timestamp();
    }

    @Override
    public Object outputs() {
        if (((DeploymentExtendedInner)this.inner()).properties() == null) {
            return null;
        }
        return ((DeploymentExtendedInner)this.inner()).properties().outputs();
    }

    @Override
    public List<Provider> providers() {
        if (((DeploymentExtendedInner)this.inner()).properties() == null) {
            return null;
        }
        ArrayList<Provider> providers = new ArrayList<Provider>();
        for (ProviderInner inner : ((DeploymentExtendedInner)this.inner()).properties().providers()) {
            providers.add(new ProviderImpl(inner));
        }
        return providers;
    }

    @Override
    public List<Dependency> dependencies() {
        if (((DeploymentExtendedInner)this.inner()).properties() == null) {
            return null;
        }
        return ((DeploymentExtendedInner)this.inner()).properties().dependencies();
    }

    @Override
    public Object template() {
        if (((DeploymentExtendedInner)this.inner()).properties() == null) {
            return null;
        }
        return ((DeploymentExtendedInner)this.inner()).properties().template();
    }

    @Override
    public TemplateLink templateLink() {
        if (((DeploymentExtendedInner)this.inner()).properties() == null) {
            return null;
        }
        return ((DeploymentExtendedInner)this.inner()).properties().templateLink();
    }

    @Override
    public Object parameters() {
        if (((DeploymentExtendedInner)this.inner()).properties() == null) {
            return null;
        }
        return ((DeploymentExtendedInner)this.inner()).properties().parameters();
    }

    @Override
    public ParametersLink parametersLink() {
        if (((DeploymentExtendedInner)this.inner()).properties() == null) {
            return null;
        }
        return ((DeploymentExtendedInner)this.inner()).properties().parametersLink();
    }

    @Override
    public DeploymentMode mode() {
        if (((DeploymentExtendedInner)this.inner()).properties() == null) {
            return null;
        }
        return ((DeploymentExtendedInner)this.inner()).properties().mode();
    }

    @Override
    public DeploymentOperations deploymentOperations() {
        return new DeploymentOperationsImpl(this.deploymentOperationsClient, this);
    }

    @Override
    public void cancel() {
        this.client.cancel(this.resourceGroupName, this.name());
    }

    @Override
    public DeploymentExportResult exportTemplate() {
        DeploymentExportResultInner inner = this.client.exportTemplate(this.resourceGroupName(), this.name());
        return new DeploymentExportResultImpl(inner);
    }

    @Override
    public DeploymentImpl withNewResourceGroup(String resourceGroupName, Region region) {
        this.creatableResourceGroup = (Creatable)((ResourceGroup.DefinitionStages.Blank)this.resourceManager.resourceGroups().define(resourceGroupName)).withRegion(region);
        this.addCreatableDependency(this.creatableResourceGroup);
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public DeploymentImpl withNewResourceGroup(Creatable<ResourceGroup> resourceGroupDefinition) {
        this.resourceGroupName = resourceGroupDefinition.name();
        this.addCreatableDependency(resourceGroupDefinition);
        this.creatableResourceGroup = resourceGroupDefinition;
        return this;
    }

    @Override
    public DeploymentImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public DeploymentImpl withExistingResourceGroup(ResourceGroup resourceGroup) {
        this.resourceGroupName = resourceGroup.name();
        return this;
    }

    @Override
    public DeploymentImpl withTemplate(Object template) {
        if (((DeploymentExtendedInner)this.inner()).properties() == null) {
            ((DeploymentExtendedInner)this.inner()).withProperties(new DeploymentPropertiesExtended());
        }
        ((DeploymentExtendedInner)this.inner()).properties().withTemplate(template);
        ((DeploymentExtendedInner)this.inner()).properties().withTemplateLink(null);
        return this;
    }

    @Override
    public DeploymentImpl withTemplate(String templateJson) throws IOException {
        return this.withTemplate(this.objectMapper.readTree(templateJson));
    }

    @Override
    public DeploymentImpl withTemplateLink(String uri, String contentVersion) {
        if (((DeploymentExtendedInner)this.inner()).properties() == null) {
            ((DeploymentExtendedInner)this.inner()).withProperties(new DeploymentPropertiesExtended());
        }
        ((DeploymentExtendedInner)this.inner()).properties().withTemplateLink(new TemplateLink().withUri(uri).withContentVersion(contentVersion));
        ((DeploymentExtendedInner)this.inner()).properties().withTemplate(null);
        return this;
    }

    @Override
    public DeploymentImpl withMode(DeploymentMode mode) {
        if (((DeploymentExtendedInner)this.inner()).properties() == null) {
            ((DeploymentExtendedInner)this.inner()).withProperties(new DeploymentPropertiesExtended());
        }
        ((DeploymentExtendedInner)this.inner()).properties().withMode(mode);
        return this;
    }

    @Override
    public DeploymentImpl withParameters(Object parameters) {
        if (((DeploymentExtendedInner)this.inner()).properties() == null) {
            ((DeploymentExtendedInner)this.inner()).withProperties(new DeploymentPropertiesExtended());
        }
        ((DeploymentExtendedInner)this.inner()).properties().withParameters(parameters);
        ((DeploymentExtendedInner)this.inner()).properties().withParametersLink(null);
        return this;
    }

    @Override
    public DeploymentImpl withParameters(String parametersJson) throws IOException {
        return this.withParameters(this.objectMapper.readTree(parametersJson));
    }

    @Override
    public DeploymentImpl withParametersLink(String uri, String contentVersion) {
        if (((DeploymentExtendedInner)this.inner()).properties() == null) {
            ((DeploymentExtendedInner)this.inner()).withProperties(new DeploymentPropertiesExtended());
        }
        ((DeploymentExtendedInner)this.inner()).properties().withParametersLink(new ParametersLink().withUri(uri).withContentVersion(contentVersion));
        ((DeploymentExtendedInner)this.inner()).properties().withParameters(null);
        return this;
    }

    @Override
    public DeploymentImpl beginCreate() {
        if (this.creatableResourceGroup != null) {
            this.creatableResourceGroup.create();
        }
        DeploymentInner inner = new DeploymentInner().withProperties(new DeploymentProperties());
        inner.properties().withMode(this.mode());
        inner.properties().withTemplate(this.template());
        inner.properties().withTemplateLink(this.templateLink());
        inner.properties().withParameters(this.parameters());
        inner.properties().withParametersLink(this.parametersLink());
        this.client.beginCreateOrUpdate(this.resourceGroupName(), this.name(), inner);
        return this;
    }

    @Override
    public Observable<Deployment> createResourceAsync() {
        DeploymentInner inner = new DeploymentInner().withProperties(new DeploymentProperties());
        inner.properties().withMode(this.mode());
        inner.properties().withTemplate(this.template());
        inner.properties().withTemplateLink(this.templateLink());
        inner.properties().withParameters(this.parameters());
        inner.properties().withParametersLink(this.parametersLink());
        return this.client.createOrUpdateAsync(this.resourceGroupName(), this.name(), inner).map(this.innerToFluentMap(this));
    }

    @Override
    public Observable<Deployment> applyAsync() {
        return this.updateResourceAsync();
    }

    @Override
    public Observable<Deployment> updateResourceAsync() {
        try {
            if (this.templateLink() != null && this.template() != null) {
                this.withTemplate(null);
            }
            if (this.parametersLink() != null && this.parameters() != null) {
                this.withParameters(null);
            }
        }
        catch (IOException e) {
            return Observable.error((Throwable)e);
        }
        return this.createResourceAsync();
    }

    @Override
    public Deployment refresh() {
        this.setInner(this.client.get(this.resourceGroupName(), this.name()));
        return this;
    }

    @Override
    public boolean isInCreateMode() {
        return ((DeploymentExtendedInner)this.inner()).id() == null;
    }
}

