/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources.implementation;

import com.microsoft.azure.management.resources.DeploymentOperation;
import com.microsoft.azure.management.resources.TargetResource;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import com.microsoft.azure.management.resources.implementation.DeploymentOperationInner;
import com.microsoft.azure.management.resources.implementation.DeploymentOperationsInner;
import org.joda.time.DateTime;

final class DeploymentOperationImpl
extends IndexableRefreshableWrapperImpl<DeploymentOperation, DeploymentOperationInner>
implements DeploymentOperation {
    private String resourceGroupName;
    private String deploymentName;
    private final DeploymentOperationsInner client;

    DeploymentOperationImpl(DeploymentOperationInner innerModel, DeploymentOperationsInner client) {
        super(innerModel);
        this.client = client;
        this.resourceGroupName = ResourceUtils.groupFromResourceId(innerModel.id());
        this.deploymentName = ResourceUtils.extractFromResourceId(innerModel.id(), "deployments");
    }

    @Override
    public String operationId() {
        return ((DeploymentOperationInner)this.inner()).operationId();
    }

    @Override
    public String provisioningState() {
        if (((DeploymentOperationInner)this.inner()).properties() == null) {
            return null;
        }
        return ((DeploymentOperationInner)this.inner()).properties().provisioningState();
    }

    @Override
    public DateTime timestamp() {
        if (((DeploymentOperationInner)this.inner()).properties() == null) {
            return null;
        }
        return ((DeploymentOperationInner)this.inner()).properties().timestamp();
    }

    @Override
    public String statusCode() {
        if (((DeploymentOperationInner)this.inner()).properties() == null) {
            return null;
        }
        return ((DeploymentOperationInner)this.inner()).properties().statusCode();
    }

    @Override
    public Object statusMessage() {
        if (((DeploymentOperationInner)this.inner()).properties() == null) {
            return null;
        }
        return ((DeploymentOperationInner)this.inner()).properties().statusMessage();
    }

    @Override
    public TargetResource targetResource() {
        if (((DeploymentOperationInner)this.inner()).properties() == null) {
            return null;
        }
        return ((DeploymentOperationInner)this.inner()).properties().targetResource();
    }

    @Override
    public DeploymentOperation refresh() {
        this.setInner(this.client.get(this.resourceGroupName, this.deploymentName, this.operationId()));
        return this;
    }
}

