/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources.implementation;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.resources.Deployment;
import com.microsoft.azure.management.resources.Deployments;
import com.microsoft.azure.management.resources.ResourceGroup;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupPagedList;
import com.microsoft.azure.management.resources.fluentcore.utils.PagedListConverter;
import com.microsoft.azure.management.resources.implementation.DeploymentExtendedInner;
import com.microsoft.azure.management.resources.implementation.DeploymentImpl;
import com.microsoft.azure.management.resources.implementation.DeploymentOperationsInner;
import com.microsoft.azure.management.resources.implementation.DeploymentsInner;
import com.microsoft.azure.management.resources.implementation.ResourceManager;
import com.microsoft.rest.ServiceCall;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceResponse;
import java.util.List;
import rx.Observable;
import rx.functions.Func1;

final class DeploymentsImpl
implements Deployments {
    private final DeploymentsInner client;
    private final DeploymentOperationsInner deploymentOperationsClient;
    private final ResourceManager resourceManager;
    private PagedListConverter<DeploymentExtendedInner, Deployment> converter;

    DeploymentsImpl(DeploymentsInner client, DeploymentOperationsInner deploymentOperationsClient, ResourceManager resourceManager) {
        this.client = client;
        this.deploymentOperationsClient = deploymentOperationsClient;
        this.resourceManager = resourceManager;
        this.converter = new PagedListConverter<DeploymentExtendedInner, Deployment>(){

            @Override
            public Deployment typeConvert(DeploymentExtendedInner deploymentInner) {
                return DeploymentsImpl.this.createFluentModel(deploymentInner);
            }
        };
    }

    @Override
    public PagedList<Deployment> list() {
        return new GroupPagedList<Deployment>(this.resourceManager.resourceGroups().list()){

            @Override
            public List<Deployment> listNextGroup(String resourceGroupName) {
                return DeploymentsImpl.this.converter.convert(DeploymentsImpl.this.client.list(resourceGroupName));
            }
        };
    }

    @Override
    public PagedList<Deployment> listByGroup(String groupName) {
        return this.converter.convert(this.client.list(groupName));
    }

    @Override
    public Deployment getByName(String name) {
        for (ResourceGroup group : this.resourceManager.resourceGroups().list()) {
            DeploymentExtendedInner inner = this.client.get(group.name(), name);
            if (inner == null) continue;
            return this.createFluentModel(inner);
        }
        return null;
    }

    @Override
    public Deployment getByGroup(String groupName, String name) {
        return this.createFluentModel(this.client.get(groupName, name));
    }

    @Override
    public void delete(String groupName, String name) {
        this.deleteAsync(groupName, name).toBlocking().subscribe();
    }

    @Override
    public ServiceCall<Void> deleteAsync(String groupName, String name, ServiceCallback<Void> callback) {
        return ServiceCall.create((Observable)this.deleteAsync(groupName, name).map((Func1)new Func1<Void, ServiceResponse<Void>>(){

            public ServiceResponse<Void> call(Void aVoid) {
                return new ServiceResponse((Object)aVoid, null);
            }
        }), callback);
    }

    @Override
    public Observable<Void> deleteAsync(String groupName, String name) {
        return this.client.deleteAsync(groupName, name);
    }

    @Override
    public DeploymentImpl define(String name) {
        return this.createFluentModel(name);
    }

    @Override
    public boolean checkExistence(String resourceGroupName, String deploymentName) {
        return this.client.checkExistence(resourceGroupName, deploymentName);
    }

    protected DeploymentImpl createFluentModel(String name) {
        return new DeploymentImpl(new DeploymentExtendedInner().withName(name), this.client, this.deploymentOperationsClient, this.resourceManager);
    }

    protected DeploymentImpl createFluentModel(DeploymentExtendedInner deploymentExtendedInner) {
        return new DeploymentImpl(deploymentExtendedInner, this.client, this.deploymentOperationsClient, this.resourceManager);
    }

    @Override
    public Deployment getById(String id) {
        return this.getByGroup(ResourceUtils.groupFromResourceId(id), ResourceUtils.nameFromResourceId(id));
    }

    @Override
    public void delete(String id) {
        this.deleteAsync(id).toBlocking().subscribe();
    }

    @Override
    public ServiceCall<Void> deleteAsync(String id, ServiceCallback<Void> callback) {
        return ServiceCall.create((Observable)this.deleteAsync(id).map((Func1)new Func1<Void, ServiceResponse<Void>>(){

            public ServiceResponse<Void> call(Void aVoid) {
                return new ServiceResponse((Object)aVoid, null);
            }
        }), callback);
    }

    @Override
    public Observable<Void> deleteAsync(String id) {
        return this.deleteAsync(ResourceUtils.groupFromResourceId(id), ResourceUtils.nameFromResourceId(id));
    }
}

