/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceCall;
import com.microsoft.azure.AzureServiceResponseBuilder;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.resources.implementation.FeatureClientImpl;
import com.microsoft.azure.management.resources.implementation.FeatureResultInner;
import com.microsoft.azure.management.resources.implementation.PageImpl;
import com.microsoft.rest.ServiceCall;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public final class FeaturesInner {
    private FeaturesService service;
    private FeatureClientImpl client;

    public FeaturesInner(Retrofit retrofit, FeatureClientImpl client) {
        this.service = (FeaturesService)retrofit.create(FeaturesService.class);
        this.client = client;
    }

    public PagedList<FeatureResultInner> listAll() {
        ServiceResponse response = (ServiceResponse)this.listAllSinglePageAsync().toBlocking().single();
        return new PagedList<FeatureResultInner>((Page)response.getBody()){

            public Page<FeatureResultInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)FeaturesInner.this.listAllNextSinglePageAsync(nextPageLink).toBlocking().single()).getBody();
            }
        };
    }

    public ServiceCall<List<FeatureResultInner>> listAllAsync(ListOperationCallback<FeatureResultInner> serviceCallback) {
        return AzureServiceCall.create(this.listAllSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<FeatureResultInner>>>>(){

            public Observable<ServiceResponse<Page<FeatureResultInner>>> call(String nextPageLink) {
                return FeaturesInner.this.listAllNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<FeatureResultInner>> listAllAsync() {
        return this.listAllWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<FeatureResultInner>>, Page<FeatureResultInner>>(){

            public Page<FeatureResultInner> call(ServiceResponse<Page<FeatureResultInner>> response) {
                return (Page)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Page<FeatureResultInner>>> listAllWithServiceResponseAsync() {
        return this.listAllSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<FeatureResultInner>>, Observable<ServiceResponse<Page<FeatureResultInner>>>>(){

            public Observable<ServiceResponse<Page<FeatureResultInner>>> call(ServiceResponse<Page<FeatureResultInner>> page) {
                String nextPageLink = ((Page)page.getBody()).getNextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(FeaturesInner.this.listAllNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<FeatureResultInner>>> listAllSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listAll(this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<FeatureResultInner>>>>(){

            public Observable<ServiceResponse<Page<FeatureResultInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = FeaturesInner.this.listAllDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.getBody(), result.getResponse()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<FeatureResultInner>> listAllDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.client.mapperAdapter()).register(200, new TypeToken<PageImpl<FeatureResultInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<FeatureResultInner> list(String resourceProviderNamespace) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(resourceProviderNamespace).toBlocking().single();
        return new PagedList<FeatureResultInner>((Page)response.getBody()){

            public Page<FeatureResultInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)FeaturesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).getBody();
            }
        };
    }

    public ServiceCall<List<FeatureResultInner>> listAsync(String resourceProviderNamespace, ListOperationCallback<FeatureResultInner> serviceCallback) {
        return AzureServiceCall.create(this.listSinglePageAsync(resourceProviderNamespace), (Func1)new Func1<String, Observable<ServiceResponse<Page<FeatureResultInner>>>>(){

            public Observable<ServiceResponse<Page<FeatureResultInner>>> call(String nextPageLink) {
                return FeaturesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<FeatureResultInner>> listAsync(String resourceProviderNamespace) {
        return this.listWithServiceResponseAsync(resourceProviderNamespace).map((Func1)new Func1<ServiceResponse<Page<FeatureResultInner>>, Page<FeatureResultInner>>(){

            public Page<FeatureResultInner> call(ServiceResponse<Page<FeatureResultInner>> response) {
                return (Page)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Page<FeatureResultInner>>> listWithServiceResponseAsync(String resourceProviderNamespace) {
        return this.listSinglePageAsync(resourceProviderNamespace).concatMap((Func1)new Func1<ServiceResponse<Page<FeatureResultInner>>, Observable<ServiceResponse<Page<FeatureResultInner>>>>(){

            public Observable<ServiceResponse<Page<FeatureResultInner>>> call(ServiceResponse<Page<FeatureResultInner>> page) {
                String nextPageLink = ((Page)page.getBody()).getNextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(FeaturesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<FeatureResultInner>>> listSinglePageAsync(String resourceProviderNamespace) {
        if (resourceProviderNamespace == null) {
            throw new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.list(resourceProviderNamespace, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<FeatureResultInner>>>>(){

            public Observable<ServiceResponse<Page<FeatureResultInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = FeaturesInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.getBody(), result.getResponse()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<FeatureResultInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.client.mapperAdapter()).register(200, new TypeToken<PageImpl<FeatureResultInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public FeatureResultInner get(String resourceProviderNamespace, String featureName) {
        return (FeatureResultInner)((ServiceResponse)this.getWithServiceResponseAsync(resourceProviderNamespace, featureName).toBlocking().single()).getBody();
    }

    public ServiceCall<FeatureResultInner> getAsync(String resourceProviderNamespace, String featureName, ServiceCallback<FeatureResultInner> serviceCallback) {
        return ServiceCall.create(this.getWithServiceResponseAsync(resourceProviderNamespace, featureName), serviceCallback);
    }

    public Observable<FeatureResultInner> getAsync(String resourceProviderNamespace, String featureName) {
        return this.getWithServiceResponseAsync(resourceProviderNamespace, featureName).map((Func1)new Func1<ServiceResponse<FeatureResultInner>, FeatureResultInner>(){

            public FeatureResultInner call(ServiceResponse<FeatureResultInner> response) {
                return (FeatureResultInner)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<FeatureResultInner>> getWithServiceResponseAsync(String resourceProviderNamespace, String featureName) {
        if (resourceProviderNamespace == null) {
            throw new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null.");
        }
        if (featureName == null) {
            throw new IllegalArgumentException("Parameter featureName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.get(resourceProviderNamespace, featureName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<FeatureResultInner>>>(){

            public Observable<ServiceResponse<FeatureResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = FeaturesInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<FeatureResultInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.client.mapperAdapter()).register(200, new TypeToken<FeatureResultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public FeatureResultInner register(String resourceProviderNamespace, String featureName) {
        return (FeatureResultInner)((ServiceResponse)this.registerWithServiceResponseAsync(resourceProviderNamespace, featureName).toBlocking().single()).getBody();
    }

    public ServiceCall<FeatureResultInner> registerAsync(String resourceProviderNamespace, String featureName, ServiceCallback<FeatureResultInner> serviceCallback) {
        return ServiceCall.create(this.registerWithServiceResponseAsync(resourceProviderNamespace, featureName), serviceCallback);
    }

    public Observable<FeatureResultInner> registerAsync(String resourceProviderNamespace, String featureName) {
        return this.registerWithServiceResponseAsync(resourceProviderNamespace, featureName).map((Func1)new Func1<ServiceResponse<FeatureResultInner>, FeatureResultInner>(){

            public FeatureResultInner call(ServiceResponse<FeatureResultInner> response) {
                return (FeatureResultInner)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<FeatureResultInner>> registerWithServiceResponseAsync(String resourceProviderNamespace, String featureName) {
        if (resourceProviderNamespace == null) {
            throw new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null.");
        }
        if (featureName == null) {
            throw new IllegalArgumentException("Parameter featureName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.register(resourceProviderNamespace, featureName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<FeatureResultInner>>>(){

            public Observable<ServiceResponse<FeatureResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = FeaturesInner.this.registerDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<FeatureResultInner> registerDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.client.mapperAdapter()).register(200, new TypeToken<FeatureResultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<FeatureResultInner> listAllNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listAllNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<FeatureResultInner>((Page)response.getBody()){

            public Page<FeatureResultInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)FeaturesInner.this.listAllNextSinglePageAsync(nextPageLink).toBlocking().single()).getBody();
            }
        };
    }

    public ServiceCall<List<FeatureResultInner>> listAllNextAsync(String nextPageLink, ServiceCall<List<FeatureResultInner>> serviceCall, ListOperationCallback<FeatureResultInner> serviceCallback) {
        return AzureServiceCall.create(this.listAllNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<FeatureResultInner>>>>(){

            public Observable<ServiceResponse<Page<FeatureResultInner>>> call(String nextPageLink) {
                return FeaturesInner.this.listAllNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<FeatureResultInner>> listAllNextAsync(String nextPageLink) {
        return this.listAllNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<FeatureResultInner>>, Page<FeatureResultInner>>(){

            public Page<FeatureResultInner> call(ServiceResponse<Page<FeatureResultInner>> response) {
                return (Page)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Page<FeatureResultInner>>> listAllNextWithServiceResponseAsync(String nextPageLink) {
        return this.listAllNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<FeatureResultInner>>, Observable<ServiceResponse<Page<FeatureResultInner>>>>(){

            public Observable<ServiceResponse<Page<FeatureResultInner>>> call(ServiceResponse<Page<FeatureResultInner>> page) {
                String nextPageLink = ((Page)page.getBody()).getNextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(FeaturesInner.this.listAllNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<FeatureResultInner>>> listAllNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        return this.service.listAllNext(nextPageLink, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<FeatureResultInner>>>>(){

            public Observable<ServiceResponse<Page<FeatureResultInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = FeaturesInner.this.listAllNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.getBody(), result.getResponse()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<FeatureResultInner>> listAllNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.client.mapperAdapter()).register(200, new TypeToken<PageImpl<FeatureResultInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<FeatureResultInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<FeatureResultInner>((Page)response.getBody()){

            public Page<FeatureResultInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)FeaturesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).getBody();
            }
        };
    }

    public ServiceCall<List<FeatureResultInner>> listNextAsync(String nextPageLink, ServiceCall<List<FeatureResultInner>> serviceCall, ListOperationCallback<FeatureResultInner> serviceCallback) {
        return AzureServiceCall.create(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<FeatureResultInner>>>>(){

            public Observable<ServiceResponse<Page<FeatureResultInner>>> call(String nextPageLink) {
                return FeaturesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<FeatureResultInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<FeatureResultInner>>, Page<FeatureResultInner>>(){

            public Page<FeatureResultInner> call(ServiceResponse<Page<FeatureResultInner>> response) {
                return (Page)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Page<FeatureResultInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<FeatureResultInner>>, Observable<ServiceResponse<Page<FeatureResultInner>>>>(){

            public Observable<ServiceResponse<Page<FeatureResultInner>>> call(ServiceResponse<Page<FeatureResultInner>> page) {
                String nextPageLink = ((Page)page.getBody()).getNextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(FeaturesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<FeatureResultInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        return this.service.listNext(nextPageLink, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<FeatureResultInner>>>>(){

            public Observable<ServiceResponse<Page<FeatureResultInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = FeaturesInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.getBody(), result.getResponse()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<FeatureResultInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.client.mapperAdapter()).register(200, new TypeToken<PageImpl<FeatureResultInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface FeaturesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Features/features")
        public Observable<Response<ResponseBody>> listAll(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Features/providers/{resourceProviderNamespace}/features")
        public Observable<Response<ResponseBody>> list(@Path(value="resourceProviderNamespace") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Features/providers/{resourceProviderNamespace}/features/{featureName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceProviderNamespace") String var1, @Path(value="featureName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @POST(value="subscriptions/{subscriptionId}/providers/Microsoft.Features/providers/{resourceProviderNamespace}/features/{featureName}/register")
        public Observable<Response<ResponseBody>> register(@Path(value="resourceProviderNamespace") String var1, @Path(value="featureName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @GET(value="{nextLink}")
        public Observable<Response<ResponseBody>> listAllNext(@Path(value="nextLink", encoded=true) String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @GET(value="{nextLink}")
        public Observable<Response<ResponseBody>> listNext(@Path(value="nextLink", encoded=true) String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

