/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources.implementation;

import com.microsoft.azure.management.resources.GenericResource;
import com.microsoft.azure.management.resources.Plan;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.microsoft.azure.management.resources.implementation.GenericResourceInner;
import com.microsoft.azure.management.resources.implementation.ResourceManagementClientImpl;
import com.microsoft.azure.management.resources.implementation.ResourceManager;
import com.microsoft.azure.management.resources.implementation.ResourcesInner;
import rx.Observable;
import rx.schedulers.Schedulers;

final class GenericResourceImpl
extends GroupableResourceImpl<GenericResource, GenericResourceInner, GenericResourceImpl, ResourceManager>
implements GenericResource,
GenericResource.Definition,
GenericResource.UpdateStages.WithApiVersion,
GenericResource.Update {
    private final ResourcesInner client;
    private String resourceProviderNamespace;
    private String parentResourceId;
    private String resourceType;
    private String apiVersion;

    GenericResourceImpl(String key, GenericResourceInner innerModel, ResourcesInner client, ResourceManagementClientImpl serviceClient, ResourceManager resourceManager) {
        super(key, innerModel, resourceManager);
        this.client = client;
    }

    @Override
    public String resourceProviderNamespace() {
        return this.resourceProviderNamespace;
    }

    @Override
    public String parentResourceId() {
        return this.parentResourceId;
    }

    @Override
    public String resourceType() {
        return this.resourceType;
    }

    @Override
    public String apiVersion() {
        return this.apiVersion;
    }

    @Override
    public Plan plan() {
        return ((GenericResourceInner)((Object)this.inner())).plan();
    }

    @Override
    public Object properties() {
        return ((GenericResourceInner)((Object)this.inner())).properties();
    }

    @Override
    public GenericResource refresh() {
        return null;
    }

    @Override
    public GenericResourceImpl withProperties(Object properties) {
        ((GenericResourceInner)((Object)this.inner())).withProperties(properties);
        return this;
    }

    @Override
    public GenericResourceImpl withParentResource(String parentResourceId) {
        this.parentResourceId = parentResourceId;
        return this;
    }

    @Override
    public GenericResourceImpl withPlan(String name, String publisher, String product, String promotionCode) {
        ((GenericResourceInner)((Object)this.inner())).withPlan(new Plan().withName(name).withPublisher(publisher).withProduct(product).withPromotionCode(promotionCode));
        return this;
    }

    @Override
    public GenericResourceImpl withoutPlan() {
        ((GenericResourceInner)((Object)this.inner())).withPlan(null);
        return this;
    }

    @Override
    public GenericResourceImpl withProviderNamespace(String resourceProviderNamespace) {
        this.resourceProviderNamespace = resourceProviderNamespace;
        return this;
    }

    @Override
    public GenericResourceImpl withResourceType(String resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    @Override
    public GenericResourceImpl withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Override
    public Observable<GenericResource> createResourceAsync() {
        return this.client.createOrUpdateAsync(this.resourceGroupName(), this.resourceProviderNamespace, this.parentResourceId, this.resourceType, this.name(), this.apiVersion, (GenericResourceInner)((Object)this.inner())).subscribeOn(Schedulers.io()).map(this.innerToFluentMap(this));
    }
}

