/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources.implementation;

import com.microsoft.azure.CloudException;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.resources.GenericResource;
import com.microsoft.azure.management.resources.GenericResources;
import com.microsoft.azure.management.resources.ResourceGroup;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.GroupableResourcesImpl;
import com.microsoft.azure.management.resources.implementation.GenericResourceImpl;
import com.microsoft.azure.management.resources.implementation.GenericResourceInner;
import com.microsoft.azure.management.resources.implementation.ResourceManagementClientImpl;
import com.microsoft.azure.management.resources.implementation.ResourceManager;
import com.microsoft.azure.management.resources.implementation.ResourcesInner;
import com.microsoft.azure.management.resources.implementation.ResourcesMoveInfoInner;
import java.util.List;
import rx.Observable;

final class GenericResourcesImpl
extends GroupableResourcesImpl<GenericResource, GenericResourceImpl, GenericResourceInner, ResourcesInner, ResourceManager>
implements GenericResources {
    private final ResourceManagementClientImpl serviceClient;

    GenericResourcesImpl(ResourceManagementClientImpl serviceClient, ResourceManager resourceManager) {
        super(serviceClient.resources(), resourceManager);
        this.serviceClient = serviceClient;
    }

    @Override
    public PagedList<GenericResource> listByGroup(String groupName) {
        return this.wrapList(this.serviceClient.resourceGroups().listResources(groupName));
    }

    @Override
    public GenericResource.DefinitionStages.Blank define(String name) {
        return new GenericResourceImpl(name, new GenericResourceInner(), (ResourcesInner)this.innerCollection, this.serviceClient, (ResourceManager)this.myManager);
    }

    @Override
    public boolean checkExistence(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion) {
        return ((ResourcesInner)this.innerCollection).checkExistence(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion);
    }

    @Override
    public GenericResource getById(String id) {
        return this.get(ResourceUtils.groupFromResourceId(id), ResourceUtils.resourceProviderFromResourceId(id), ResourceUtils.resourceTypeFromResourceId(id), ResourceUtils.nameFromResourceId(id));
    }

    @Override
    public GenericResource get(String resourceGroupName, String providerNamespace, String resourceType, String name) {
        PagedList<GenericResource> genericResources = this.listByGroup(resourceGroupName);
        for (GenericResource resource : genericResources) {
            if (!resource.name().equalsIgnoreCase(name) || !resource.resourceProviderNamespace().equalsIgnoreCase(providerNamespace) || !resource.resourceType().equalsIgnoreCase(resourceType)) continue;
            return resource;
        }
        throw new CloudException("Generic resource not found.");
    }

    @Override
    public GenericResource get(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion) {
        if (parentResourcePath == null) {
            parentResourcePath = "";
        }
        GenericResourceInner inner = ((ResourcesInner)this.innerCollection).get(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion);
        GenericResourceImpl resource = new GenericResourceImpl(resourceName, inner, (ResourcesInner)this.innerCollection, this.serviceClient, (ResourceManager)this.myManager);
        return ((GenericResourceImpl)resource.withExistingResourceGroup(resourceGroupName)).withProviderNamespace(resourceProviderNamespace).withParentResource(parentResourcePath).withResourceType(resourceType).withApiVersion(apiVersion);
    }

    @Override
    public void moveResources(String sourceResourceGroupName, ResourceGroup targetResourceGroup, List<String> resources) {
        ResourcesMoveInfoInner moveInfo = new ResourcesMoveInfoInner();
        moveInfo.withTargetResourceGroup(targetResourceGroup.id());
        moveInfo.withResources(resources);
        ((ResourcesInner)this.innerCollection).moveResources(sourceResourceGroupName, moveInfo);
    }

    @Override
    public void delete(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion) {
        ((ResourcesInner)this.innerCollection).delete(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion);
    }

    @Override
    protected GenericResourceImpl wrapModel(String id) {
        return ((GenericResourceImpl)new GenericResourceImpl(id, new GenericResourceInner(), (ResourcesInner)this.innerCollection, this.serviceClient, (ResourceManager)this.myManager).withExistingResourceGroup(ResourceUtils.groupFromResourceId(id))).withProviderNamespace(ResourceUtils.resourceProviderFromResourceId(id)).withResourceType(ResourceUtils.resourceTypeFromResourceId(id)).withParentResource(ResourceUtils.parentResourcePathFromResourceId(id));
    }

    @Override
    protected GenericResourceImpl wrapModel(GenericResourceInner inner) {
        return ((GenericResourceImpl)new GenericResourceImpl(inner.id(), inner, (ResourcesInner)this.innerCollection, this.serviceClient, (ResourceManager)this.myManager).withExistingResourceGroup(ResourceUtils.groupFromResourceId(inner.id()))).withProviderNamespace(ResourceUtils.resourceProviderFromResourceId(inner.id())).withResourceType(ResourceUtils.resourceTypeFromResourceId(inner.id())).withParentResource(ResourceUtils.parentResourcePathFromResourceId(inner.id()));
    }

    @Override
    public GenericResource getByGroup(String groupName, String name) {
        throw new UnsupportedOperationException("Get just by resource group and name is not supported. Please use other overloads.");
    }

    @Override
    public Observable<Void> deleteAsync(String groupName, String name) {
        throw new UnsupportedOperationException("Delete just by resource group and name is not supported. Please use other overloads.");
    }
}

