/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources.implementation;

import com.microsoft.azure.management.resources.ResourceGroup;
import com.microsoft.azure.management.resources.ResourceGroupExportResult;
import com.microsoft.azure.management.resources.ResourceGroupExportTemplateOptions;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.CreatableUpdatableImpl;
import com.microsoft.azure.management.resources.implementation.ExportTemplateRequestInner;
import com.microsoft.azure.management.resources.implementation.ResourceGroupExportResultImpl;
import com.microsoft.azure.management.resources.implementation.ResourceGroupExportResultInner;
import com.microsoft.azure.management.resources.implementation.ResourceGroupInner;
import com.microsoft.azure.management.resources.implementation.ResourceGroupsInner;
import com.microsoft.azure.management.resources.implementation.ResourceManagementClientImpl;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import rx.Observable;

class ResourceGroupImpl
extends CreatableUpdatableImpl<ResourceGroup, ResourceGroupInner, ResourceGroupImpl>
implements ResourceGroup,
ResourceGroup.Definition,
ResourceGroup.Update {
    private final ResourceGroupsInner client;

    protected ResourceGroupImpl(ResourceGroupInner innerModel, ResourceManagementClientImpl serviceClient) {
        super(innerModel.name(), innerModel);
        this.client = serviceClient.resourceGroups();
    }

    @Override
    public String name() {
        return ((ResourceGroupInner)this.inner()).name();
    }

    @Override
    public String provisioningState() {
        return ((ResourceGroupInner)this.inner()).properties().provisioningState();
    }

    @Override
    public String regionName() {
        return ((ResourceGroupInner)this.inner()).location();
    }

    @Override
    public Region region() {
        return Region.fromName(this.regionName());
    }

    @Override
    public String id() {
        return ((ResourceGroupInner)this.inner()).id();
    }

    @Override
    public String type() {
        return null;
    }

    @Override
    public Map<String, String> tags() {
        return Collections.unmodifiableMap(((ResourceGroupInner)this.inner()).tags());
    }

    @Override
    public ResourceGroupExportResult exportTemplate(ResourceGroupExportTemplateOptions options) {
        ExportTemplateRequestInner inner = new ExportTemplateRequestInner().withResources(Arrays.asList("*")).withOptions(options.toString());
        ResourceGroupExportResultInner resultInner = this.client.exportTemplate(this.name(), inner);
        return new ResourceGroupExportResultImpl(resultInner);
    }

    @Override
    public ResourceGroupImpl withRegion(String regionName) {
        ((ResourceGroupInner)this.inner()).withLocation(regionName);
        return this;
    }

    @Override
    public ResourceGroupImpl withRegion(Region region) {
        return this.withRegion(region.toString());
    }

    @Override
    public ResourceGroupImpl withTags(Map<String, String> tags) {
        ((ResourceGroupInner)this.inner()).withTags(new HashMap<String, String>(tags));
        return this;
    }

    @Override
    public ResourceGroupImpl withTag(String key, String value) {
        if (((ResourceGroupInner)this.inner()).tags() == null) {
            ((ResourceGroupInner)this.inner()).withTags(new HashMap<String, String>());
        }
        ((ResourceGroupInner)this.inner()).tags().put(key, value);
        return this;
    }

    @Override
    public ResourceGroupImpl withoutTag(String key) {
        ((ResourceGroupInner)this.inner()).tags().remove(key);
        return this;
    }

    @Override
    public Observable<ResourceGroup> createResourceAsync() {
        ResourceGroupInner params = new ResourceGroupInner();
        params.withLocation(((ResourceGroupInner)this.inner()).location());
        params.withTags(((ResourceGroupInner)this.inner()).tags());
        return this.client.createOrUpdateAsync(this.name(), params).map(this.innerToFluentMap(this));
    }

    @Override
    public Observable<ResourceGroup> updateResourceAsync() {
        return this.createResourceAsync();
    }

    @Override
    public boolean isInCreateMode() {
        return ((ResourceGroupInner)this.inner()).id() == null;
    }

    @Override
    public ResourceGroupImpl refresh() {
        this.setInner(this.client.get(this.key));
        return this;
    }
}

