/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources.implementation;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.resources.ResourceGroup;
import com.microsoft.azure.management.resources.ResourceGroups;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.CreatableResourcesImpl;
import com.microsoft.azure.management.resources.implementation.ResourceGroupImpl;
import com.microsoft.azure.management.resources.implementation.ResourceGroupInner;
import com.microsoft.azure.management.resources.implementation.ResourceGroupsInner;
import com.microsoft.azure.management.resources.implementation.ResourceManagementClientImpl;
import rx.Observable;

final class ResourceGroupsImpl
extends CreatableResourcesImpl<ResourceGroup, ResourceGroupImpl, ResourceGroupInner>
implements ResourceGroups {
    private final ResourceGroupsInner client;
    private final ResourceManagementClientImpl serviceClient;

    ResourceGroupsImpl(ResourceManagementClientImpl serviceClient) {
        this.serviceClient = serviceClient;
        this.client = serviceClient.resourceGroups();
    }

    @Override
    public PagedList<ResourceGroup> list() {
        return this.wrapList(this.client.list());
    }

    @Override
    public ResourceGroupImpl getByName(String name) {
        return this.wrapModel(this.client.get(name));
    }

    @Override
    public Observable<Void> deleteAsync(String name) {
        return this.client.deleteAsync(name);
    }

    @Override
    public ResourceGroupImpl define(String name) {
        return this.wrapModel(name);
    }

    @Override
    public boolean checkExistence(String name) {
        return this.client.checkExistence(name);
    }

    @Override
    protected ResourceGroupImpl wrapModel(String name) {
        return new ResourceGroupImpl(new ResourceGroupInner().withName(name), this.serviceClient);
    }

    @Override
    protected ResourceGroupImpl wrapModel(ResourceGroupInner inner) {
        return new ResourceGroupImpl(inner, this.serviceClient);
    }
}

