/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceCall;
import com.microsoft.azure.AzureServiceResponseBuilder;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.resources.implementation.ExportTemplateRequestInner;
import com.microsoft.azure.management.resources.implementation.GenericResourceInner;
import com.microsoft.azure.management.resources.implementation.PageImpl;
import com.microsoft.azure.management.resources.implementation.ResourceGroupExportResultInner;
import com.microsoft.azure.management.resources.implementation.ResourceGroupInner;
import com.microsoft.azure.management.resources.implementation.ResourceManagementClientImpl;
import com.microsoft.rest.ServiceCall;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HEAD;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public final class ResourceGroupsInner {
    private ResourceGroupsService service;
    private ResourceManagementClientImpl client;

    public ResourceGroupsInner(Retrofit retrofit, ResourceManagementClientImpl client) {
        this.service = (ResourceGroupsService)retrofit.create(ResourceGroupsService.class);
        this.client = client;
    }

    public PagedList<GenericResourceInner> listResources(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listResourcesSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<GenericResourceInner>((Page)response.getBody()){

            public Page<GenericResourceInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ResourceGroupsInner.this.listResourcesNextSinglePageAsync(nextPageLink).toBlocking().single()).getBody();
            }
        };
    }

    public ServiceCall<List<GenericResourceInner>> listResourcesAsync(String resourceGroupName, ListOperationCallback<GenericResourceInner> serviceCallback) {
        return AzureServiceCall.create(this.listResourcesSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<GenericResourceInner>>>>(){

            public Observable<ServiceResponse<Page<GenericResourceInner>>> call(String nextPageLink) {
                return ResourceGroupsInner.this.listResourcesNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<GenericResourceInner>> listResourcesAsync(String resourceGroupName) {
        return this.listResourcesWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<GenericResourceInner>>, Page<GenericResourceInner>>(){

            public Page<GenericResourceInner> call(ServiceResponse<Page<GenericResourceInner>> response) {
                return (Page)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Page<GenericResourceInner>>> listResourcesWithServiceResponseAsync(String resourceGroupName) {
        return this.listResourcesSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<GenericResourceInner>>, Observable<ServiceResponse<Page<GenericResourceInner>>>>(){

            public Observable<ServiceResponse<Page<GenericResourceInner>>> call(ServiceResponse<Page<GenericResourceInner>> page) {
                String nextPageLink = ((Page)page.getBody()).getNextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ResourceGroupsInner.this.listResourcesNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<GenericResourceInner>>> listResourcesSinglePageAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String filter = null;
        String expand = null;
        Integer top = null;
        return this.service.listResources(resourceGroupName, this.client.subscriptionId(), filter, expand, top, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<GenericResourceInner>>>>(){

            public Observable<ServiceResponse<Page<GenericResourceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ResourceGroupsInner.this.listResourcesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.getBody(), result.getResponse()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<GenericResourceInner> listResources(String resourceGroupName, String filter, String expand, Integer top) {
        ServiceResponse response = (ServiceResponse)this.listResourcesSinglePageAsync(resourceGroupName, filter, expand, top).toBlocking().single();
        return new PagedList<GenericResourceInner>((Page)response.getBody()){

            public Page<GenericResourceInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ResourceGroupsInner.this.listResourcesNextSinglePageAsync(nextPageLink).toBlocking().single()).getBody();
            }
        };
    }

    public ServiceCall<List<GenericResourceInner>> listResourcesAsync(String resourceGroupName, String filter, String expand, Integer top, ListOperationCallback<GenericResourceInner> serviceCallback) {
        return AzureServiceCall.create(this.listResourcesSinglePageAsync(resourceGroupName, filter, expand, top), (Func1)new Func1<String, Observable<ServiceResponse<Page<GenericResourceInner>>>>(){

            public Observable<ServiceResponse<Page<GenericResourceInner>>> call(String nextPageLink) {
                return ResourceGroupsInner.this.listResourcesNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<GenericResourceInner>> listResourcesAsync(String resourceGroupName, String filter, String expand, Integer top) {
        return this.listResourcesWithServiceResponseAsync(resourceGroupName, filter, expand, top).map((Func1)new Func1<ServiceResponse<Page<GenericResourceInner>>, Page<GenericResourceInner>>(){

            public Page<GenericResourceInner> call(ServiceResponse<Page<GenericResourceInner>> response) {
                return (Page)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Page<GenericResourceInner>>> listResourcesWithServiceResponseAsync(String resourceGroupName, String filter, String expand, Integer top) {
        return this.listResourcesSinglePageAsync(resourceGroupName, filter, expand, top).concatMap((Func1)new Func1<ServiceResponse<Page<GenericResourceInner>>, Observable<ServiceResponse<Page<GenericResourceInner>>>>(){

            public Observable<ServiceResponse<Page<GenericResourceInner>>> call(ServiceResponse<Page<GenericResourceInner>> page) {
                String nextPageLink = ((Page)page.getBody()).getNextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ResourceGroupsInner.this.listResourcesNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<GenericResourceInner>>> listResourcesSinglePageAsync(String resourceGroupName, String filter, String expand, Integer top) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listResources(resourceGroupName, this.client.subscriptionId(), filter, expand, top, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<GenericResourceInner>>>>(){

            public Observable<ServiceResponse<Page<GenericResourceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ResourceGroupsInner.this.listResourcesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.getBody(), result.getResponse()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<GenericResourceInner>> listResourcesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.client.mapperAdapter()).register(200, new TypeToken<PageImpl<GenericResourceInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public boolean checkExistence(String resourceGroupName) {
        return (Boolean)((ServiceResponse)this.checkExistenceWithServiceResponseAsync(resourceGroupName).toBlocking().single()).getBody();
    }

    public ServiceCall<Boolean> checkExistenceAsync(String resourceGroupName, ServiceCallback<Boolean> serviceCallback) {
        return ServiceCall.create(this.checkExistenceWithServiceResponseAsync(resourceGroupName), serviceCallback);
    }

    public Observable<Boolean> checkExistenceAsync(String resourceGroupName) {
        return this.checkExistenceWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Boolean>, Boolean>(){

            public Boolean call(ServiceResponse<Boolean> response) {
                return (Boolean)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Boolean>> checkExistenceWithServiceResponseAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.checkExistence(resourceGroupName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<Void>, Observable<ServiceResponse<Boolean>>>(){

            public Observable<ServiceResponse<Boolean>> call(Response<Void> response) {
                try {
                    ServiceResponse clientResponse = ResourceGroupsInner.this.checkExistenceDelegate((Response<Void>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Boolean> checkExistenceDelegate(Response<Void> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.client.mapperAdapter()).register(204, new TypeToken<Void>(){}.getType()).register(404, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).buildEmpty(response);
    }

    public ResourceGroupInner createOrUpdate(String resourceGroupName, ResourceGroupInner parameters) {
        return (ResourceGroupInner)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, parameters).toBlocking().single()).getBody();
    }

    public ServiceCall<ResourceGroupInner> createOrUpdateAsync(String resourceGroupName, ResourceGroupInner parameters, ServiceCallback<ResourceGroupInner> serviceCallback) {
        return ServiceCall.create(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, parameters), serviceCallback);
    }

    public Observable<ResourceGroupInner> createOrUpdateAsync(String resourceGroupName, ResourceGroupInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, parameters).map((Func1)new Func1<ServiceResponse<ResourceGroupInner>, ResourceGroupInner>(){

            public ResourceGroupInner call(ServiceResponse<ResourceGroupInner> response) {
                return (ResourceGroupInner)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<ResourceGroupInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, ResourceGroupInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.createOrUpdate(resourceGroupName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ResourceGroupInner>>>(){

            public Observable<ServiceResponse<ResourceGroupInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ResourceGroupsInner.this.createOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ResourceGroupInner> createOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.client.mapperAdapter()).register(201, new TypeToken<ResourceGroupInner>(){}.getType()).register(200, new TypeToken<ResourceGroupInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName).toBlocking().last()).getBody();
    }

    public ServiceCall<Void> deleteAsync(String resourceGroupName, ServiceCallback<Void> serviceCallback) {
        return ServiceCall.create(this.deleteWithServiceResponseAsync(resourceGroupName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName).toBlocking().single()).getBody();
    }

    public ServiceCall<Void> beginDeleteAsync(String resourceGroupName, ServiceCallback<Void> serviceCallback) {
        return ServiceCall.create(this.beginDeleteWithServiceResponseAsync(resourceGroupName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.beginDelete(resourceGroupName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ResourceGroupsInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.client.mapperAdapter()).register(202, new TypeToken<Void>(){}.getType()).register(200, new TypeToken<Void>(){}.getType()).build(response);
    }

    public ResourceGroupInner get(String resourceGroupName) {
        return (ResourceGroupInner)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName).toBlocking().single()).getBody();
    }

    public ServiceCall<ResourceGroupInner> getAsync(String resourceGroupName, ServiceCallback<ResourceGroupInner> serviceCallback) {
        return ServiceCall.create(this.getWithServiceResponseAsync(resourceGroupName), serviceCallback);
    }

    public Observable<ResourceGroupInner> getAsync(String resourceGroupName) {
        return this.getWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<ResourceGroupInner>, ResourceGroupInner>(){

            public ResourceGroupInner call(ServiceResponse<ResourceGroupInner> response) {
                return (ResourceGroupInner)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<ResourceGroupInner>> getWithServiceResponseAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.get(resourceGroupName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ResourceGroupInner>>>(){

            public Observable<ServiceResponse<ResourceGroupInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ResourceGroupsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ResourceGroupInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.client.mapperAdapter()).register(200, new TypeToken<ResourceGroupInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ResourceGroupInner patch(String resourceGroupName, ResourceGroupInner parameters) {
        return (ResourceGroupInner)((ServiceResponse)this.patchWithServiceResponseAsync(resourceGroupName, parameters).toBlocking().single()).getBody();
    }

    public ServiceCall<ResourceGroupInner> patchAsync(String resourceGroupName, ResourceGroupInner parameters, ServiceCallback<ResourceGroupInner> serviceCallback) {
        return ServiceCall.create(this.patchWithServiceResponseAsync(resourceGroupName, parameters), serviceCallback);
    }

    public Observable<ResourceGroupInner> patchAsync(String resourceGroupName, ResourceGroupInner parameters) {
        return this.patchWithServiceResponseAsync(resourceGroupName, parameters).map((Func1)new Func1<ServiceResponse<ResourceGroupInner>, ResourceGroupInner>(){

            public ResourceGroupInner call(ServiceResponse<ResourceGroupInner> response) {
                return (ResourceGroupInner)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<ResourceGroupInner>> patchWithServiceResponseAsync(String resourceGroupName, ResourceGroupInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.patch(resourceGroupName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ResourceGroupInner>>>(){

            public Observable<ServiceResponse<ResourceGroupInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ResourceGroupsInner.this.patchDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ResourceGroupInner> patchDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.client.mapperAdapter()).register(200, new TypeToken<ResourceGroupInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ResourceGroupExportResultInner exportTemplate(String resourceGroupName, ExportTemplateRequestInner parameters) {
        return (ResourceGroupExportResultInner)((ServiceResponse)this.exportTemplateWithServiceResponseAsync(resourceGroupName, parameters).toBlocking().single()).getBody();
    }

    public ServiceCall<ResourceGroupExportResultInner> exportTemplateAsync(String resourceGroupName, ExportTemplateRequestInner parameters, ServiceCallback<ResourceGroupExportResultInner> serviceCallback) {
        return ServiceCall.create(this.exportTemplateWithServiceResponseAsync(resourceGroupName, parameters), serviceCallback);
    }

    public Observable<ResourceGroupExportResultInner> exportTemplateAsync(String resourceGroupName, ExportTemplateRequestInner parameters) {
        return this.exportTemplateWithServiceResponseAsync(resourceGroupName, parameters).map((Func1)new Func1<ServiceResponse<ResourceGroupExportResultInner>, ResourceGroupExportResultInner>(){

            public ResourceGroupExportResultInner call(ServiceResponse<ResourceGroupExportResultInner> response) {
                return (ResourceGroupExportResultInner)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<ResourceGroupExportResultInner>> exportTemplateWithServiceResponseAsync(String resourceGroupName, ExportTemplateRequestInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.exportTemplate(resourceGroupName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ResourceGroupExportResultInner>>>(){

            public Observable<ServiceResponse<ResourceGroupExportResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ResourceGroupsInner.this.exportTemplateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ResourceGroupExportResultInner> exportTemplateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.client.mapperAdapter()).register(200, new TypeToken<ResourceGroupExportResultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ResourceGroupInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<ResourceGroupInner>((Page)response.getBody()){

            public Page<ResourceGroupInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ResourceGroupsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).getBody();
            }
        };
    }

    public ServiceCall<List<ResourceGroupInner>> listAsync(ListOperationCallback<ResourceGroupInner> serviceCallback) {
        return AzureServiceCall.create(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<ResourceGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ResourceGroupInner>>> call(String nextPageLink) {
                return ResourceGroupsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ResourceGroupInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<ResourceGroupInner>>, Page<ResourceGroupInner>>(){

            public Page<ResourceGroupInner> call(ServiceResponse<Page<ResourceGroupInner>> response) {
                return (Page)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Page<ResourceGroupInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<ResourceGroupInner>>, Observable<ServiceResponse<Page<ResourceGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ResourceGroupInner>>> call(ServiceResponse<Page<ResourceGroupInner>> page) {
                String nextPageLink = ((Page)page.getBody()).getNextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ResourceGroupsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ResourceGroupInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String filter = null;
        Integer top = null;
        return this.service.list(this.client.subscriptionId(), filter, top, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ResourceGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ResourceGroupInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ResourceGroupsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.getBody(), result.getResponse()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<ResourceGroupInner> list(String filter, Integer top) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(filter, top).toBlocking().single();
        return new PagedList<ResourceGroupInner>((Page)response.getBody()){

            public Page<ResourceGroupInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ResourceGroupsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).getBody();
            }
        };
    }

    public ServiceCall<List<ResourceGroupInner>> listAsync(String filter, Integer top, ListOperationCallback<ResourceGroupInner> serviceCallback) {
        return AzureServiceCall.create(this.listSinglePageAsync(filter, top), (Func1)new Func1<String, Observable<ServiceResponse<Page<ResourceGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ResourceGroupInner>>> call(String nextPageLink) {
                return ResourceGroupsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ResourceGroupInner>> listAsync(String filter, Integer top) {
        return this.listWithServiceResponseAsync(filter, top).map((Func1)new Func1<ServiceResponse<Page<ResourceGroupInner>>, Page<ResourceGroupInner>>(){

            public Page<ResourceGroupInner> call(ServiceResponse<Page<ResourceGroupInner>> response) {
                return (Page)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Page<ResourceGroupInner>>> listWithServiceResponseAsync(String filter, Integer top) {
        return this.listSinglePageAsync(filter, top).concatMap((Func1)new Func1<ServiceResponse<Page<ResourceGroupInner>>, Observable<ServiceResponse<Page<ResourceGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ResourceGroupInner>>> call(ServiceResponse<Page<ResourceGroupInner>> page) {
                String nextPageLink = ((Page)page.getBody()).getNextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ResourceGroupsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ResourceGroupInner>>> listSinglePageAsync(String filter, Integer top) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.list(this.client.subscriptionId(), filter, top, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ResourceGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ResourceGroupInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ResourceGroupsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.getBody(), result.getResponse()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ResourceGroupInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.client.mapperAdapter()).register(200, new TypeToken<PageImpl<ResourceGroupInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<GenericResourceInner> listResourcesNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listResourcesNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<GenericResourceInner>((Page)response.getBody()){

            public Page<GenericResourceInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ResourceGroupsInner.this.listResourcesNextSinglePageAsync(nextPageLink).toBlocking().single()).getBody();
            }
        };
    }

    public ServiceCall<List<GenericResourceInner>> listResourcesNextAsync(String nextPageLink, ServiceCall<List<GenericResourceInner>> serviceCall, ListOperationCallback<GenericResourceInner> serviceCallback) {
        return AzureServiceCall.create(this.listResourcesNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<GenericResourceInner>>>>(){

            public Observable<ServiceResponse<Page<GenericResourceInner>>> call(String nextPageLink) {
                return ResourceGroupsInner.this.listResourcesNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<GenericResourceInner>> listResourcesNextAsync(String nextPageLink) {
        return this.listResourcesNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<GenericResourceInner>>, Page<GenericResourceInner>>(){

            public Page<GenericResourceInner> call(ServiceResponse<Page<GenericResourceInner>> response) {
                return (Page)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Page<GenericResourceInner>>> listResourcesNextWithServiceResponseAsync(String nextPageLink) {
        return this.listResourcesNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<GenericResourceInner>>, Observable<ServiceResponse<Page<GenericResourceInner>>>>(){

            public Observable<ServiceResponse<Page<GenericResourceInner>>> call(ServiceResponse<Page<GenericResourceInner>> page) {
                String nextPageLink = ((Page)page.getBody()).getNextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ResourceGroupsInner.this.listResourcesNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<GenericResourceInner>>> listResourcesNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        return this.service.listResourcesNext(nextPageLink, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<GenericResourceInner>>>>(){

            public Observable<ServiceResponse<Page<GenericResourceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ResourceGroupsInner.this.listResourcesNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.getBody(), result.getResponse()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<GenericResourceInner>> listResourcesNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.client.mapperAdapter()).register(200, new TypeToken<PageImpl<GenericResourceInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ResourceGroupInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ResourceGroupInner>((Page)response.getBody()){

            public Page<ResourceGroupInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ResourceGroupsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).getBody();
            }
        };
    }

    public ServiceCall<List<ResourceGroupInner>> listNextAsync(String nextPageLink, ServiceCall<List<ResourceGroupInner>> serviceCall, ListOperationCallback<ResourceGroupInner> serviceCallback) {
        return AzureServiceCall.create(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ResourceGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ResourceGroupInner>>> call(String nextPageLink) {
                return ResourceGroupsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ResourceGroupInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ResourceGroupInner>>, Page<ResourceGroupInner>>(){

            public Page<ResourceGroupInner> call(ServiceResponse<Page<ResourceGroupInner>> response) {
                return (Page)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Page<ResourceGroupInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ResourceGroupInner>>, Observable<ServiceResponse<Page<ResourceGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ResourceGroupInner>>> call(ServiceResponse<Page<ResourceGroupInner>> page) {
                String nextPageLink = ((Page)page.getBody()).getNextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ResourceGroupsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ResourceGroupInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        return this.service.listNext(nextPageLink, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ResourceGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ResourceGroupInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ResourceGroupsInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.getBody(), result.getResponse()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ResourceGroupInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.client.mapperAdapter()).register(200, new TypeToken<PageImpl<ResourceGroupInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ResourceGroupsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/resources")
        public Observable<Response<ResponseBody>> listResources(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="$filter") String var3, @Query(value="$expand") String var4, @Query(value="$top") Integer var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @HEAD(value="subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}")
        public Observable<Response<Void>> checkExistence(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @PUT(value="subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Body ResourceGroupInner var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @HTTP(path="subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @HTTP(path="subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @GET(value="subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @PATCH(value="subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}")
        public Observable<Response<ResponseBody>> patch(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Body ResourceGroupInner var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @POST(value="subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/exportTemplate")
        public Observable<Response<ResponseBody>> exportTemplate(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Body ExportTemplateRequestInner var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @GET(value="subscriptions/{subscriptionId}/resourcegroups")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="$filter") String var2, @Query(value="$top") Integer var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @GET(value="{nextLink}")
        public Observable<Response<ResponseBody>> listResourcesNext(@Path(value="nextLink", encoded=true) String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @GET(value="{nextLink}")
        public Observable<Response<ResponseBody>> listNext(@Path(value="nextLink", encoded=true) String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

