/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources.implementation;

import com.microsoft.azure.RestClient;
import com.microsoft.azure.credentials.AzureTokenCredentials;
import com.microsoft.azure.management.resources.Deployments;
import com.microsoft.azure.management.resources.Features;
import com.microsoft.azure.management.resources.GenericResources;
import com.microsoft.azure.management.resources.Providers;
import com.microsoft.azure.management.resources.ResourceGroups;
import com.microsoft.azure.management.resources.Subscriptions;
import com.microsoft.azure.management.resources.Tenants;
import com.microsoft.azure.management.resources.fluentcore.arm.AzureConfigurable;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.AzureConfigurableImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.implementation.DeploymentsImpl;
import com.microsoft.azure.management.resources.implementation.FeatureClientImpl;
import com.microsoft.azure.management.resources.implementation.FeaturesImpl;
import com.microsoft.azure.management.resources.implementation.GenericResourcesImpl;
import com.microsoft.azure.management.resources.implementation.ProvidersImpl;
import com.microsoft.azure.management.resources.implementation.ResourceGroupsImpl;
import com.microsoft.azure.management.resources.implementation.ResourceManagementClientImpl;
import com.microsoft.azure.management.resources.implementation.SubscriptionClientImpl;
import com.microsoft.azure.management.resources.implementation.SubscriptionsImpl;
import com.microsoft.azure.management.resources.implementation.TenantsImpl;
import com.microsoft.rest.credentials.ServiceClientCredentials;

public final class ResourceManager
extends ManagerBase {
    private final ResourceManagementClientImpl resourceManagementClient;
    private final FeatureClientImpl featureClient;
    private ResourceGroups resourceGroups;
    private GenericResources genericResources;
    private Deployments deployments;
    private Features features;
    private Providers providers;

    public static Authenticated authenticate(AzureTokenCredentials credentials) {
        return new AuthenticatedImpl(credentials.getEnvironment().newRestClientBuilder().withCredentials((ServiceClientCredentials)credentials).build());
    }

    public static Authenticated authenticate(RestClient restClient) {
        return new AuthenticatedImpl(restClient);
    }

    public static Configurable configure() {
        return new ConfigurableImpl();
    }

    private ResourceManager(RestClient restClient, String subscriptionId) {
        super(null, subscriptionId);
        super.setResourceManager(this);
        this.resourceManagementClient = new ResourceManagementClientImpl(restClient);
        this.resourceManagementClient.withSubscriptionId(subscriptionId);
        this.featureClient = new FeatureClientImpl(restClient);
        this.featureClient.withSubscriptionId(subscriptionId);
    }

    public ResourceGroups resourceGroups() {
        if (this.resourceGroups == null) {
            this.resourceGroups = new ResourceGroupsImpl(this.resourceManagementClient);
        }
        return this.resourceGroups;
    }

    public GenericResources genericResources() {
        if (this.genericResources == null) {
            this.genericResources = new GenericResourcesImpl(this.resourceManagementClient, this);
        }
        return this.genericResources;
    }

    public Deployments deployments() {
        if (this.deployments == null) {
            this.deployments = new DeploymentsImpl(this.resourceManagementClient.deployments(), this.resourceManagementClient.deploymentOperations(), this);
        }
        return this.deployments;
    }

    public Features features() {
        if (this.features == null) {
            this.features = new FeaturesImpl(this.featureClient.features());
        }
        return this.features;
    }

    public Providers providers() {
        if (this.providers == null) {
            this.providers = new ProvidersImpl(this.resourceManagementClient.providers());
        }
        return this.providers;
    }

    private static final class AuthenticatedImpl
    implements Authenticated {
        private RestClient restClient;
        private SubscriptionClientImpl subscriptionClient;
        private Subscriptions subscriptions;
        private Tenants tenants;

        AuthenticatedImpl(RestClient restClient) {
            this.restClient = restClient;
            this.subscriptionClient = new SubscriptionClientImpl(restClient);
        }

        @Override
        public Subscriptions subscriptions() {
            if (this.subscriptions == null) {
                this.subscriptions = new SubscriptionsImpl(this.subscriptionClient.subscriptions());
            }
            return this.subscriptions;
        }

        @Override
        public Tenants tenants() {
            if (this.tenants == null) {
                this.tenants = new TenantsImpl(this.subscriptionClient.tenants());
            }
            return this.tenants;
        }

        @Override
        public ResourceManager withSubscription(String subscriptionId) {
            return new ResourceManager(this.restClient, subscriptionId);
        }
    }

    public static interface Authenticated {
        public Tenants tenants();

        public Subscriptions subscriptions();

        public ResourceManager withSubscription(String var1);
    }

    private static class ConfigurableImpl
    extends AzureConfigurableImpl<Configurable>
    implements Configurable {
        private ConfigurableImpl() {
        }

        @Override
        public Authenticated authenticate(AzureTokenCredentials credentials) {
            return ResourceManager.authenticate(this.buildRestClient(credentials));
        }
    }

    public static interface Configurable
    extends AzureConfigurable<Configurable> {
        public Authenticated authenticate(AzureTokenCredentials var1);
    }
}

